/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.dd;

import com.sun.enterprise.logging.LogDomains;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import tools.com.sun.enterprise.util.XMLValidationHandler;

public class ParseDD
extends VerifierTest {
    DocumentBuilder builder = null;
    Result result = this.getInitializedResult();
    private LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
    boolean oneFailed = false;
    private static String EJB = "EJB Deployment Descriptor";
    private static String APPCLIENT = "App Client Deployment Descriptor";
    private static String CONNECTOR = "Connector Deployment Descriptor";
    private static String WEB = "Web Deployment Descriptor";
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.avk.tools.verifier");

    public ParseDD() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setAttribute("http://apache.org/xml/features/allow-java-encodings", new Boolean(true));
            this.builder = factory.newDocumentBuilder();
            XMLValidationHandler dh = new XMLValidationHandler(false);
            this.builder.setEntityResolver(dh);
        }
        catch (ParserConfigurationException e) {
            logger.log(Level.SEVERE, this.getClass().getName() + ".Exception", new Object[]{e.toString()});
            this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{e.toString()}));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, this.getClass().getName() + ".Exception", new Object[]{e.toString()});
            this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{e.toString()}));
        }
    }

    public Result validateConnectorDescriptor(InputStream source) {
        Document document = null;
        this.result = this.getInitializedResult();
        this.result.setComponentName(EJB);
        NodeList nodeList = null;
        try {
            String value;
            int i;
            if (source == null) {
                logger.log(Level.SEVERE, this.getClass().getName() + ".srcnull");
                this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".NoIO", "no InputStream found", new Object[0]));
                return this.result;
            }
            document = this.builder.parse(source);
            nodeList = document.getElementsByTagName("license-required");
            if (nodeList != null) {
                for (i = 0; i < nodeList.getLength(); ++i) {
                    value = ((Text)nodeList.item(i).getFirstChild()).getNodeValue();
                    if (!value.equals("true") && !value.equals("false")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedLicense", "[Connector] license-required cannot be {0}. It has to be either true or false.", new Object[]{value}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedLicense", "PASSED[Connector]  : license-required is {0}.", new Object[]{value}));
                }
            }
            if ((nodeList = document.getElementsByTagName("reauthentication-support")) != null) {
                for (i = 0; i < nodeList.getLength(); ++i) {
                    value = ((Text)nodeList.item(i).getFirstChild()).getNodeValue();
                    if (!value.equals("true") && !value.equals("false")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedReauthenticationSupport", "[Connector] reauthentication-support cannot be {0}. It has to be either true or false.", new Object[]{value}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedReauthenticationSupport", "PASSED [Connector] : reauthentication-support is {0}.", new Object[]{value}));
                }
            }
            if ((nodeList = document.getElementsByTagName("transaction-support")) != null) {
                for (i = 0; i < nodeList.getLength(); ++i) {
                    value = ((Text)nodeList.item(i).getFirstChild()).getNodeValue();
                    if (!(value.equals("NoTransaction") || value.equals("LocalTransaction") || value.equals("XATransaction"))) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedTransactionSupport", "[Connector]transaction-support cannot be {0}. It has to be either NoTransaction or LocalTransaction or XATransaction.", new Object[]{value}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedTransactionSupport", "PASSED [Connector] : transaction-support is {0}.", new Object[]{value}));
                }
            }
            if (this.result.getStatus() != 1) {
                this.result.setStatus(0);
            }
            return this.result;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, this.getClass().getName() + ".Exception", new Object[]{e.toString()});
            this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{e.toString()}));
            return this.result;
        }
        catch (SAXException e) {
            logger.log(Level.SEVERE, this.getClass().getName() + ".Exception", new Object[]{e.toString()});
            this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{e.toString()}));
            return this.result;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, this.getClass().getName() + ".Exception", new Object[]{e.toString()});
            this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{e.toString()}));
            return this.result;
        }
    }

    public Result validateAppClientDescriptor(InputStream source) {
        Document document = null;
        this.result = this.getInitializedResult();
        this.result.setComponentName(EJB);
        NodeList nodeList = null;
        try {
            String value;
            int i;
            if (source == null) {
                logger.log(Level.SEVERE, this.getClass().getName() + ".srcnull");
                this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".NoIO", "no InputStream found", new Object[0]));
                return this.result;
            }
            document = this.builder.parse(source);
            nodeList = document.getElementsByTagName("ejb-ref-type");
            if (nodeList != null) {
                for (i = 0; i < nodeList.getLength(); ++i) {
                    String ejbRefTypeValue = ((Text)nodeList.item(i).getFirstChild()).getNodeValue();
                    if (!ejbRefTypeValue.equals("Session") && !ejbRefTypeValue.equals("Entity")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedAppClientEjbRefType", "[App Client] ejb-ref-type cannot be {0}. It has to be either Entity or Session.", new Object[]{ejbRefTypeValue}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedAppClientEjbRefType", "PASSED [App Client] : ejb-ref-type is {0}.", new Object[]{ejbRefTypeValue}));
                }
            }
            if ((nodeList = document.getElementsByTagName("res-auth")) != null) {
                for (i = 0; i < nodeList.getLength(); ++i) {
                    value = ((Text)nodeList.item(i).getFirstChild()).getNodeValue();
                    if (!value.equals("Application") && !value.equals("Container")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedAppClientResAuth", "[App Client] res-auth cannot be {0}. It has to be either Application or Container", new Object[]{value}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedAppClientResAuth", "PASSED [App Client] : res-auth is {0}.", new Object[]{value}));
                }
            }
            if ((nodeList = document.getElementsByTagName("res-sharing-scope")) != null) {
                for (i = 0; i < nodeList.getLength(); ++i) {
                    value = ((Text)nodeList.item(i).getFirstChild()).getNodeValue();
                    if (!value.equals("Shareable") && !value.equals("Unshareable")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedAppClientResSharingScope", "[App Client] res-sharing-scope cannot be {0}. It has to be either Shareable or Unshareable", new Object[]{value}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedAppClientResSharingScope", "PASSED [App Client] : res-sharing-scope is {0}.", new Object[]{value}));
                }
            }
            if (this.result.getStatus() != 1) {
                this.result.setStatus(0);
            }
            return this.result;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, this.getClass().getName() + ".Exception", new Object[]{e.toString()});
            this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{e.toString()}));
            return this.result;
        }
        catch (SAXException e) {
            logger.log(Level.SEVERE, this.getClass().getName() + ".Exception", new Object[]{e.toString()});
            this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{e.toString()}));
            return this.result;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, this.getClass().getName() + ".Exception", new Object[]{e.toString()});
            this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{e.toString()}));
            return this.result;
        }
    }

    public Result validateWebDescriptor(InputStream source) {
        Document document = null;
        this.result = this.getInitializedResult();
        this.result.setComponentName(EJB);
        NodeList nodeList = null;
        try {
            String value;
            int i;
            if (source == null) {
                logger.log(Level.SEVERE, this.getClass().getName() + ".srcnull");
                this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".NoIO", "no InputStream found", new Object[0]));
                return this.result;
            }
            document = this.builder.parse(source);
            nodeList = document.getElementsByTagName("ejb-ref-type");
            if (nodeList != null) {
                for (i = 0; i < nodeList.getLength(); ++i) {
                    String ejbRefTypeValue = ((Text)nodeList.item(i).getFirstChild()).getNodeValue();
                    if (!ejbRefTypeValue.equals("Session") && !ejbRefTypeValue.equals("Entity")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedWebEjbRefType", "[Web] ejb-ref-type cannot be {0}. It has to be either Entity or Session.", new Object[]{ejbRefTypeValue}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedWebEjbRefType", "PASSED [Web] : ejb-ref-type is {0}.", new Object[]{ejbRefTypeValue}));
                }
            }
            if ((nodeList = document.getElementsByTagName("res-auth")) != null) {
                for (i = 0; i < nodeList.getLength(); ++i) {
                    value = ((Text)nodeList.item(i).getFirstChild()).getNodeValue();
                    if (!value.equals("Application") && !value.equals("Container")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedWebResAuth", "[Web] res-auth cannot be {0}. It has to be either Application or Container", new Object[]{value}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedWebResAuth", "PASSED[Web]  : res-auth is {0}.", new Object[]{value}));
                }
            }
            if ((nodeList = document.getElementsByTagName("res-sharing-scope")) != null) {
                for (i = 0; i < nodeList.getLength(); ++i) {
                    value = ((Text)nodeList.item(i).getFirstChild()).getNodeValue();
                    if (!value.equals("Shareable") && !value.equals("Unshareable")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedWebResSharingScope", "[Web] res-sharing-scope cannot be {0}. It has to be either Shareable or Unshareable", new Object[]{value}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedWebResSharingScope", "PASSED [Web] : res-sharing-scope is {0}.", new Object[]{value}));
                }
            }
            if (this.result.getStatus() != 1) {
                this.result.setStatus(0);
            }
            return this.result;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, this.getClass().getName() + ".Exception", new Object[]{e.toString()});
            this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{e.toString()}));
            return this.result;
        }
        catch (SAXException e) {
            logger.log(Level.SEVERE, this.getClass().getName() + ".Exception", new Object[]{e.toString()});
            this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{e.toString()}));
            return this.result;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, this.getClass().getName() + ".Exception", new Object[]{e.toString()});
            this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{e.toString()}));
            return this.result;
        }
    }

    public Result validateEJBDescriptor(InputStream source) {
        Document document = null;
        this.result = this.getInitializedResult();
        this.result.setComponentName(EJB);
        NodeList nodeList = null;
        try {
            String value;
            int i;
            if (source == null) {
                logger.log(Level.SEVERE, this.getClass().getName() + ".srcnull");
                this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".NoIO", "no InputStream found", new Object[0]));
                return this.result;
            }
            document = this.builder.parse(source);
            this.checkInterfacePairs(document, "remote", "home");
            this.checkInterfacePairs(document, "local", "local-home");
            nodeList = document.getElementsByTagName("session-type");
            if (nodeList != null) {
                for (i = 0; i < nodeList.getLength(); ++i) {
                    String sessionTypeValue = ((Text)nodeList.item(i).getFirstChild()).getNodeValue();
                    if (!sessionTypeValue.equals("Stateless") && !sessionTypeValue.equals("Stateful")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedSession", "session-type cannot be {0}. It has to be either Stateless or Stateful.", new Object[]{sessionTypeValue}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedSession", "PASSED : session-type is {0}.", new Object[]{sessionTypeValue}));
                }
            }
            if ((nodeList = document.getElementsByTagName("ejb-ref-type")) != null) {
                for (i = 0; i < nodeList.getLength(); ++i) {
                    String ejbRefTypeValue = ((Text)nodeList.item(i).getFirstChild()).getNodeValue();
                    if (!ejbRefTypeValue.equals("Session") && !ejbRefTypeValue.equals("Entity")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedEjbRefType", "[EJB] ejb-ref-type cannot be {0}. It has to be either Entity or Session.", new Object[]{ejbRefTypeValue}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedEjbRefType", "PASSED [EJB] : ejb-ref-type is {0}.", new Object[]{ejbRefTypeValue}));
                }
            }
            if ((nodeList = document.getElementsByTagName("multiplicity")) != null) {
                for (i = 0; i < nodeList.getLength(); ++i) {
                    String multiplicityValue = ((Text)nodeList.item(i).getFirstChild()).getNodeValue();
                    if (!multiplicityValue.equals("One") && !multiplicityValue.equals("Many")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedMultiplicity", "[EJB] multiplicity cannot be {0}. It has to be either One or Many", new Object[]{multiplicityValue}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedMultiplicity", "PASSED [EJB] : multiplicity is {0}.", new Object[]{multiplicityValue}));
                }
            }
            if ((nodeList = document.getElementsByTagName("cmp-version")) != null) {
                for (i = 0; i < nodeList.getLength(); ++i) {
                    value = ((Text)nodeList.item(i).getFirstChild()).getNodeValue();
                    if (!value.equals("1.x") && !value.equals("2.x")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedVersion", "[EJB] version cannot be {0}. It has to be either 1.x or 2.x", new Object[]{value}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedVersion", "PASSED [EJB] : version is {0}.", new Object[]{value}));
                }
            }
            if ((nodeList = document.getElementsByTagName("destination-type")) != null) {
                for (i = 0; i < nodeList.getLength(); ++i) {
                    value = ((Text)nodeList.item(i).getFirstChild()).getNodeValue();
                    if (!value.equals("javax.jms.Queue") && !value.equals("javax.jms.Topic")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedDestinationType", "[EJB] destination-type cannot be {0}. It has to be either javax.jms.Topic or javax.jms.Queue", new Object[]{value}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedDestinationType", "PASSED [EJB] : destination-type is {0}.", new Object[]{value}));
                }
            }
            if ((nodeList = document.getElementsByTagName("method-intf")) != null) {
                for (i = 0; i < nodeList.getLength(); ++i) {
                    value = ((Text)nodeList.item(i).getFirstChild()).getNodeValue();
                    if (!(value.equals("Home") || value.equals("Remote") || value.equals("LocalHome") || value.equals("Local") || value.equals("ServiceEndpoint"))) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedMethodIntf", "[EJB] method-intf cannot be [ {0} ]. It has to be either Local, Remote, LocalHome or Home or ServiceEndpoint", new Object[]{value}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedMethodIntf", "PASSED [EJB] : method-intf is {0}.", new Object[]{value}));
                }
            }
            if ((nodeList = document.getElementsByTagName("persistence-type")) != null) {
                for (i = 0; i < nodeList.getLength(); ++i) {
                    value = ((Text)nodeList.item(i).getFirstChild()).getNodeValue();
                    if (!value.equals("Bean") && !value.equals("Container")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedPersistenceType", "[EJB] persistence-type cannot be {0}. It has to be either Bean or Container", new Object[]{value}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedPersistenceType", "PASSED [EJB] : persistence-type is {0}.", new Object[]{value}));
                }
            }
            if ((nodeList = document.getElementsByTagName("reentrant")) != null) {
                for (i = 0; i < nodeList.getLength(); ++i) {
                    value = ((Text)nodeList.item(i).getFirstChild()).getNodeValue();
                    if (!value.equals("True") && !value.equals("False")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedReentrant", "[EJB] reentrant cannot be {0}. It has to be either True or False", new Object[]{value}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedReentrant", "PASSED [EJB] : reentrant is {0}.", new Object[]{value}));
                }
            }
            if ((nodeList = document.getElementsByTagName("res-auth")) != null) {
                for (i = 0; i < nodeList.getLength(); ++i) {
                    value = ((Text)nodeList.item(i).getFirstChild()).getNodeValue();
                    if (!value.equals("Application") && !value.equals("Container")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedEjbResAuth", "[EJB] res-auth cannot be {0}. It has to be either Application or Container", new Object[]{value}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedEjbResAuth", "PASSED [EJB] : res-auth is {0}.", new Object[]{value}));
                }
            }
            if ((nodeList = document.getElementsByTagName("result-type-mapping")) != null) {
                for (i = 0; i < nodeList.getLength(); ++i) {
                    value = ((Text)nodeList.item(i).getFirstChild()).getNodeValue();
                    if (!value.equals("Local") && !value.equals("Remote")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedResultTypeMapping", "[EJB] result-type-mapping cannot be {0}. It has to be either Remote or Local", new Object[]{value}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedResultTypeMapping", "PASSED [EJB] : result-type-mapping is {0}.", new Object[]{value}));
                }
            }
            if ((nodeList = document.getElementsByTagName("subscription-durability")) != null) {
                for (i = 0; i < nodeList.getLength(); ++i) {
                    value = ((Text)nodeList.item(i).getFirstChild()).getNodeValue();
                    if (!value.equals("Durable") && !value.equals("NonDurable")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedSubscriptionDurability", "[EJB] subscription-durability cannot be {0}. It has to be either Durable or NonDurable", new Object[]{value}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedSubscriptionDurability", "PASSED [EJB] : subscription-durability is {0}.", new Object[]{value}));
                }
            }
            if ((nodeList = document.getElementsByTagName("trans-attribute")) != null) {
                for (i = 0; i < nodeList.getLength(); ++i) {
                    value = ((Text)nodeList.item(i).getFirstChild()).getNodeValue();
                    if (!(value.equals("NotSupported") || value.equals("Supports") || value.equals("Required") || value.equals("RequiresNew") || value.equals("Mandatory") || value.equals("Never"))) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedTransAttribute", "[EJB] trans-attribute cannot be {0}. It has to be either NotSupported or Supports or Required or RequiresNew or Mandatory or Never.", new Object[]{value}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedTransAttribute", "PASSED [EJB]: trans-attribute is {0}.", new Object[]{value}));
                }
            }
            if ((nodeList = document.getElementsByTagName("transaction-type")) != null) {
                for (i = 0; i < nodeList.getLength(); ++i) {
                    value = ((Text)nodeList.item(i).getFirstChild()).getNodeValue();
                    if (!value.equals("Bean") && !value.equals("Container")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedTransactionType", "[EJB] transaction-type cannot be {0}. It has to be either Bean or Container", new Object[]{value}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedTransactionType", "PASSED [EJB]: transaction-type is {0}.", new Object[]{value}));
                }
            }
            if ((nodeList = document.getElementsByTagName("acknowledge-mode")) != null) {
                for (i = 0; i < nodeList.getLength(); ++i) {
                    value = ((Text)nodeList.item(i).getFirstChild()).getNodeValue();
                    if (!value.equals("Auto-acknowledge") && !value.equals("Dups-ok-acknowledge")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedAcknowledgeMode", "[EJB] acknowledge-mode cannot be {0}. It has to be either True or False", new Object[]{value}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedAcknowledgeMode", "PASSED [EJB]: acknowledge-mode is {0}.", new Object[]{value}));
                }
            }
            if ((nodeList = document.getElementsByTagName("res-sharing-scope")) != null) {
                for (i = 0; i < nodeList.getLength(); ++i) {
                    value = ((Text)nodeList.item(i).getFirstChild()).getNodeValue();
                    if (!value.equals("Shareable") && !value.equals("Unshareable")) {
                        this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedEjbResSharingScope", "[EJB] res-sharing-scope cannot be {0}. It has to be either Shareable or Unshareable", new Object[]{value}));
                        this.oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedEjbResSharingScope", "PASSED [EJB] : res-sharing-scope is {0}.", new Object[]{value}));
                }
            }
            if (this.result.getStatus() != 1) {
                this.result.setStatus(0);
            }
            return this.result;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, this.getClass().getName() + ".Exception", new Object[]{e.toString()});
            this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{e.toString()}));
            return this.result;
        }
        catch (SAXException e) {
            logger.log(Level.SEVERE, this.getClass().getName() + ".Exception", new Object[]{e.toString()});
            this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{e.toString()}));
            return this.result;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, this.getClass().getName() + ".Exception", new Object[]{e.toString()});
            this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".Exception", "Exception : {0}", new Object[]{e.toString()}));
            return this.result;
        }
    }

    public void checkInterfacePairs(Document document, String intf1, String intf2) {
        int length1 = 0;
        int length2 = 0;
        NodeList nodeList = document.getElementsByTagName(intf1.trim());
        if (nodeList != null) {
            length1 = nodeList.getLength();
        }
        if ((nodeList = document.getElementsByTagName(intf2.trim())) != null) {
            length2 = nodeList.getLength();
        }
        if (length1 == length2) {
            if (length1 != 0) {
                this.result.addGoodDetails(this.smh.getLocalString(this.getClass().getName() + ".passedPairs", "PASSED [EJB] : [ {0} ] and [ {1} ] tags present.", new Object[]{intf1, intf2}));
            }
        } else {
            this.result.failed(this.smh.getLocalString(this.getClass().getName() + ".failedPairs", "FAILED [EJB] : Either one of the [ {0} ] : [ {1} ] tag pair is not present.", new Object[]{intf1, intf2}));
        }
    }
}

