/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.common.util;

import com.sun.enterprise.tools.common.util.diagnostics.CallerInfo;
import com.sun.enterprise.tools.common.util.diagnostics.CallerInfoException;

public class Assertion {
    private static boolean doCheck = true;
    private static Assertion staticInstance = null;

    public static void check(boolean b, String s) {
        if (doCheck && !b) {
            Assertion.toss(s);
        }
    }

    public static void check(boolean b) {
        if (doCheck && !b) {
            Assertion.toss();
        }
    }

    public static void check(Object obj, String s) {
        if (doCheck && obj == null) {
            Assertion.toss(s);
        }
    }

    public static void check(String checkMe, String s) {
        if (doCheck && (checkMe == null || checkMe.length() <= 0)) {
            Assertion.toss(s);
        }
    }

    public static void check(String checkMe) {
        if (doCheck && (checkMe == null || checkMe.length() <= 0)) {
            Assertion.toss();
        }
    }

    public static void check(Object obj) {
        if (doCheck && obj == null) {
            Assertion.toss();
        }
    }

    public static void check(double x, String s) {
        if (doCheck && x == 0.0) {
            Assertion.toss(s);
        }
    }

    public static void check(double x) {
        if (doCheck && x == 0.0) {
            Assertion.toss();
        }
    }

    public static void check(long x, String s) {
        if (doCheck && x == 0L) {
            Assertion.toss(s);
        }
    }

    public static void check(long x) {
        if (doCheck && x == 0L) {
            Assertion.toss();
        }
    }

    public static void setCheck(boolean c) {
        doCheck = c;
    }

    public static void main(String[] args) {
        Assertion.check(args);
        Assertion.check(args.length, "No command line arguments");
    }

    private static void toss() {
        Assertion.toss(null);
    }

    private static void toss(String gripe) {
        String msg = "\nAssertion failed";
        String ci = Assertion.getCallerInfo();
        if (ci != null) {
            msg = msg + " at " + ci;
        }
        if (gripe != null) {
            msg = msg + " --> " + gripe;
        }
        throw new Failure(msg);
    }

    private static String getCallerInfo() {
        try {
            CallerInfo ci = new CallerInfo(new Object[]{staticInstance});
            return ci.toString();
        }
        catch (CallerInfoException e) {
            return null;
        }
    }

    static {
        staticInstance = new Assertion();
    }

    public static class Failure
    extends RuntimeException {
        public Failure(String gripe) {
            super(gripe);
        }
    }
}

