/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.ss.provider;

import com.sun.enterprise.server.ss.spi.ASSocketFacadeUtils;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ASPlainSocketImpl {
    private SocketImpl si = null;
    private final String SOCKET_IMPL_CLASS = "java.net.SocksSocketImpl";
    private static final Logger logger = LogDomains.getLogger("javax.enterprise.system.core");
    private Method createMethod = null;
    private Method connectMethod1 = null;
    private Method connectMethod2 = null;
    private Method connectMethod3 = null;
    private Method bindMethod = null;
    private Method listenMethod = null;
    private Method acceptMethod = null;
    private Method getInputStreamMethod = null;
    private Method getOutputStreamMethod = null;
    private Method availableMethod = null;
    private Method closeMethod = null;
    private Method shutdownInputMethod = null;
    private Method shutdownOutputMethod = null;
    private Method sendUrgentDataMethod = null;
    private Method setOptionMethod = null;
    private Method getOptionMethod = null;
    private Method getPortMethod = null;
    private Method supportsUrgentDataMethod = null;
    private Method getInetAddressMethod = null;
    private Method getLocalPortMethod = null;

    public ASPlainSocketImpl() {
        try {
            this.setup();
        }
        catch (PrivilegedActionException ex) {
            logger.log(Level.FINE, ex.getMessage(), ex);
            throw new RuntimeException(ex);
        }
    }

    private void setup() throws PrivilegedActionException {
        Object impl = AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                Class<?> tmpClass = Class.forName("java.net.SocksSocketImpl");
                Constructor<?> cons = tmpClass.getDeclaredConstructor(new Class[0]);
                cons.setAccessible(true);
                Object obj = cons.newInstance(null);
                while (!tmpClass.getName().equalsIgnoreCase("JAVA.NET.SOCKETIMPL")) {
                    ASPlainSocketImpl.this._setupMethods(tmpClass);
                    tmpClass = tmpClass.getSuperclass();
                }
                return obj;
            }
        });
        this.si = (SocketImpl)impl;
    }

    private void _setupMethods(Class siClass) {
        Method[] methods;
        for (Method m : methods = siClass.getDeclaredMethods()) {
            if (Modifier.isPrivate(m.getModifiers())) continue;
            m.setAccessible(true);
            if (m.getName().equalsIgnoreCase("CREATE")) {
                if (this.createMethod != null) continue;
                this.createMethod = m;
                continue;
            }
            if (m.getName().equalsIgnoreCase("CONNECT")) {
                if (m.getParameterTypes()[0].equals(String.class)) {
                    if (this.connectMethod1 != null) continue;
                    this.connectMethod1 = m;
                    continue;
                }
                if (m.getParameterTypes()[0].equals(InetAddress.class)) {
                    if (this.connectMethod2 != null) continue;
                    this.connectMethod2 = m;
                    continue;
                }
                if (this.connectMethod3 != null) continue;
                this.connectMethod3 = m;
                continue;
            }
            if (m.getName().equalsIgnoreCase("BIND")) {
                if (this.bindMethod != null) continue;
                this.bindMethod = m;
                continue;
            }
            if (m.getName().equalsIgnoreCase("LISTEN")) {
                if (this.listenMethod != null) continue;
                this.listenMethod = m;
                continue;
            }
            if (m.getName().equalsIgnoreCase("ACCEPT")) {
                if (this.acceptMethod != null) continue;
                this.acceptMethod = m;
                continue;
            }
            if (m.getName().equalsIgnoreCase("GETINPUTSTREAM")) {
                if (this.getInputStreamMethod != null) continue;
                this.getInputStreamMethod = m;
                continue;
            }
            if (m.getName().equalsIgnoreCase("GETOUTPUTSTREAM")) {
                if (this.getOutputStreamMethod != null) continue;
                this.getOutputStreamMethod = m;
                continue;
            }
            if (m.getName().equalsIgnoreCase("AVAILABLE")) {
                if (this.availableMethod != null) continue;
                this.availableMethod = m;
                continue;
            }
            if (m.getName().equalsIgnoreCase("CLOSE")) {
                if (this.closeMethod != null) continue;
                this.closeMethod = m;
                continue;
            }
            if (m.getName().equalsIgnoreCase("SHUTDOWNINPUT")) {
                if (this.shutdownInputMethod != null) continue;
                this.shutdownInputMethod = m;
                continue;
            }
            if (m.getName().equalsIgnoreCase("SHUTDOWNOUTPUT")) {
                if (this.shutdownOutputMethod != null) continue;
                this.shutdownOutputMethod = m;
                continue;
            }
            if (m.getName().equalsIgnoreCase("SENDURGENTDATA")) {
                if (this.sendUrgentDataMethod != null) continue;
                this.sendUrgentDataMethod = m;
                continue;
            }
            if (m.getName().equalsIgnoreCase("GETOPTION")) {
                if (this.getOptionMethod != null) continue;
                this.getOptionMethod = m;
                continue;
            }
            if (m.getName().equalsIgnoreCase("SETOPTION")) {
                if (this.setOptionMethod != null) continue;
                this.setOptionMethod = m;
                continue;
            }
            if (m.getName().equalsIgnoreCase("GETPORT")) {
                if (this.getPortMethod != null) continue;
                this.getPortMethod = m;
                continue;
            }
            if (m.getName().equalsIgnoreCase("GETINETADDRESS")) {
                if (this.getInetAddressMethod != null) continue;
                this.getInetAddressMethod = m;
                continue;
            }
            if (m.getName().equalsIgnoreCase("GETLOCALPORT")) {
                if (this.getLocalPortMethod != null) continue;
                this.getLocalPortMethod = m;
                continue;
            }
            if (!m.getName().equalsIgnoreCase("SUPPORTSURGENTDATA") || this.supportsUrgentDataMethod != null) continue;
            this.supportsUrgentDataMethod = m;
        }
    }

    protected void create(boolean stream) throws IOException {
        this._invoke(this.createMethod, new Object[]{new Boolean(stream)});
    }

    protected void connect(String host, int port) throws IOException {
        boolean waitForStartupReqd = !ASSocketFacadeUtils.getASSocketService().socketServiceNotified(port);
        this._invoke(this.connectMethod1, new Object[]{host, new Integer(port)});
        if (!ASSocketFacadeUtils.getASSocketService().isLocalClient(InetAddress.getByName(host))) {
            return;
        }
        if (waitForStartupReqd) {
            ASSocketFacadeUtils.getASSocketService().waitOnClientConnection(this.getPort());
        }
        ASSocketFacadeUtils.getASSocketService().clientSocketConnected(this.getPort(), this.getLocalPort());
    }

    protected void connect(InetAddress address, int port) throws IOException {
        boolean waitForStartupReqd = !ASSocketFacadeUtils.getASSocketService().socketServiceNotified(port);
        this._invoke(this.connectMethod2, new Object[]{address, new Integer(port)});
        if (!ASSocketFacadeUtils.getASSocketService().isLocalClient(address)) {
            return;
        }
        if (waitForStartupReqd) {
            ASSocketFacadeUtils.getASSocketService().waitOnClientConnection(this.getPort());
        }
        ASSocketFacadeUtils.getASSocketService().clientSocketConnected(this.getPort(), this.getLocalPort());
    }

    protected void connect(SocketAddress address, int timeout) throws IOException {
        InetSocketAddress isa = (InetSocketAddress)address;
        boolean waitForStartupReqd = !ASSocketFacadeUtils.getASSocketService().socketServiceNotified(isa.getPort());
        this._invoke(this.connectMethod3, new Object[]{address, new Integer(timeout)});
        if (!ASSocketFacadeUtils.getASSocketService().isLocalClient(isa.getAddress())) {
            return;
        }
        if (waitForStartupReqd) {
            ASSocketFacadeUtils.getASSocketService().waitOnClientConnection(this.getPort());
        }
        ASSocketFacadeUtils.getASSocketService().clientSocketConnected(this.getPort(), this.getLocalPort());
    }

    protected void bind(InetAddress host, int port) throws IOException {
        this._invoke(this.bindMethod, new Object[]{host, new Integer(port)});
    }

    protected void listen(int backlog) throws IOException {
        this._invoke(this.listenMethod, new Object[]{new Integer(backlog)});
    }

    protected void accept(SocketImpl s) throws IOException {
        this._invoke(this.acceptMethod, new Object[]{s});
    }

    protected InputStream getInputStream() throws IOException {
        return (InputStream)this._invoke(this.getInputStreamMethod, null);
    }

    protected OutputStream getOutputStream() throws IOException {
        return (OutputStream)this._invoke(this.getOutputStreamMethod, null);
    }

    protected int available() throws IOException {
        return (Integer)this._invoke(this.availableMethod, null);
    }

    protected void close() throws IOException {
        this._invoke(this.closeMethod, null);
    }

    protected void shutdownInput() throws IOException {
        this._invoke(this.shutdownInputMethod, null);
    }

    protected void shutdownOutput() throws IOException {
        this._invoke(this.shutdownOutputMethod, null);
    }

    protected void sendUrgentData(int data) throws IOException {
        this._invoke(this.sendUrgentDataMethod, new Object[]{new Integer(data)});
    }

    public void setOption(int optID, Object value) throws SocketException {
        try {
            this._invoke(this.setOptionMethod, new Object[]{new Integer(optID), value});
        }
        catch (IOException ie) {
            SocketException se = new SocketException(ie.getMessage());
            throw (SocketException)se.initCause(ie);
        }
    }

    public Object getOption(int optID) throws SocketException {
        try {
            return this._invoke(this.getOptionMethod, new Object[]{new Integer(optID)});
        }
        catch (IOException ie) {
            SocketException se = new SocketException(ie.getMessage());
            throw (SocketException)se.initCause(ie);
        }
    }

    public int getPort() {
        try {
            return (Integer)this._invoke(this.getPortMethod, null);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean supportsUrgentData() {
        try {
            return (Boolean)this._invoke(this.supportsUrgentDataMethod, null);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public InetAddress getInetAddress() {
        try {
            return (InetAddress)this._invoke(this.getInetAddressMethod, null);
        }
        catch (IOException ex) {
            logger.log(Level.FINER, ex.getMessage(), ex);
            throw new RuntimeException(ex);
        }
    }

    public int getLocalPort() {
        try {
            return (Integer)this._invoke(this.getLocalPortMethod, null);
        }
        catch (IOException ex) {
            logger.log(Level.FINER, ex.getMessage(), ex);
            throw new RuntimeException(ex);
        }
    }

    private Object _invoke(final Method m, final Object[] args) throws SocketException, IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return m.invoke((Object)ASPlainSocketImpl.this.si, args);
                }
            });
        }
        catch (PrivilegedActionException ex) {
            Throwable e;
            logger.log(Level.FINER, ex.getMessage(), ex);
            Throwable tmpEx = ex;
            if (ex.getCause() != null) {
                tmpEx = ex.getCause();
            }
            if (tmpEx instanceof InvocationTargetException && (e = ((InvocationTargetException)tmpEx).getTargetException()) != null) {
                tmpEx = e;
            }
            logger.log(Level.FINER, tmpEx.getMessage(), tmpEx);
            if (tmpEx instanceof SocketException) {
                throw (SocketException)tmpEx;
            }
            if (tmpEx instanceof IOException) {
                throw (IOException)tmpEx;
            }
            IOException ie = new IOException(tmpEx.getMessage());
            throw (IOException)ie.initCause(tmpEx);
        }
        catch (Exception ex) {
            logger.log(Level.FINER, ex.getMessage(), ex);
            IOException ie = new IOException(ex.getMessage());
            throw (IOException)ie.initCause(ex);
        }
    }
}

