/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.ondemand;

import com.sun.appserv.server.ServerLifecycle;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.enterprise.naming.SerialInitContextFactory;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.server.ondemand.OnDemandServices;
import com.sun.enterprise.server.ondemand.ServerEntryListenerImpl;
import com.sun.enterprise.server.ondemand.ServiceGroup;
import com.sun.enterprise.server.ondemand.ServiceGroupBuilder;
import com.sun.enterprise.server.ondemand.SystemAppLoader;
import com.sun.enterprise.server.ondemand.entry.EntryPoint;
import com.sun.enterprise.server.ondemand.entry.ServerEntryHelper;
import com.sun.enterprise.server.ondemand.entry.ServerEntryListener;
import com.sun.enterprise.server.pluggable.InternalServicesList;
import com.sun.enterprise.server.pluggable.PluggableFeatureFactory;
import com.sun.enterprise.server.ss.ASLazyKernel;
import com.sun.enterprise.server.ss.ASSocketService;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnDemandServer
extends ApplicationServer
implements EntryPoint {
    private static boolean onDemandStartup = true;
    private static volatile ServerEntryListener listener = null;
    private static volatile SystemAppLoader systemAppLoader = null;
    private volatile ServiceGroup sg = null;

    @Override
    public void onInitialization(ServerContext context) throws ServerLifecycleException {
        listener = new ServerEntryListenerImpl(this);
        ServiceGroupBuilder builder = new ServiceGroupBuilder();
        this.sg = builder.buildServiceGroup(this);
        try {
            super.setServerContext(context);
            PluggableFeatureFactory pff = context.getPluggableFeatureFactory();
            ASLazyKernel lazyStartupKernel = pff.getASLazyKernel();
            onDemandStartup = lazyStartupKernel.startASSocketServices(context);
        }
        catch (Exception e) {
            onDemandStartup = false;
        }
        SerialInitContextFactory.setInitializeOrbManager(false);
        super.onInitialization(context);
        try {
            systemAppLoader = new SystemAppLoader();
        }
        catch (Exception e) {
            throw new ServerLifecycleException(e);
        }
    }

    @Override
    public void onStartup() throws ServerLifecycleException {
        this.generateEntryContext(new Boolean(onDemandStartup));
        super.onStartup();
    }

    @Override
    public void onShutdown() throws ServerLifecycleException {
        super.onShutdown();
        try {
            this.sg.stop(null);
        }
        catch (Exception e) {
            throw new ServerLifecycleException(e);
        }
    }

    @Override
    public void generateEntryContext(Object event) {
        ServerEntryHelper.generateStartUpEntryContext((Boolean)event);
    }

    @Override
    protected List<ServerLifecycle> instantiateRuntimeServices(ServerContext serverContext, String[][] defaultServices) throws ServerLifecycleException {
        if (onDemandStartup) {
            InternalServicesList services = serverContext.getPluggableFeatureFactory().getInternalServicesList();
            OnDemandServices ondemandservices = new OnDemandServices();
            String[][] servicesByName = services.getServicesByName();
            String[][] odsByName = ondemandservices.getServicesByName();
            if (servicesByName == null) {
                _logger.log(Level.SEVERE, "services.null");
                throw new ServerLifecycleException();
            }
            ArrayList<ServerLifecycle> serviceList = new ArrayList<ServerLifecycle>();
            block2: for (String[] service : servicesByName) {
                for (String[] ods : odsByName) {
                    if (service[0].equals(ods[0])) continue block2;
                }
                try {
                    ServerLifecycle serverLifecycle = ApplicationServer.instantiateOneServerLifecycle(serverContext, service[1]);
                    serviceList.add(serverLifecycle);
                }
                catch (Exception ex) {
                    _logger.log(Level.SEVERE, "server.exception", ex);
                    throw new ServerLifecycleException(ex.getMessage());
                }
            }
            return serviceList;
        }
        return super.instantiateRuntimeServices(serverContext, defaultServices);
    }

    public static ServerEntryListener getServerEntryListener() {
        return listener;
    }

    public static SystemAppLoader getSystemAppLoader() {
        return systemAppLoader;
    }

    public ServiceGroup getServiceGroup() {
        return this.sg;
    }

    public static boolean isOnDemandOff() {
        return !onDemandStartup;
    }

    public static SelectionKey keyFor(SelectableChannel channel, Selector sel) {
        if (!onDemandStartup) {
            return channel.keyFor(sel);
        }
        return ASSocketService.keyFor(channel, sel);
    }
}

