/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.LogService;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.server.pluggable.LoggingSupport;
import com.sun.enterprise.util.StringUtils;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.StreamHandler;

public class TomcatLoggingSupport
implements LoggingSupport {
    private static String defaultLogFileName = null;
    private static String logFileName = null;
    private static FileHandler fHandler = null;
    private static final String LOGS_DIR = "logs";
    private static final String LOG_FILE = "server.log";

    public Handler createLogHandler() {
        String fileName = TomcatLoggingSupport.getLogFileName();
        StreamHandler h = null;
        try {
            if (fHandler == null) {
                fHandler = new FileHandler(fileName, true);
            }
        }
        catch (Exception e) {
            System.err.println("Error creating log handler for " + fileName + ". Using ConsoleHandler -- " + e.getMessage());
            e.printStackTrace();
            h = new ConsoleHandler();
            return h;
        }
        h = fHandler;
        return h;
    }

    private static String getLogFileName() {
        ServerContext sc;
        if (logFileName == null && (sc = ApplicationServer.getServerContext()) != null) {
            ConfigContext ctx = sc.getConfigContext();
            LogService ls = null;
            try {
                ls = ServerBeansFactory.getConfigBean(ctx).getLogService();
            }
            catch (ConfigException ce) {
                System.err.println("Error accessing log service config -- " + ce.getMessage() + "\nUsing default file");
                ce.printStackTrace();
            }
            if (ls != null) {
                logFileName = ls.getFile();
            }
        }
        if (logFileName != null) {
            return logFileName;
        }
        return TomcatLoggingSupport.getDefaultLogFileName();
    }

    private static String getDefaultLogFileName() {
        if (defaultLogFileName == null) {
            ServerContext sc = ApplicationServer.getServerContext();
            String instDir = sc != null ? sc.getInstanceEnvironment().getInstancesRoot() : System.getProperty("user.dir");
            String[] names = new String[]{instDir, LOGS_DIR, LOG_FILE};
            defaultLogFileName = StringUtils.makeFilePath(names, false);
        }
        return defaultLogFileName;
    }
}

