/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import com.sun.appserv.management.helper.AMXDebugHelper;
import com.sun.enterprise.server.logging.LoggingImplHook;
import com.sun.enterprise.util.FeatureAvailability;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class AMXLoggingHook {
    private ObjectName mLoggingObjectName;
    private MBeanServer mMBeanServer;
    private LoggingImplHook mLoggingImplHook;
    private Level mMinimumLogLevel;
    private final AMXDebugHelper mDebug;
    private final String mServerName = System.getProperty("com.sun.aas.instanceName");
    private static final AMXLoggingHook INSTANCE = new AMXLoggingHook();
    private static final String LOGGING_IMPL_CLASSNAME = "com.sun.enterprise.management.ext.logging.LoggingImpl";

    private void dumpSystemProps(AMXDebugHelper output) {
        Properties props = System.getProperties();
        Object[] keys = props.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        for (Object key : keys) {
            this.debug((String)key + "=" + props.getProperty((String)key));
        }
    }

    public static AMXLoggingHook getInstance() {
        return INSTANCE;
    }

    AMXLoggingHook() {
        String instanceRoot = System.getProperty("com.sun.aas.instanceRoot");
        this.mDebug = new AMXDebugHelper(instanceRoot + "/AMXLoggingHook-" + this.mServerName + ".debug");
        this.mLoggingObjectName = null;
        this.mMinimumLogLevel = Level.FINEST;
        this.mLoggingImplHook = null;
        this.mMBeanServer = null;
    }

    private final void debug(Object o) {
        this.mDebug.println(o);
    }

    public static ObjectName enableLoggingHook() {
        return AMXLoggingHook.getInstance()._enableLoggingHook();
    }

    private synchronized ObjectName _enableLoggingHook() {
        this.debug("_enableLoggingHook");
        if (this.mLoggingImplHook != null) {
            throw new IllegalStateException();
        }
        this.mMBeanServer = FeatureAvailability.getInstance().waitForMBeanServer();
        LoggingImplHook hook = null;
        try {
            Class<?> loggingClass = Class.forName(LOGGING_IMPL_CLASSNAME);
            Constructor<?> constructor = loggingClass.getConstructor(String.class);
            hook = (LoggingImplHook)constructor.newInstance(this.mServerName);
            Method getObjectNameMethod = loggingClass.getMethod("getObjectName", String.class);
            ObjectName proposedObjectName = (ObjectName)getObjectNameMethod.invoke((Object)hook, this.mServerName);
            this.debug("registering Logging as: " + proposedObjectName);
            this.mLoggingObjectName = this.mMBeanServer.registerMBean(hook, proposedObjectName).getObjectName();
            this.mLoggingImplHook = hook;
        }
        catch (Exception e) {
            hook = null;
            String msg = "Can't load com.sun.enterprise.management.ext.logging.LoggingImpl, caught: " + e;
            this.debug(msg);
            throw new Error(msg, e);
        }
        this.debug("_enableLoggingHook DONE");
        return this.mLoggingObjectName;
    }

    public Level getMinimumLogLevel() {
        return this.mMinimumLogLevel;
    }

    public void setMinimumLogLevel(Level level) {
        this.mMinimumLogLevel = level;
    }

    void publish(LogRecord record, Formatter theFormatter) {
        if (record.getLevel().intValue() < this.mMinimumLogLevel.intValue()) {
            return;
        }
        this.debug("publish: " + theFormatter.format(record));
        if (this.mLoggingImplHook != null) {
            try {
                this.mLoggingImplHook.privateLoggingHook(record, theFormatter);
            }
            catch (Throwable t) {
                this.mDebug.println("AMXLoggingHook.publish: Exception calling privateLoggingHook: ", t);
            }
        }
    }

    private static final class FileOutput
    implements Output {
        private PrintStream mOut;

        public FileOutput(File f) throws IOException {
            this.mOut = new PrintStream(new FileOutputStream(f));
        }

        public void println(Object o) {
            this.mOut.println(o.toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            if (this.mOut != null) {
                try {
                    this.mOut.close();
                    Object var2_1 = null;
                    this.mOut = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.mOut = null;
                    throw throwable;
                }
            }
        }
    }

    private static final class NullOutput
    implements Output {
        NullOutput() {
        }

        public void println(Object o) {
        }
    }

    private static interface Output {
        public void println(Object var1);
    }
}

