/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.config.clientbeans.ClientBeansFactory;
import com.sun.enterprise.config.clientbeans.ClientBeansResolver;
import com.sun.enterprise.config.clientbeans.ClientContainer;
import com.sun.enterprise.server.logging.BaseLogManager;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class ACCLogManager
extends BaseLogManager {
    private final String CLIENT_XML_FULL_NAME = "com.sun.enterprise.appclient.ClientContainer";
    private final String DEFAULT_CLIENT_CONTAINER_XML = "sun-acc.xml";
    private Handler _clientHandler = null;
    private Level _logLevel = Level.INFO;
    private boolean initialized = false;

    public synchronized void init(String configFile) {
        block6: {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            try {
                String logFileName;
                ConfigContext ctx = ConfigFactory.createConfigContext(configFile, true, false, false, ClientContainer.class, new ClientBeansResolver());
                ClientContainer cc = ClientBeansFactory.getClientBean(ctx);
                String logLevel = cc.getLogService().getLevel();
                if (logLevel != null && !logLevel.equals("")) {
                    this._logLevel = Level.parse(logLevel);
                }
                if ((logFileName = cc.getLogService().getFile()) != null && !logFileName.equals("")) {
                    this._clientHandler = new FileHandler(logFileName, true);
                    this._clientHandler.setFormatter(new SimpleFormatter());
                    File lockFile = new File(logFileName + ".lck");
                    lockFile.deleteOnExit();
                }
            }
            catch (Exception ex) {
                if (_logger == null) break block6;
                _logger.logrb(Level.SEVERE, null, null, "com.sun.logging.enterprise.system.container.appclient.LogStrings", "acc.cannot_create_log_handler", (Throwable)ex);
            }
        }
        Enumeration<String> e = this.getLoggerNames();
        while (e.hasMoreElements()) {
            String loggerName = e.nextElement();
            Logger l = this.getLogger(loggerName);
            this.initializeLogger(l);
        }
    }

    protected synchronized void initializeLogger(final Logger l) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                l.setLevel(ACCLogManager.this._logLevel);
                if (ACCLogManager.this._clientHandler != null) {
                    Handler[] h = l.getHandlers();
                    for (int i = 0; i < h.length; ++i) {
                        l.removeHandler(h[i]);
                    }
                    l.setUseParentHandlers(false);
                    l.addHandler(ACCLogManager.this._clientHandler);
                }
                return null;
            }
        });
    }
}

