/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.AdminEventListenerRegistry;
import com.sun.enterprise.admin.event.ApplicationDeployEvent;
import com.sun.enterprise.admin.event.ApplicationDeployEventListener;
import com.sun.enterprise.admin.event.DeployEventListenerHelper;
import com.sun.enterprise.appclient.jws.AppclientJWSSupportManager;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.autodeploy.AutoDirReDeployer;
import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.deployment.backend.DeploymentCommand;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactory;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactoryMgr;
import com.sun.enterprise.instance.AppsManager;
import com.sun.enterprise.security.acl.RoleMapper;
import com.sun.enterprise.server.AbstractLoader;
import com.sun.enterprise.server.AbstractManager;
import com.sun.enterprise.server.ApplicationLoader;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ConnectorResourcesLoader;
import com.sun.enterprise.server.MonitorableEntry;
import com.sun.enterprise.server.pluggable.ApplicationLoaderFactory;
import com.sun.enterprise.server.pluggable.PluggableFeatureFactory;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanException;

public class ApplicationManager
extends AbstractManager
implements ApplicationDeployEventListener {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");
    private static StringManager localStrings = StringManager.getManager(ApplicationManager.class);
    private static final String RAR = "rar";

    ApplicationManager(AppsManager appsManager, ClassLoader connectorClassLoader) {
        super(connectorClassLoader, appsManager);
        AdminEventListenerRegistry.addApplicationDeployEventListener(this);
        AppclientJWSSupportManager.getInstance();
    }

    protected AbstractLoader getLoader(String id) {
        PluggableFeatureFactory featureFactory = ApplicationServer.getServerContext().getPluggableFeatureFactory();
        ApplicationLoaderFactory appLoaderFactory = featureFactory.getApplicationLoaderFactory();
        ApplicationLoader appLoader = appLoaderFactory.createApplicationLoader(id, this.parentClassLoader, (AppsManager)this.configManager);
        _logger.log(Level.FINEST, "ApplicationLoader " + appLoader);
        return appLoader;
    }

    boolean applicationDeployed(String appID) {
        return this.applicationDeployed(false, appID, true);
    }

    boolean applicationDeployed(boolean jsr77, String appID) {
        return this.applicationDeployed(jsr77, appID, true);
    }

    boolean applicationDeployed(boolean jsr77, String appID, ConfigContext dynamicConfigContext) {
        return this.applicationDeployed(jsr77, appID, true, dynamicConfigContext);
    }

    boolean applicationDeployed(boolean jsr77, String appID, ConfigContext dynamicConfigContext, int loadUnloadAction) {
        return this.applicationDeployed(jsr77, appID, true, dynamicConfigContext, loadUnloadAction);
    }

    boolean applicationDeployed(boolean jsr77, String appID, boolean addToRM) {
        return this.applicationDeployed(jsr77, appID, addToRM, null);
    }

    boolean applicationDeployed(boolean jsr77, String appID, boolean addToRM, ConfigContext dynamicConfigContext) {
        return this.applicationDeployed(jsr77, appID, addToRM, dynamicConfigContext, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean applicationDeployed(boolean jsr77, String appID, boolean addToRM, ConfigContext dynamicConfigContext, int loadUnloadAction) {
        boolean handlePostLoadAction;
        boolean handlePreLoadAction;
        AbstractLoader appLoader;
        boolean loadJSR77;
        boolean deployed;
        block42: {
            block41: {
                deployed = false;
                loadJSR77 = jsr77 || this.loadJSR77(appID, DeployableObjectType.APP);
                appLoader = null;
                try {
                    if (this.configManager.isSystem(appID)) {
                        return true;
                    }
                }
                catch (ConfigException confEx) {
                    _logger.log(Level.WARNING, "core.error_while_loading_app", confEx);
                }
                if (loadUnloadAction == 0) {
                    loadUnloadAction = 1;
                }
                handlePreLoadAction = loadUnloadAction == 1 || loadUnloadAction == 2;
                boolean bl = handlePostLoadAction = loadUnloadAction == 1 || loadUnloadAction == 3;
                if (handlePreLoadAction && addToRM) {
                    this.addToReloadMonitor(appID);
                }
                if (this.id2loader.get(appID) == null) break block41;
                boolean bl2 = true;
                Object var15_19 = null;
                if (appLoader != null) {
                    appLoader.setConfigContext(null);
                }
                return bl2;
            }
            if (handlePreLoadAction) {
                appLoader = this.getLoader(appID);
                if (loadUnloadAction == 1) {
                    this.id2loader.put(appID, appLoader);
                } else if (loadUnloadAction == 2) {
                    this.id2loader.put(appID + RAR, appLoader);
                }
                break block42;
            }
            if (loadUnloadAction != 3) break block42;
            appLoader = (AbstractLoader)this.id2loader.remove(appID + RAR);
            if (appLoader != null) {
                this.id2loader.put(appID, appLoader);
                break block42;
            }
            boolean bl = false;
            Object var15_20 = null;
            if (appLoader != null) {
                appLoader.setConfigContext(null);
            }
            return bl;
        }
        try {
            block43: {
                try {
                    appLoader.setConfigContext(dynamicConfigContext);
                    appLoader.setLoadUnloadAction(loadUnloadAction);
                    if (handlePreLoadAction && loadJSR77) {
                        try {
                            appLoader.createRootMBean();
                        }
                        catch (MBeanException mbe) {
                            _logger.log(Level.WARNING, "core.error_while_creating_jsr77_root_mbean", mbe);
                        }
                    }
                    if (this.isEnabled(dynamicConfigContext, appID)) {
                        boolean retSts;
                        _logger.log(Level.FINEST, "[ApplicationManager] Application is enabled: " + appID);
                        if (handlePreLoadAction) {
                            try {
                                appLoader.setState(0);
                            }
                            catch (MBeanException mbe) {
                                _logger.log(Level.WARNING, "core.error_while_setting_jsr77_state", mbe);
                            }
                        }
                        deployed = retSts = appLoader.load(jsr77);
                        if (handlePostLoadAction && retSts) {
                            try {
                                appLoader.setState(1);
                            }
                            catch (MBeanException mbe) {
                                _logger.log(Level.WARNING, "core.error_while_setting_jsr77_state", mbe);
                            }
                            deployed = true;
                            SecurityRoleMapperFactory factory = SecurityRoleMapperFactoryMgr.getFactory();
                            if (factory == null) {
                                throw new IllegalArgumentException(localStrings.getString("enterprise.deployment.deployment.norolemapperfactorydefine", "This application has no role mapper factory defined"));
                            }
                            break block43;
                        }
                        if (retSts) break block43;
                        if (handlePreLoadAction && loadJSR77) {
                            try {
                                appLoader.deleteLeafAndRootMBeans();
                            }
                            catch (MBeanException mbe) {
                                _logger.log(Level.WARNING, "core.error_while_deleting_jsr77_leaf_and_root_mbean", mbe);
                            }
                        } else if (!loadJSR77) {
                            try {
                                appLoader.setState(4);
                            }
                            catch (MBeanException mbe) {
                                _logger.log(Level.WARNING, "core.error_while_setting_jsr77_state", mbe);
                            }
                        }
                        try {
                            appLoader.done();
                        }
                        catch (Throwable thr) {
                            String msg = localStrings.getString("core.application_not_loaded", appID);
                            _logger.log(Level.INFO, msg, thr);
                        }
                        _logger.log(Level.WARNING, "core.application_not_loaded", appID);
                        break block43;
                    }
                    _logger.log(Level.INFO, "core.application_disabled", appID);
                    deployed = false;
                }
                catch (ConfigException confEx) {
                    _logger.log(Level.WARNING, "core.error_while_loading_app", confEx);
                    Object var15_22 = null;
                    if (appLoader != null) {
                        appLoader.setConfigContext(null);
                    }
                }
            }
            Object var15_21 = null;
            if (appLoader != null) {
                appLoader.setConfigContext(null);
            }
        }
        catch (Throwable throwable) {
            Object var15_23 = null;
            if (appLoader != null) {
                appLoader.setConfigContext(null);
            }
            throw throwable;
        }
        return deployed;
    }

    boolean applicationUndeployed(String appID) {
        return this.applicationUndeployed(false, appID, true);
    }

    boolean applicationUndeployed(boolean jsr77, String appID) {
        return this.applicationUndeployed(jsr77, appID, true);
    }

    boolean applicationUndeployed(boolean jsr77, String appID, boolean clearRM) {
        return this.applicationUndeployed(jsr77, appID, clearRM, false);
    }

    boolean applicationUndeployed(boolean jsr77, String appID, boolean clearRM, boolean cascade) {
        return this.applicationUndeployed(jsr77, appID, clearRM, cascade, 4);
    }

    boolean applicationUndeployed(boolean jsr77, String appID, boolean clearRM, boolean cascade, int loadUnloadAction) {
        boolean handlePostUnloadAction;
        if (loadUnloadAction == 0) {
            loadUnloadAction = 4;
        }
        boolean handlePreUnloadAction = loadUnloadAction == 4 || loadUnloadAction == 6;
        boolean bl = handlePostUnloadAction = loadUnloadAction == 4 || loadUnloadAction == 5;
        if (handlePreUnloadAction && clearRM) {
            this.removeFromReloadMonitor(appID);
        }
        AbstractLoader appLoader = (AbstractLoader)this.id2loader.get(appID);
        if (handlePostUnloadAction) {
            appLoader = (AbstractLoader)this.id2loader.remove(appID);
        }
        if (appLoader == null || appLoader != null && appLoader.getApplication() == null) {
            return true;
        }
        appLoader.setCascade(cascade);
        appLoader.setLoadUnloadAction(loadUnloadAction);
        Application app = appLoader.getApplication();
        if (handlePreUnloadAction) {
            try {
                appLoader.setState(2);
            }
            catch (MBeanException mbe) {
                _logger.log(Level.WARNING, "core.error_while_setting_jsr77_state", mbe);
            }
            RoleMapper.removeRoleMapper(app.getRoleMapper().getName());
            if (jsr77) {
                try {
                    appLoader.deleteLeafAndRootMBeans();
                }
                catch (MBeanException mbe) {
                    _logger.log(Level.WARNING, "core.error_while_deleting_jsr77_leaf_and_root_mbeans", mbe);
                }
            } else {
                try {
                    appLoader.setState(3);
                }
                catch (MBeanException mbe) {
                    _logger.log(Level.WARNING, "core.error_while_setting_jsr77_state", mbe);
                }
            }
        }
        boolean undeployed = appLoader.unload(jsr77);
        if (loadUnloadAction == 6) {
            return undeployed;
        }
        if (undeployed) {
            if (app.getEjbComponentCount() > 0) {
                _logger.log(Level.INFO, "core.application_unloaded_ejb", appID);
            }
        } else {
            _logger.log(Level.INFO, "core.application_not_unloaded", appID);
        }
        return undeployed;
    }

    private void holdRequest() {
    }

    private void holdRequest(String appID) {
    }

    public synchronized boolean reload(MonitorableEntry entry) {
        String appName = entry.getId();
        boolean status = false;
        try {
            DeploymentRequest req = new DeploymentRequest(this.configManager.getInstanceEnvironment(), DeployableObjectType.APP, DeploymentCommand.DEPLOY);
            req.setFileSource(entry.getMonitoredFile().getParentFile());
            req.setName(appName);
            req.setForced(true);
            AutoDirReDeployer deployer = new AutoDirReDeployer(req);
            status = deployer.redeploy();
        }
        catch (IASDeploymentException de) {
            _logger.log(Level.WARNING, "core.error_while_redeploying_app", de);
            return false;
        }
        return status;
    }

    public synchronized void applicationDeployed(ApplicationDeployEvent event) throws AdminEventListenerException {
        try {
            block9: {
                try {
                    AbstractLoader appLoader;
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, "[ApplicationManager] Handling event " + event.toString());
                    }
                    DeployEventListenerHelper.getDeployEventListenerHelper().synchronize(event);
                    this.configManager.refreshConfigContext(event.getConfigContext());
                    boolean jsr77 = false;
                    String action = event.getAction();
                    if (action.equals("deploy") || action.equals("redeploy")) {
                        jsr77 = true;
                    }
                    String appName = event.getApplicationName();
                    ConnectorResourcesLoader connecorResourcesLoader = null;
                    if (event.getForceDeploy()) {
                        ResourcesUtil.setEventConfigContext(event.getConfigContext());
                        connecorResourcesLoader = new ConnectorResourcesLoader();
                        if (event.getLoadUnloadAction() == 2) {
                            connecorResourcesLoader.loadEmbeddedRarRAConfigs(appName);
                        }
                    }
                    if (this.isEnabled(event.getConfigContext(), appName) && !this.applicationDeployed(jsr77, appName, event.getConfigContext(), event.getLoadUnloadAction())) {
                        String msg = localStrings.getString("applicationmgr.application_deployed_failed", appName);
                        this.registerException(event, msg);
                    }
                    if (event.getLoadUnloadAction() != 3 || !event.getForceDeploy() || (appLoader = (AbstractLoader)this.id2loader.get(appName)) == null) break block9;
                    Application appDescriptor = appLoader.getApplication();
                    connecorResourcesLoader.loadEmbeddedRarResources(appName, appDescriptor);
                }
                catch (ConfigException ce) {
                    throw new AdminEventListenerException(ce.getMessage());
                }
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            ResourcesUtil.resetEventConfigContext();
            throw throwable;
        }
        ResourcesUtil.resetEventConfigContext();
    }

    public synchronized void applicationUndeployed(ApplicationDeployEvent event) throws AdminEventListenerException {
        boolean jsr77 = false;
        String action = event.getAction();
        if (action.equals("undeploy") || action.equals("redeploy")) {
            jsr77 = true;
        }
        try {
            boolean undeployed;
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "[ApplicationManager] Handling event " + event.toString());
            }
            this.configManager.refreshConfigContext(event.getOldConfigContext());
            String appName = event.getApplicationName();
            if (event.getForceDeploy()) {
                event.setCascade(true);
            }
            if (!(undeployed = this.applicationUndeployed(jsr77, appName, true, event.getCascade(), event.getLoadUnloadAction()))) {
                String msg = localStrings.getString("applicationmgr.application_undeployed_failed", appName);
                this.registerException(event, msg);
            }
        }
        catch (ConfigException ce) {
            throw new AdminEventListenerException(ce.getMessage());
        }
    }

    public synchronized void applicationRedeployed(ApplicationDeployEvent event) throws AdminEventListenerException {
        try {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "[ApplicationManager] Handling event " + event.toString());
            }
            this.configManager.refreshConfigContext(event.getConfigContext());
            String appName = event.getApplicationName();
            boolean ok = this.applicationUndeployed(true, appName);
            if (ok) {
                ok = this.applicationDeployed(true, appName, event.getConfigContext());
            }
            if (!ok) {
                String msg = localStrings.getString("applicationmgr.application_redeployed_failed", appName);
                this.registerException(event, msg);
            }
        }
        catch (ConfigException ce) {
            throw new AdminEventListenerException(ce.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void applicationEnabled(ApplicationDeployEvent event) throws AdminEventListenerException {
        block12: {
            block11: {
                try {
                    try {
                        AbstractLoader appLoader;
                        Application appDescriptor;
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.log(Level.FINEST, "[ApplicationManager] Handling event " + event.toString());
                        }
                        if (!this.isEnabled(event.getConfigContext(), event.getApplicationName())) {
                            Object var9_2 = null;
                            break block11;
                        }
                        this.configManager.refreshConfigContext(event.getConfigContext());
                        String appName = event.getApplicationName();
                        boolean cascade = true;
                        ConnectorResourcesLoader connecorResourcesLoader = new ConnectorResourcesLoader();
                        ResourcesUtil.setEventConfigContext(event.getConfigContext());
                        connecorResourcesLoader.loadEmbeddedRarRAConfigs(appName);
                        boolean enabled = this.applicationDeployed(false, appName, event.getConfigContext());
                        if (!enabled) {
                            String msg = localStrings.getString("applicationmgr.application_enabled_failed", appName);
                            this.registerException(event, msg);
                        }
                        if ((appDescriptor = (appLoader = (AbstractLoader)this.id2loader.get(appName)).getApplication()) != null) {
                            connecorResourcesLoader.loadEmbeddedRarResources(appName, appDescriptor);
                            break block12;
                        } else {
                            _logger.log(Level.FINE, "[ApplicationManager] Application descriptor is NULL.  Skip loading embedded rar resources...");
                        }
                        break block12;
                    }
                    catch (ConfigException ce) {
                        throw new AdminEventListenerException(ce.getMessage());
                    }
                    catch (Throwable th) {
                        AdminEventListenerException aele = new AdminEventListenerException(th.getMessage());
                        aele.initCause(th);
                        throw aele;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_4 = null;
                    ResourcesUtil.resetEventConfigContext();
                    throw throwable;
                }
            }
            ResourcesUtil.resetEventConfigContext();
            return;
        }
        Object var9_3 = null;
        ResourcesUtil.resetEventConfigContext();
    }

    public synchronized void applicationDisabled(ApplicationDeployEvent event) throws AdminEventListenerException {
        try {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "[ApplicationManager] Handling event " + event.toString());
            }
            this.configManager.refreshConfigContext(event.getConfigContext());
            String appName = event.getApplicationName();
            AbstractLoader appLoader = (AbstractLoader)this.id2loader.get(appName);
            if (appLoader == null) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "[ApplicationManager] appLoader Null. Returning applicationDisabled");
                }
                return;
            }
            event.setCascade(true);
            boolean disabled = this.applicationUndeployed(false, appName, true, true);
            if (!disabled) {
                String msg = localStrings.getString("applicationmgr.application_disabled_failed", appName);
                this.registerException(event, msg);
            }
        }
        catch (ConfigException ce) {
            throw new AdminEventListenerException(ce.getMessage());
        }
    }

    public void applicationReferenceAdded(ApplicationDeployEvent event) throws AdminEventListenerException {
    }

    public void applicationReferenceRemoved(ApplicationDeployEvent event) throws AdminEventListenerException {
    }
}

