/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jmac.config;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityBindingDescriptor;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.security.AppservAccessController;
import com.sun.enterprise.security.jauth.AuthParam;
import com.sun.enterprise.security.jauth.AuthPolicy;
import com.sun.enterprise.security.jauth.ClientAuthModule;
import com.sun.enterprise.security.jauth.FailureException;
import com.sun.enterprise.security.jauth.HttpServletAuthParam;
import com.sun.enterprise.security.jauth.PendingException;
import com.sun.enterprise.security.jauth.SOAPAuthParam;
import com.sun.enterprise.security.jmac.AuthMessagePolicy;
import com.sun.enterprise.security.jmac.PacketMessageInfo;
import com.sun.enterprise.security.jmac.config.ConfigParser;
import com.sun.logging.LogDomains;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.MessagePolicy;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.config.AuthConfig;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.ClientAuthConfig;
import javax.security.auth.message.config.ClientAuthContext;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.security.auth.message.config.ServerAuthContext;
import javax.security.auth.message.module.ServerAuthModule;
import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;

public class GFServerConfigProvider
implements AuthConfigProvider {
    public static final String SOAP = "SOAP";
    public static final String HTTPSERVLET = "HttpServlet";
    protected static final String CLIENT = "client";
    protected static final String SERVER = "server";
    protected static final String MANAGES_SESSIONS_OPTION = "managessessions";
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    private static final String DEFAULT_HANDLER_CLASS = "com.sun.enterprise.security.jmac.callback.ContainerCallbackHandler";
    private static final String DEFAULT_PARSER_CLASS = "com.sun.enterprise.security.jmac.config.ConfigXMLParser";
    private static final ThreadLocal<Subject> subjectLocal = new ThreadLocal();
    protected static final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    protected static final Map<String, String> layerDefaultRegisIDMap = new HashMap<String, String>();
    protected static int epoch;
    protected static String parserClassName;
    protected static ConfigParser parser;
    protected static boolean parserInitialized;
    protected static AuthConfigFactory slaveFactory;
    protected static AuthConfigProvider slaveProvider;
    protected AuthConfigFactory factory = null;

    private GFServerConfigProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GFServerConfigProvider(Map properties, AuthConfigFactory factory) {
        this.factory = factory;
        this.initializeParser();
        if (factory != null) {
            boolean hasSlaveFactory = false;
            try {
                rwLock.readLock().lock();
                hasSlaveFactory = slaveFactory != null;
            }
            finally {
                rwLock.readLock().unlock();
            }
            if (!hasSlaveFactory) {
                try {
                    rwLock.writeLock().lock();
                    if (slaveFactory == null) {
                        slaveFactory = factory;
                    }
                }
                finally {
                    rwLock.writeLock().unlock();
                }
            }
        }
        boolean hasSlaveProvider = false;
        try {
            rwLock.readLock().lock();
            hasSlaveProvider = slaveProvider != null;
        }
        finally {
            rwLock.readLock().unlock();
        }
        if (!hasSlaveProvider) {
            try {
                rwLock.writeLock().lock();
                if (slaveProvider == null) {
                    slaveProvider = this;
                }
            }
            finally {
                rwLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeParser() {
        try {
            rwLock.readLock().lock();
            if (parserInitialized) {
                return;
            }
        }
        finally {
            rwLock.readLock().unlock();
        }
        try {
            rwLock.writeLock().lock();
            if (!parserInitialized) {
                parserClassName = System.getProperty("config.parser", DEFAULT_PARSER_CLASS);
                GFServerConfigProvider.loadParser(this, this.factory, null);
                parserInitialized = true;
            }
        }
        finally {
            rwLock.writeLock().unlock();
        }
    }

    protected static ModuleInfo createModuleInfo(Entry entry, CallbackHandler handler, String type, Map properties) throws AuthException {
        try {
            Object newModule = entry.newInstance();
            HashMap map = properties;
            Map entryOptions = entry.getOptions();
            if (entryOptions != null) {
                map = map == null ? new HashMap() : new HashMap(map);
                map.putAll(entryOptions);
            }
            if (SERVER.equals(type)) {
                if (newModule instanceof ServerAuthModule) {
                    ServerAuthModule sam = (ServerAuthModule)newModule;
                    sam.initialize(entry.getRequestPolicy(), entry.getResponsePolicy(), handler, map);
                } else if (newModule instanceof com.sun.enterprise.security.jauth.ServerAuthModule) {
                    com.sun.enterprise.security.jauth.ServerAuthModule sam0 = (com.sun.enterprise.security.jauth.ServerAuthModule)newModule;
                    AuthPolicy requestPolicy = entry.getRequestPolicy() != null ? new AuthPolicy(entry.getRequestPolicy()) : null;
                    AuthPolicy responsePolicy = entry.getResponsePolicy() != null ? new AuthPolicy(entry.getResponsePolicy()) : null;
                    sam0.initialize(requestPolicy, responsePolicy, handler, map);
                }
            } else if (newModule instanceof javax.security.auth.message.module.ClientAuthModule) {
                javax.security.auth.message.module.ClientAuthModule cam = (javax.security.auth.message.module.ClientAuthModule)newModule;
                cam.initialize(entry.getRequestPolicy(), entry.getResponsePolicy(), handler, map);
            } else if (newModule instanceof ClientAuthModule) {
                ClientAuthModule cam0 = (ClientAuthModule)newModule;
                AuthPolicy requestPolicy = new AuthPolicy(entry.getRequestPolicy());
                AuthPolicy responsePolicy = new AuthPolicy(entry.getResponsePolicy());
                cam0.initialize(requestPolicy, responsePolicy, handler, map);
            }
            return new ModuleInfo(newModule, map);
        }
        catch (Exception e) {
            if (e instanceof AuthException) {
                throw (AuthException)e;
            }
            AuthException ae = new AuthException();
            ae.initCause((Throwable)e);
            throw ae;
        }
    }

    private static Object createObject(String className) {
        try {
            final String finalClassName = className;
            return AppservAccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    Class<?> c = Class.forName(finalClassName, true, loader);
                    return c.newInstance();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException(pae.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Entry getEntry(String intercept, String id, MessagePolicy requestPolicy, MessagePolicy responsePolicy, String type) {
        MessagePolicy respP;
        Map configMap;
        try {
            rwLock.readLock().lock();
            configMap = parser.getConfigMap();
        }
        finally {
            rwLock.readLock().unlock();
        }
        if (configMap == null) {
            return null;
        }
        InterceptEntry intEntry = (InterceptEntry)configMap.get(intercept);
        if (intEntry == null || intEntry.idMap == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("module config has no IDs configured for [" + intercept + "]");
            }
            return null;
        }
        IDEntry idEntry = null;
        if (id == null || (idEntry = (IDEntry)intEntry.idMap.get(id)) == null) {
            String defaultID;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("DD did not specify ID, or DD-specified ID for [" + intercept + "] not found in config -- " + "attempting to look for default ID");
            }
            if ((idEntry = (IDEntry)intEntry.idMap.get(defaultID = CLIENT.equals(type) ? intEntry.defaultClientID : intEntry.defaultServerID)) == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("no default config ID for [" + intercept + "]");
                }
                return null;
            }
        }
        if (idEntry.type.indexOf(type) < 0) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("request type [" + type + "] does not match config type [" + idEntry.type + "]");
            }
            return null;
        }
        MessagePolicy reqP = requestPolicy != null || responsePolicy != null ? requestPolicy : idEntry.requestPolicy;
        MessagePolicy messagePolicy = respP = requestPolicy != null || responsePolicy != null ? responsePolicy : idEntry.responsePolicy;
        if (reqP == null && respP == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("no policy applies");
            }
            return null;
        }
        Entry entry = new Entry(idEntry.moduleClassName, reqP, respP, idEntry.options);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("getEntry for: " + intercept + " -- " + id + "\n    module class: " + entry.moduleClassName + "\n    options: " + entry.options + "\n    request policy: " + entry.requestPolicy + "\n    response policy: " + entry.responsePolicy);
        }
        return entry;
    }

    public ClientAuthConfig getClientAuthConfig(String layer, String appContext, CallbackHandler handler) throws AuthException {
        return new GFClientAuthConfig(this, layer, appContext, handler);
    }

    public ServerAuthConfig getServerAuthConfig(String layer, String appContext, CallbackHandler handler) throws AuthException {
        return new GFServerAuthConfig(this, layer, appContext, handler);
    }

    public void refresh() {
        GFServerConfigProvider.loadParser(this, this.factory, null);
    }

    public static void loadConfigContext(ConfigContext configContext) {
        AuthConfigFactory aFactory = slaveFactory;
        if (aFactory == null) {
            aFactory = AuthConfigFactory.getFactory();
        }
        GFServerConfigProvider.loadParser(slaveProvider, slaveFactory, configContext);
    }

    protected static void loadParser(AuthConfigProvider aProvider, AuthConfigFactory aFactory, ConfigContext configContext) {
        try {
            rwLock.writeLock().lock();
            int next = epoch + 1;
            ConfigParser nextParser = (ConfigParser)GFServerConfigProvider.createObject(parserClassName);
            nextParser.initialize(configContext);
            if (aFactory != null && aProvider != null) {
                String regisID;
                Set<String> layerSet = nextParser.getLayersWithDefault();
                for (String layer : layerDefaultRegisIDMap.keySet()) {
                    if (layerSet.contains(layer)) continue;
                    regisID = layerDefaultRegisIDMap.remove(layer);
                    aFactory.removeRegistration(regisID);
                }
                for (String layer : layerSet) {
                    if (layerDefaultRegisIDMap.containsKey(layer)) continue;
                    regisID = aFactory.registerConfigProvider(aProvider, layer, null, "GFServerConfigProvider: self registration");
                    layerDefaultRegisIDMap.put(layer, regisID);
                }
            }
            epoch = next == 0 ? 1 : next;
            parser = nextParser;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            rwLock.writeLock().unlock();
        }
    }

    protected static ClassLoader getClassLoader() {
        ClassLoader rvalue = (ClassLoader)AppservAccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        return rvalue;
    }

    public static void setValidateRequestSubject(Subject subject) {
        subjectLocal.set(subject);
    }

    static {
        parserClassName = null;
        parserInitialized = false;
        slaveFactory = null;
        slaveProvider = null;
    }

    static class Entry {
        private static final Class[] PARAMS = new Class[0];
        private static final Object[] ARGS = new Object[0];
        private String moduleClassName;
        private MessagePolicy requestPolicy;
        private MessagePolicy responsePolicy;
        private Map options;
        Object module;

        Entry(String moduleClassName, MessagePolicy requestPolicy, MessagePolicy responsePolicy, Map options) {
            this.moduleClassName = moduleClassName;
            this.requestPolicy = requestPolicy;
            this.responsePolicy = responsePolicy;
            this.options = options;
        }

        MessagePolicy getRequestPolicy() {
            return this.requestPolicy;
        }

        MessagePolicy getResponsePolicy() {
            return this.responsePolicy;
        }

        String getModuleClassName() {
            return this.moduleClassName;
        }

        Map getOptions() {
            return this.options;
        }

        Object newInstance() throws AuthException {
            try {
                ClassLoader finalLoader = GFServerConfigProvider.getClassLoader();
                Class<?> c = Class.forName(this.moduleClassName, true, finalLoader);
                Constructor<?> constructor = c.getConstructor(PARAMS);
                return constructor.newInstance(ARGS);
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "jmac.provider_unable_to_load_authmodule", new String[]{this.moduleClassName, e.toString()});
                }
                AuthException ae = new AuthException();
                ae.initCause((Throwable)e);
                throw ae;
            }
        }
    }

    class GFAuthConfig
    implements AuthConfig {
        protected AuthConfigProvider provider = null;
        protected String layer = null;
        protected String appContext = null;
        protected CallbackHandler handler = null;
        protected String type = null;
        protected String providerID = null;
        protected boolean init = false;
        protected boolean onePolicy = false;
        protected boolean newHandler = false;
        protected MessageSecurityBindingDescriptor binding = null;
        protected SunWebApp sunWebApp = null;

        protected GFAuthConfig(AuthConfigProvider provider, String layer, String appContext, CallbackHandler handler, String type) {
            this.provider = provider;
            this.layer = layer;
            this.appContext = appContext;
            this.type = type;
            if (handler == null) {
                handler = AuthMessagePolicy.getDefaultCallbackHandler();
                this.newHandler = true;
            }
            this.handler = handler;
        }

        public String getMessageLayer() {
            return this.layer;
        }

        public String getAppContext() {
            return this.appContext;
        }

        public String getAuthContextID(MessageInfo messageInfo) {
            if (GFServerConfigProvider.SOAP.equals(this.layer)) {
                String rvalue = null;
                if (messageInfo instanceof PacketMessageInfo) {
                    QName n;
                    WSDLBoundOperation w;
                    WSDLPort port;
                    Message m;
                    PacketMessageInfo pmi = (PacketMessageInfo)messageInfo;
                    Packet p = pmi.getRequestPacket();
                    if (p != null && (m = p.getMessage()) != null && (port = (WSDLPort)messageInfo.getMap().get("WSDL_MODEL")) != null && (w = m.getOperation(port)) != null && (n = w.getName()) != null) {
                        rvalue = n.getLocalPart();
                    }
                    return rvalue;
                }
                return this.getOpName((SOAPMessage)messageInfo.getRequestMessage());
            }
            if (GFServerConfigProvider.HTTPSERVLET.equals(this.layer)) {
                String isMandatoryStr = (String)messageInfo.getMap().get("javax.security.auth.message.MessagePolicy.isMandatory");
                return Boolean.valueOf(isMandatoryStr).toString();
            }
            return null;
        }

        private String getOpName(SOAPMessage message) {
            Name name;
            String[] actions;
            if (message == null) {
                return null;
            }
            String rvalue = null;
            MimeHeaders headers = message.getMimeHeaders();
            if (headers != null && (actions = headers.getHeader("SOAPAction")) != null && actions.length > 0 && (rvalue = actions[0]) != null && rvalue.equals("\"\"")) {
                rvalue = null;
            }
            if (rvalue == null && (name = this.getName(message)) != null) {
                rvalue = name.getLocalName();
            }
            return rvalue;
        }

        private Name getName(SOAPMessage message) {
            Name rvalue;
            block4: {
                rvalue = null;
                SOAPPart soap = message.getSOAPPart();
                if (soap != null) {
                    try {
                        SOAPBody body;
                        SOAPEnvelope envelope = soap.getEnvelope();
                        if (envelope == null || (body = envelope.getBody()) == null) break block4;
                        Iterator it = body.getChildElements();
                        while (it.hasNext()) {
                            Object o = it.next();
                            if (!(o instanceof SOAPElement)) continue;
                            rvalue = ((SOAPElement)o).getElementName();
                            break;
                        }
                    }
                    catch (SOAPException se) {
                        if (!logger.isLoggable(Level.FINE)) break block4;
                        logger.log(Level.FINE, "WSS: Unable to get SOAP envelope", se);
                    }
                }
            }
            return rvalue;
        }

        public void refresh() {
            GFServerConfigProvider.loadParser(this.provider, GFServerConfigProvider.this.factory, null);
        }

        public boolean isProtected() {
            return true;
        }

        protected AuthParam getAuthParam(MessageInfo info) throws AuthException {
            if (GFServerConfigProvider.SOAP.equals(this.layer)) {
                if (info instanceof PacketMessageInfo) {
                    return ((PacketMessageInfo)info).getSOAPAuthParam();
                }
                return new SOAPAuthParam((SOAPMessage)info.getRequestMessage(), (SOAPMessage)info.getResponseMessage());
            }
            if (GFServerConfigProvider.HTTPSERVLET.equals(this.layer)) {
                return new HttpServletAuthParam(info);
            }
            throw new AuthException();
        }

        CallbackHandler getCallbackHandler() {
            return this.handler;
        }

        protected ModuleInfo getModuleInfo(String authContextID, Map properties) throws AuthException {
            if (!this.init) {
                this.initialize(properties);
            }
            MessagePolicy[] policies = null;
            policies = GFServerConfigProvider.SOAP.equals(this.layer) ? AuthMessagePolicy.getSOAPPolicies(this.binding, authContextID, this.onePolicy) : AuthMessagePolicy.getHttpServletPolicies(authContextID);
            MessagePolicy requestPolicy = policies[0];
            MessagePolicy responsePolicy = policies[1];
            Entry entry = GFServerConfigProvider.this.getEntry(this.layer, this.providerID, requestPolicy, responsePolicy, this.type);
            return entry != null ? GFServerConfigProvider.createModuleInfo(entry, this.handler, this.type, properties) : null;
        }

        private void initialize(Map properties) {
            if (!this.init) {
                if (GFServerConfigProvider.SOAP.equals(this.layer)) {
                    this.binding = AuthMessagePolicy.getMessageSecurityBinding(this.layer, properties);
                    this.providerID = AuthMessagePolicy.getProviderID(this.binding);
                    this.onePolicy = AuthMessagePolicy.oneSOAPPolicy(this.binding);
                } else {
                    this.sunWebApp = AuthMessagePolicy.getSunWebApp(properties);
                    this.providerID = AuthMessagePolicy.getProviderID(this.sunWebApp);
                    this.onePolicy = true;
                }
                this.init = true;
            }
        }
    }

    class GFClientAuthConfig
    extends GFAuthConfig
    implements ClientAuthConfig {
        protected GFClientAuthConfig(AuthConfigProvider provider, String layer, String appContext, CallbackHandler handler) {
            super(provider, layer, appContext, handler, GFServerConfigProvider.CLIENT);
        }

        public ClientAuthContext getAuthContext(String authContextID, Subject clientSubject, Map properties) throws AuthException {
            GFClientAuthContext clientAuthContext = null;
            ModuleInfo moduleInfo = this.getModuleInfo(authContextID, properties);
            if (moduleInfo != null && moduleInfo.getModule() != null) {
                Object moduleObj = moduleInfo.getModule();
                Map map = moduleInfo.getMap();
                clientAuthContext = moduleObj instanceof javax.security.auth.message.module.ClientAuthModule ? new GFClientAuthContext(this, (javax.security.auth.message.module.ClientAuthModule)moduleObj, map) : new GFClientAuthContext(this, (ClientAuthModule)moduleObj, map);
            }
            return clientAuthContext;
        }
    }

    protected static class GFClientAuthContext
    implements ClientAuthContext {
        private GFClientAuthConfig config;
        private javax.security.auth.message.module.ClientAuthModule module;
        private ClientAuthModule oldModule;
        private Map map;

        protected GFClientAuthContext(GFClientAuthConfig config, javax.security.auth.message.module.ClientAuthModule module, Map map) {
            this.config = config;
            this.module = module;
            this.oldModule = null;
            this.map = map;
        }

        protected GFClientAuthContext(GFClientAuthConfig config, ClientAuthModule module, Map map) {
            this.config = config;
            this.module = null;
            this.oldModule = module;
            this.map = map;
        }

        public AuthStatus secureRequest(MessageInfo messageInfo, Subject clientSubject) throws AuthException {
            if (this.module != null) {
                return this.module.secureRequest(messageInfo, clientSubject);
            }
            if (this.oldModule != null) {
                this.oldModule.secureRequest(this.config.getAuthParam(messageInfo), clientSubject, messageInfo.getMap());
                return AuthStatus.SEND_SUCCESS;
            }
            throw new AuthException();
        }

        public AuthStatus validateResponse(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
            if (this.module != null) {
                return this.module.validateResponse(messageInfo, clientSubject, serviceSubject);
            }
            if (this.oldModule != null) {
                this.oldModule.validateResponse(this.config.getAuthParam(messageInfo), clientSubject, messageInfo.getMap());
                return AuthStatus.SUCCESS;
            }
            throw new AuthException();
        }

        public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
            if (this.module != null) {
                this.module.cleanSubject(messageInfo, subject);
            } else if (this.oldModule != null) {
                this.oldModule.disposeSubject(subject, messageInfo.getMap());
            } else {
                throw new AuthException();
            }
        }
    }

    class GFServerAuthConfig
    extends GFAuthConfig
    implements ServerAuthConfig {
        protected GFServerAuthConfig(AuthConfigProvider provider, String layer, String appContext, CallbackHandler handler) {
            super(provider, layer, appContext, handler, GFServerConfigProvider.SERVER);
        }

        public ServerAuthContext getAuthContext(String authContextID, Subject serviceSubject, Map properties) throws AuthException {
            GFServerAuthContext serverAuthContext = null;
            ModuleInfo moduleInfo = this.getModuleInfo(authContextID, properties);
            if (moduleInfo != null && moduleInfo.getModule() != null) {
                Object moduleObj = moduleInfo.getModule();
                Map map = moduleInfo.getMap();
                serverAuthContext = moduleObj instanceof ServerAuthModule ? new GFServerAuthContext(this, (ServerAuthModule)moduleObj, map) : new GFServerAuthContext(this, (com.sun.enterprise.security.jauth.ServerAuthModule)moduleObj, map);
            }
            return serverAuthContext;
        }
    }

    protected static class GFServerAuthContext
    implements ServerAuthContext {
        private GFServerAuthConfig config;
        private ServerAuthModule module;
        private com.sun.enterprise.security.jauth.ServerAuthModule oldModule;
        private Map map;
        boolean managesSession = false;

        protected GFServerAuthContext(GFServerAuthConfig config, ServerAuthModule module, Map map) {
            this.config = config;
            this.module = module;
            this.oldModule = null;
            this.map = map;
        }

        protected GFServerAuthContext(GFServerAuthConfig config, com.sun.enterprise.security.jauth.ServerAuthModule module, Map map) {
            String msStr;
            this.config = config;
            this.module = null;
            this.oldModule = module;
            this.map = map;
            if (map != null && (msStr = (String)map.get(GFServerConfigProvider.MANAGES_SESSIONS_OPTION)) != null) {
                this.managesSession = Boolean.valueOf(msStr);
            }
        }

        private static void setCallerPrincipals(final Subject s, final CallbackHandler handler, final Subject pvcSubject) throws AuthException {
            if (handler != null) {
                try {
                    AppservAccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            Set<Principal> ps = s.getPrincipals();
                            Iterator<Principal> it = ps.iterator();
                            if (ps == null || ps.isEmpty()) {
                                return null;
                            }
                            Callback[] callbacks = new Callback[]{new CallerPrincipalCallback(s, it.next().getName())};
                            if (pvcSubject != null) {
                                s.getPrincipals().addAll(pvcSubject.getPrincipals());
                            }
                            handler.handle(callbacks);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    Throwable cause = pae.getCause();
                    AuthException aex = new AuthException();
                    aex.initCause(cause);
                    throw aex;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
            if (this.module != null) {
                return this.module.validateRequest(messageInfo, clientSubject, serviceSubject);
            }
            if (this.oldModule != null) {
                try {
                    subjectLocal.remove();
                    this.oldModule.validateRequest(this.config.getAuthParam(messageInfo), clientSubject, messageInfo.getMap());
                    GFServerAuthContext.setCallerPrincipals(clientSubject, this.config.getCallbackHandler(), (Subject)subjectLocal.get());
                    if (!this.managesSession && GFServerConfigProvider.HTTPSERVLET.equals(this.config.getMessageLayer())) {
                        messageInfo.getMap().put("com.sun.web.RealmAdapter.register", Boolean.TRUE.toString());
                    }
                    AuthStatus authStatus = AuthStatus.SUCCESS;
                    return authStatus;
                }
                catch (PendingException pe) {
                    AuthStatus authStatus = AuthStatus.SEND_CONTINUE;
                    return authStatus;
                }
                catch (FailureException fe) {
                    AuthStatus authStatus = AuthStatus.SEND_FAILURE;
                    return authStatus;
                }
                finally {
                    subjectLocal.remove();
                }
            }
            throw new AuthException();
        }

        public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
            if (this.module != null) {
                return this.module.secureResponse(messageInfo, serviceSubject);
            }
            if (this.oldModule != null) {
                this.oldModule.secureResponse(this.config.getAuthParam(messageInfo), serviceSubject, messageInfo.getMap());
                return AuthStatus.SEND_SUCCESS;
            }
            throw new AuthException();
        }

        public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
            if (this.module != null) {
                this.module.cleanSubject(messageInfo, subject);
            } else if (this.oldModule != null) {
                this.oldModule.disposeSubject(subject, messageInfo.getMap());
            } else {
                throw new AuthException();
            }
        }
    }

    static class IDEntry {
        private String type;
        private String moduleClassName;
        private MessagePolicy requestPolicy;
        private MessagePolicy responsePolicy;
        private Map options;

        IDEntry(String type, String moduleClassName, MessagePolicy requestPolicy, MessagePolicy responsePolicy, Map options) {
            this.type = type;
            this.moduleClassName = moduleClassName;
            this.requestPolicy = requestPolicy;
            this.responsePolicy = responsePolicy;
            this.options = options;
        }
    }

    static class InterceptEntry {
        String defaultClientID;
        String defaultServerID;
        HashMap idMap;

        InterceptEntry(String defaultClientID, String defaultServerID, HashMap idMap) {
            this.defaultClientID = defaultClientID;
            this.defaultServerID = defaultServerID;
            this.idMap = idMap;
        }
    }

    protected static class ModuleInfo {
        private Object module;
        private Map map;

        ModuleInfo(Object module, Map map) {
            this.module = module;
            this.map = map;
        }

        Object getModule() {
            return this.module;
        }

        Map getMap() {
            return this.map;
        }
    }
}

