/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jmac.config;

import com.sun.enterprise.security.jmac.AuthMessagePolicy;
import com.sun.enterprise.security.jmac.config.CallbackHandlerConfig;
import com.sun.enterprise.security.jmac.config.HandlerContext;
import com.sun.enterprise.webservice.ClientPipeCloser;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.AuthConfig;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.ClientAuthConfig;
import javax.security.auth.message.config.ClientAuthContext;
import javax.security.auth.message.config.RegistrationListener;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.security.auth.message.config.ServerAuthContext;

public abstract class ConfigHelper {
    private static final String DEFAULT_HANDLER_CLASS = "com.sun.enterprise.security.jmac.callback.ContainerCallbackHandler";
    private static String handlerClassName = null;
    protected static final AuthConfigFactory factory = AuthConfigFactory.getFactory();
    private ReadWriteLock rwLock;
    private Lock rLock;
    private Lock wLock;
    protected String layer;
    protected String appCtxt;
    protected Map map;
    protected CallbackHandler cbh;
    protected AuthConfigRegistrationWrapper listenerWrapper = null;

    protected void init(String layer, String appContext, Map map, CallbackHandler cbh) {
        this.layer = layer;
        this.appCtxt = appContext;
        this.map = map;
        this.cbh = cbh;
        if (this.cbh == null) {
            this.cbh = this.getCallbackHandler();
        }
        this.rwLock = new ReentrantReadWriteLock(true);
        this.rLock = this.rwLock.readLock();
        this.wLock = this.rwLock.writeLock();
        this.listenerWrapper = new AuthConfigRegistrationWrapper(this.layer, this.appCtxt);
    }

    public void setJmacProviderRegisID(String jmacProviderRegisID) {
        this.listenerWrapper.setJmacProviderRegisID(jmacProviderRegisID);
    }

    public AuthConfigRegistrationWrapper getRegistrationWrapper() {
        return this.listenerWrapper;
    }

    public void setRegistrationWrapper(AuthConfigRegistrationWrapper wrapper) {
        this.listenerWrapper = wrapper;
    }

    public AuthConfigRegistrationWrapper.AuthConfigRegistrationListener getRegistrationListener() {
        return this.listenerWrapper.getListener();
    }

    public void disable() {
        this.listenerWrapper.disable();
    }

    public Object getProperty(String key) {
        return this.map == null ? null : this.map.get(key);
    }

    public String getAppContextID() {
        return this.appCtxt;
    }

    public ClientAuthConfig getClientAuthConfig() throws AuthException {
        return (ClientAuthConfig)this.getAuthConfig(false);
    }

    public ServerAuthConfig getServerAuthConfig() throws AuthException {
        return (ServerAuthConfig)this.getAuthConfig(true);
    }

    public ClientAuthContext getClientAuthContext(MessageInfo info, Subject s) throws AuthException {
        ClientAuthConfig c = (ClientAuthConfig)this.getAuthConfig(false);
        if (c != null) {
            return c.getAuthContext(c.getAuthContextID(info), s, this.map);
        }
        return null;
    }

    public ServerAuthContext getServerAuthContext(MessageInfo info, Subject s) throws AuthException {
        ServerAuthConfig c = (ServerAuthConfig)this.getAuthConfig(true);
        if (c != null) {
            return c.getAuthContext(c.getAuthContextID(info), s, this.map);
        }
        return null;
    }

    protected AuthConfig getAuthConfig(AuthConfigProvider p, boolean isServer) throws AuthException {
        Object c = null;
        if (p != null) {
            c = isServer ? p.getServerAuthConfig(this.layer, this.appCtxt, this.cbh) : p.getClientAuthConfig(this.layer, this.appCtxt, this.cbh);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthConfig getAuthConfig(boolean isServer) throws AuthException {
        ConfigData d = null;
        AuthConfig c = null;
        boolean disabled = false;
        AuthConfigProvider lastP = null;
        try {
            this.rLock.lock();
            boolean bl = disabled = !this.listenerWrapper.isEnabled();
            if (!disabled && (d = this.listenerWrapper.getConfigData()) != null) {
                c = isServer ? d.sConfig : d.cConfig;
                lastP = d.provider;
            }
            Object var7_6 = null;
            this.rLock.unlock();
            if (disabled || c != null || d != null && lastP == null) {
                return c;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.rLock.unlock();
            if (disabled || c != null || d != null && lastP == null) {
                return c;
            }
            throw throwable;
        }
        if (d == null) {
            try {
                this.wLock.lock();
                if (this.listenerWrapper.getConfigData() == null) {
                    AuthConfigProvider nextP = factory.getConfigProvider(this.layer, this.appCtxt, (RegistrationListener)this.getRegistrationListener());
                    if (nextP != null) {
                        this.listenerWrapper.setConfigData(new ConfigData(nextP, this.getAuthConfig(nextP, isServer)));
                    } else {
                        this.listenerWrapper.setConfigData(new ConfigData());
                    }
                }
                d = this.listenerWrapper.getConfigData();
                Object var9_10 = null;
                this.wLock.unlock();
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                this.wLock.unlock();
                throw throwable;
            }
        }
        return isServer ? d.sConfig : d.cConfig;
    }

    protected boolean hasExactMatchAuthProvider() {
        boolean exactMatch = false;
        AuthConfigProvider p = factory.getConfigProvider(this.layer, this.appCtxt, null);
        if (p != null) {
            String[] IDs;
            for (String i : IDs = factory.getRegistrationIDs(p)) {
                AuthConfigFactory.RegistrationContext c = factory.getRegistrationContext(i);
                if (!this.layer.equals(c.getMessageLayer()) || !this.appCtxt.equals(c.getAppContext())) continue;
                exactMatch = true;
                break;
            }
        }
        return exactMatch;
    }

    private CallbackHandler getCallbackHandler() {
        CallbackHandler rvalue = AuthMessagePolicy.getDefaultCallbackHandler();
        if (rvalue instanceof CallbackHandlerConfig) {
            ((CallbackHandlerConfig)((Object)rvalue)).setHandlerContext(this.getHandlerContext(this.map));
        }
        return rvalue;
    }

    protected HandlerContext getHandlerContext(Map map) {
        return null;
    }

    public class AuthConfigRegistrationWrapper {
        private String layer;
        private String appCtxt;
        private String jmacProviderRegisID = null;
        private boolean enabled;
        private ConfigData data;
        private Lock wLock;
        private ReadWriteLock rwLock;
        AuthConfigRegistrationListener listener;
        int referenceCount = 1;

        public AuthConfigRegistrationWrapper(String layer, String appCtxt) {
            this.layer = layer;
            this.appCtxt = appCtxt;
            this.rwLock = new ReentrantReadWriteLock(true);
            this.wLock = this.rwLock.writeLock();
            this.enabled = factory != null;
            this.listener = new AuthConfigRegistrationListener(layer, appCtxt);
        }

        public AuthConfigRegistrationListener getListener() {
            return this.listener;
        }

        public void setListener(AuthConfigRegistrationListener listener) {
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disable() {
            try {
                this.wLock.lock();
                this.setEnabled(false);
                Object var2_1 = null;
                this.data = null;
                this.wLock.unlock();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.data = null;
                this.wLock.unlock();
                throw throwable;
            }
            if (factory != null) {
                String[] ids = factory.detachListener((RegistrationListener)this.listener, this.layer, this.appCtxt);
                if (ids != null) {
                    for (int i = 0; i < ids.length; ++i) {
                        factory.removeRegistration(ids[i]);
                    }
                }
                if (this.getJmacProviderRegisID() != null) {
                    factory.removeRegistration(this.getJmacProviderRegisID());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disableWithRefCount() {
            if (this.referenceCount <= 1) {
                this.disable();
                ClientPipeCloser.getInstance().removeListenerWrapper(this);
            } else {
                try {
                    this.wLock.lock();
                    --this.referenceCount;
                    Object var2_1 = null;
                    this.wLock.unlock();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.wLock.unlock();
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void incrementReference() {
            try {
                this.wLock.lock();
                ++this.referenceCount;
                Object var2_1 = null;
                this.wLock.unlock();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.wLock.unlock();
                throw throwable;
            }
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getJmacProviderRegisID() {
            return this.jmacProviderRegisID;
        }

        public void setJmacProviderRegisID(String jmacProviderRegisID) {
            this.jmacProviderRegisID = jmacProviderRegisID;
        }

        public ConfigData getConfigData() {
            return this.data;
        }

        public void setConfigData(ConfigData data) {
            this.data = data;
        }

        public class AuthConfigRegistrationListener
        implements RegistrationListener {
            private String layer;
            private String appCtxt;

            public AuthConfigRegistrationListener(String layer, String appCtxt) {
                this.layer = layer;
                this.appCtxt = appCtxt;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void notify(String layer, String appContext) {
                if (this.layer.equals(layer) && (this.appCtxt == null && appContext == null || appContext != null && appContext.equals(this.appCtxt))) {
                    try {
                        AuthConfigRegistrationWrapper.this.wLock.lock();
                        AuthConfigRegistrationWrapper.this.data = null;
                        Object var4_3 = null;
                        AuthConfigRegistrationWrapper.this.wLock.unlock();
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        AuthConfigRegistrationWrapper.this.wLock.unlock();
                        throw throwable;
                    }
                }
            }
        }
    }

    private class ConfigData {
        private AuthConfigProvider provider;
        private AuthConfig sConfig;
        private AuthConfig cConfig;

        ConfigData() {
            this.provider = null;
            this.sConfig = null;
            this.cConfig = null;
        }

        ConfigData(AuthConfigProvider p, AuthConfig a) {
            this.provider = p;
            if (a == null) {
                this.sConfig = null;
                this.cConfig = null;
            } else if (a instanceof ServerAuthConfig) {
                this.sConfig = a;
                this.cConfig = null;
            } else if (a instanceof ClientAuthConfig) {
                this.sConfig = null;
                this.cConfig = a;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }
}

