/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm;

import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.UserMgmtEvent;
import com.sun.enterprise.admin.event.UserMgmtEventListener;
import com.sun.enterprise.security.SecurityUtil;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.file.FileRealm;
import com.sun.enterprise.server.pluggable.SecuritySupport;

public class UserMgmtEventListenerImpl
implements UserMgmtEventListener {
    public void userAdded(UserMgmtEvent event) throws AdminEventListenerException {
        this.reloadRealm(event);
    }

    public void userRemoved(UserMgmtEvent event) throws AdminEventListenerException {
        this.reloadRealm(event);
    }

    public void userUpdated(UserMgmtEvent event) throws AdminEventListenerException {
        this.reloadRealm(event);
    }

    private void reloadRealm(UserMgmtEvent event) throws AdminEventListenerException {
        try {
            String realmName = event.getAuthRealmName();
            Realm realm = Realm.getInstance(realmName);
            if (realm instanceof FileRealm) {
                SecuritySupport secSupp = SecurityUtil.getSecuritySupport();
                secSupp.synchronizeKeyFile(event.getConfigContext(), realmName);
            }
            realm.refresh();
        }
        catch (Exception ex) {
            throw new AdminEventListenerException(ex);
        }
    }
}

