/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationException;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.monitor.registry.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.admin.monitor.stats.ConnectorConnectionPoolStats;
import com.sun.enterprise.admin.monitor.stats.JDBCConnectionPoolStats;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.connectors.ConnectorConstants;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.distributedtx.J2EETransaction;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.LazyEnlistableResourceManagerImpl;
import com.sun.enterprise.resource.MonitorableResourcePool;
import com.sun.enterprise.resource.NoTxResourceManagerImpl;
import com.sun.enterprise.resource.PoolLifeCycle;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceManager;
import com.sun.enterprise.resource.ResourceManagerImpl;
import com.sun.enterprise.resource.ResourcePool;
import com.sun.enterprise.resource.ResourcePoolFactoryImpl;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.resource.SystemResourceManagerImpl;
import com.sun.enterprise.resource.monitor.ConnectorConnectionPoolStatsImpl;
import com.sun.enterprise.resource.monitor.ConnectorServiceMonitoringLevelListener;
import com.sun.enterprise.resource.monitor.JDBCConnectionPoolStatsImpl;
import com.sun.enterprise.resource.monitor.JDBCPoolMonitoringLevelListener;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.logging.LogDomains;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.DissociatableManagedConnection;
import javax.resource.spi.ManagedConnection;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;

public class PoolManagerImpl
implements PoolManager {
    private ConcurrentHashMap poolTable = new ConcurrentHashMap();
    private ResourceManager resourceManager = new ResourceManagerImpl();
    private ResourceManager sysResourceManager = new SystemResourceManagerImpl();
    private ResourceManager noTxResourceManager = new NoTxResourceManagerImpl();
    private LazyEnlistableResourceManagerImpl lazyEnlistableResourceManager = new LazyEnlistableResourceManagerImpl();
    private PoolLifeCycle listener = null;
    static Logger _logger = null;
    MonitoringRegistry monitoringRegistry_;

    public void registerPoolLifeCycleListner(PoolLifeCycle poolListener) {
        this.listener = poolListener;
    }

    public void createEmptyConnectionPool(String poolName, ConnectorConstants.PoolType pt) throws PoolingException {
        this.createAndInitPool(poolName, pt);
        if (this.listener != null) {
            try {
                this.listener.poolCreated(poolName);
            }
            catch (Exception ex) {
                _logger.log(Level.FINE, "Exception thrown on pool listener");
            }
        }
    }

    private ResourcePool createAndInitPool(String poolName, ConnectorConstants.PoolType pt) throws PoolingException {
        ResourcePool pool = this.getPool(poolName);
        if (pool == null) {
            pool = ResourcePoolFactoryImpl.newInstance(poolName, pt);
            this.addPool(pool);
            try {
                ConnectorRuntime runtime = ConnectorRuntime.getRuntime();
                if (runtime.getEnviron() == 1) {
                    if (this.isJdbcPool(poolName)) {
                        this.enableJDBCPoolMonitoring(pool, poolName);
                    } else {
                        this.enableConnectorConnectionPoolMonitoring(pool, poolName);
                    }
                }
            }
            catch (Exception e) {
                _logger.log(Level.INFO, "poolmon.cannot_reg");
                _logger.log(Level.FINE, "Exception while registering connection pool", e);
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Created connection  pool  and added it to PoolManager :" + pool);
            }
        }
        return pool;
    }

    public Object getResource(ResourceSpec spec, ResourceAllocator alloc, ClientSecurityInfo info) throws PoolingException {
        ResourceHandle handle;
        Transaction tran = null;
        boolean transactional = alloc.isTransactional();
        if (transactional) {
            tran = this.getResourceManager(spec).getTransaction();
        }
        if (!(handle = this.getResourceFromPool(spec, alloc, info, tran)).supportsLazyAssociation()) {
            spec.setLazyAssociatable(false);
        }
        if (spec.isLazyAssociatable() && spec.getConnectionToAssociate() != null) {
            try {
                Object connection = spec.getConnectionToAssociate();
                ManagedConnection dmc = (ManagedConnection)handle.getResource();
                dmc.associateConnection(connection);
            }
            catch (ResourceException e) {
                this.putbackDirectToPool(handle, spec.getConnectionPoolName());
                PoolingException pe = new PoolingException(e.getMessage());
                pe.initCause(e);
                throw pe;
            }
        }
        if (!handle.supportsLazyEnlistment()) {
            spec.setLazyEnlistable(false);
        }
        handle.setResourceSpec(spec);
        try {
            if (handle.getResourceState().isUnenlisted()) {
                this.getResourceManager(spec).enlistResource(handle);
            }
        }
        catch (Exception e) {
            this.putbackDirectToPool(handle, spec.getConnectionPoolName());
            _logger.log(Level.WARNING, "poolmgr.err_enlisting_res_in_getconn");
            this.logFine("rm.enlistResource threw Exception. Returning resource to pool");
            throw new PoolingException(e);
        }
        return handle.getUserConnection();
    }

    public void registerResource(ResourceHandle handle) throws PoolingException {
        ResourceManager rm = this.getResourceManager(handle.getResourceSpec());
        rm.registerResource(handle);
    }

    public ResourceHandle getResourceFromPool(ResourceSpec spec, ResourceAllocator alloc, ClientSecurityInfo info, Transaction tran) throws PoolingException {
        ResourcePool pool = this.getPool(spec.getConnectionPoolName());
        return pool.getResource(spec, alloc, tran);
    }

    private void enableConnectorConnectionPoolMonitoring(ResourcePool pool, final String poolName) {
        MonitorableResourcePool mrp = null;
        final ResourcesUtil resUtil = ResourcesUtil.createInstance();
        if (!(pool instanceof MonitorableResourcePool)) {
            return;
        }
        mrp = (MonitorableResourcePool)pool;
        final ConnectorConnectionPool ccp = resUtil.getConnectorConnectionPoolByName(poolName);
        if (this.getConnectorPoolMonitoringLevel() != MonitoringLevel.OFF) {
            final ConnectorConnectionPoolStatsImpl ccpStatsImpl = new ConnectorConnectionPoolStatsImpl(mrp);
            if (this.getConnectorPoolMonitoringLevel() == MonitoringLevel.HIGH) {
                this.setMonitoringEnabledHigh(poolName);
            }
            if (this.getConnectorPoolMonitoringLevel() == MonitoringLevel.LOW) {
                this.setMonitoringEnabledLow(poolName);
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        PoolManagerImpl.this.monitoringRegistry_.registerConnectorConnectionPoolStats((ConnectorConnectionPoolStats)ccpStatsImpl, poolName, resUtil.getAppName(ccp), resUtil.getRAName(ccp), null);
                    }
                    catch (Exception mre) {
                        _logger.log(Level.INFO, "poolmon.cannot_reg", mre.getMessage() != null ? mre.getMessage() : " ");
                        _logger.fine("Error while enabling Connector Pool monitoring for pool " + poolName + mre);
                        PoolManagerImpl.this.disableMonitoring(poolName);
                    }
                    return null;
                }
            });
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Enabled pool monitoring at pool creation for " + poolName);
            }
        }
    }

    private void enableJDBCPoolMonitoring(ResourcePool pool, final String poolName) {
        MonitorableResourcePool mrp = null;
        if (!(pool instanceof MonitorableResourcePool)) {
            return;
        }
        mrp = (MonitorableResourcePool)pool;
        if (this.getJdbcPoolMonitoringLevel() != MonitoringLevel.OFF) {
            final JDBCConnectionPoolStatsImpl jdbcStatsImpl = new JDBCConnectionPoolStatsImpl(mrp);
            if (this.getJdbcPoolMonitoringLevel() == MonitoringLevel.HIGH) {
                this.setMonitoringEnabledHigh(poolName);
            }
            if (this.getJdbcPoolMonitoringLevel() == MonitoringLevel.LOW) {
                this.setMonitoringEnabledLow(poolName);
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        PoolManagerImpl.this.monitoringRegistry_.registerJDBCConnectionPoolStats((JDBCConnectionPoolStats)jdbcStatsImpl, poolName, null);
                    }
                    catch (Exception mre) {
                        _logger.log(Level.INFO, "poolmon.cannot_reg", mre.getMessage() != null ? mre.getMessage() : " ");
                        _logger.fine("Error while enabling JDBC Pool monitoring for pool " + poolName + mre);
                        PoolManagerImpl.this.disableMonitoring(poolName);
                    }
                    return null;
                }
            });
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Enabled pool monitoring at pool creation for " + poolName);
            }
        }
    }

    public void resourceEnlisted(Transaction tran, ResourceHandle res) throws IllegalStateException {
        ResourcePool pool;
        String poolName = res.getResourceSpec().getConnectionPoolName();
        try {
            J2EETransaction j2eeTran = (J2EETransaction)tran;
            if (poolName != null && j2eeTran.getResources(poolName) == null) {
                this.addSyncListener(tran);
            }
        }
        catch (ClassCastException e) {
            this.addSyncListener(tran);
        }
        if (poolName != null && (pool = this.getPool(poolName)) != null) {
            pool.resourceEnlisted(tran, res);
        }
    }

    private void addSyncListener(Transaction tran) {
        SynchronizationListener sync = new SynchronizationListener(tran);
        try {
            tran.registerSynchronization((Synchronization)sync);
        }
        catch (Exception ex) {
            _logger.fine("Error adding syncListener : " + (ex.getMessage() != null ? ex.getMessage() : " "));
        }
    }

    public void transactionCompleted(Transaction tran, int status) throws IllegalStateException {
        Iterator iter = ((J2EETransaction)tran).getAllParticipatingPools().iterator();
        while (iter.hasNext()) {
            ResourcePool pool = this.getPool((String)iter.next());
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("calling transactionCompleted on " + pool.getPoolName());
            }
            pool.transactionCompleted(tran, status);
        }
    }

    public void resourceClosed(ResourceHandle resource) {
        ResourceManager rm = this.getResourceManager(resource.getResourceSpec());
        rm.delistResource(resource, 0x4000000);
        this.putbackResourceToPool(resource, false);
    }

    public void badResourceClosed(ResourceHandle resource) {
        ResourceManager rm = this.getResourceManager(resource.getResourceSpec());
        rm.delistResource(resource, 0x4000000);
        this.putbackBadResourceToPool(resource);
    }

    public void resourceErrorOccurred(ResourceHandle resource) {
        this.putbackResourceToPool(resource, true);
    }

    public void unregisterResource(ResourceHandle resource, int xaresFlag) {
        ResourceManager rm = this.getResourceManager(resource.getResourceSpec());
        rm.unregisterResource(resource, xaresFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putbackBadResourceToPool(ResourceHandle h) {
        ResourcePool pool;
        try {
            ResourceAllocator alloc = h.getResourceAllocator();
            alloc.cleanup(h);
        }
        catch (PoolingException ex) {
            // empty catch block
        }
        String poolName = h.getResourceSpec().getConnectionPoolName();
        if (poolName != null && (pool = (ResourcePool)this.poolTable.get(poolName)) != null) {
            ResourcePool resourcePool = pool;
            synchronized (resourcePool) {
                pool.resourceClosed(h);
                h.setConnectionErrorOccurred();
                pool.resourceErrorOccurred(h);
            }
        }
    }

    public void putbackResourceToPool(ResourceHandle h, boolean errorOccurred) {
        ResourcePool pool;
        try {
            ResourceAllocator alloc = h.getResourceAllocator();
            alloc.cleanup(h);
        }
        catch (PoolingException ex) {
            errorOccurred = true;
        }
        String poolName = h.getResourceSpec().getConnectionPoolName();
        if (poolName != null && (pool = (ResourcePool)this.poolTable.get(poolName)) != null) {
            if (errorOccurred) {
                pool.resourceErrorOccurred(h);
            } else {
                pool.resourceClosed(h);
            }
        }
    }

    public void emptyResourcePool(ResourceSpec spec) {
        ResourcePool pool;
        String poolName = spec.getConnectionPoolName();
        if (poolName != null && (pool = (ResourcePool)this.poolTable.get(poolName)) != null) {
            pool.emptyPool();
        }
    }

    public ResourceReferenceDescriptor getResourceReference(String jndiName) {
        InvocationManager i = Switch.getSwitch().getInvocationManager();
        if (i == null) {
            return null;
        }
        ComponentInvocation inv = null;
        inv = i.getCurrentInvocation();
        if (inv == null) {
            return null;
        }
        int invType = inv.getInvocationType();
        Set refs = null;
        Object container = inv.getContainerContext();
        JndiNameEnvironment env = (JndiNameEnvironment)Switch.getSwitch().getDescriptorFor(container);
        if (env == null) {
            return null;
        }
        refs = env.getResourceReferenceDescriptors();
        for (ResourceReferenceDescriptor ref : refs) {
            String name = ref.getJndiName();
            if (!jndiName.equals(name)) continue;
            return ref;
        }
        return null;
    }

    private ResourceManager getResourceManager(ResourceSpec spec) {
        if (spec.isNonTx()) {
            this.logFine("@@@@ Returning noTxResourceManager");
            return this.noTxResourceManager;
        }
        if (spec.isPM()) {
            this.logFine("@@@@ Returning sysResourceManager");
            return this.sysResourceManager;
        }
        if (spec.isLazyEnlistable()) {
            this.logFine("@@@@ Returning LazyEnlistableResourceManager");
            return this.lazyEnlistableResourceManager;
        }
        this.logFine("@@@@ Returning resourceManager");
        return this.resourceManager;
    }

    public void putbackDirectToPool(ResourceHandle h, String poolName) {
        ResourcePool pool;
        if (poolName != null && (pool = (ResourcePool)this.poolTable.get(poolName)) != null) {
            pool.resourceClosed(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killPool(String poolName) {
        ResourcePool pool = (ResourcePool)this.poolTable.get(poolName);
        if (pool != null) {
            pool.cancelResizerTask();
            pool.emptyPool();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Removing pool " + pool + " from pooltable");
            }
            ConcurrentHashMap concurrentHashMap = this.poolTable;
            synchronized (concurrentHashMap) {
                this.poolTable.remove(poolName);
            }
        }
        if (this.listener != null) {
            this.listener.poolDestroyed(poolName);
        }
        try {
            ConnectorRuntime runtime = ConnectorRuntime.getRuntime();
            if (runtime.getEnviron() == 1) {
                String fPoolName = poolName;
                if (this.isJdbcPool(fPoolName)) {
                    this.disableJDBCPoolMonitoring(fPoolName);
                } else {
                    this.disableConnectorConnectionPoolMonitoring(fPoolName);
                }
            }
        }
        catch (Exception e) {
            _logger.log(Level.INFO, "poolmon.cannot_unreg");
        }
    }

    private void disableConnectorConnectionPoolMonitoring(final String fPoolName) {
        final ResourcesUtil resUtil = ResourcesUtil.createInstance();
        final ConnectorConnectionPool ccp = resUtil.getConnectorConnectionPoolByName(fPoolName);
        if (this.getConnectorPoolMonitoringLevel() != MonitoringLevel.OFF) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        PoolManagerImpl.this.monitoringRegistry_.unregisterConnectorConnectionPoolStats(fPoolName, resUtil.getAppName(ccp), resUtil.getRAName(ccp));
                    }
                    catch (Exception mre) {
                        _logger.log(Level.INFO, "poolmon.cannot_unreg", mre.getMessage());
                    }
                    return null;
                }
            });
        }
    }

    private void disableJDBCPoolMonitoring(final String fPoolName) {
        if (this.getJdbcPoolMonitoringLevel() != MonitoringLevel.OFF) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        PoolManagerImpl.this.monitoringRegistry_.unregisterJDBCConnectionPoolStats(fPoolName);
                    }
                    catch (Exception mre) {
                        _logger.log(Level.INFO, "poolmon.cannot_unreg", mre.getMessage());
                    }
                    return null;
                }
            });
        }
    }

    public void reconfigPoolProperties(com.sun.enterprise.connectors.ConnectorConnectionPool ccp) throws PoolingException {
        String poolName = ccp.getName();
        PoolManager poolmgr = Switch.getSwitch().getPoolManager();
        ResourcePool pool = (ResourcePool)poolmgr.getPoolTable().get(poolName);
        if (pool != null) {
            pool.reconfigPoolProperties(ccp);
        }
    }

    public void disableMonitoring(String poolName) {
        ResourcePool pool = (ResourcePool)this.poolTable.get(poolName);
        if (pool != null) {
            pool.disableMonitoring();
        }
    }

    public void setMonitoringEnabledHigh(String poolName) {
        ResourcePool pool = (ResourcePool)this.poolTable.get(poolName);
        if (pool != null) {
            pool.setMonitoringEnabledHigh();
        }
    }

    public void setMonitoringEnabledLow(String poolName) {
        ResourcePool pool = (ResourcePool)this.poolTable.get(poolName);
        if (pool != null) {
            pool.setMonitoringEnabledLow();
        }
    }

    public boolean switchOnMatching(String poolName) {
        PoolManager poolmgr = Switch.getSwitch().getPoolManager();
        ResourcePool pool = (ResourcePool)poolmgr.getPoolTable().get(poolName);
        if (pool != null) {
            pool.switchOnMatching();
            return true;
        }
        return false;
    }

    private boolean isJdbcPool(String poolName) {
        JdbcConnectionPool[] pools;
        for (JdbcConnectionPool pool : pools = ResourcesUtil.createInstance().getJdbcConnectionPools()) {
            if (!poolName.equals(pool.getName())) continue;
            return true;
        }
        return false;
    }

    public ConcurrentHashMap getPoolTable() {
        return this.poolTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPool(ResourcePool pool) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Adding pool " + pool.getPoolName() + "to pooltable");
        }
        ConcurrentHashMap concurrentHashMap = this.poolTable;
        synchronized (concurrentHashMap) {
            this.poolTable.put(pool.getPoolName(), pool);
        }
    }

    public void initializeMonitoring() {
        try {
            final ConnectorServiceMonitoringLevelListener csMonitoringListener = new ConnectorServiceMonitoringLevelListener();
            final JDBCPoolMonitoringLevelListener jdbcMonitoringListener = new JDBCPoolMonitoringLevelListener();
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ServerContext ctxt = ApplicationServer.getServerContext();
                    if (ctxt != null) {
                        PoolManagerImpl.this.monitoringRegistry_ = ctxt.getMonitoringRegistry();
                        PoolManagerImpl.this.monitoringRegistry_.registerMonitoringLevelListener((MonitoringLevelListener)csMonitoringListener, MonitoredObjectType.CONNECTOR_SERVICE);
                        PoolManagerImpl.this.monitoringRegistry_.registerMonitoringLevelListener((MonitoringLevelListener)jdbcMonitoringListener, MonitoredObjectType.JDBC_CONN_POOL);
                    }
                    return null;
                }
            });
            _logger.log(Level.FINE, "poolmon.init_monitoring_registry");
        }
        catch (Exception e) {
            _logger.log(Level.INFO, "poolmon.error_registering_listener", e);
        }
    }

    private MonitoringLevel getJdbcPoolMonitoringLevel() {
        MonitoringLevel off;
        Config cfg = null;
        MonitoringLevel l = off = MonitoringLevel.OFF;
        try {
            cfg = ServerBeansFactory.getConfigBean(ApplicationServer.getServerContext().getConfigContext());
            String lvl = cfg.getMonitoringService().getModuleMonitoringLevels().getJdbcConnectionPool();
            l = MonitoringLevel.instance((String)lvl);
            if (l == null) {
                return off;
            }
        }
        catch (Exception e) {
            return off;
        }
        return l;
    }

    private MonitoringLevel getConnectorPoolMonitoringLevel() {
        MonitoringLevel l;
        try {
            Config cfg = ServerBeansFactory.getConfigBean(ApplicationServer.getServerContext().getConfigContext());
            String lvl = cfg.getMonitoringService().getModuleMonitoringLevels().getConnectorConnectionPool();
            l = MonitoringLevel.instance((String)lvl);
            if (l == null) {
                return MonitoringLevel.OFF;
            }
        }
        catch (Exception e) {
            return MonitoringLevel.OFF;
        }
        return l;
    }

    public void killAllPools() {
        Iterator pools = this.poolTable.values().iterator();
        this.logFine("---Killing all pools");
        while (pools.hasNext()) {
            ResourcePool pool = (ResourcePool)pools.next();
            if (pool == null) continue;
            String name = pool.getPoolName();
            try {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Now killing pool : " + name);
                }
                this.killPool(name);
            }
            catch (Exception e) {
                _logger.fine("Error killing pool : " + name + " :: " + (e.getMessage() != null ? e.getMessage() : " "));
            }
        }
        this.stopEmbeddedDerby();
    }

    private void stopEmbeddedDerby() {
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
        }
        catch (ClassNotFoundException cnfe) {
            _logger.log(Level.FINE, "Derby.Driver.Not.Found", cnfe.fillInStackTrace());
        }
        catch (SQLException se) {
            _logger.log(Level.FINE, "Derby.Shutdown.Exception", se.fillInStackTrace());
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "Derby.Shutdown.Exception", e.fillInStackTrace());
        }
    }

    public void killFreeConnectionsInPools() {
        Iterator pools = this.poolTable.values().iterator();
        this.logFine("Killing all free connections in pools");
        while (pools.hasNext()) {
            ResourcePool pool = (ResourcePool)pools.next();
            if (pool == null) continue;
            String name = pool.getPoolName();
            try {
                if (name == null) continue;
                ResourcePool poolToKill = (ResourcePool)this.poolTable.get(name);
                if (poolToKill != null) {
                    pool.emptyFreeConnectionsInPool();
                }
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.fine("Now killing free connections in pool : " + name);
            }
            catch (Exception e) {
                _logger.fine("Error killing pool : " + name + " :: " + (e.getMessage() != null ? e.getMessage() : " "));
            }
        }
    }

    private void logFine(String msg) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(msg);
        }
    }

    public ResourcePool getPool(String name) {
        if (name == null) {
            return null;
        }
        return (ResourcePool)Switch.getSwitch().getPoolManager().getPoolTable().get(name);
    }

    public void setSelfManaged(String poolName, boolean flag) {
        if (poolName == null) {
            return;
        }
        this.getPool(poolName).setSelfManaged(flag);
    }

    public void lazyEnlist(ManagedConnection mc) throws ResourceException {
        this.lazyEnlistableResourceManager.lazyEnlist(mc);
    }

    public void postInvoke() throws InvocationException {
        ResourceHandle[] handles;
        J2EETransactionManager tm = Switch.getSwitch().getTransactionManager();
        ComponentInvocation invToUse = Switch.getSwitch().getInvocationManager().getCurrentInvocation();
        if (invToUse == null) {
            return;
        }
        Object comp = invToUse.getInstance();
        if (comp == null) {
            return;
        }
        List list = tm.getExistingResourceList(comp, invToUse);
        if (list == null) {
            return;
        }
        if (list.size() == 0) {
            return;
        }
        for (ResourceHandle h : handles = list.toArray(new ResourceHandle[0])) {
            Object var15_12;
            ResourceSpec spec = h.getResourceSpec();
            if (!spec.isLazyAssociatable()) continue;
            DissociatableManagedConnection mc = (DissociatableManagedConnection)h.getResource();
            if (h.isEnlisted()) {
                this.getResourceManager(spec).delistResource(h, 0x4000000);
            }
            try {
                try {
                    mc.dissociateConnections();
                }
                catch (ResourceException re) {
                    InvocationException ie = new InvocationException(re.getMessage());
                    ie.initCause(re);
                    throw ie;
                }
                var15_12 = null;
                if (!h.getResourceState().isBusy()) continue;
                this.putbackDirectToPool(h, spec.getConnectionPoolName());
            }
            catch (Throwable throwable) {
                var15_12 = null;
                if (h.getResourceState().isBusy()) {
                    this.putbackDirectToPool(h, spec.getConnectionPoolName());
                }
                throw throwable;
            }
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    }

    class SynchronizationListener
    implements Synchronization {
        private Transaction tran;

        SynchronizationListener(Transaction tran) {
            this.tran = tran;
        }

        public void afterCompletion(int status) {
            try {
                PoolManagerImpl.this.transactionCompleted(this.tran, status);
            }
            catch (Exception ex) {
                _logger.fine("Exception in afterCompletion : " + (ex.getMessage() != null ? ex.getMessage() : " "));
            }
        }

        public void beforeCompletion() {
        }
    }
}

