/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.resource.AbstractResourcePool;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import javax.transaction.Transaction;

public class AssocWithThreadResourcePool
extends AbstractResourcePool {
    private static ThreadLocal<ResourceHandle> localResource = new ThreadLocal();

    public AssocWithThreadResourcePool(String poolName) throws PoolingException {
        super(poolName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceHandle prefetch(ResourceSpec spec, ResourceAllocator alloc, Transaction tran) {
        ResourceHandle ar = localResource.get();
        if (ar != null) {
            Object object = ar.lock;
            synchronized (object) {
                if (ar.getThreadId() != Thread.currentThread().getId() || ar.hasConnectionErrorOccurred() || ar.isDirty() || !ar.isAssociated()) {
                    localResource.remove();
                    return null;
                }
                if (ar.getResourceState().isFree() && ar.getResourceState().isUnenlisted()) {
                    if (this.matchConnections) {
                        if (!alloc.matchConnection(ar)) {
                            localResource.remove();
                            ar.setAssociated(false);
                            if (this.monitoringEnabled) {
                                this.poolCounters.incrementNumConnNotSuccessfullyMatched();
                            }
                            return null;
                        }
                        if (this.monitoringEnabled) {
                            this.poolCounters.incrementNumConnSuccessfullyMatched();
                        }
                    }
                    this.setResourceStateToBusy(ar);
                    if (this.maxConnectionUsage_ > 0) {
                        ar.incrementUsageCount();
                    }
                    return ar;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInThreadLocal(ResourceHandle h) {
        if (h != null) {
            Object object = h.lock;
            synchronized (object) {
                h.setThreadId(Thread.currentThread().getId());
                h.setAssociated(true);
                localResource.set(h);
            }
        }
    }

    protected boolean isResourceUnused(ResourceHandle h) {
        return h.getResourceState().isFree() && !h.isAssociated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceHandle getUnenlistedResource(ResourceSpec spec, ResourceAllocator alloc, Transaction tran) throws PoolingException {
        ResourceHandle result = super.getUnenlistedResource(spec, alloc, tran);
        if (result == null) {
            AssocWithThreadResourcePool assocWithThreadResourcePool = this;
            synchronized (assocWithThreadResourcePool) {
                for (ResourceHandle resource : this.resources) {
                    Object object = resource.lock;
                    synchronized (object) {
                        if (resource.getResourceState().isUnenlisted() && resource.getResourceState().isFree()) {
                            if (!this.matchConnection(resource, alloc)) {
                                continue;
                            }
                            if (resource.hasConnectionErrorOccurred()) {
                                continue;
                            }
                            result = resource;
                            this.setResourceStateToBusy(result);
                            result.setAssociated(false);
                            break;
                        }
                    }
                }
            }
        }
        if (localResource.get() == null) {
            this.setInThreadLocal(result);
        }
        return result;
    }

    protected synchronized void freeUnenlistedResource(ResourceHandle h) {
        if (!h.isAssociated()) {
            this.free.add(h);
        }
        if (this.monitoringEnabled) {
            this.poolCounters.decrementNumConnUsed(false);
        }
        if (this.maxConnectionUsage_ > 0) {
            this.performMaxConnectionUsageOperation(h);
        }
        this.notifyWaitingThreads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyResource(ResourceHandle resourceHandle) {
        Object object;
        try {
            super.destroyResource(resourceHandle);
            Object var3_2 = null;
            object = resourceHandle.lock;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Object object2 = resourceHandle.lock;
            synchronized (object2) {
                resourceHandle.setDirty();
            }
            throw throwable;
        }
        synchronized (object) {
            resourceHandle.setDirty();
        }
    }
}

