/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.repository;

import com.sun.enterprise.repository.RepositoryNameParser;
import com.sun.enterprise.util.FileUtil;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;

class RepositoryContext
implements Context {
    private static Logger _logger = null;
    public static final String REPOSITORY_NAME = "com.sun.enterprise.repository.name";
    public static final String REPOSITORY_DIR = "com.sun.enterprise.repository.dir";
    Hashtable myEnv;
    private Properties bindings;
    private static final boolean debug = false;
    static NameParser myParser;
    private static final String DEFAULT_NAMETABLE_DIR = "config/";
    private static final String DEFAULT_NAME = "default";
    private static final String FILE_EXT = ".properties";

    RepositoryContext(Hashtable environment) {
        this.myEnv = environment != null ? (Hashtable)environment.clone() : null;
        this.resurrectTable();
    }

    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException("Context.getNameInNamespace() not implemented");
    }

    public Object lookup(String name) throws NamingException {
        if (name.equals("")) {
            return new RepositoryContext(this.myEnv);
        }
        Object answer = this.bindings.get(name);
        if (answer == null) {
            throw new NameNotFoundException(name + " not found");
        }
        return answer;
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public void bind(String name, Object obj) throws NamingException {
        if (name.equals("")) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        if (this.bindings.get(name) != null) {
            throw new NameAlreadyBoundException("Use rebind to override");
        }
        this.bindings.put(name, obj);
        this.store();
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        if (name.equals("")) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        this.bindings.put(name, obj);
        this.store();
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    public void unbind(String name) throws NamingException {
        if (name.equals("")) {
            throw new InvalidNameException("Cannot unbind empty name");
        }
        this.bindings.remove(name);
        this.store();
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void rename(String oldname, String newname) throws NamingException {
        if (oldname.equals("") || newname.equals("")) {
            throw new InvalidNameException("Cannot rename empty name");
        }
        if (this.bindings.get(newname) != null) {
            throw new NameAlreadyBoundException(newname + " is already bound");
        }
        Object oldBinding = this.bindings.remove(oldname);
        if (oldBinding == null) {
            throw new NameNotFoundException(oldname + " not bound");
        }
        this.bindings.put(newname, oldBinding);
        this.store();
    }

    public void rename(Name oldname, Name newname) throws NamingException {
        this.rename(oldname.toString(), newname.toString());
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (name.equals("")) {
            return new RepNames(this.bindings.keys());
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).list("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (name.equals("")) {
            return new RepBindings(this.bindings.keys());
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).listBindings("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("RepositoryContext does not support subcontexts");
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("RepositoryContext does not support subcontexts");
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public NameParser getNameParser(String name) throws NamingException {
        return myParser;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(5, 0.75f);
        }
        return this.myEnv.put(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this.myEnv == null) {
            return null;
        }
        return this.myEnv.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(3, 0.75f);
        }
        return this.myEnv;
    }

    public void close() throws NamingException {
        this.store();
        this.myEnv = null;
        this.bindings = null;
    }

    private void store() {
        try {
            if (this.bindings != null) {
                FileOutputStream fos = new FileOutputStream(this.getStoragePath());
                this.bindings.store(fos, "Repository resource mapping");
                fos.close();
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "enterprise.store_exception", e);
        }
    }

    static String getFilePath(final String dirName, final String filename) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String path = filename + RepositoryContext.FILE_EXT;
                if (path != null) {
                    String fname = FileUtil.getAbsolutePath(dirName + path);
                    File f = new File(fname);
                    if (!f.exists()) {
                        path = "default.properties";
                    }
                } else {
                    path = "default.properties";
                }
                return FileUtil.getAbsolutePath(dirName + path);
            }
        });
    }

    private String getStoragePath() {
        String dirName = (String)this.myEnv.get(REPOSITORY_DIR);
        if (dirName == null) {
            dirName = DEFAULT_NAMETABLE_DIR;
        }
        return RepositoryContext.getFilePath(dirName, (String)this.myEnv.get(REPOSITORY_NAME));
    }

    public static String getRepositoryName(String fname) {
        String filepath = RepositoryContext.getFilePath(DEFAULT_NAMETABLE_DIR, fname);
        int fileIndex = filepath.lastIndexOf(File.separator);
        String filename = null;
        filename = fileIndex > 0 ? filepath.substring(fileIndex + 1) : filepath;
        int extIndex = filename.lastIndexOf(FILE_EXT);
        String fwithoutext = extIndex > 0 ? filename.substring(0, extIndex) : filename;
        return fwithoutext;
    }

    private void resurrectTable() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                RepositoryContext.this.bindings = new Properties();
                try {
                    File f = new File(RepositoryContext.this.getStoragePath());
                    if (f.exists()) {
                        RepositoryContext.this.bindings.load(new FileInputStream(f));
                    }
                }
                catch (Exception e) {
                    _logger.log(Level.SEVERE, "enterprise.load_exception", e);
                }
                return null;
            }
        });
    }

    private static void print(Hashtable ht) {
        Enumeration en = ht.keys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            Object v = ht.get(key);
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise");
        myParser = new RepositoryNameParser();
    }

    class RepBindings
    implements NamingEnumeration {
        Enumeration names;

        RepBindings(Enumeration names) {
            this.names = names;
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                String name = (String)this.names.nextElement();
                return new Binding(name, RepositoryContext.this.bindings.get(name));
            }
            return null;
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() throws NamingException {
            throw new OperationNotSupportedException("NamingEnumeration.close() not implemented");
        }
    }

    class RepNames
    implements NamingEnumeration {
        Enumeration names;

        RepNames(Enumeration names) {
            this.names = names;
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            if (this.names.hasMoreElements()) {
                String name = (String)this.names.nextElement();
                String className = RepositoryContext.this.bindings.get(name).getClass().getName();
                return new NameClassPair(name, className);
            }
            return null;
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() throws NamingException {
            throw new OperationNotSupportedException("NamingEnumeration.close() not implemented");
        }
    }
}

