/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.naming.factory;

import com.sun.enterprise.Switch;
import com.sun.enterprise.connectors.ConnectionManagerImpl;
import com.sun.enterprise.connectors.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;

public class ConnectorObjectFactory
implements ObjectFactory {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.naming");
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ConnectorObjectFactory.class);
    private ConnectorRuntime runtime = ConnectorRuntime.getRuntime();

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable env) throws Exception {
        ClassLoader loader;
        Reference ref = (Reference)obj;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "ConnectorObjectFactory: " + ref + " Name:" + name);
        }
        String poolName = (String)ref.get(0).getContent();
        String moduleName = (String)ref.get(1).getContent();
        Switch sw = Switch.getSwitch();
        if (this.runtime.getEnviron() == 2) {
            ConnectorDescriptor connectorDescriptor = null;
            try {
                InitialContext ic = new InitialContext();
                String descriptorJNDIName = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForDescriptor(moduleName);
                connectorDescriptor = (ConnectorDescriptor)ic.lookup(descriptorJNDIName);
            }
            catch (NamingException ne) {
                _logger.log(Level.FINE, "Failed to look up ConnectorDescriptor from JNDI", moduleName);
                throw new ConnectorRuntimeException("Failed to look up ConnectorDescriptor from JNDI");
            }
            this.runtime.createActiveResourceAdapter(connectorDescriptor, moduleName, null);
        }
        if (!this.runtime.checkAccessibility(moduleName, loader = Thread.currentThread().getContextClassLoader())) {
            throw new NamingException("Only the application that has the embedded resourceadapter can access the resource adapter");
        }
        ManagedConnectionFactory mcf = this.runtime.obtainManagedConnectionFactory(poolName);
        if (mcf == null) {
            _logger.log(Level.FINE, "Failed to create MCF ", poolName);
            throw new ConnectorRuntimeException("Failed to create MCF");
        }
        String jndiName = name.toString();
        boolean forceNoLazyAssoc = false;
        if (jndiName.endsWith("__pm")) {
            forceNoLazyAssoc = true;
        }
        ConnectionManagerImpl mgr = (ConnectionManagerImpl)this.runtime.obtainConnectionManager(poolName, forceNoLazyAssoc);
        mgr.setJndiName(this.deriveJndiName(jndiName, env));
        mgr.setRarName(moduleName);
        mgr.initialize();
        Object cf = mcf.createConnectionFactory((ConnectionManager)mgr);
        if (cf == null) {
            String msg = localStrings.getLocalString("no.resource.adapter", "");
            throw new ConfigurationException(msg);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Connection Factory:" + cf);
        }
        return cf;
    }

    private String deriveJndiName(String name, Hashtable env) {
        String suffix = (String)env.get("com.sun.enterprise.connectors.jndisuffix");
        if (this.runtime.isValidJndiSuffix(suffix)) {
            _logger.log(Level.FINE, "JNDI name will be suffixed with :" + suffix);
            return name + suffix;
        }
        return name;
    }
}

