/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.model;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.management.model.J2EEModuleMdl;
import com.sun.enterprise.management.util.J2EEModuleCallBack;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.management.ObjectName;

public class EJBModuleMdl
extends J2EEModuleMdl {
    private static String MANAGED_OBJECT_TYPE = "EJBModule";
    private String ejbModuleName = null;
    private String applicationName = null;
    private boolean hasWebServices = false;
    private String[] endpointAddresses = null;

    public EJBModuleMdl(J2EEModuleCallBack module, EjbBundleDescriptor ejbBundle) {
        super(module);
        WebServicesDescriptor wsDesc;
        this.ejbModuleName = module.getName();
        this.applicationName = module.getParentName();
        if (EJBModuleMdl.isStandAloneModule(this.applicationName)) {
            this.applicationName = "null";
        }
        if ((wsDesc = ejbBundle.getWebServices()).hasWebServices()) {
            this.hasWebServices = true;
            Vector<String> endpointList = new Vector<String>();
            for (WebServiceEndpoint wse : wsDesc.getEndpoints()) {
                endpointList.add(wse.getEndpointAddressUri());
            }
            this.endpointAddresses = new String[endpointList.size()];
            endpointList.copyInto(this.endpointAddresses);
        }
    }

    public String[] getejbs() {
        Set appMods = this.findNames("EJBModule=" + this.ejbModuleName + ",J2EEServer=" + this.getJ2EEServer() + ",J2EEApplication=" + this.applicationName);
        Iterator it = appMods.iterator();
        String[] mods = new String[appMods.size()];
        int i = 0;
        while (it.hasNext()) {
            mods[i++] = ((ObjectName)it.next()).toString();
        }
        return mods;
    }

    public String getj2eeType() {
        return MANAGED_OBJECT_TYPE;
    }

    public String getJ2EEApplication() {
        return this.applicationName;
    }

    public String getModuleName() {
        return this.ejbModuleName;
    }
}

