/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.agent;

import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.admin.meta.MBeanRegistryFactory;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.management.agent.ListenerRegistry;
import com.sun.enterprise.management.util.J2EEModuleUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.j2ee.ListenerRegistration;

public class MEJBHelper {
    private MBeanServerConnection server;
    private static MEJBHelper mejbHelper = null;
    private ListenerRegistry listenerRegistry = null;
    static Logger _logger = MBeanRegistryFactory.getAdminContext().getAdminLogger();

    private MEJBHelper() {
        AdminContext adminContext = MBeanRegistryFactory.getAdminContext();
        ConfigContext configContext = adminContext.getRuntimeConfigContext();
        String serverName = adminContext.getServerName();
        try {
            boolean isDas = ServerHelper.isDAS(configContext, serverName);
            if (isDas) {
                ArrayList mbservers = (ArrayList)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return MBeanServerFactory.findMBeanServer(null);
                    }
                });
                this.server = mbservers.isEmpty() ? null : (MBeanServer)mbservers.get(0);
            } else {
                this.server = null;
                Server dasSrv = ServerHelper.getDAS(configContext);
                String dasName = dasSrv.getName();
                MBeanServerConnection mbsc = ServerHelper.connect(configContext, dasName);
                if (mbsc != null) {
                    this.server = mbsc;
                }
            }
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "MEJBHelper.exception_determining_mbean_server_connection");
        }
    }

    public static MEJBHelper getMEJBHelper() {
        if (mejbHelper == null) {
            mejbHelper = new MEJBHelper();
        }
        return mejbHelper;
    }

    public Set queryNames(ObjectName name, QueryExp query) throws Exception {
        return this.server.queryNames(name, query);
    }

    public boolean isRegistered(ObjectName name) throws Exception {
        return this.server.isRegistered(name);
    }

    public Integer getMBeanCount() throws IOException, Exception {
        return this.server.getMBeanCount();
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException, RemoteException {
        return this.server.getMBeanInfo(name);
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException, RemoteException {
        return this.server.getAttribute(name, attribute);
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException, RemoteException {
        return this.server.getAttributes(name, attributes);
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException, RemoteException {
        this.server.setAttribute(name, attribute);
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, IOException, RemoteException {
        return this.server.setAttributes(name, attributes);
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, IOException, ReflectionException, RemoteException {
        return this.server.invoke(name, operationName, params, signature);
    }

    public String getDefaultDomain() throws IOException {
        return this.server.getDefaultDomain();
    }

    public ListenerRegistration getListenerRegistry() {
        if (this.listenerRegistry == null) {
            try {
                this.listenerRegistry = new ListenerRegistry(InetAddress.getLocalHost().getHostAddress());
            }
            catch (UnknownHostException e) {
                this.listenerRegistry = new ListenerRegistry(J2EEModuleUtil.getDomainName());
            }
        }
        return this.listenerRegistry;
    }
}

