/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.instance;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.instance.BaseManager;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SerializedDescriptorHelper {
    private static final String SERIALIZED_DESCRIPTOR_FILE_NAME = "appDescr.dat";
    private static final String SERIALIZATION_ENABLED_PROPERTY = "com.sun.aas.deployment.serializeDescriptors";
    private static final String SERIALIZATION_ENABLED_DEFAULT = "true";
    private static final boolean isSerializedDescriptorIOEnabled = Boolean.parseBoolean(System.getProperty("com.sun.aas.deployment.serializeDescriptors", "true"));
    private static final Logger logger = LogDomains.getLogger("javax.enterprise.system.core");

    public static Loader load(String moduleID, BaseManager manager) {
        Loader loader = new Loader(moduleID, manager);
        loader.loadSerializedDescriptor();
        return loader;
    }

    public static void store(String moduleID, BaseManager manager, Application application) {
        File file = SerializedDescriptorHelper.getSerializedDescriptorFile(moduleID, manager);
        SerializedDescriptorHelper.store(moduleID, manager, application, file);
    }

    private static void store(String moduleID, BaseManager manager, Application application, File serializedFile) {
        if (SerializedDescriptorHelper.isSerializedDescriptorIOEnabled() && !SerializedDescriptorHelper.storeSerializedDescriptor(application, serializedFile, moduleID)) {
            SerializedDescriptorHelper.storeSerializedDescriptor(new Exception(SerializedDescriptorHelper.getCurrentSoftwareVersion()), serializedFile, moduleID);
        }
    }

    private static boolean isSerializedDescriptorIOEnabled() {
        return isSerializedDescriptorIOEnabled;
    }

    private static String getCurrentSoftwareVersion() {
        return Version.getMajorVersion() + "." + Version.getMinorVersion() + "-" + Version.getBuildVersion();
    }

    private static File getSerializedDescriptorFile(String moduleID, BaseManager manager) {
        return new File(manager.getGeneratedXMLLocation(moduleID), SERIALIZED_DESCRIPTOR_FILE_NAME);
    }

    private static void log(Level level, String messageKey, Throwable t, Object ... args) {
        String msg = logger.getResourceBundle().getString(messageKey);
        String formattedMsg = MessageFormat.format(msg, args);
        logger.log(level, formattedMsg, t);
    }

    private static void log(Level level, String messageKey, Object ... args) {
        logger.log(level, messageKey, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean storeSerializedDescriptor(Object obj, File file, String moduleID) {
        boolean result;
        ObjectOutputStream oos;
        block10: {
            if (!SerializedDescriptorHelper.isSerializedDescriptorIOEnabled()) {
                return false;
            }
            if (!file.getParentFile().exists()) {
                return false;
            }
            oos = null;
            oos = new ObjectOutputStream(new FileOutputStream(file));
            oos.writeObject(obj);
            result = true;
            if (!logger.isLoggable(Level.FINE)) break block10;
            logger.log(Level.FINE, "Serialized application " + moduleID);
        }
        Object var7_5 = null;
        if (oos == null) return result;
        try {
            oos.close();
            return result;
        }
        catch (IOException ioe) {
            SerializedDescriptorHelper.log(Level.WARNING, "core.error_ser_descr", ioe, moduleID);
        }
        return result;
        {
            catch (Throwable t) {
                result = false;
                SerializedDescriptorHelper.log(Level.WARNING, "core.error_ser_descr", t, moduleID);
                Object var7_6 = null;
                if (oos == null) return result;
                try {
                    oos.close();
                    return result;
                }
                catch (IOException ioe) {
                    SerializedDescriptorHelper.log(Level.WARNING, "core.error_ser_descr", ioe, moduleID);
                }
                return result;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (oos == null) throw throwable;
            try {
                oos.close();
                throw throwable;
            }
            catch (IOException ioe) {
                SerializedDescriptorHelper.log(Level.WARNING, "core.error_ser_descr", ioe, moduleID);
            }
            throw throwable;
        }
    }

    static /* synthetic */ boolean access$600() {
        return SerializedDescriptorHelper.isSerializedDescriptorIOEnabled();
    }

    static /* synthetic */ void access$700(Level x0, String x1, Object[] x2) {
        SerializedDescriptorHelper.log(x0, x1, x2);
    }

    public static class Loader {
        private Application deserializedApplication;
        private Exception deserializedException;
        private String moduleID;
        private BaseManager manager;
        private File file;

        private Loader(String moduleID, BaseManager manager) {
            this.moduleID = moduleID;
            this.manager = manager;
            this.file = SerializedDescriptorHelper.getSerializedDescriptorFile(moduleID, manager);
        }

        public void store(Application application) {
            boolean tryToWrite;
            if (application == this.deserializedApplication) {
                return;
            }
            boolean bl = tryToWrite = this.deserializedException == null;
            if (this.deserializedException != null && !this.deserializedException.getMessage().equals(SerializedDescriptorHelper.getCurrentSoftwareVersion())) {
                tryToWrite = true;
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Trying to serialize an application that could not be serialized by " + this.deserializedException.getMessage());
                }
            }
            if (tryToWrite) {
                SerializedDescriptorHelper.store(this.moduleID, this.manager, application, this.file);
            }
        }

        public Application getApplication() {
            return this.deserializedApplication;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void loadSerializedDescriptor() {
            if (!SerializedDescriptorHelper.access$600()) {
                return;
            }
            this.deserializedApplication = null;
            this.deserializedException = null;
            ois = null;
            fine = SerializedDescriptorHelper.access$400().isLoggable(Level.FINE);
            try {
                block17: {
                    block16: {
                        if (this.file.exists()) break block16;
                        if (fine) {
                            SerializedDescriptorHelper.access$400().fine("Serialized descriptor for " + this.moduleID + " not found.  Will not try to read serialized file.");
                        }
                        var5_3 = null;
                        if (ois == null) return;
                        ** GOTO lbl53
                    }
                    ois = new ObjectInputStream(new FileInputStream(this.file));
                    o = ois.readObject();
                    if (!(o instanceof Application)) break block17;
                    this.deserializedApplication = (Application)o;
                    if (fine) {
                        SerializedDescriptorHelper.access$400().fine("Serialized descriptor for " + this.moduleID + " loaded from " + this.file.getAbsolutePath());
                    }
                    ** GOTO lbl59
                }
                if (o instanceof Exception) {
                    this.deserializedException = (Exception)o;
                    if (fine) {
                        SerializedDescriptorHelper.access$400().fine("Serialized descriptor file contained an exception with message \"" + this.deserializedException.getMessage() + "\" " + "because a previous attempt to write it failed.");
                    }
                } else {
                    SerializedDescriptorHelper.access$700(Level.WARNING, "core.unexp_deser_type", new Object[]{this.moduleID, o.getClass().getName()});
                }
                ** GOTO lbl59
            }
            catch (Throwable thr) {
                SerializedDescriptorHelper.access$700(Level.WARNING, "core.error_deser_descr", new Object[]{this.moduleID, thr.getLocalizedMessage()});
                var5_5 = null;
                if (ois == null) return;
                try {
                    ois.close();
                    return;
                }
                catch (IOException ioe) {
                    SerializedDescriptorHelper.access$700(Level.WARNING, "core.error_deser_descr", new Object[]{this.moduleID, ioe.getLocalizedMessage(), ioe});
                    return;
                }
            }
            {
                catch (Throwable var4_13) {
                    var5_6 = null;
                    if (ois == null) throw var4_13;
                    ** try [egrp 2[TRYBLOCK] [6 : 314->321)] { 
lbl48:
                    // 1 sources

                    ois.close();
                    throw var4_13;
lbl50:
                    // 1 sources

                    catch (IOException ioe) {
                        SerializedDescriptorHelper.access$700(Level.WARNING, "core.error_deser_descr", new Object[]{this.moduleID, ioe.getLocalizedMessage(), ioe});
                    }
                    throw var4_13;
                }
lbl53:
                // 1 sources

                ** try [egrp 2[TRYBLOCK] [6 : 314->321)] { 
lbl54:
                // 1 sources

                ois.close();
                return;
lbl56:
                // 1 sources

                catch (IOException ioe) {
                    SerializedDescriptorHelper.access$700(Level.WARNING, "core.error_deser_descr", new Object[]{this.moduleID, ioe.getLocalizedMessage(), ioe});
                }
                return;
lbl59:
                // 3 sources

                var5_4 = null;
                if (ois == null) return;
                try {}
                catch (IOException ioe) {}
                SerializedDescriptorHelper.access$700(Level.WARNING, "core.error_deser_descr", new Object[]{this.moduleID, ioe.getLocalizedMessage(), ioe});
                return;
                ois.close();
                return;
            }
        }
    }
}

