/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.instance;

import com.sun.enterprise.admin.server.core.channel.AdminChannel;
import com.sun.enterprise.admin.server.core.channel.RMIClient;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.EjbContainer;
import com.sun.enterprise.config.serverbeans.PropertyResolver;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.instance.ApplicationEnvironment;
import com.sun.enterprise.instance.ExceptionType;
import com.sun.enterprise.instance.Localizer;
import com.sun.enterprise.instance.ModuleEnvironment;
import com.sun.enterprise.instance.ServerManager;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.diagnostics.ObjectAnalyzer;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class InstanceEnvironment {
    private static Object lock = new Object();
    private static final boolean TIMESTAMP_MECHANISM_ENABLED = true;
    private static final boolean MIMETYPE_TIMESTAMP_MECHANISM_ENABLED = true;
    private static final boolean VIRTUAL_SERVER_TIMESTAMP_MECHANISM_ENABLED = true;
    private static final long INVALID_TIME_STAMP = 0L;
    private static final long UNINITIALIZED_TIME_STAMP = 0L;
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");
    public static final String kConfigDirName = "config";
    public static final String kBackupDirName = ".";
    private static final String kRepositoryBackupDirName = "backup";
    public static final String kGeneratedDirName = "generated";
    public static final String kRepositoryDirName = "applications";
    public static final String kApplicationDirName = "j2ee-apps";
    public static final String kModuleDirName = "j2ee-modules";
    public static final String kLifecycleModuleDirName = "lifecycle-modules";
    public static final String kEJBStubDirName = "ejb";
    public static final String kConfigXMLFileName = "domain.xml";
    public static final String kServerXMLFileName = "server.xml";
    public static final String kLibDirName = "lib";
    public static final String kAutoDeployDirName = "autodeploy";
    public static final String kLibClassesDirName = "classes";
    public static final String kCompileJspDirName = "jsp";
    public static final String kGeneratedXMLDirName = "xml";
    public static final String kSessionStoreDirName = "session-store";
    public static final String kHttpSessionDirName = "http";
    public static final String kDocRootDirName = "docroot";
    public static final String kObjectFileName = "obj.conf";
    public static final String kInitFileName = "init.conf";
    public static final String kSecurityPasswordsFileName = "password.conf";
    public static final String kRealmsKeyFileName = "keyfile";
    public static final String kInstallDirName = "install";
    public static final String kTemplatesDirName = "templates";
    public static final String kAclTemplate = "template.acl";
    public static final int kOrbListenerPort = 3700;
    public static final int kJmsProviderPort = 7676;
    public static final String kJavaWebStartDirName = "java-web-start";
    private String instanceRoot = null;
    private String mLogicalName = null;
    private String mConfigFilePath = null;
    private String mBackupConfigFilePath = null;
    private String mApplicationRootPath = null;
    private String mApplicationRepositoryPath = null;
    private String mApplicationBackupRepositoryPath = null;
    private String mModuleRepositoryPath = null;
    private String mModuleBackupRepositoryPath = null;
    private String mApplicationStubRepositoryPath = null;
    private String mModuleStubRepositoryPath = null;
    private String mApplicationGeneratedXMLPath = null;
    private String mModuleGeneratedXMLPath = null;
    private String mLibPath = null;
    private String mAutoDeployDirPath = null;
    private String mLibClassesPath = null;
    private String mApplicationPassivatedEjbPath = null;
    private String mModulePassivatedEjbPath = null;
    private String mApplicationCompiledJspPath = null;
    private String mWebModuleCompiledJspPath = null;
    private String mApplicationHttpSessionStorePath = null;
    private String mModuleHttpSessionStorePath = null;
    private String mDocRootPath = null;
    private String mStopCommandPath = null;
    private String mDefaultAccessLogPath = null;
    private String mObjectFilePath = null;
    private String mInitFilePath = null;
    private String mBackupObjectFilePath = null;
    private String mBackupInitFilePath = null;
    private String mSecurityPasswordsFilePath = null;
    private String mRealmsKeyFilePath = null;
    private String mBackupRealmsKeyFilePath = null;
    private String mAclFilePath = null;
    private String mBackupAclFilePath = null;
    private String kAclFilePrefix = "generated";
    private String kBackupAclFilePrefix = "genwork";
    private String kAclFileSuffix = "acl";
    private String mJavaWebStartDirPath = null;
    private boolean mInited = false;
    private String mInstancesRoot = null;
    private PropertyResolver mPathResolver;

    public InstanceEnvironment(String instanceName) {
        this(System.getProperty("com.sun.aas.instanceRoot"), instanceName);
    }

    public InstanceEnvironment(String instancesRoot, String instanceName) {
        if (!StringUtils.ok(instanceName)) {
            throw new IllegalArgumentException(Localizer.getValue(ExceptionType.NULL_ARG));
        }
        this.mLogicalName = instanceName;
        this.mInstancesRoot = instancesRoot;
        this.createConfigFilePath();
    }

    private void init() {
        if (this.mInited) {
            return;
        }
        this.createPathResolver();
        this.createApplicationRootPath();
        this.createApplicationRepositoryPath();
        this.createApplicationBackupRepositoryPath();
        this.createModuleRepositoryPath();
        this.createModuleBackupRepositoryPath();
        this.createApplicationStubPath();
        this.createModuleStubPath();
        this.createApplicationGeneratedXMLPath();
        this.createModuleGeneratedXMLPath();
        this.createLibPath();
        this.createLibClassesPath();
        this.createAutoDeployDirPath();
        this.createPassivatedEjbPaths();
        this.createApplicationCompiledJspPath();
        this.createWebModuleCompiledJspPath();
        this.createHttpSessionStorePaths();
        this.createDocRootPath();
        this.createStopCommandPath();
        this.createDefaultAccessLogPath();
        this.createObjectFilePath();
        this.createInitFilePath();
        this.createSecurityPasswordsFilePath();
        this.createRealmsKeyFilePath();
        this.createAclFilePath();
        this.createJavaWebStartPath();
        this.mInited = true;
    }

    public void applyChangesFromBackup() throws ConfigException {
    }

    public void applyChangesFromBackup(boolean overwrite) throws ConfigException {
    }

    public boolean hasHotChanged() {
        return false;
    }

    public boolean hasInitOrObjConfFileChanged() {
        return false;
    }

    public boolean hasRealmsKeyConfFileChanged() {
        return false;
    }

    public boolean hasMimeConfFileChanged() {
        return false;
    }

    public boolean hasVirtualServerConfFileChanged() {
        return false;
    }

    public boolean hasCGIConfigFilesChanged() {
        return false;
    }

    public boolean hasHotInitChanged() {
        return false;
    }

    public boolean hasHotRealmsKeyChanged() {
        return false;
    }

    public boolean hasHotObjectChanged() {
        return false;
    }

    public boolean hasHotXmlChanged() {
        return false;
    }

    public boolean canReloadManualXmlChanges() {
        return false;
    }

    private boolean hasOnlyHotXmlChanged() {
        return false;
    }

    public boolean hasHotMimeChanged() {
        return false;
    }

    public boolean hasHotVirtualServerConfChanged() {
        return false;
    }

    public boolean hasBakupVirtualServerConfChanged() {
        return false;
    }

    private boolean hasVirtualServerConfChanged(ConfigContext context, boolean isHot) throws ConfigException {
        return false;
    }

    private long getConfigFileTimeStamp(String configFile) {
        long ts = 0L;
        try {
            File f = new File(configFile);
            ts = f.lastModified();
        }
        catch (Throwable t) {
            // empty catch block
        }
        return ts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLastModifiedFromTSFile(String tsFileName) {
        long ts = 0L;
        InputStreamReader fr = null;
        try {
            File f = new File(tsFileName);
            fr = new FileReader(f);
            char[] cbuf = new char[13];
            fr.read(cbuf);
            String s = new String(cbuf);
            ts = new Long(s);
        }
        catch (Throwable t) {
        }
        finally {
            try {
                fr.close();
                fr = null;
            }
            catch (Exception ex) {}
        }
        return ts;
    }

    private String getTimeStampFileName(String fullName) {
        return fullName + ".timestamp";
    }

    public void useManualConfigChanges() throws ConfigException {
    }

    public void useManualServerXmlChanges() throws ConfigException {
    }

    private void useManualInitFileChanges() throws ConfigException {
    }

    private void useManualRealmsKeyFileChanges() throws ConfigException {
    }

    private void useManualObjectFileChanges() throws ConfigException {
    }

    private void useManualAllMimeFileChanges() throws ConfigException {
    }

    private void useManualVirtualServerConfFileChanges(ConfigContext bakXmlCtx) throws ConfigException {
    }

    private void deleteVirtualServerConfigFiles(ConfigContext ctx, ConfigContext ctx2, boolean isHot) throws ConfigException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTimeStampFiles() {
        this.init();
        Object object = lock;
        synchronized (object) {
            this.createTSFile(this.getTimeStampFileName(this.mConfigFilePath), this.mConfigFilePath, this.mConfigFilePath);
            this.createTSFile(this.getTimeStampFileName(this.mBackupRealmsKeyFilePath), this.mRealmsKeyFilePath, this.mBackupRealmsKeyFilePath);
        }
    }

    private void createTSFile(String tsFileName, String actualFile, String backupFile) {
        File f = new File(tsFileName);
        if (!f.exists()) {
            this.saveTimeStamp(tsFileName, actualFile, backupFile);
        }
    }

    private void createMimeTSFiles() {
    }

    private void createVirtualServersConfTSFiles() {
    }

    private void saveTimeStamp(String tsFileName, String actualFile, String backupFile) {
        long ts = this.saveTimeStamp(tsFileName, actualFile);
        new File(backupFile).setLastModified(ts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long saveTimeStamp(String tsFileName, String actualFile) {
        long timestamp = this.getConfigFileTimeStamp(actualFile);
        File f = null;
        OutputStreamWriter fw = null;
        try {
            f = new File(tsFileName);
            fw = new FileWriter(f);
            fw.write("" + timestamp);
        }
        catch (Throwable t) {
            _logger.log(Level.WARNING, "core.file_io_exception", t);
        }
        finally {
            try {
                fw.close();
            }
            catch (Throwable ex) {}
        }
        return timestamp;
    }

    public void applyServerXmlChanges(boolean overwrite) throws ConfigException {
    }

    public void applyInitFileChanges() throws ConfigException {
    }

    public void applyRealmsKeyFileChanges() throws ConfigException {
    }

    public void applyObjectFileChanges() throws ConfigException {
    }

    public void applyAllMimeFileChanges() throws ConfigException {
    }

    public void applyAclFileChanges() throws ConfigException {
    }

    public void applyVirtualServersConfFileChanges(ConfigContext hotXmlCtx) throws ConfigException {
    }

    private void copyFile(File fromFile, File toFile) throws ConfigException {
        if (!fromFile.exists()) {
            throw new ConfigException(Localizer.getValue(ExceptionType.FROM_NOT_EXIST, fromFile.getPath()));
        }
        if (fromFile.isDirectory()) {
            throw new ConfigException(Localizer.getValue(ExceptionType.FROM_IS_DIR, fromFile.getPath()));
        }
        if (toFile.isDirectory()) {
            throw new ConfigException(Localizer.getValue(ExceptionType.TO_IS_DIR, toFile.getPath()));
        }
        if (toFile.exists() && !toFile.canWrite()) {
            throw new ConfigException(Localizer.getValue(ExceptionType.TO_READ_ONLY, toFile.getPath()));
        }
        try {
            FileUtils.copy(fromFile, toFile);
        }
        catch (Exception e) {
            Object[] objs = new Object[]{fromFile.getPath(), toFile.getPath(), e.toString()};
            throw new ConfigException(Localizer.getValue(ExceptionType.FAILED_COPY, objs), e);
        }
    }

    private void createConfigFilePath() {
        String[] onlyFolderNames = new String[]{this.mInstancesRoot, kConfigDirName, kConfigXMLFileName};
        this.mConfigFilePath = StringUtils.makeFilePath(onlyFolderNames, false);
    }

    private void createBackupConfigFilePath() {
        String[] onlyFolderNames = new String[]{this.mInstancesRoot, kConfigDirName, kBackupDirName, kConfigXMLFileName};
        this.mBackupConfigFilePath = StringUtils.makeFilePath(onlyFolderNames, false);
    }

    private void createApplicationRootPath() {
        try {
            ConfigContext context = ConfigFactory.createConfigContext(this.mConfigFilePath);
            Domain domain = ServerBeansFactory.getDomainBean(context);
            this.mApplicationRootPath = domain.getApplicationRoot();
            if (this.mApplicationRootPath == null || this.mApplicationRootPath.length() <= 0) {
                this.createDefaultApplicationRootPath();
            }
            this.mApplicationRootPath = this.resolvePath(this.mApplicationRootPath);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "InstanceEnv.createApplicationRootPath()", e);
        }
    }

    private void createDefaultApplicationRootPath() {
        String[] onlyFolderNames = new String[]{this.mInstancesRoot, kRepositoryDirName};
        this.mApplicationRootPath = StringUtils.makeFilePath(onlyFolderNames, false);
    }

    private void createApplicationRepositoryPath() {
        String[] onlyFolderNames = new String[]{this.mApplicationRootPath, kApplicationDirName};
        this.mApplicationRepositoryPath = StringUtils.makeFilePath(onlyFolderNames, false);
    }

    private void createModuleRepositoryPath() {
        String[] onlyFolderNames = new String[]{this.mApplicationRootPath, kModuleDirName};
        this.mModuleRepositoryPath = StringUtils.makeFilePath(onlyFolderNames, false);
    }

    private void createApplicationBackupRepositoryPath() {
        String[] onlyFolderNames = new String[]{this.mApplicationRootPath, kRepositoryBackupDirName, kApplicationDirName};
        this.mApplicationBackupRepositoryPath = StringUtils.makeFilePath(onlyFolderNames, false);
    }

    private void createModuleBackupRepositoryPath() {
        String[] onlyFolderNames = new String[]{this.mApplicationRootPath, kRepositoryBackupDirName, kModuleDirName};
        this.mModuleBackupRepositoryPath = StringUtils.makeFilePath(onlyFolderNames, false);
    }

    private void createAutoDeployDirPath() {
        String[] onlyFolderNames = new String[]{this.mInstancesRoot, kAutoDeployDirName};
        this.mAutoDeployDirPath = StringUtils.makeFilePath(onlyFolderNames, false);
    }

    private void createLibPath() {
        String[] onlyFolderNames = new String[]{this.mInstancesRoot, kLibDirName};
        this.mLibPath = StringUtils.makeFilePath(onlyFolderNames, false);
    }

    private void createLibClassesPath() {
        String[] onlyFolderNames = new String[]{this.mInstancesRoot, kLibDirName, kLibClassesDirName};
        this.mLibClassesPath = StringUtils.makeFilePath(onlyFolderNames, false);
    }

    private void createApplicationStubPath() {
        String[] onlyFolderNames = new String[]{this.mInstancesRoot, kGeneratedDirName, kEJBStubDirName, kApplicationDirName};
        this.mApplicationStubRepositoryPath = StringUtils.makeFilePath(onlyFolderNames, false);
    }

    private void createModuleStubPath() {
        String[] onlyFolderNames = new String[]{this.mInstancesRoot, kGeneratedDirName, kEJBStubDirName, kModuleDirName};
        this.mModuleStubRepositoryPath = StringUtils.makeFilePath(onlyFolderNames, false);
    }

    private void createApplicationGeneratedXMLPath() {
        String[] onlyFolderNames = new String[]{this.mInstancesRoot, kGeneratedDirName, kGeneratedXMLDirName, kApplicationDirName};
        this.mApplicationGeneratedXMLPath = StringUtils.makeFilePath(onlyFolderNames, false);
    }

    private void createModuleGeneratedXMLPath() {
        String[] onlyFolderNames = new String[]{this.mInstancesRoot, kGeneratedDirName, kGeneratedXMLDirName, kModuleDirName};
        this.mModuleGeneratedXMLPath = StringUtils.makeFilePath(onlyFolderNames, false);
    }

    private String getDefaultSessionStorePath() {
        String[] onlyFolderNames = new String[]{this.mInstancesRoot, kSessionStoreDirName};
        return StringUtils.makeFilePath(onlyFolderNames, false);
    }

    private void createPassivatedEjbPaths() {
        try {
            ConfigContext context = ConfigFactory.createConfigContext(this.mConfigFilePath);
            EjbContainer ejbContainer = ServerBeansFactory.getConfigBean(context).getEjbContainer();
            String sessionStore = ejbContainer.getSessionStore();
            if (sessionStore == null || sessionStore.length() <= 0) {
                sessionStore = this.getDefaultSessionStorePath();
            }
            sessionStore = this.resolvePath(sessionStore);
            String[] onlyFolderNames = new String[]{sessionStore, kEJBStubDirName, kApplicationDirName};
            this.mApplicationPassivatedEjbPath = StringUtils.makeFilePath(onlyFolderNames, false);
            onlyFolderNames[2] = kModuleDirName;
            this.mModulePassivatedEjbPath = StringUtils.makeFilePath(onlyFolderNames, false);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "InstanceEnv.createApplicationRootPath()", e);
        }
    }

    private void createHttpSessionStorePaths() {
        try {
            ConfigContext context = ConfigFactory.createConfigContext(this.mConfigFilePath);
            EjbContainer ejbContainer = ServerBeansFactory.getConfigBean(context).getEjbContainer();
            String sessionStore = ejbContainer.getSessionStore();
            if (sessionStore == null || sessionStore.length() <= 0) {
                sessionStore = this.getDefaultSessionStorePath();
            }
            sessionStore = this.resolvePath(sessionStore);
            String[] onlyFolderNames = new String[]{sessionStore, kHttpSessionDirName, kApplicationDirName};
            this.mApplicationHttpSessionStorePath = StringUtils.makeFilePath(onlyFolderNames, false);
            onlyFolderNames[2] = kModuleDirName;
            this.mModuleHttpSessionStorePath = StringUtils.makeFilePath(onlyFolderNames, false);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "InstanceEnv.createApplicationRootPath()", e);
        }
    }

    private void createApplicationCompiledJspPath() {
        String[] onlyFolderNames = new String[]{this.mInstancesRoot, kGeneratedDirName, kCompileJspDirName, kApplicationDirName};
        this.mApplicationCompiledJspPath = StringUtils.makeFilePath(onlyFolderNames, false);
    }

    private void createWebModuleCompiledJspPath() {
        String[] onlyFolderNames = new String[]{this.mInstancesRoot, kGeneratedDirName, kCompileJspDirName, kModuleDirName};
        this.mWebModuleCompiledJspPath = StringUtils.makeFilePath(onlyFolderNames, false);
    }

    private void createDocRootPath() {
        String[] onlyFolderNames = new String[]{this.mInstancesRoot, kDocRootDirName};
        this.mDocRootPath = StringUtils.makeFilePath(onlyFolderNames, false);
    }

    private void createStopCommandPath() {
        String[] onlyFolderNames = new String[]{this.mInstancesRoot};
        String execName = null;
        execName = OS.isWindows() ? "stopserv.bat" : "stopserv";
        this.mStopCommandPath = StringUtils.makeFilePath(onlyFolderNames, true) + execName;
    }

    private void createDefaultAccessLogPath() {
        String logDirName = "logs";
        String accessLogFileName = "access";
        String[] fileNames = new String[]{this.mInstancesRoot, "logs", "access"};
        this.mDefaultAccessLogPath = StringUtils.makeFilePath(fileNames, false);
    }

    private void createObjectFilePath() {
        String[] fileNames = new String[]{this.mInstancesRoot, kConfigDirName, kObjectFileName};
        this.mObjectFilePath = StringUtils.makeFilePath(fileNames, false);
    }

    private void createInitFilePath() {
        String[] fileNames = new String[]{this.mInstancesRoot, kConfigDirName, kInitFileName};
        this.mInitFilePath = StringUtils.makeFilePath(fileNames, false);
    }

    private void createSecurityPasswordsFilePath() {
        String[] fileNames = new String[]{this.mInstancesRoot, kConfigDirName, kSecurityPasswordsFileName};
        this.mSecurityPasswordsFilePath = StringUtils.makeFilePath(fileNames, false);
    }

    private void createRealmsKeyFilePath() {
        String[] fileNames = new String[]{this.mInstancesRoot, kConfigDirName, kRealmsKeyFileName};
        this.mRealmsKeyFilePath = StringUtils.makeFilePath(fileNames, false);
    }

    private void createBackupObjectFilePath() {
        String[] fileNames = new String[]{this.mInstancesRoot, kConfigDirName, kBackupDirName, kObjectFileName};
        this.mBackupObjectFilePath = StringUtils.makeFilePath(fileNames, false);
    }

    private void createBackupInitFilePath() {
        String[] fileNames = new String[]{this.mInstancesRoot, kConfigDirName, kBackupDirName, kInitFileName};
        this.mBackupInitFilePath = StringUtils.makeFilePath(fileNames, false);
    }

    private void createAclFilePath() {
        String aclFileName = this.kAclFilePrefix + kBackupDirName + this.getName() + kBackupDirName + this.kAclFileSuffix;
        String[] fileNames = new String[]{this.mInstancesRoot, kConfigDirName, aclFileName};
        this.mAclFilePath = StringUtils.makeFilePath(fileNames, false);
    }

    private void createBackupAclFilePath() {
        String backupAclFileName = this.kBackupAclFilePrefix + kBackupDirName + this.getName() + kBackupDirName + this.kAclFileSuffix;
        String[] fileNames = new String[]{this.mInstancesRoot, kConfigDirName, backupAclFileName};
        this.mBackupAclFilePath = StringUtils.makeFilePath(fileNames, false);
    }

    private void createBackupRealmsKeyFilePath() {
        String[] fileNames = new String[]{this.mInstancesRoot, kConfigDirName, kBackupDirName, kRealmsKeyFileName};
        this.mBackupRealmsKeyFilePath = StringUtils.makeFilePath(fileNames, false);
    }

    private void createJavaWebStartPath() {
        String[] fileNames = new String[]{this.mInstancesRoot, kJavaWebStartDirName};
        this.mJavaWebStartDirPath = StringUtils.makeFilePath(fileNames, false);
    }

    public String getName() {
        return this.mLogicalName;
    }

    public String getInstancesRoot() {
        return this.mInstancesRoot;
    }

    public String getConfigDirPath() {
        String[] folderNames = new String[]{this.mInstancesRoot, kConfigDirName};
        String configDirPath = StringUtils.makeFilePath(folderNames, false);
        return configDirPath;
    }

    public String getBackupConfigDirPath() {
        return this.getConfigDirPath();
    }

    public String getConfigFilePath() {
        return this.mConfigFilePath;
    }

    public String getBackupConfigFilePath() {
        return this.mConfigFilePath;
    }

    public String getApplicationRepositoryPath() {
        this.init();
        return this.mApplicationRepositoryPath;
    }

    public String getApplicationBackupRepositoryPath() {
        this.init();
        return this.mApplicationBackupRepositoryPath;
    }

    public String getModuleRepositoryPath() {
        this.init();
        return this.mModuleRepositoryPath;
    }

    public String getModuleBackupRepositoryPath() {
        this.init();
        return this.mModuleBackupRepositoryPath;
    }

    public String getApplicationStubPath() {
        this.init();
        return this.mApplicationStubRepositoryPath;
    }

    public String getModuleStubPath() {
        this.init();
        return this.mModuleStubRepositoryPath;
    }

    public String getApplicationGeneratedXMLPath() {
        this.init();
        return this.mApplicationGeneratedXMLPath;
    }

    public String getModuleGeneratedXMLPath() {
        this.init();
        return this.mModuleGeneratedXMLPath;
    }

    public String getLibPath() {
        this.init();
        return this.mLibPath;
    }

    public static String getTemplatesDirPath() {
        String installRoot = System.getProperty("com.sun.aas.installRoot");
        String[] dirs = new String[]{installRoot, kLibDirName, kInstallDirName, kTemplatesDirName};
        return StringUtils.makeFilePath(dirs, false);
    }

    public String getAutoDeployDirPath() {
        this.init();
        return this.mAutoDeployDirPath;
    }

    public String getLibClassesPath() {
        this.init();
        return this.mLibClassesPath;
    }

    public String getApplicationCompileJspPath() {
        this.init();
        return this.mApplicationCompiledJspPath;
    }

    public String getWebModuleCompileJspPath() {
        this.init();
        return this.mWebModuleCompiledJspPath;
    }

    public String getApplicationPassivatedEjbPath() {
        this.init();
        return this.mApplicationPassivatedEjbPath;
    }

    public String getModulePassivatedEjbPath() {
        this.init();
        return this.mModulePassivatedEjbPath;
    }

    public String getApplicationHttpSessionStorePath() {
        this.init();
        return this.mApplicationHttpSessionStorePath;
    }

    public String getModuleHttpSessionStorePath() {
        this.init();
        return this.mModuleHttpSessionStorePath;
    }

    public String getDocRootPath() {
        this.init();
        return this.mDocRootPath;
    }

    public String getStopCommandPath() {
        this.init();
        return this.mStopCommandPath;
    }

    public String getDefaultAccessLogPath() {
        this.init();
        return this.mDefaultAccessLogPath;
    }

    public String getInitFilePath() {
        this.init();
        return this.mInitFilePath;
    }

    public String getBackupInitFilePath() {
        this.init();
        return this.mBackupInitFilePath;
    }

    public String getSecurityPasswordsFilePath() {
        this.init();
        return this.mSecurityPasswordsFilePath;
    }

    public String getRealmsKeyFilePath() {
        this.init();
        return this.mRealmsKeyFilePath;
    }

    public String getBackupRealmsKeyFilePath() {
        this.init();
        return this.mRealmsKeyFilePath;
    }

    public String getObjectFilePath() {
        this.init();
        return this.mObjectFilePath;
    }

    public String getBackupObjectFilePath() {
        this.init();
        return this.mBackupObjectFilePath;
    }

    public ApplicationEnvironment getApplicationEnvironment(String appName) {
        this.init();
        if (appName == null) {
            throw new IllegalArgumentException();
        }
        return new ApplicationEnvironment(this, appName);
    }

    public ModuleEnvironment getModuleEnvironment(String moduleName, DeployableObjectType type) {
        this.init();
        if (moduleName == null) {
            throw new IllegalArgumentException();
        }
        return new ModuleEnvironment(this, moduleName, type);
    }

    public String getJavaWebStartPath() {
        this.init();
        return this.mJavaWebStartDirPath;
    }

    public String verify() {
        return null;
    }

    public String toString() {
        this.init();
        return ObjectAnalyzer.toString(this);
    }

    public final boolean isIASOwned(String filename) {
        return this.isIASOwned(new File(filename));
    }

    public final boolean isIASOwned(File file) {
        this.init();
        try {
            String iasPath = this.getInstancesRoot();
            assert (StringUtils.ok(iasPath));
            iasPath = FileUtils.safeGetCanonicalPath(new File(iasPath));
            String filename = FileUtils.safeGetCanonicalPath(file);
            if (!StringUtils.ok(iasPath)) {
                return false;
            }
            if (!StringUtils.ok(filename)) {
                return false;
            }
            return filename.startsWith(iasPath);
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restartRequired() {
        this.init();
        Object object = lock;
        synchronized (object) {
            try {
                RMIClient rc = AdminChannel.getRMIClient(this.mLogicalName);
                if (!rc.isAlive()) {
                    return false;
                }
                return !rc.hasRestartedSince(this.getManualChangeTime());
                {
                }
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    private long getManualChangeTime() {
        long ts = 0L;
        long tsTmp = 0L;
        try {
            ts = this.getConfigFileTimeStamp(this.mInitFilePath);
            tsTmp = this.getConfigFileTimeStamp(this.mObjectFilePath);
            if (ts < tsTmp) {
                ts = tsTmp;
            }
            if (ts < (tsTmp = this.getConfigFileTimeStamp(this.mConfigFilePath))) {
                ts = tsTmp;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        return ts;
    }

    private boolean hasBakMimeChanged() {
        return false;
    }

    public String getInstanceUser() throws IOException {
        this.init();
        return ServerManager.instance().getInstanceUser(this);
    }

    public boolean isChownNeeded(File f) {
        this.init();
        return false;
    }

    private void chownFile(String filePath) throws ConfigException {
    }

    private void createPathResolver() {
        try {
            this.mPathResolver = new PropertyResolver(ConfigFactory.createConfigContext(this.mConfigFilePath), this.mLogicalName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String resolvePath(String unresolved) {
        if (this.mPathResolver != null) {
            return this.mPathResolver.resolve(unresolved);
        }
        return unresolved;
    }
}

