/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop;

import com.sun.corba.ee.spi.folb.ClusterInstanceInfo;
import com.sun.corba.ee.spi.folb.GroupInfoService;
import com.sun.corba.ee.spi.folb.SocketInfo;
import com.sun.enterprise.admin.util.JMXConnectorConfig;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigAPIHelper;
import com.sun.enterprise.config.serverbeans.IiopListener;
import com.sun.enterprise.config.serverbeans.IiopService;
import com.sun.enterprise.config.serverbeans.PropertyResolver;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.iiop.ASORBUtilities;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.ORBManager;
import com.sun.logging.LogDomains;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.ORBPackage.InvalidName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IIOPEndpointsInfo {
    private static ServerRef[] serverRefs;
    private static IiopListener[][] listeners;
    private static Cluster cluster;
    private static Logger _logger;
    private static final String baseMsg;
    private static ConfigContext configCtx;

    public static ServerRef[] getServersInCluster() {
        if (serverRefs != null) {
            return serverRefs;
        }
        _logger.log(Level.FINE, baseMsg + ".getServersInCluster:" + "no servers available. Server Context is null");
        return null;
    }

    public static IiopListener[][] getListenersInCluster() {
        if (listeners != null) {
            return listeners;
        }
        _logger.log(Level.FINE, baseMsg + ".getServersInCluster:" + "no listeners available. Server Context is null");
        return null;
    }

    public static List<SocketInfo> getSocketInfoForServer(ServerRef serverRef, IiopListener[] listen) throws ConfigException {
        LinkedList<SocketInfo> listOfSocketInfo = new LinkedList<SocketInfo>();
        String serverName = serverRef.getRef();
        String hostName = IIOPEndpointsInfo.getHostNameForServerInstance(serverName);
        if (hostName == null) {
            hostName = listen[0].getAddress();
        }
        for (int j = 0; j < listen.length; ++j) {
            String id = listen[j].getId();
            String port = IIOPEndpointsInfo.getResolvedPort(listen[j], serverName);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, baseMsg + ".getSocketInfoForServer:" + " adding address for " + serverName + "/" + id + "/" + hostName + "/" + port);
            }
            listOfSocketInfo.add(new SocketInfo(id, hostName, Integer.valueOf(port)));
        }
        return listOfSocketInfo;
    }

    private static boolean isEE() {
        boolean isEE = false;
        String eepffc = "com.sun.enterprise.ee.server.pluggable.EEPluggableFeatureImpl";
        String pn = "com.sun.appserv.pluggable.features";
        String pv = System.getProperty("com.sun.appserv.pluggable.features");
        if ("com.sun.enterprise.ee.server.pluggable.EEPluggableFeatureImpl".equals(pv)) {
            isEE = true;
        }
        return isEE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getIIOPEndpoints() {
        String endpoints;
        block15: {
            String string;
            block14: {
                endpoints = null;
                try {
                    String string2;
                    block13: {
                        try {
                            _logger.log(Level.FINE, baseMsg + ".getIIOPEndpoints->:");
                            if (IIOPEndpointsInfo.isEE()) {
                                GroupInfoService gis = (GroupInfoService)ORBManager.getORB().resolve_initial_references("FolbServerGroupInfoService");
                                if (gis == null) {
                                    _logger.fine(baseMsg + ".getIIOPEndpoints->:" + "GroupInfoService not available.Is this PE?");
                                    string2 = null;
                                    Object var7_9 = null;
                                    break block13;
                                }
                            } else {
                                _logger.fine(baseMsg + ".getIIOPEndpoints->:" + "This is PE");
                                string = null;
                                break block14;
                            }
                            if (serverRefs != null) {
                                for (int i = 0; i < serverRefs.length; ++i) {
                                    List<SocketInfo> listOfSocketInfo = IIOPEndpointsInfo.getSocketInfoForServer(serverRefs[i], listeners[i]);
                                    for (SocketInfo si : listOfSocketInfo) {
                                        if (si.type.equals("SSL_MUTUALAUTH") || si.type.equals("SSL")) continue;
                                        if (endpoints == null) {
                                            endpoints = si.host + ":" + si.port;
                                            continue;
                                        }
                                        endpoints = endpoints + "," + si.host + ":" + si.port;
                                    }
                                    if (!_logger.isLoggable(Level.FINE)) continue;
                                    _logger.log(Level.FINE, baseMsg + ".getIIOPEndpoints: " + endpoints);
                                }
                            }
                            break block15;
                        }
                        catch (ConfigException e) {
                            _logger.log(Level.FINE, baseMsg + ".getIIOPEndpoints: " + "ConfigException occurred => " + e);
                            String string3 = null;
                            Object var7_12 = null;
                            _logger.log(Level.FINE, baseMsg + ".getIIOPEndpoints<-: " + endpoints);
                            return string3;
                        }
                        catch (NullPointerException e) {
                            _logger.log(Level.FINE, baseMsg + ".getIIOPEndpoints: " + "NPE occurred => " + e);
                            String string4 = null;
                            Object var7_13 = null;
                            _logger.log(Level.FINE, baseMsg + ".getIIOPEndpoints<-: " + endpoints);
                            return string4;
                        }
                        catch (InvalidName in) {
                            _logger.log(Level.FINE, baseMsg + ".getIIOPEndpoints<-: " + "FolbServerGroupInfoService" + "doesnot exist. This is PE");
                            String string5 = null;
                            Object var7_14 = null;
                            _logger.log(Level.FINE, baseMsg + ".getIIOPEndpoints<-: " + endpoints);
                            return string5;
                        }
                    }
                    _logger.log(Level.FINE, baseMsg + ".getIIOPEndpoints<-: " + endpoints);
                    return string2;
                }
                catch (Throwable throwable) {
                    Object var7_15 = null;
                    _logger.log(Level.FINE, baseMsg + ".getIIOPEndpoints<-: " + endpoints);
                    throw throwable;
                }
            }
            Object var7_10 = null;
            _logger.log(Level.FINE, baseMsg + ".getIIOPEndpoints<-: " + endpoints);
            return string;
        }
        String i = endpoints;
        Object var7_11 = null;
        _logger.log(Level.FINE, baseMsg + ".getIIOPEndpoints<-: " + endpoints);
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<ClusterInstanceInfo> getClusterInstanceInfo() {
        LinkedList<ClusterInstanceInfo> linkedList;
        LinkedList<ClusterInstanceInfo> result;
        block11: {
            result = new LinkedList<ClusterInstanceInfo>();
            try {
                List<ClusterInstanceInfo> list;
                block10: {
                    try {
                        _logger.log(Level.FINE, baseMsg + ".getClusterForInstanceInfo->:");
                        Cluster[] clusterInfo = ClusterHelper.getClustersInDomain(configCtx);
                        if (clusterInfo.length == 0) {
                            _logger.fine(baseMsg + ".getClusterInstanceInfo->:" + "This is EE. But there is either no cluster or" + " the cluster has only one server instance");
                            list = null;
                            Object var11_9 = null;
                            break block10;
                        }
                        if (serverRefs != null) {
                            for (int i = 0; i < serverRefs.length; ++i) {
                                String serverName = serverRefs[i].getRef();
                                Server server = ServerHelper.getServerByName(configCtx, serverName);
                                List<SocketInfo> listOfSocketInfo = IIOPEndpointsInfo.getSocketInfoForServer(serverRefs[i], listeners[i]);
                                SocketInfo[] arrayOfSocketInfo = new SocketInfo[listOfSocketInfo.size()];
                                int x = 0;
                                for (SocketInfo si : listOfSocketInfo) {
                                    arrayOfSocketInfo[x++] = si;
                                }
                                _logger.fine("server.getLbWeight() = " + server.getLbWeight());
                                ClusterInstanceInfo clusterInstanceInfo = new ClusterInstanceInfo(serverName, Integer.valueOf(server.getLbWeight()), arrayOfSocketInfo);
                                result.add(clusterInstanceInfo);
                                if (!_logger.isLoggable(Level.FINE)) continue;
                                _logger.log(Level.INFO, baseMsg + ".getClusterForInstance: " + ASORBUtilities.toString(clusterInstanceInfo));
                            }
                        }
                        linkedList = result;
                        break block11;
                    }
                    catch (ConfigException e) {
                        _logger.log(Level.FINE, baseMsg + ".getClusterForInstance: " + "ConfigException occurred => " + e);
                        List<ClusterInstanceInfo> list2 = null;
                        Object var11_11 = null;
                        _logger.log(Level.FINE, baseMsg + ".getClusterForInstanceInfo<-: " + result);
                        return list2;
                    }
                    catch (NullPointerException e) {
                        _logger.log(Level.FINE, baseMsg + ".getClusterForInstance: " + "NPE occurred => " + e);
                        List<ClusterInstanceInfo> list3 = null;
                        Object var11_12 = null;
                        _logger.log(Level.FINE, baseMsg + ".getClusterForInstanceInfo<-: " + result);
                        return list3;
                    }
                }
                _logger.log(Level.FINE, baseMsg + ".getClusterForInstanceInfo<-: " + result);
                return list;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                _logger.log(Level.FINE, baseMsg + ".getClusterForInstanceInfo<-: " + result);
                throw throwable;
            }
        }
        Object var11_10 = null;
        _logger.log(Level.FINE, baseMsg + ".getClusterForInstanceInfo<-: " + result);
        return linkedList;
    }

    public static IiopListener[][] getIIOPEndPointsForCurrentCluster() throws ConfigException {
        IiopListener[][] listeners = new IiopListener[serverRefs.length][3];
        for (int i = 0; i < serverRefs.length; ++i) {
            Server server = ServerHelper.getServerByName(configCtx, serverRefs[i].getRef());
            String configRef = server.getConfigRef();
            Config config = ConfigAPIHelper.getConfigByName(configCtx, configRef);
            IiopService iiopService = config.getIiopService();
            listeners[i] = iiopService.getIiopListener();
        }
        return listeners;
    }

    public static String getHostNameForServerInstance(String serverName) {
        try {
            JMXConnectorConfig info = ServerHelper.getJMXConnectorInfo(configCtx, serverName);
            _logger.log(Level.FINE, baseMsg + ".getHostNameForServerInstance: " + "found info: " + info.toString());
            String host = info.getHost();
            _logger.log(Level.FINE, baseMsg + ".getHostNameForServerInstance: " + "found host: " + host);
            return host;
        }
        catch (Throwable e) {
            _logger.log(Level.FINE, baseMsg + ".getHostNameForServerInstance: " + "gotException: " + e + " " + e.getMessage() + "; returning null");
            return null;
        }
    }

    public static String getResolvedPort(IiopListener l, String server) throws ConfigException {
        String rawPort = l.getRawAttributeValue("port");
        PropertyResolver pr = new PropertyResolver(configCtx, server);
        return pr.resolve(rawPort);
    }

    static {
        cluster = null;
        _logger = LogDomains.getLogger("javax.enterprise.resource.corba");
        baseMsg = IIOPEndpointsInfo.class.getName();
        if (ApplicationServer.getServerContext() != null) {
            configCtx = ApplicationServer.getServerContext().getConfigContext();
            String instanceName = ApplicationServer.getServerContext().getInstanceName();
            try {
                cluster = ClusterHelper.getClusterForInstance(configCtx, instanceName);
                serverRefs = cluster.getServerRef();
                listeners = IIOPEndpointsInfo.getIIOPEndPointsForCurrentCluster();
            }
            catch (ConfigException e) {
                _logger.log(Level.FINE, baseMsg + ".<static block>:" + e);
            }
        }
    }
}

