/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics.report.html;

import com.sun.enterprise.diagnostics.Data;
import com.sun.enterprise.diagnostics.Defaults;
import com.sun.enterprise.diagnostics.ReportConfig;
import com.sun.enterprise.diagnostics.ReportTarget;
import com.sun.enterprise.diagnostics.ServiceConfig;
import com.sun.enterprise.diagnostics.TargetType;
import com.sun.enterprise.diagnostics.collect.FileData;
import com.sun.enterprise.diagnostics.report.html.DataTraverser;
import com.sun.enterprise.diagnostics.report.html.Document;
import com.sun.enterprise.diagnostics.report.html.Element;
import com.sun.enterprise.diagnostics.report.html.Escape;
import com.sun.enterprise.diagnostics.report.html.HTMLDocument;
import com.sun.enterprise.diagnostics.report.html.HTMLElement;
import com.sun.enterprise.diagnostics.report.html.Link;
import com.sun.enterprise.diagnostics.report.html.Table;
import com.sun.logging.LogDomains;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HTMLReportTemplate {
    private static final String REPORT_NAME = File.separator + "ReportSummary.html";
    private Table toc;
    private Document doc;
    protected Element bodyElement;
    private Element descElement;
    private int tocNo;
    protected ReportConfig config;
    protected ReportTarget target;
    private String targetName;
    private String reportDir;
    protected DataTraverser dataObjTraverser;
    private static String report_description = "This Snapshot was generated for {0} at {1,time} on {1,date}";
    private static final String description = "Description";
    private static final String customer_information = "Customer Information";
    private static final String bug_ids = "Bug IDs";
    private static String component_details = "{0} details ";
    private static final String checksum_details = "Checksum Information";
    protected static final String monitoring_information = "Monitoring Information";
    private static final String system_information = "System Information";
    private static final String installation_log = "Installation Log";
    private static final String domain_xml_validation_details = "Domain Validation Details";
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.admin");

    public HTMLReportTemplate(ReportConfig config, Data dataObj) {
        this.config = config;
        this.target = config.getTarget();
        this.targetName = this.target.getName();
        this.reportDir = this.target.getIntermediateReportDir();
        this.dataObjTraverser = new DataTraverser(dataObj);
        this.initialize();
    }

    public void write() {
        try {
            String reportFile = this.reportDir + REPORT_NAME;
            File file = new File(reportFile);
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write(this.doc.toString());
            writer.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void addMiscellaneousInfo() {
    }

    private void initialize() {
        this.doc = new HTMLDocument();
        this.bodyElement = this.doc.getBody();
        this.addDocTitle();
        this.addDocHeading();
        this.addTOCSection();
        this.addDescSection();
        this.addCustomerInformation();
        this.addBugIds();
        this.addChecksumSection();
        this.addComponentDetails();
        this.addMiscellaneousInfo();
    }

    private void addDocHeading() {
        HTMLElement h1Element = new HTMLElement("h1");
        h1Element.addAttribute("align", "center");
        h1Element.addText("SJS AS Diagnostic Report Summary");
        this.bodyElement.add(h1Element);
    }

    private void addDocTitle() {
        HTMLElement titleElement = new HTMLElement("title");
        titleElement.addText("SJS AS Diagnostic Report Summary");
        this.doc.getHead().add(titleElement);
    }

    private void addTOCSection() {
        this.toc = new Table();
        this.bodyElement.add(this.toc);
    }

    private void addDescSection() {
        this.addTitle(description, true, true, 0, 0);
        this.descElement = new HTMLElement("desc");
        String description = this.getText(report_description, new Object[]{this.targetName, new Date()});
        this.descElement.addText(description);
        this.addElement(this.descElement);
    }

    private void addCustomerInformation() {
        Iterator<Data> iterator = this.dataObjTraverser.getData("customer info");
        if (iterator.hasNext()) {
            Data dataObj = iterator.next();
            this.addTitle(customer_information, true, true, 0, 0);
            HTMLElement element = new HTMLElement("customer_information");
            if (dataObj instanceof FileData) {
                this.copyFromFile(element, dataObj.getSource());
            }
            element.addText(dataObj.getValues());
            this.addElement(element);
        }
    }

    private void addChecksumSection() {
        Iterator<Data> iterator = this.dataObjTraverser.getData("checksum");
        if (iterator.hasNext()) {
            ArrayList<Link> elements = new ArrayList<Link>();
            Link link = new Link(checksum_details, "#" + this.getNextTocNo());
            elements.add(link);
            this.toc.addRow(elements, null);
            Link bodyLink = new Link(null, null, this.getTocNo());
            this.bodyElement.add(bodyLink);
        }
        while (iterator.hasNext()) {
            Data checksumData = iterator.next();
            Iterator<Iterator<String>> details = checksumData.getTable();
            Table table = new Table(1, 0);
            HTMLElement h2 = new HTMLElement("h2");
            h2.addText(checksumData.getSource() + " " + checksum_details);
            this.bodyElement.add(h2);
            table.addRow(details.next(), true, null);
            while (details.hasNext()) {
                table.addRow(details.next(), false, null);
            }
            this.bodyElement.add(table);
        }
    }

    private void addBugIds() {
        if (this.config.getCLIOptions().getBugIds() != null && this.config.getCLIOptions().getBugIds().trim().length() > 0) {
            this.addTitle(bug_ids, true, true, 0, 0);
            HTMLElement bugIdElement = new HTMLElement(bug_ids);
            bugIdElement.addText(this.config.getCLIOptions().getBugIds());
            this.addElement(bugIdElement);
        }
    }

    private void addComponentDetails() {
        String componentDetailsTitle = this.getText(component_details, new Object[]{this.target.getName()});
        this.addTitle(componentDetailsTitle, true, true, 0, 0);
        HTMLElement element = new HTMLElement("component_details");
        this.addInstanceSpecificSection(element);
        this.addElement(element);
    }

    protected void addInstanceSpecificSection(Element element) {
        if (element != null) {
            Iterator<ServiceConfig> configurations = this.config.getInstanceConfigurations();
            while (configurations.hasNext()) {
                ServiceConfig config = configurations.next();
                String instanceName = config.getInstanceName();
                int indentation = 1;
                String linkPrefix = "." + File.separator;
                String instanceFolder = this.reportDir;
                if (!instanceName.equals(TargetType.DAS.getType())) {
                    linkPrefix = instanceName + File.separator;
                    instanceFolder = instanceFolder + File.separator + instanceName;
                    this.addLink(element, instanceName, instanceName, indentation++);
                }
                this.addLink(element, "config", linkPrefix + "config", indentation);
                if (this.exists(instanceFolder, "generated")) {
                    this.addLink(element, "generated", linkPrefix + "generated", indentation);
                }
                if (this.exists(instanceFolder, "applications")) {
                    this.addLink(element, "applications", linkPrefix + "applications", indentation);
                }
                if (this.exists(instanceFolder, "logs")) {
                    this.addLink(element, "logs", linkPrefix + "logs", indentation);
                }
                if (this.exists(instanceFolder, Defaults.DOMAIN_XML_VERIFICATION_OUTPUT)) {
                    this.addLink(element, domain_xml_validation_details, linkPrefix + Defaults.DOMAIN_XML_VERIFICATION_OUTPUT, indentation);
                }
                this.addInstallationLogSection(config.isCaptureInstallLogEnabled(), element, indentation);
                this.addLink(config.isCaptureSystemInfoEnabled(), element, "system Info", system_information, indentation);
                this.addMonitoringInfo(element, instanceName, indentation);
            }
        }
    }

    protected void addMonitoringInfo(Element element, String instanceName, int indentation) {
        if (!this.config.getCLIOptions().isLocal()) {
            this.addLink(element, monitoring_information, instanceName + File.separator + "MonitoringInformation", indentation);
        }
    }

    private void addInstallationLogSection(boolean enabled, Element element, int indentation) {
        ArrayList<String> files = new ArrayList<String>(2);
        if (enabled) {
            String[] logFiles = new File(this.target.getIntermediateReportDir()).list(new FilenameFilter(){

                public boolean accept(File folder, String name) {
                    return name.contains("Install_Application_Server") || name.contains("Sun_Java_System_Application_Server");
                }
            });
            files.addAll(Arrays.asList(logFiles));
        }
        for (String fileName : files) {
            this.addLink(element, fileName, fileName, indentation);
        }
    }

    private void addLink(boolean enabled, Element element, String dataType, String text, int indentation) {
        if (enabled) {
            Iterator<Data> iterator = this.dataObjTraverser.getData(dataType);
            while (iterator.hasNext()) {
                Data data = iterator.next();
                this.addLink(element, text, data.getSource(), indentation);
            }
        }
    }

    protected boolean exists(String parent, String folder) {
        File file = new File(parent + File.separator + folder);
        return file.exists();
    }

    protected void addTitle(String title, boolean add2TOC, boolean showTitleInBody, int titleIndent, int textIndent) {
        String tocTitle = this.indentText("", titleIndent);
        if (add2TOC) {
            ArrayList<HTMLElement> elements = new ArrayList<HTMLElement>();
            HTMLElement p = new HTMLElement("p");
            p.addText(tocTitle);
            Link link = new Link(title, "#" + this.getNextTocNo());
            p.add(link);
            elements.add(p);
            this.toc.addRow(elements, null);
        }
        Link bodyLink = new Link(null, null, this.getTocNo());
        this.bodyElement.add(bodyLink);
        if (showTitleInBody) {
            HTMLElement h2 = new HTMLElement("h2");
            h2.addText(title);
            this.bodyElement.add(h2);
        }
    }

    protected void addElement(Element element) {
        this.bodyElement.add(element);
        this.bodyElement.add(new HTMLElement("br"));
    }

    protected void addLink(Element element, String text, String link, int textIndent) {
        String indentation = this.indentText("", textIndent);
        if (text != null) {
            if (link == null) {
                link = "#";
            }
            Link detail = new Link(text, link);
            HTMLElement span = new HTMLElement("span");
            span.addText(indentation);
            span.add(detail);
            element.add(span);
            element.add(new HTMLElement("br"));
        }
    }

    protected String getNextTocNo() {
        return String.valueOf(++this.tocNo);
    }

    protected String getTocNo() {
        return String.valueOf(this.tocNo);
    }

    private String indentText(String text, int indentIndex) {
        String indentedText = text;
        for (int i = 1; i <= indentIndex; ++i) {
            indentedText = Escape.getInstance().decodeEntities("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;") + indentedText;
        }
        return indentedText;
    }

    private String getText(String str, Object[] args) {
        MessageFormat form = new MessageFormat(str);
        return MessageFormat.format(str, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFromFile(Element element, String fileName) {
        if (element != null && fileName != null) {
            logger.log(Level.FINE, "fileName : " + fileName);
            BufferedReader reader = null;
            try {
                String entry;
                reader = new BufferedReader(new FileReader(fileName));
                while ((entry = reader.readLine()) != null) {
                    logger.log(Level.FINE, "entry : " + entry);
                    element.addText(entry);
                    element.add(new HTMLElement("br"));
                }
                reader.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "diagnostic-service.copy_failed", new Object[]{fileName, e.getMessage()});
            }
        }
    }
}

