/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics;

import com.sun.enterprise.diagnostics.DiagnosticException;
import com.sun.enterprise.diagnostics.ServiceConfigHelper;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServiceConfig {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.admin");
    private String logFile;
    private int minLogLevel;
    private int maxNoOfEntries;
    private String repositoryDir;
    private String instanceName;
    private boolean local;
    private boolean captureSystemInfoEnabled;
    private boolean captureChecksumEnabled = true;
    private boolean captureAppDDEnabled = true;
    private boolean captureInstallLogEnabled = true;
    private boolean verifyDomainEnabled = true;
    private boolean captureHadbInfoEnabled;
    private ServiceConfigHelper configHelper;

    public ServiceConfig(boolean localFlag, String repositoryDir, String instanceName) throws DiagnosticException {
        this.local = localFlag;
        this.repositoryDir = repositoryDir;
        this.instanceName = instanceName;
        this.setValues();
    }

    public ServiceConfig(boolean captureChecksumEnabled, boolean captureAppDDEnabled, boolean captureInstallLogEnabled, boolean verifyDomainEnabled, boolean captureHadbInfoEnabled, boolean captureSystemInfoEnabled, int minLogLevel, int maxNoOfEntries, String logFile, String repositoryDir, String instanceName) {
        this.captureChecksumEnabled = captureChecksumEnabled;
        this.captureAppDDEnabled = captureAppDDEnabled;
        this.captureInstallLogEnabled = captureInstallLogEnabled;
        this.verifyDomainEnabled = verifyDomainEnabled;
        this.captureHadbInfoEnabled = captureHadbInfoEnabled;
        this.captureSystemInfoEnabled = captureSystemInfoEnabled;
        this.minLogLevel = minLogLevel;
        this.maxNoOfEntries = maxNoOfEntries;
        this.logFile = logFile;
        this.instanceName = instanceName;
        this.repositoryDir = repositoryDir;
    }

    public int getMaxNoOfEntries() {
        return this.maxNoOfEntries;
    }

    public int getMinLogLevel() {
        return this.minLogLevel;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public String getRepositoryDir() {
        return this.repositoryDir;
    }

    public boolean isCaptureAppDDEnabled() {
        return this.captureAppDDEnabled;
    }

    public boolean isCaptureInstallLogEnabled() {
        return this.captureInstallLogEnabled;
    }

    public boolean isVerifyDomainEnabled() {
        return this.verifyDomainEnabled;
    }

    public boolean isCaptureChecksumEnabled() {
        return this.captureChecksumEnabled;
    }

    public boolean isCaptureHadbInfoEnabled() {
        return this.captureHadbInfoEnabled;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public boolean isCaptureSystemInfoEnabled() {
        return this.captureSystemInfoEnabled;
    }

    public String getConfigName() {
        if (this.configHelper != null) {
            return this.configHelper.getConfigName();
        }
        return null;
    }

    public void debug() {
        logger.log(Level.FINEST, "diagnostic-service.capture_app_dd ", new Object[]{this.captureAppDDEnabled});
        logger.log(Level.FINEST, "diagnostic-service.capture_hadb_info", new Object[]{this.captureHadbInfoEnabled});
        logger.log(Level.FINEST, "diagnostic-service.capture_checksum", new Object[]{this.captureChecksumEnabled});
        logger.log(Level.FINEST, "diagnostic-service.capture_install_log", new Object[]{this.captureInstallLogEnabled});
        logger.log(Level.FINEST, "diagnostic-service.min_log_level", new Object[]{this.minLogLevel});
        logger.log(Level.FINEST, "diagnostic-service.max_log_entries", new Object[]{this.maxNoOfEntries});
    }

    public String toString() {
        return this.getInstanceName() + "," + this.getConfigName() + "," + this.getMaxNoOfEntries() + "," + this.getMinLogLevel() + "," + this.getLogFile() + "," + this.getRepositoryDir() + "," + this.isCaptureAppDDEnabled() + "," + this.isCaptureChecksumEnabled() + "," + this.isCaptureHadbInfoEnabled() + "," + this.isCaptureInstallLogEnabled() + "," + this.isVerifyDomainEnabled();
    }

    private void setValues() throws DiagnosticException {
        this.configHelper = new ServiceConfigHelper(this.repositoryDir, this.instanceName, this.local);
        this.minLogLevel = Level.parse(this.getAttribute("min-log-level")).intValue();
        this.logFile = this.getAttribute("file");
        this.maxNoOfEntries = Integer.parseInt(this.getAttribute("max-log-entries"));
        this.captureAppDDEnabled = this.getBooleanAttribute("capture-app-dd");
        this.captureInstallLogEnabled = this.getBooleanAttribute("capture-install-log");
        this.verifyDomainEnabled = this.getBooleanAttribute("verify-config");
        this.captureHadbInfoEnabled = this.getBooleanAttribute("capture-hadb-info");
        this.captureChecksumEnabled = this.getBooleanAttribute("compute-checksum");
        this.captureSystemInfoEnabled = this.getBooleanAttribute("capture-system-info");
    }

    private String getAttribute(String attribute) throws DiagnosticException {
        return this.configHelper.getAttribute(attribute);
    }

    private boolean getBooleanAttribute(String attrName) throws DiagnosticException {
        return Boolean.valueOf(this.getAttribute(attrName));
    }
}

