/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.phasing;

import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.common.exception.DeploymentException;
import com.sun.enterprise.admin.common.exception.ServerInstanceException;
import com.sun.enterprise.admin.server.core.AdminNotificationHelper;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.admin.server.core.DeploymentNotificationHelper;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.admin.util.HostAndPort;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigBeansFactory;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.AppclientModule;
import com.sun.enterprise.config.serverbeans.ApplicationHelper;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigAPIHelper;
import com.sun.enterprise.config.serverbeans.ConnectorModule;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.EjbModule;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.LifecycleModule;
import com.sun.enterprise.config.serverbeans.PropertyResolver;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.backend.AppDD;
import com.sun.enterprise.deployment.backend.ClientJarMakerRegistry;
import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.DeploymentRequestRegistry;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.phasing.DeploymentContext;
import com.sun.enterprise.deployment.phasing.DeploymentTarget;
import com.sun.enterprise.deployment.phasing.DeploymentTargetFactory;
import com.sun.enterprise.deployment.phasing.PEDeploymentService;
import com.sun.enterprise.deployment.util.DeploymentProperties;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.instance.AppclientModulesManager;
import com.sun.enterprise.instance.AppsManager;
import com.sun.enterprise.instance.BaseManager;
import com.sun.enterprise.instance.ConnectorModulesManager;
import com.sun.enterprise.instance.EjbModulesManager;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.WebModulesManager;
import com.sun.enterprise.resource.Resource;
import com.sun.enterprise.resource.ResourceUtilities;
import com.sun.enterprise.resource.ResourcesXMLParser;
import com.sun.enterprise.resource.SunResourcesXML;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.RelativePathResolver;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.enterprise.deploy.shared.ModuleType;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentServiceUtils {
    public static final Logger sLogger = DeploymentLogger.get();
    private static StringManager localStrings = StringManager.getManager(DeploymentServiceUtils.class);
    private static final Object[] emptyParams = new Object[0];
    private static final String[] emptySignature = new String[0];
    private static final String SYSTEM_PREFIX = "system-";
    private static final String PORT = "port";
    private static final String DEF_VS = "default-virtual-server";
    private static final String SERVER_NAME = "server-name";
    private static final String REDIRECT_PORT = "redirect-port";
    private static final String SEC_ENABLED = "security-enabled";
    private static final String LISTENER_ENABLED = "enabled";
    private static final String OBJECT_TYPE = "object-type";
    private static final String EXTERNALLY_MANAGED = "externally-managed";
    private static final String DIRECTORY_DEPLOYED_ATTR = "DirectoryDeployed";
    private static final String HOSTS = "hosts";
    private static final String HTTP_LISTENERS = "http_listeners";
    private static final String DEFAULT_WEB_MODULE = "default_web_module";
    private static final String STATE = "state";
    private static final String ID = "id";
    private static final String SUN_RESOURCE_XML = "sun-resources.xml";
    private static final String SUN_RESOURCE_XML_PATH = "META-INF" + File.separator + "sun-resources.xml";
    private static final String LIST_ADMIN_OBJECTS = "getAdminObjectResource";
    private static final String LIST_CONNECTOR_CONNECTION_POOLS = "getConnectorConnectionPool";
    private static final String LIST_RESOURCE_ADAPTER_CONFIGS = "getResourceAdapterConfig";
    private static final DeployableObjectType[] deployableObjectTypes = new DeployableObjectType[]{DeployableObjectType.APP, DeployableObjectType.EJB, DeployableObjectType.WEB, DeployableObjectType.CONN, DeployableObjectType.CAR, DeployableObjectType.LCM, DeployableObjectType.CMB};
    private static String[] httpListenerAttrNames = new String[]{"enabled", "default-virtual-server", "server-name", "redirect-port", "port", "security-enabled", "id"};
    private static String[] vsAttrNames = new String[]{"hosts", "http_listeners", "default_web_module", "state", "id"};

    public static String getClientJarPath(String moduleID) {
        ClientJarMakerRegistry registry = ClientJarMakerRegistry.getInstance();
        if (registry.isRegistered(moduleID)) {
            registry.waitForCompletion(moduleID);
        }
        return moduleID + "Client.jar";
    }

    static boolean multicastEvent(int eventType, String entityName, String targetName) throws IASDeploymentException {
        return DeploymentServiceUtils.multicastEvent(eventType, entityName, null, targetName);
    }

    static boolean multicastEvent(int eventType, String entityName, String moduleType, String targetName) throws IASDeploymentException {
        return DeploymentServiceUtils.multicastEvent(eventType, entityName, moduleType, false, targetName);
    }

    static boolean multicastEvent(int eventType, String entityName, String moduleType, boolean cascade, String targetName) throws IASDeploymentException {
        return DeploymentServiceUtils.multicastEvent(eventType, entityName, moduleType, cascade, false, targetName);
    }

    static boolean multicastEvent(int eventType, String entityName, String moduleType, boolean cascade, boolean forceDeploy, String targetName) throws IASDeploymentException {
        return DeploymentServiceUtils.multicastEvent(eventType, entityName, moduleType, cascade, forceDeploy, 0, targetName);
    }

    public static boolean multicastEvent(int eventType, String entityName, String moduleType, boolean cascade, boolean forceDeploy, int loadUnloadAction, String targetName) throws IASDeploymentException {
        try {
            ConfigContext config = DeploymentServiceUtils.getConfigContext();
            if (config != null && config.isChanged()) {
                config.flush();
            }
        }
        catch (ConfigException ce) {
            throw new IASDeploymentException(ce);
        }
        try {
            return DeploymentNotificationHelper.multicastEvent(eventType, entityName, moduleType, cascade, forceDeploy, loadUnloadAction, targetName);
        }
        catch (Throwable t) {
            IASDeploymentException iasEx = new IASDeploymentException(t.getMessage());
            iasEx.initCause(t);
            throw iasEx;
        }
    }

    protected static void flushConfigAndSendEvents() throws Exception {
        AdminContext adminContext = AdminService.getAdminService().getAdminContext();
        ConfigContext ctx = adminContext.getAdminConfigContext();
        if (ctx.isChanged()) {
            ctx.flush();
        }
        new AdminNotificationHelper(adminContext).sendNotification();
    }

    public static String getModuleTypeString(DeployableObjectType moduleType) {
        String moduleTypeString = null;
        if (moduleType.equals(DeployableObjectType.EJB)) {
            moduleTypeString = "ejb";
        } else if (moduleType.equals(DeployableObjectType.WEB)) {
            moduleTypeString = "web";
        } else if (moduleType.equals(DeployableObjectType.CONN)) {
            moduleTypeString = "connector";
        } else if (moduleType.equals(DeployableObjectType.CAR)) {
            moduleTypeString = "appclient";
        }
        return moduleTypeString;
    }

    public static BaseManager getInstanceManager(DeployableObjectType moduleType) {
        try {
            InstanceEnvironment insEnv = new InstanceEnvironment(DeploymentServiceUtils.getInstanceName());
            if (moduleType.equals(DeployableObjectType.APP)) {
                return new AppsManager(insEnv);
            }
            if (moduleType.equals(DeployableObjectType.EJB)) {
                return new EjbModulesManager(insEnv);
            }
            if (moduleType.equals(DeployableObjectType.WEB)) {
                return new WebModulesManager(insEnv);
            }
            if (moduleType.equals(DeployableObjectType.CONN)) {
                return new ConnectorModulesManager(insEnv);
            }
            if (moduleType.equals(DeployableObjectType.CAR)) {
                return new AppclientModulesManager(insEnv);
            }
            return null;
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    public static String[] getContextRootsForEmbeddedWebApp(String appName) throws IASDeploymentException {
        try {
            AppsManager appsManager = new AppsManager(new InstanceEnvironment(DeploymentServiceUtils.getInstanceName()));
            Application application = appsManager.getRegisteredDescriptor(appName);
            if (application != null) {
                ArrayList<String> contextRoots = new ArrayList<String>();
                for (WebBundleDescriptor wbd : application.getWebBundleDescriptors()) {
                    contextRoots.add(wbd.getContextRoot());
                }
                return contextRoots.toArray(new String[contextRoots.size()]);
            }
            String xmlDir = appsManager.getGeneratedXMLLocation(appName);
            if (!FileUtils.safeIsDirectory(xmlDir)) {
                String appDir = appsManager.getLocation(appName);
                sLogger.log(Level.WARNING, "deployment.no_xmldir", new Object[]{xmlDir, appDir});
                xmlDir = appDir;
            }
            AppDD appDD = new AppDD(new File(xmlDir));
            return appDD.getContextRoots();
        }
        catch (Exception e) {
            if (e instanceof IASDeploymentException) {
                throw (IASDeploymentException)e;
            }
            throw new IASDeploymentException(e);
        }
    }

    public static List<String> getTargetNamesFromTargetString(String targetString) {
        if (targetString == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(targetString);
        ArrayList<String> targetNames = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            targetNames.add(st.nextToken());
        }
        return targetNames;
    }

    public static void setResourceOptionsInRequest(DeploymentRequest req, DeploymentProperties props) {
        req.setResourceAction(props.getResourceAction());
        req.setResourceTargetList(props.getResourceTargetList());
    }

    public static FilenameFilter getFilenameFilter(final String fileName) {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (new File(dir, name).isDirectory()) {
                    return true;
                }
                return name != null && name.equals(fileName);
            }
        };
        return filter;
    }

    private static List<Resource> getResourcesFromResourcesXML(String appId, DeployableObjectType moduleType, DeploymentContext deploymentCtx) throws Exception {
        String directoryToLook = DeploymentServiceUtils.getInstanceManager(moduleType).getGeneratedXMLLocation(appId);
        Set listOfFiles = FileUtil.getAllFilesUnder(new File(directoryToLook), DeploymentServiceUtils.getFilenameFilter(SUN_RESOURCE_XML), true);
        ArrayList<String> expectedXMLPaths = new ArrayList<String>();
        Application app = DeploymentServiceUtils.getInstanceManager(moduleType).getRegisteredDescriptor(appId);
        if (app == null && deploymentCtx != null) {
            app = deploymentCtx.getApplication(appId);
        }
        if (app != null) {
            if (app.isVirtual()) {
                expectedXMLPaths.add(SUN_RESOURCE_XML_PATH);
            } else {
                expectedXMLPaths.add(SUN_RESOURCE_XML_PATH);
                Iterator itr = app.getModules();
                while (itr.hasNext()) {
                    ModuleDescriptor aModule = (ModuleDescriptor)itr.next();
                    String moduleUri = FileUtils.makeFriendlyFileName(aModule.getArchiveUri());
                    String subModulePath = moduleUri + File.separator + SUN_RESOURCE_XML_PATH;
                    expectedXMLPaths.add(subModulePath);
                }
            }
        } else {
            expectedXMLPaths.add(SUN_RESOURCE_XML_PATH);
        }
        ArrayList<SunResourcesXML> resourcesXMLList = new ArrayList<SunResourcesXML>();
        for (File file : listOfFiles) {
            String filePath = file.getPath();
            String xmlFilePath = new File(directoryToLook, filePath).getAbsolutePath();
            if (expectedXMLPaths.contains(filePath)) {
                ResourcesXMLParser allResources = new ResourcesXMLParser(xmlFilePath);
                SunResourcesXML sunResourcesXML = new SunResourcesXML(filePath, allResources.getResourcesList());
                resourcesXMLList.add(sunResourcesXML);
                continue;
            }
            sLogger.log(Level.WARNING, "enterprise.deployment.ignore.sun.resources.xml", xmlFilePath);
        }
        return DeploymentServiceUtils.processResourcesList(resourcesXMLList);
    }

    private static List<Resource> processResourcesList(List<SunResourcesXML> resourcesXMLList) throws Exception {
        Set<Resource> resolvedResourcesWithinArchive = ResourceUtilities.resolveResourceDuplicatesConflictsWithinArchive(resourcesXMLList);
        ArrayList<Resource> allResources = new ArrayList<Resource>();
        for (Resource res : resolvedResourcesWithinArchive) {
            allResources.add(res);
        }
        return allResources;
    }

    public static String getLocation(File appDir) {
        if (appDir != null) {
            return RelativePathResolver.unresolvePath(appDir.getAbsolutePath(), new String[]{"com.sun.aas.instanceRoot", "com.sun.aas.installRoot"});
        }
        return null;
    }

    private static Applications getAppsConfigBean() throws ConfigException {
        ConfigContext configContext = DeploymentServiceUtils.getConfigContext();
        Domain domainConfig = ConfigAPIHelper.getDomainConfigBean(configContext);
        Applications appsConfig = domainConfig.getApplications();
        return appsConfig;
    }

    public static String getLocation(String appId, DeployableObjectType type) throws IASDeploymentException {
        try {
            ConfigBean module = DeploymentServiceUtils.getModule(appId, type);
            String location = module.getAttributeValue("location");
            return new RelativePathResolver().resolve(location);
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    public static boolean isEnabled(String appId, DeployableObjectType type) throws IASDeploymentException {
        try {
            ConfigBean module = DeploymentServiceUtils.getModule(appId, type);
            String enabled = module.getAttributeValue(LISTENER_ENABLED);
            return Boolean.valueOf(enabled);
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    public static boolean isDirectoryDeployed(String appId, DeployableObjectType type) throws IASDeploymentException {
        try {
            String[] attributeNames;
            ConfigBean module = DeploymentServiceUtils.getModule(appId, type);
            for (String attributeName : attributeNames = module.getAttributeNames()) {
                if (!attributeName.equals(DIRECTORY_DEPLOYED_ATTR)) continue;
                String directoryDeployed = module.getAttributeValue(DIRECTORY_DEPLOYED_ATTR);
                return Boolean.valueOf(directoryDeployed);
            }
            return false;
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    public static String getObjectType(String appId, DeployableObjectType type) throws IASDeploymentException {
        try {
            if (type.isCAR()) {
                return null;
            }
            ConfigBean module = DeploymentServiceUtils.getModule(appId, type);
            String objectType = module.getAttributeValue(OBJECT_TYPE);
            return objectType;
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    public static void setContextRoot(String appId, DeployableObjectType type, String contextRoot) throws IASDeploymentException {
        try {
            if (contextRoot != null && contextRoot.length() > 0) {
                ConfigBean module = DeploymentServiceUtils.getModule(appId, type);
                module.setAttributeValue("context-root", contextRoot);
            }
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    public static boolean isSystem(String appId, DeployableObjectType type) throws IASDeploymentException {
        String objectType = DeploymentServiceUtils.getObjectType(appId, type);
        if (objectType != null) {
            return objectType.startsWith(SYSTEM_PREFIX);
        }
        return false;
    }

    private static AttributeList populateAttributeList(DeploymentRequest request) throws IASDeploymentException {
        Properties optionalAttributes;
        String dirDeployed;
        String availEnabled;
        String contextRoot;
        String libraries;
        String jwsEnabled;
        String enabled;
        String description;
        String location;
        AttributeList attrList = new AttributeList();
        String name = request.getName();
        if (name != null && name.length() > 0) {
            Attribute nameAttr = new Attribute("name", name);
            attrList.add(nameAttr);
        }
        if ((location = DeploymentServiceUtils.getLocation(request.getDeployedDirectory())) != null && location.length() > 0) {
            Attribute locationAttr = new Attribute("location", location);
            attrList.add(locationAttr);
        }
        if ((description = request.getDescription()) != null && description.length() > 0) {
            Attribute descriptionAttr = new Attribute("description", description);
            attrList.add(descriptionAttr);
        }
        if (!request.getType().isCAR() && (enabled = String.valueOf(request.isStartOnDeploy())) != null && enabled.length() > 0) {
            Attribute enableAttr = new Attribute(LISTENER_ENABLED, enabled);
            attrList.add(enableAttr);
        }
        if ((request.getType().isAPP() || request.getType().isCAR()) && (jwsEnabled = String.valueOf(request.isJavaWebStartEnabled())) != null && jwsEnabled.length() > 0) {
            Attribute jwsEnableAttr = new Attribute("java-web-start-enabled", jwsEnabled);
            attrList.add(jwsEnableAttr);
        }
        if ((request.getType().isAPP() || request.getType().isEJB() || request.getType().isWEB()) && (libraries = request.getLibraries()) != null && libraries.length() > 0) {
            Attribute librariesAttr = new Attribute("libraries", libraries);
            attrList.add(librariesAttr);
        }
        if (request.getType().isWEB() && (contextRoot = request.getContextRoot()) != null && contextRoot.length() > 0) {
            Attribute contextRootAttr = new Attribute("context-root", contextRoot);
            attrList.add(contextRootAttr);
        }
        if (!request.getType().isCAR() && !request.getType().isCONN() && (availEnabled = String.valueOf(request.isAvailabilityEnabled())) != null && availEnabled.length() > 0) {
            Attribute availEnabledAttr = new Attribute("availability-enabled", availEnabled);
            attrList.add(availEnabledAttr);
        }
        if ((dirDeployed = String.valueOf(request.isDirectory())) != null && dirDeployed.length() > 0) {
            Attribute dirDeployedAttr = new Attribute("directory-deployed", dirDeployed);
            attrList.add(dirDeployedAttr);
        }
        if ((optionalAttributes = request.getOptionalAttributes()) != null) {
            Properties mProps = (Properties)optionalAttributes.clone();
            try {
                mProps.remove("virtual-servers");
            }
            catch (Exception re) {
                // empty catch block
            }
            Enumeration<Object> tags = mProps.keys();
            while (tags.hasMoreElements()) {
                String tag = (String)tags.nextElement();
                String value = mProps.getProperty(tag);
                if (tag == null || tag.length() <= 0 || value == null || value.length() <= 0) continue;
                Attribute optionalAttr = new Attribute(tag, value);
                attrList.add(optionalAttr);
            }
        }
        return attrList;
    }

    public static void addToConfig(DeploymentRequest request) throws IASDeploymentException {
        try {
            ConfigBean newApp = DeploymentServiceUtils.createNewModule(request.getType());
            DeployableObjectType type = request.getType();
            AttributeList attrList = DeploymentServiceUtils.populateAttributeList(request);
            for (Object obj : attrList) {
                Attribute attr = (Attribute)obj;
                newApp.setAttributeValue(attr.getName(), (String)attr.getValue());
            }
            DeploymentServiceUtils.setPropertyOnAppBean(newApp, request);
            DeploymentServiceUtils.addModule(request.getType(), newApp);
            DeploymentServiceUtils.getConfigContext().resetConfigChangeList();
        }
        catch (Exception e) {
            if (e instanceof IASDeploymentException) {
                throw (IASDeploymentException)e;
            }
            throw new IASDeploymentException(e);
        }
    }

    public static void updateConfig(DeploymentRequest request) throws IASDeploymentException {
        try {
            String name = request.getName();
            ConfigBean appBean = ApplicationHelper.findApplication(DeploymentServiceUtils.getConfigContext(), name);
            if (appBean != null) {
                for (Attribute attr : DeploymentServiceUtils.populateAttributeList(request)) {
                    appBean.setAttributeValue(attr.getName(), (String)attr.getValue());
                }
                DeploymentServiceUtils.setPropertyOnAppBean(appBean, request);
                DeploymentServiceUtils.getConfigContext().flush();
                DeploymentServiceUtils.getConfigContext().resetConfigChangeList();
            }
        }
        catch (Exception e) {
            if (e instanceof IASDeploymentException) {
                throw (IASDeploymentException)e;
            }
            throw new IASDeploymentException(e);
        }
    }

    public static void removeFromConfig(String name, DeployableObjectType type) throws IASDeploymentException {
        try {
            ConfigBean module = DeploymentServiceUtils.getModule(name, type);
            if (module != null) {
                DeploymentServiceUtils.removeModule(type, module);
                DeploymentServiceUtils.getConfigContext().flush();
                DeploymentServiceUtils.getConfigContext().resetConfigChangeList();
            }
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    public static void setPropertyOnAppBean(ConfigBean appBean, DeploymentRequest request) throws ConfigException {
        if (request.isExternallyManagedApp()) {
            ElementProperty extManagedProperty = new ElementProperty();
            extManagedProperty.setName(EXTERNALLY_MANAGED);
            extManagedProperty.setValue("true");
            if (appBean instanceof J2eeApplication) {
                J2eeApplication app = (J2eeApplication)appBean;
                app.addElementProperty(extManagedProperty);
            } else if (appBean instanceof EjbModule) {
                EjbModule app = (EjbModule)appBean;
                app.addElementProperty(extManagedProperty);
            } else if (appBean instanceof WebModule) {
                WebModule app = (WebModule)appBean;
                app.addElementProperty(extManagedProperty);
            } else if (appBean instanceof AppclientModule) {
                AppclientModule app = (AppclientModule)appBean;
                app.addElementProperty(extManagedProperty);
            } else if (appBean instanceof ConnectorModule) {
                ConnectorModule app = (ConnectorModule)appBean;
                app.addElementProperty(extManagedProperty);
            }
        }
    }

    public static boolean isExternallyManagedApp(String appName, DeployableObjectType type) throws IASDeploymentException {
        try {
            ConfigBean appBean = DeploymentServiceUtils.getModule(appName, type);
            if (appBean != null) {
                ElementProperty extManagedProperty = null;
                if (appBean instanceof J2eeApplication) {
                    J2eeApplication app = (J2eeApplication)appBean;
                    extManagedProperty = app.getElementPropertyByName(EXTERNALLY_MANAGED);
                } else if (appBean instanceof EjbModule) {
                    EjbModule app = (EjbModule)appBean;
                    extManagedProperty = app.getElementPropertyByName(EXTERNALLY_MANAGED);
                } else if (appBean instanceof WebModule) {
                    WebModule app = (WebModule)appBean;
                    extManagedProperty = app.getElementPropertyByName(EXTERNALLY_MANAGED);
                } else if (appBean instanceof AppclientModule) {
                    AppclientModule app = (AppclientModule)appBean;
                    extManagedProperty = app.getElementPropertyByName(EXTERNALLY_MANAGED);
                } else if (appBean instanceof ConnectorModule) {
                    ConnectorModule app = (ConnectorModule)appBean;
                    extManagedProperty = app.getElementPropertyByName(EXTERNALLY_MANAGED);
                }
                if (extManagedProperty != null) {
                    return Boolean.valueOf(extManagedProperty.getValue());
                }
                return false;
            }
            return false;
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    public static boolean isRegistered(String appName, DeployableObjectType type) throws IASDeploymentException {
        try {
            ConfigBean module = DeploymentServiceUtils.getModule(appName, type);
            return module != null;
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    public static ConfigContext getConfigContext() {
        try {
            AdminService adminService = AdminService.getAdminService();
            if (adminService != null) {
                ConfigContext config = adminService.getAdminContext().getAdminConfigContext();
                return config;
            }
            return null;
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    public static String getInstanceName() {
        return ApplicationServer.getServerContext().getInstanceName();
    }

    public static String getDomainName() throws IASDeploymentException {
        try {
            AdminService adminService = AdminService.getAdminService();
            if (adminService != null) {
                String domainName = adminService.getAdminContext().getDomainName();
                return domainName;
            }
            return null;
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    public static void validate(String appID, DeployableObjectType type, String action, DeploymentRequest request) throws IASDeploymentException {
        String dependentResource;
        boolean allowSystemAppModification = Boolean.valueOf(System.getProperty("com.sun.aas.deployment.AllowSysAppDeployment", "false"));
        if (!allowSystemAppModification && DeploymentServiceUtils.isSystem(appID, type)) {
            String msg = localStrings.getString("enterprise.deployment.phasing.component_is_system", new Object[]{action, appID});
            throw new IASDeploymentException(msg);
        }
        boolean isExternallyManagedPath = request.isExternallyManagedPath();
        if (!isExternallyManagedPath && DeploymentServiceUtils.isExternallyManagedApp(appID, type)) {
            String msg = localStrings.getString("enterprise.deployment.phasing.component_is_externally_managed", new Object[]{action, appID});
            throw new IASDeploymentException(msg);
        }
        String resAction = request.getResourceAction();
        if (action.equals(PEDeploymentService.STOP_ACTION) && resAction != null && resAction.equals("resUndeployment") && (dependentResource = DeploymentServiceUtils.checkConnectorDependentResourcesForUndeploy(request)) != null) {
            String msg = localStrings.getString("enterprise.deployment.phasing.stop.dependentresexist", new Object[]{dependentResource, request.getName()});
            throw new IASDeploymentException(msg);
        }
    }

    public static boolean containsResourceAdapter(DeploymentRequest req) {
        boolean containsRar = false;
        if (!req.isApplication()) {
            if (req.isConnectorModule()) {
                containsRar = true;
            }
        } else {
            Application app = DeploymentServiceUtils.getInstanceManager(DeployableObjectType.APP).getRegisteredDescriptor(req.getName());
            if (app != null && app.getRarComponentCount() != 0) {
                containsRar = true;
            }
        }
        return containsRar;
    }

    public static String checkConnectorDependentResourcesForUndeploy(DeploymentRequest req) {
        try {
            if (req.getCascade() || !DeploymentServiceUtils.containsResourceAdapter(req)) {
                return null;
            }
            List<Resource> resourceList = DeploymentServiceUtils.getResourceList(req, false, null);
            if (resourceList == null || resourceList.size() == 0) {
                return DeploymentServiceUtils.checkConnectorDependentResources(req);
            }
            return null;
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    private static String checkConnectorDependentResources(DeploymentRequest req) throws Exception {
        String id = req.getName();
        MBeanServer mbs = MBeanServerFactory.getMBeanServer();
        ObjectName mbeanName = new ObjectName("com.sun.appserv:type=resources,category=config");
        Object[] params = new Object[]{};
        String[] signature = new String[]{};
        ObjectName[] adminObjs = (ObjectName[])mbs.invoke(mbeanName, LIST_ADMIN_OBJECTS, params, signature);
        for (int i = 0; i < adminObjs.length; ++i) {
            String raName = (String)mbs.getAttribute(adminObjs[i], "res_adapter");
            if (!id.equals(raName)) continue;
            String adminObjName = (String)mbs.getAttribute(adminObjs[i], "jndi_name");
            return "admin object [" + adminObjName + "]";
        }
        ObjectName[] poolNames = (ObjectName[])mbs.invoke(mbeanName, LIST_CONNECTOR_CONNECTION_POOLS, params, signature);
        for (int i = 0; i < poolNames.length; ++i) {
            String raName = (String)mbs.getAttribute(poolNames[i], "resource_adapter_name");
            if (!id.equals(raName)) continue;
            String poolName = (String)mbs.getAttribute(poolNames[i], "name");
            return "connector connection pool [" + poolName + "]";
        }
        ObjectName[] resAdapterConfigs = (ObjectName[])mbs.invoke(mbeanName, LIST_RESOURCE_ADAPTER_CONFIGS, params, signature);
        for (int i = 0; i < resAdapterConfigs.length; ++i) {
            String raName = (String)mbs.getAttribute(resAdapterConfigs[i], "resource_adapter_name");
            if (!id.equals(raName)) continue;
            return "resource adapter config";
        }
        return null;
    }

    public static List<Resource> getResourceList(DeploymentRequest req, boolean isForceParsing, DeploymentContext deploymentCtx) throws Exception {
        List resourceList = null;
        Application app = DeploymentServiceUtils.getInstanceManager(req.getType()).getRegisteredDescriptor(req.getName());
        if (app == null && deploymentCtx != null) {
            app = deploymentCtx.getApplication(req.getName());
        }
        if (app != null && app.getResourceList() != null && !isForceParsing) {
            resourceList = app.getResourceList();
        } else {
            resourceList = DeploymentServiceUtils.getResourcesFromResourcesXML(req.getName(), req.getType(), deploymentCtx);
            if (app != null) {
                app.setResourceList(resourceList);
            }
        }
        return resourceList;
    }

    public static void checkWebModuleReferences(String webModuleName) throws IASDeploymentException {
        ArrayList<String> virtualServerIds = new ArrayList<String>();
        try {
            Config config = (Config)ConfigBeansFactory.getConfigBeanByXPath(DeploymentServiceUtils.getConfigContext(), "/domain/configs/config[@name='server-config']");
            HttpService httpService = config.getHttpService();
            VirtualServer[] virtualServers = httpService.getVirtualServer();
            for (int j = 0; j < virtualServers.length; ++j) {
                VirtualServer aServer = virtualServers[j];
                String defWebModule = aServer.getDefaultWebModule();
                if (defWebModule == null || !defWebModule.equals(webModuleName)) continue;
                virtualServerIds.add(aServer.getId());
            }
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
        if (!virtualServerIds.isEmpty()) {
            throw new IASDeploymentException(localStrings.getString("enterprise.deployment.phasing.def_web_module_refs_exist", virtualServerIds.toString(), webModuleName));
        }
    }

    public static void checkAbort(String moduleID) throws IASDeploymentException {
        DeploymentRequest request = DeploymentRequestRegistry.getRegistry().getDeploymentRequest(moduleID);
        if (request != null && request.isAborted()) {
            DeploymentRequestRegistry.getRegistry().removeDeploymentRequest(moduleID);
            String msg = localStrings.getString("enterprise.deployment.phasing.operation.abort", new Object[]{moduleID});
            throw new IASDeploymentException(msg);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DeployableObjectType getTypeFromFile(String name, String filePath) throws DeploymentException {
        if (filePath == null) {
            throw new DeploymentException("deploy file not specified");
        }
        try {
            if (!filePath.endsWith(".class")) {
                Archivist archivist = ArchivistFactory.getArchivistForArchive(filePath);
                ModuleType moduleType = archivist.getModuleType();
                return DeploymentServiceUtils.getDeployableObjectType(moduleType);
            }
            StringTokenizer tk = new StringTokenizer(name, "_");
            File f = new File(filePath);
            for (int i = 0; i < tk.countTokens(); f = f.getParentFile(), ++i) {
            }
            try {
                URL[] urls = new URL[]{f.toURL()};
                URLClassLoader cLoader = new URLClassLoader(urls, DeploymentServiceUtils.class.getClassLoader());
                String className = name.replaceAll("_", ".");
                Class<?> clazz = cLoader.loadClass(className);
                if (clazz != null && clazz.getAnnotation(Stateless.class) != null) {
                    return DeployableObjectType.EJB;
                }
                return DeployableObjectType.WEB;
            }
            catch (Exception e) {
                sLogger.log(Level.WARNING, e.getMessage(), e);
                return DeployableObjectType.WEB;
            }
        }
        catch (IOException ioe) {
            DeploymentException de = new DeploymentException(localStrings.getString("enterprise.deployment.ioexc_getting_archtype", filePath));
            de.initCause(ioe);
            throw de;
        }
        catch (Exception ex) {
            DeploymentException de = new DeploymentException(localStrings.getString("enterprise.deployment.unknown.application.type", filePath));
            de.initCause(ex);
            throw de;
        }
    }

    public static DeploymentTarget getAndValidateDeploymentTarget(String targetName, String appName, boolean isDeleting) throws IASDeploymentException {
        try {
            DeploymentTarget target = DeploymentServiceUtils.getDeploymentTarget(targetName);
            if (targetName == null) {
                targetName = target.getTarget().getName();
            }
            if (target.getTarget().getType() == TargetType.SERVER || target.getTarget().getType() == TargetType.DAS) {
                if (isDeleting) {
                    if (!ServerHelper.serverReferencesApplication(DeploymentServiceUtils.getConfigContext(), targetName, appName)) {
                        throw new IASDeploymentException(localStrings.getString("serverApplicationRefDoesNotExist", targetName, appName));
                    }
                } else if (ServerHelper.serverReferencesApplication(DeploymentServiceUtils.getConfigContext(), targetName, appName)) {
                    throw new IASDeploymentException(localStrings.getString("serverApplicationRefAlreadyExists", appName, targetName));
                }
            } else if (target.getTarget().getType() == TargetType.CLUSTER) {
                if (isDeleting) {
                    if (!ClusterHelper.clusterReferencesApplication(DeploymentServiceUtils.getConfigContext(), targetName, appName)) {
                        throw new IASDeploymentException(localStrings.getString("clusterApplicationRefDoesNotExist", targetName, appName));
                    }
                } else if (ClusterHelper.clusterReferencesApplication(DeploymentServiceUtils.getConfigContext(), targetName, appName)) {
                    throw new IASDeploymentException(localStrings.getString("clusterApplicationRefAlreadyExists", appName, targetName));
                }
            }
            return target;
        }
        catch (IASDeploymentException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IASDeploymentException(ex);
        }
    }

    public static void setHostAndPort(DeploymentRequest req) throws ServerInstanceException, ConfigException {
        String virtualServers = (String)req.getOptionalAttributes().get("virtual-servers");
        if (virtualServers == null) {
            HostAndPort hap = DeploymentServiceUtils.getHostAndPort(false);
            if (hap != null) {
                req.setHttpHostName(DeploymentServiceUtils.getHostName(hap));
                req.setHttpPort(DeploymentServiceUtils.getPort(hap, false));
            }
            if ((hap = DeploymentServiceUtils.getHostAndPort(true)) != null) {
                req.setHttpsHostName(DeploymentServiceUtils.getHostName(hap));
                req.setHttpsPort(DeploymentServiceUtils.getPort(hap, true));
            }
        } else {
            StringTokenizer st = new StringTokenizer(virtualServers, ",");
            if (st.hasMoreTokens()) {
                String aVirtualServer = st.nextToken();
                HostAndPort hap = DeploymentServiceUtils.getVirtualServerHostAndPort(aVirtualServer, false);
                if (hap != null) {
                    req.setHttpHostName(DeploymentServiceUtils.getHostName(hap));
                    req.setHttpPort(DeploymentServiceUtils.getPort(hap, false));
                }
                if ((hap = DeploymentServiceUtils.getVirtualServerHostAndPort(aVirtualServer, true)) != null) {
                    req.setHttpsHostName(DeploymentServiceUtils.getHostName(hap));
                    req.setHttpsPort(DeploymentServiceUtils.getPort(hap, true));
                }
            }
        }
    }

    private static String getHostName(HostAndPort hap) {
        String hostName = hap.getHost();
        if (hostName == null || hostName.trim().equals("")) {
            hostName = DeploymentServiceUtils.getDefaultHostName();
        }
        return hostName;
    }

    private static String getDefaultHostName() {
        String defaultHostName = "localhost";
        try {
            InetAddress host = InetAddress.getLocalHost();
            defaultHostName = host.getCanonicalHostName();
        }
        catch (UnknownHostException uhe) {
            sLogger.log(Level.FINEST, "mbean.get_local_host_error", uhe);
            sLogger.log(Level.INFO, "mbean.use_default_host");
        }
        return defaultHostName;
    }

    private static int getPort(HostAndPort hap, boolean securityEnabled) {
        int port = hap.getPort();
        if (port == 0) {
            port = DeploymentServiceUtils.getDefaultPort(securityEnabled);
        }
        return port;
    }

    private static int getDefaultPort(boolean securityEnabled) {
        int port = 0;
        port = securityEnabled ? 8181 : 8080;
        sLogger.log(Level.INFO, "mbean.use_default_port", String.valueOf(port));
        return port;
    }

    private static Object getNamedAttributeValue(AttributeList attrs, String attrName) {
        if (attrs == null || attrName == null) {
            return null;
        }
        Object value = null;
        for (Attribute attr : attrs) {
            if (!attrName.equals(attr.getName())) continue;
            value = attr.getValue();
            break;
        }
        return value;
    }

    private static HostAndPort buildHostAndPortFromCurrentConfig(boolean securityEnabled) throws ConfigException {
        ServerContext serverContext = ApplicationServer.getServerContext();
        if (serverContext == null) {
            throw new IllegalStateException("Unable to locate server context");
        }
        ConfigContext configContext = serverContext.getConfigContext();
        if (configContext == null) {
            throw new IllegalStateException("Unable to locate config context from server");
        }
        return DeploymentServiceUtils.buildHostAndPortFromConfig(configContext, securityEnabled);
    }

    private static HostAndPort buildHostAndPortFromConfig(ConfigContext configContext, boolean securityEnabled) throws ConfigException {
        Config config = ServerBeansFactory.getConfigBean(configContext);
        HttpService httpService = config.getHttpService();
        HttpListener[] listeners = httpService.getHttpListener();
        return DeploymentServiceUtils.findNonadminListener(configContext, listeners, securityEnabled);
    }

    private static HostAndPort findNonadminListener(ConfigContext configContext, HttpListener[] listeners, boolean securityEnabled) throws ConfigException {
        HostAndPort result = null;
        for (HttpListener listener : listeners) {
            if (!listener.isEnabled() || listener.getDefaultVirtualServer().equals("__asadmin") || listener.isSecurityEnabled() != securityEnabled) continue;
            String serverName = listener.getServerName();
            if (serverName == null || serverName.trim().equals("")) {
                serverName = DeploymentServiceUtils.getDefaultHostName();
            }
            String portStr = listener.getPort();
            String redirectPortStr = listener.getRedirectPort();
            if (redirectPortStr != null && !redirectPortStr.trim().equals("")) {
                portStr = redirectPortStr;
            }
            String resolvedPortStr = new PropertyResolver(configContext, DeploymentServiceUtils.getInstanceName()).resolve(portStr);
            int port = Integer.parseInt(resolvedPortStr);
            result = new HostAndPort(serverName, port, listener.isSecurityEnabled());
            break;
        }
        return result;
    }

    private static HostAndPort getHostAndPort(boolean securityEnabled) throws ServerInstanceException, ConfigException {
        return DeploymentServiceUtils.buildHostAndPortFromCurrentConfig(securityEnabled);
    }

    private static HostAndPort getVirtualServerHostAndPort(String vs, boolean securityEnabled) throws ServerInstanceException {
        String serverName = null;
        int port = 0;
        try {
            VirtualServer[] virtualServer;
            Domain domain = ConfigAPIHelper.getDomainConfigBean(DeploymentServiceUtils.getConfigContext());
            Config config = domain.getConfigs().getConfig(0);
            HttpService httpService = config.getHttpService();
            HttpListener[] httpListener = httpService.getHttpListener();
            for (VirtualServer v : virtualServer = httpService.getVirtualServer()) {
                if (!v.getId().equals(vs)) continue;
                String httpListeners = v.getHttpListeners();
                List httpListenerList = StringUtils.parseStringList(httpListeners, " ,");
                for (String vsHttpListenerID : httpListenerList) {
                    for (HttpListener listener : httpListener) {
                        if (!listener.getId().equals(vsHttpListenerID) || !listener.isEnabled() || listener.isSecurityEnabled() != securityEnabled) continue;
                        serverName = listener.getServerName();
                        if (serverName == null || serverName.trim().equals("")) {
                            serverName = DeploymentServiceUtils.getDefaultHostName();
                        }
                        String portStr = listener.getPort();
                        String redirPort = listener.getRedirectPort();
                        if (redirPort != null && !redirPort.trim().equals("")) {
                            portStr = redirPort;
                        }
                        String resolvedPort = new PropertyResolver(DeploymentServiceUtils.getConfigContext(), DeploymentServiceUtils.getInstanceName()).resolve(portStr);
                        port = Integer.parseInt(resolvedPort);
                        return new HostAndPort(serverName, port);
                    }
                }
            }
        }
        catch (Exception e) {
            ServerInstanceException sie = new ServerInstanceException(e.getLocalizedMessage());
            sie.initCause(e);
            throw sie;
        }
        return null;
    }

    public static DeploymentTarget getDeploymentTarget(String targetName) throws IASDeploymentException {
        try {
            DeploymentTarget target = DeploymentTargetFactory.getDeploymentTargetFactory().getTarget(DeploymentServiceUtils.getConfigContext(), DeploymentServiceUtils.getDomainName(), targetName);
            return target;
        }
        catch (IASDeploymentException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IASDeploymentException(ex);
        }
    }

    public static void checkAppReferencesBeforeUndeployFromDomain(String appName) throws IASDeploymentException {
        try {
            if (ApplicationHelper.isApplicationReferenced(DeploymentServiceUtils.getConfigContext(), appName)) {
                throw new IASDeploymentException(localStrings.getString("applicationIsReferenced", appName, ApplicationHelper.getApplicationReferenceesAsString(DeploymentServiceUtils.getConfigContext(), appName)));
            }
        }
        catch (IASDeploymentException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IASDeploymentException(ex);
        }
    }

    public static DeployableObjectType getRegisteredType(String name) throws DeploymentException {
        try {
            for (int i = 0; i < deployableObjectTypes.length; ++i) {
                if (!DeploymentServiceUtils.isRegistered(name, deployableObjectTypes[i])) continue;
                return deployableObjectTypes[i];
            }
        }
        catch (Exception e) {
            throw new DeploymentException(e.getMessage());
        }
        String msg = localStrings.getString("enterprise.deployment.component.not.registered", name);
        throw new DeploymentException(msg);
    }

    public static DeployableObjectType getDeployableObjectType(ModuleType type) {
        if (ModuleType.EAR.equals(type)) {
            return DeployableObjectType.APP;
        }
        if (ModuleType.EJB.equals(type)) {
            return DeployableObjectType.EJB;
        }
        if (ModuleType.WAR.equals(type)) {
            return DeployableObjectType.WEB;
        }
        if (ModuleType.CAR.equals(type)) {
            return DeployableObjectType.CAR;
        }
        if (ModuleType.RAR.equals(type)) {
            return DeployableObjectType.CONN;
        }
        return null;
    }

    private static ConfigBean createNewModule(DeployableObjectType type) {
        ConfigBean result = null;
        if (type.equals(DeployableObjectType.APP)) {
            result = new J2eeApplication();
        } else if (type.equals(DeployableObjectType.CAR)) {
            result = new AppclientModule();
        } else if (type.equals(DeployableObjectType.CONN)) {
            result = new ConnectorModule();
        } else if (type.equals(DeployableObjectType.EJB)) {
            result = new EjbModule();
        } else if (type.equals(DeployableObjectType.WEB)) {
            result = new WebModule();
        } else {
            throw new IllegalArgumentException(type.toString());
        }
        return result;
    }

    private static void addModule(DeployableObjectType type, ConfigBean module) throws ConfigException {
        DeploymentServiceUtils.getAppsConfigBean().addValue(DeploymentServiceUtils.toConfigBeanType(type), module);
    }

    private static void removeModule(DeployableObjectType type, ConfigBean module) throws ConfigException {
        DeploymentServiceUtils.removeReferences(module);
        DeploymentServiceUtils.getAppsConfigBean().removeValue(DeploymentServiceUtils.toConfigBeanType(type), module);
    }

    private static void removeReferences(ConfigBean module) throws ConfigException {
        ApplicationRef ref;
        ConfigContext configContext = module.getConfigContext();
        String name = module.getAttributeValue("name");
        Server[] servers = ServerHelper.getServersReferencingApplication(configContext, name);
        Cluster[] clusters = ClusterHelper.getClustersReferencingApplication(configContext, name);
        for (Server server : servers) {
            ref = server.getApplicationRefByRef(name);
            server.removeApplicationRef(ref);
        }
        for (ConfigBean configBean : clusters) {
            ref = ((Cluster)configBean).getApplicationRefByRef(name);
            ((Cluster)configBean).removeApplicationRef(ref);
        }
    }

    private static ConfigBean getModule(String appID, DeployableObjectType type) throws ConfigException {
        ConfigBean module = ApplicationHelper.findApplication(DeploymentServiceUtils.getConfigContext(), appID);
        if (module != null && type.equals(DeploymentServiceUtils.toDeployableObjectType(module))) {
            return module;
        }
        return null;
    }

    private static String toConfigBeanType(DeployableObjectType type) {
        String result;
        if (type.equals(DeployableObjectType.APP)) {
            result = "J2eeApplication";
        } else if (type.equals(DeployableObjectType.CAR)) {
            result = "AppclientModule";
        } else if (type.equals(DeployableObjectType.CONN)) {
            result = "ConnectorModule";
        } else if (type.equals(DeployableObjectType.EJB)) {
            result = "EjbModule";
        } else if (type.equals(DeployableObjectType.WEB)) {
            result = "WebModule";
        } else {
            throw new IllegalArgumentException(type.toString());
        }
        return result;
    }

    private static DeployableObjectType toDeployableObjectType(ConfigBean module) {
        DeployableObjectType result = module instanceof J2eeApplication ? DeployableObjectType.APP : (module instanceof EjbModule ? DeployableObjectType.EJB : (module instanceof WebModule ? DeployableObjectType.WEB : (module instanceof LifecycleModule ? DeployableObjectType.LCM : (module instanceof AppclientModule ? DeployableObjectType.CAR : (module instanceof ConnectorModule ? DeployableObjectType.CONN : null)))));
        return result;
    }
}

