/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.factory;

import com.sun.enterprise.deployment.annotation.impl.AnnotationProcessorImpl;
import com.sun.enterprise.deployment.annotation.impl.AnnotationUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;

public abstract class Factory {
    private static Set<String> skipAnnotationClassList = null;
    private static final String SKIP_ANNOTATION_CLASS_LIST_URL = "skip-annotation-class-list";

    protected Factory() {
    }

    private static void init() {
    }

    public static AnnotationProcessorImpl getDefaultAnnotationProcessor() {
        return new AnnotationProcessorImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void initSkipAnnotationClassList() {
        if (skipAnnotationClassList == null) {
            skipAnnotationClassList = new HashSet<String>();
            InputStream is = null;
            try {
                String className;
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                is = cl.getResourceAsStream(SKIP_ANNOTATION_CLASS_LIST_URL);
                BufferedReader bf = new BufferedReader(new InputStreamReader(is));
                while ((className = bf.readLine()) != null) {
                    skipAnnotationClassList.add(className.trim());
                }
            }
            catch (IOException ioe) {
                AnnotationUtils.getLogger().log(Level.WARNING, ioe.getMessage(), ioe);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static boolean isSkipAnnotationProcessing(String cName) {
        if (skipAnnotationClassList == null) {
            Factory.initSkipAnnotationClassList();
        }
        return skipAnnotationClassList.contains(cName);
    }
}

