/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.appclient.jws;

import com.sun.enterprise.appclient.jws.JWSAdHocServletRequestWrapper;
import com.sun.enterprise.appclient.jws.NamingConventions;
import com.sun.enterprise.appclient.jws.WebPath;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JWSAdHocServlet
extends HttpServlet {
    public static final String CONTEXT_ROOT_PARAMETER_NAME = "context-root";
    public static final String CATEGORY_PARAMETER_NAME = "category";
    private ServletContext jwsAppContext = null;
    private RequestDispatcher systemWebAppDispatcher = null;
    private String targetContextRoot = null;
    private String category = null;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        JWSAdHocServletRequestWrapper wrappedRequest = new JWSAdHocServletRequestWrapper(request, this.targetContextRoot, this.category);
        try {
            this.getJWSRequestDispatcher().forward((ServletRequest)wrappedRequest, (ServletResponse)response);
        }
        catch (Throwable thr) {
            throw new ServletException("Error dispatching request to Java Web Start app client application", thr);
        }
    }

    public void init() {
        ServletConfig config = this.getServletConfig();
        this.targetContextRoot = config.getInitParameter(CONTEXT_ROOT_PARAMETER_NAME);
        this.category = config.getInitParameter(CATEGORY_PARAMETER_NAME);
    }

    private ServletContext getJWSAppContext() {
        if (this.jwsAppContext == null) {
            String uri = NamingConventions.webAppURI();
            this.jwsAppContext = this.getServletContext().getContext(uri);
        }
        return this.jwsAppContext;
    }

    private RequestDispatcher getJWSRequestDispatcher() {
        if (this.systemWebAppDispatcher == null) {
            String uri = NamingConventions.webAppURI();
            WebPath webPath = new WebPath(uri);
            ServletContext sc = this.getServletContext().getContext(webPath.contextRoot());
            String servletContextName = sc.getServletContextName();
            this.systemWebAppDispatcher = sc.getRequestDispatcher(webPath.path() + "/" + this.category + this.targetContextRoot);
        }
        return this.systemWebAppDispatcher;
    }
}

