/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.appclient;

import com.sun.enterprise.InjectionManager;
import com.sun.enterprise.J2EESecurityManager;
import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.appclient.ACCEntityResolver;
import com.sun.enterprise.appclient.AppClientInfo;
import com.sun.enterprise.appclient.AppClientInfoFactory;
import com.sun.enterprise.appclient.AppContainer;
import com.sun.enterprise.appclient.HttpAuthenticator;
import com.sun.enterprise.appclient.ScriptingSupport;
import com.sun.enterprise.appclient.UserError;
import com.sun.enterprise.appclient.jws.Util;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.config.clientbeans.ClientBeansFactory;
import com.sun.enterprise.config.clientbeans.ClientContainer;
import com.sun.enterprise.config.clientbeans.ClientCredential;
import com.sun.enterprise.config.clientbeans.ElementProperty;
import com.sun.enterprise.config.clientbeans.Security;
import com.sun.enterprise.config.clientbeans.Ssl;
import com.sun.enterprise.config.clientbeans.TargetServer;
import com.sun.enterprise.connectors.ActiveResourceAdapter;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.naming.ProviderManager;
import com.sun.enterprise.security.GUIErrorDialog;
import com.sun.enterprise.security.SSLUtils;
import com.sun.enterprise.security.UsernamePasswordStore;
import com.sun.enterprise.security.jmac.config.GFAuthConfigFactory;
import com.sun.enterprise.server.logging.ACCLogManager;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.Utility;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.webservice.ClientPipeCloser;
import com.sun.logging.LogDomains;
import com.sun.web.server.HttpsURLStreamHandlerFactory;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.login.FailedLoginException;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainWithModuleSupport {
    private static final String CLIENT = "-client";
    private static final String NAME = "-name";
    private static final String MAIN_CLASS = "-mainclass";
    private static final String TEXT_AUTH = "-textauth";
    private static final String XML_PATH = "-xml";
    private static final String ACC_CONFIG_XML = "-configxml";
    private static final String DEFAULT_CLIENT_CONTAINER_XML = "sun-acc.xml";
    private static final String SUNACC_XML_URL = "sun-acc.xml.url";
    private static final String NO_APP_INVOKE = "-noappinvoke";
    private static final String USER = "-user";
    private static final String PASSWORD = "-password";
    private static final String PASSWORD_FILE = "-passwordfile";
    private static final String LOGIN_NAME = "j2eelogin.name";
    private static final String LOGIN_PASSWORD = "j2eelogin.password";
    private static final String DASH = "-";
    private static final String lineSep = System.getProperty("line.separator");
    public static final String APPCLIENT_IIOP_DEFAULTHOST_PROPERTYNAME = "com.sun.aas.jws.iiop.defaultHost";
    public static final String APPCLIENT_IIOP_DEFAULTPORT_PROPERTYNAME = "com.sun.aas.jws.iiop.defaultPort";
    public static final String APPCLIENT_IIOP_FAILOVER_ENDPOINTS_PROPERTYNAME = "com.sun.aas.jws.iiop.failover.endpoints";
    public static final String APPCLIENT_PROBE_CLASSNAME_PROPERTYNAME = "com.sun.aas.jws.probeClassName";
    public static final String APPCLIENT_RETAIN_TEMP_FILES_PROPERTYNAME = "com.sun.aas.jws.retainTempFiles";
    public static final String APPCLIENT_ISJWS_PROPERTYNAME = "com.sun.aas.jws.isJWS";
    public static final String APPCLIENT_DOWNLOAD_HOST_PROPERTYNAME = "com.sun.aas.jws.download.host";
    public static final String SUN_ACC_SECURITY_CONFIG_PROPERTY = "security.config.file";
    private static final String LOGIN_CONF_FILE_PREFIX = "login";
    private static final String LOGIN_CONF_FILE_SUFFIX = ".conf";
    private static final String LOGIN_CONF_PROPERTY_NAME = "java.security.auth.login.config";
    private static final String DEFAULT_TEMPLATE_PREFIX = "jws/templates/";
    private static final String SUN_ACC_DEFAULT_TEMPLATE = "jws/templates/default-sun-accTemplate.xml";
    private static final String WSS_CLIENT_CONFIG_TEMPLATE = "jws/templates/default-wss-client-configTemplate.xml";
    private static final String LOGIN_CONF_TEMPLATE = "jws/templates/appclientlogin.conf";
    private static final String WSS_CLIENT_CONFIG_PREFIX = "wsscc";
    private static final String WSS_CLIENT_CONFIG_SUFFIX = ".xml";
    private static final String SUN_ACC_PREFIX = "sunacc";
    private static final String SUN_ACC_SUFFIX = ".xml";
    private static final String[] LOCAL_LAUNCH_PERSISTENCE_JAR_PATHS = new String[]{System.getProperty("com.sun.aas.derbyRoot") + File.separator + "lib" + File.separator + "derbyclient.jar", System.getProperty("com.sun.aas.installRoot") + File.separator + "lib" + File.separator + "toplink-essentials.jar", System.getProperty("com.sun.aas.installRoot") + File.separator + "lib" + File.separator + "dbschema.jar"};
    private static final String ORB_INITIAL_HOST_PROPERTYNAME = "org.omg.CORBA.ORBInitialHost";
    private static final String ORB_INITIAL_PORT_PROPERTYNAME = "org.omg.CORBA.ORBInitialPort";
    protected static Logger _logger;
    protected final boolean debug = false;
    protected StringManager localStrings;
    protected boolean guiAuth;
    protected boolean runClient;
    protected String host;
    protected String port;
    protected String[] args;
    protected boolean isJWS;
    protected boolean retainTempFiles;
    protected String clientJar;
    protected String displayName;
    protected String mainClass;
    protected String xmlPath;
    protected String accConfigXml;
    protected String jwsACCConfigXml;
    protected Vector<String> appArgs;
    protected String classFileFromCommandLine;
    protected boolean useTextAuth;
    private static boolean lb_enabled;

    public static boolean isLoadBalancingEnabled() {
        return lb_enabled;
    }

    public MainWithModuleSupport(String[] args) {
        this(args, MainWithModuleSupport.locateLocalPersistenceJARs());
    }

    public MainWithModuleSupport(String[] args, URL[] persistenceJarURLs) {
        block12: {
            this.debug = false;
            this.localStrings = StringManager.getManager(MainWithModuleSupport.class);
            this.guiAuth = false;
            this.runClient = true;
            this.retainTempFiles = false;
            this.clientJar = null;
            this.displayName = null;
            this.mainClass = null;
            this.xmlPath = null;
            this.accConfigXml = null;
            this.jwsACCConfigXml = null;
            this.appArgs = new Vector();
            this.classFileFromCommandLine = null;
            this.useTextAuth = false;
            BufferedLogger tempLogger = this.prepareBufferedLogging();
            _logger = tempLogger;
            this.prepareJWSSettings();
            try {
                block11: {
                    try {
                        this.appArgs = this.processCommandLine(args);
                        String classNameForClassFile = this.determineClassNameForClassFileLaunch(this.clientJar, this.isJWS, this.mainClass, this.classFileFromCommandLine);
                        String xmlPathToUse = this.chooseConfigFile(this.xmlPath, this.accConfigXml, this.isJWS);
                        this.validateXMLFile(xmlPathToUse);
                        _logger = this.prepareLogging(tempLogger, xmlPathToUse, this.isJWS);
                        File appClientJarOrDir = this.locateAppclientJarOrDir(this.clientJar, classNameForClassFile, this.isJWS);
                        this.prepareJWSLoginConfig();
                        Utility.checkJVMVersion();
                        this.prepareSecurity();
                        Object terminatingException = null;
                        AppClientInfo appClientInfo = null;
                        ClassLoader jcl = null;
                        Switch.getSwitch().setProviderManager(ProviderManager.getProviderManager());
                        Switch.getSwitch().setContainerType(1);
                        Properties iiopProperties = this.setTargetServerProperties(xmlPathToUse);
                        boolean exitCode = false;
                        MainWithModuleSupport.prepareURLStreamHandling();
                        _logger.log(Level.INFO, "acc.endpoints", lb_enabled ? System.getProperty("com.sun.appserv.iiop.endpoints") : iiopProperties.getProperty(ORB_INITIAL_HOST_PROPERTYNAME) + ":" + iiopProperties.getProperty(ORB_INITIAL_PORT_PROPERTYNAME));
                        InitialContext ic = AppContainer.initializeNaming(iiopProperties);
                        appClientInfo = AppClientInfoFactory.buildAppClientInfo(this.isJWS, _logger, appClientJarOrDir, this.mainClass, this.displayName, this.classFileFromCommandLine, persistenceJarURLs);
                        ApplicationClientDescriptor appDesc = appClientInfo.getAppClient();
                        AppContainer container = this.createAppContainer(appDesc, this.guiAuth);
                        Cleanup cleanup = MainWithModuleSupport.prepareShutdownCleanup(container, appClientInfo);
                        Authenticator.setDefault(new HttpAuthenticator(container));
                        jcl = appClientInfo.getClassLoader();
                        String appMainClass = container.preInvoke(ic, jcl);
                        if (this.mainClass != null) {
                            appMainClass = this.mainClass;
                        }
                        Thread.currentThread().setContextClassLoader(jcl);
                        if (this.isJWS) {
                            this.setClassLoaderForEDT(jcl);
                        }
                        Class cl = this.loadMainClientClass(jcl, appMainClass);
                        System.setProperty("javax.xml.ws.spi.Provider", "com.sun.enterprise.webservice.spi.ProviderImpl");
                        InjectionManager injMgr = Switch.getSwitch().getInjectionManager();
                        cleanup.setInjectionManager(injMgr, cl, appDesc);
                        injMgr.injectClass(cl, appDesc);
                        ScriptingSupport scriptingSupport = new ScriptingSupport(jcl, _logger);
                        cleanup.setScriptingSupport(scriptingSupport);
                        boolean runMainClass = true;
                        if (!this.runClient) break block11;
                        boolean bl = runMainClass = !scriptingSupport.startScript(appMainClass, this.appArgs);
                        if (!runMainClass) break block11;
                        String[] applicationArgs = this.appArgs.toArray(new String[this.appArgs.size()]);
                        Utility.invokeApplicationMain(cl, applicationArgs);
                        _logger.info("Application main() returned; GUI elements may be continuing to run");
                    }
                    catch (InvocationTargetException ite) {
                        Throwable tt = ite.getTargetException();
                        _logger.log(Level.WARNING, "acc.app_exception", tt);
                        throw new RuntimeException(ite);
                    }
                    catch (UserError ue) {
                        ue.displayAndExit();
                        Object var23_30 = null;
                        this.shutDownSystemAdapters();
                        break block12;
                    }
                    catch (Throwable t) {
                        if (t instanceof FailedLoginException) {
                            _logger.info("acc.login_error");
                            boolean isGui = Boolean.valueOf(System.getProperty("auth.gui", "true"));
                            String errorMessage = this.localStrings.getString("main.exception.loginError", "Incorrect login and/or password");
                            if (isGui) {
                                GUIErrorDialog ged = new GUIErrorDialog(errorMessage);
                                ged.show();
                            }
                        }
                        _logger.log(Level.WARNING, "acc.app_exception", t);
                        if (t instanceof NamingException) {
                            _logger.log(Level.WARNING, "acc.naming_exception_received");
                        }
                        throw new RuntimeException(t);
                    }
                }
                Object var23_29 = null;
                this.shutDownSystemAdapters();
            }
            catch (Throwable throwable) {
                Object var23_31 = null;
                this.shutDownSystemAdapters();
                throw throwable;
            }
        }
    }

    private void setClassLoaderForEDT(final ClassLoader loader) throws InterruptedException, InvocationTargetException {
        SwingUtilities.invokeAndWait(new Runnable(){
            private ClassLoader theCL;

            public void run() {
                Thread.currentThread().setContextClassLoader(loader);
                Toolkit tk = Toolkit.getDefaultToolkit();
                EventQueue eq = tk.getSystemEventQueue();
                eq.push(new EventQueue());
            }
        });
    }

    private static URL[] locateLocalPersistenceJARs() {
        try {
            URL[] localPersistenceJARURLs = new URL[LOCAL_LAUNCH_PERSISTENCE_JAR_PATHS.length];
            int slot = 0;
            for (String jarPath : LOCAL_LAUNCH_PERSISTENCE_JAR_PATHS) {
                File jarFile = new File(jarPath);
                localPersistenceJARURLs[slot++] = jarFile.toURI().toURL();
            }
            return localPersistenceJARURLs;
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException(mue);
        }
    }

    private void prepareJWSSettings() {
        this.isJWS = Boolean.getBoolean(APPCLIENT_ISJWS_PROPERTYNAME);
        this.retainTempFiles = Boolean.getBoolean(APPCLIENT_RETAIN_TEMP_FILES_PROPERTYNAME);
    }

    private void prepareSecurity() {
        if (!this.useTextAuth) {
            this.guiAuth = Boolean.valueOf(System.getProperty("auth.gui", "true"));
        }
        SecurityManager secMgr = System.getSecurityManager();
        if (!this.isJWS && secMgr != null && !J2EESecurityManager.class.equals(secMgr.getClass())) {
            J2EESecurityManager mgr = new J2EESecurityManager();
            System.setSecurityManager(mgr);
        }
        if (_logger.isLoggable(Level.INFO)) {
            if (secMgr != null) {
                _logger.info("acc.secmgron");
            } else {
                _logger.info("acc.secmgroff");
            }
        }
        try {
            SSLUtils.initStoresAtStartup();
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.log(Level.FINER, "main.ssl_keystore_init_failed", e);
            }
            _logger.log(Level.WARNING, "main.ssl_keystore_init_failed");
        }
        try {
            String defaultFactory = java.security.Security.getProperty("authconfigprovider.factory");
            if (defaultFactory == null) {
                java.security.Security.setProperty("authconfigprovider.factory", GFAuthConfigFactory.class.getName());
            }
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "main.jmac_default_factory");
        }
    }

    private Class loadMainClientClass(ClassLoader jcl, String clientMainClassName) throws UserError {
        Class<?> result = null;
        try {
            result = jcl.loadClass(clientMainClassName);
        }
        catch (ClassNotFoundException cnf) {
            String errorMessage = this.localStrings.getString("appclient.mainclass.not.found", clientMainClassName);
            throw new UserError(errorMessage, cnf);
        }
        _logger.log(Level.INFO, "acc.load_app_class", clientMainClassName);
        return result;
    }

    private Logger prepareLogging(BufferedLogger tempLogger, String xmlPathToUse, boolean isJWS) {
        Logger result = LogDomains.getLogger("javax.enterprise.system.container.appclient");
        LogManager logMgr = LogManager.getLogManager();
        if (logMgr instanceof ACCLogManager) {
            ((ACCLogManager)logMgr).init(xmlPathToUse);
        }
        tempLogger.pushTo(result);
        return result;
    }

    private Vector<String> processCommandLine(String[] args) throws UserError {
        Vector<String> clientArgs = new Vector<String>();
        AtomicInteger i = new AtomicInteger();
        String arg = null;
        if (args.length < 1) {
            this.usage();
        } else {
            while (i.get() < args.length) {
                arg = args[i.getAndIncrement()];
                if (arg.equals(CLIENT)) {
                    this.clientJar = this.getRequiredCommandOptionValue(args, CLIENT, i, "appclient.clientWithoutValue");
                    continue;
                }
                if (arg.equals(NAME)) {
                    this.displayName = this.getRequiredCommandOptionValue(args, NAME, i, "appclient.nameWithoutValue");
                    this.ensureAtMostOneOfNameAndMainClass();
                    continue;
                }
                if (arg.equals(MAIN_CLASS)) {
                    this.mainClass = this.getRequiredCommandOptionValue(args, MAIN_CLASS, i, "appclient.mainClassWithoutValue");
                    this.ensureAtMostOneOfNameAndMainClass();
                    continue;
                }
                if (arg.equals(XML_PATH)) {
                    this.xmlPath = this.getRequiredUniqueCommandOptionValue(args, XML_PATH, this.xmlPath, i, "appclient.xmlWithoutValue");
                    continue;
                }
                if (arg.equals(ACC_CONFIG_XML)) {
                    this.accConfigXml = this.getRequiredUniqueCommandOptionValue(args, ACC_CONFIG_XML, this.accConfigXml, i, "appclient.accConfigXmlWithoutValue");
                    continue;
                }
                if (arg.equals(TEXT_AUTH)) {
                    this.useTextAuth = true;
                    this.logOption(TEXT_AUTH);
                    continue;
                }
                if (arg.equals(NO_APP_INVOKE)) {
                    this.runClient = false;
                    this.logOption(NO_APP_INVOKE);
                    continue;
                }
                if (arg.equals(USER)) {
                    String userNameValue = this.getRequiredCommandOptionValue(args, USER, i, "appclient.userWithoutValue");
                    System.setProperty(LOGIN_NAME, userNameValue);
                    continue;
                }
                if (arg.equals(PASSWORD)) {
                    String passwordValue = this.getRequiredCommandOptionValue(args, PASSWORD, i, "appclient.passwordWithoutValue");
                    System.setProperty(LOGIN_PASSWORD, passwordValue);
                    continue;
                }
                if (arg.equals(PASSWORD_FILE)) {
                    String passwordFileValue = this.getRequiredCommandOptionValue(args, PASSWORD_FILE, i, "appclient.passwordFileWithoutValue");
                    try {
                        System.setProperty(LOGIN_PASSWORD, this.loadPasswordFromFile(passwordFileValue));
                        continue;
                    }
                    catch (IOException ex) {
                        throw new UserError(this.localStrings.getString("appclient.errorReadingFromPasswordFile", passwordFileValue), ex);
                    }
                }
                clientArgs.add(arg);
                this.logArgument(arg);
            }
            String uname = System.getProperty(LOGIN_NAME);
            String upass = System.getProperty(LOGIN_PASSWORD);
            if (uname != null || upass != null) {
                UsernamePasswordStore.set(uname, upass);
            }
            if (this.mainClass == null && this.clientJar == null && !this.isJWS) {
                if (clientArgs.size() > 0) {
                    this.classFileFromCommandLine = clientArgs.elementAt(0);
                    clientArgs.removeElementAt(0);
                    this.logClassFileArgument(this.classFileFromCommandLine);
                } else {
                    this.usage();
                }
            }
        }
        this.logClientArgs(clientArgs);
        return clientArgs;
    }

    private String getRequiredCommandOptionValue(String[] args, String optionName, AtomicInteger position, String errorKey) throws UserError {
        String result = null;
        if (position.get() >= args.length || args[position.get()].startsWith(DASH)) {
            throw new UserError(this.localStrings.getString(errorKey));
        }
        result = args[position.getAndIncrement()];
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(this.localStrings.getString("appclient.optionValueIs", optionName, result));
        }
        return result;
    }

    private String getRequiredUniqueCommandOptionValue(String[] args, String optionName, String currentValue, AtomicInteger position, String errorKey) throws UserError {
        if (currentValue != null) {
            throw new UserError(this.localStrings.getString("appclient.duplicateValue", optionName, currentValue));
        }
        return this.getRequiredCommandOptionValue(args, optionName, position, errorKey);
    }

    private void ensureAtMostOneOfNameAndMainClass() throws UserError {
        if (this.mainClass != null && this.displayName != null) {
            throw new UserError(this.localStrings.getString("appclient.mainclassOrNameNotBoth"));
        }
    }

    private void logOption(String optionName) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(this.localStrings.getString("appclient.valuelessOptionFound", optionName));
        }
    }

    private void logArgument(String arg) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(this.localStrings.getString("appclient.argumentValueFound", arg));
        }
    }

    private void logClassFileArgument(String classFile) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(this.localStrings.getString("appclient.classFileUsed", classFile));
        }
    }

    private void logClientArgs(Vector<String> clientArgs) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(this.localStrings.getString("appclient.clientArgs", clientArgs.toString()));
        }
    }

    private String determineClassNameForClassFileLaunch(String clientJar, boolean isJWS, String mainClass, String classFileFromCommandLine) throws UserError {
        String result = null;
        boolean isFine = _logger.isLoggable(Level.FINE);
        if (clientJar == null && !isJWS) {
            String path;
            File file;
            String value;
            if (classFileFromCommandLine != null) {
                value = classFileFromCommandLine;
                if (isFine) {
                    _logger.fine(this.localStrings.getString("appclient.classNameFromArg", classFileFromCommandLine));
                }
            } else {
                value = mainClass;
                if (isFine) {
                    _logger.fine(this.localStrings.getString("appclient.classNameFromMainClass", mainClass));
                }
            }
            if (!(file = new File(path = (result = value.endsWith(".class") ? value.substring(0, value.length() - ".class".length()) : value).replace('.', File.separatorChar) + ".class")).isAbsolute()) {
                file = new File(System.getProperty("user.dir"), path);
            }
            if (!file.exists()) {
                throw new UserError(this.localStrings.getString("appclient.cannotFindClassFile", result, file.getAbsolutePath()));
            }
            if (isFine) {
                _logger.fine(this.localStrings.getString("appclient.usingClassFile", file.getAbsolutePath()));
            }
        }
        return result;
    }

    private String chooseConfigFile(String xmlPath, String accConfigXml, boolean isJWS) {
        String pathToUse = null;
        boolean isFine = _logger.isLoggable(Level.FINE);
        if (xmlPath != null) {
            pathToUse = xmlPath;
            if (isFine) {
                _logger.fine(this.localStrings.getString("appclient.configFrom", XML_PATH, pathToUse));
            }
        } else if (accConfigXml != null) {
            pathToUse = accConfigXml;
            if (isFine) {
                _logger.fine(this.localStrings.getString("appclient.configFrom", ACC_CONFIG_XML, pathToUse));
            }
        } else if (isJWS) {
            try {
                String jwsACCConfigXml = this.prepareJWSConfig();
                if (jwsACCConfigXml != null) {
                    pathToUse = jwsACCConfigXml;
                    if (isFine) {
                        _logger.fine(this.localStrings.getString("appclient.configFromJWSTemplate"));
                    }
                }
            }
            catch (Throwable thr) {
                throw new RuntimeException(this.localStrings.getString("appclient.errorPrepConfig"), thr);
            }
        }
        return pathToUse;
    }

    private File locateAppclientJarOrDir(String clientJar, String className, boolean isJWS) throws ClassNotFoundException, URISyntaxException, UserError {
        File result = null;
        boolean isFine = _logger.isLoggable(Level.FINE);
        if (isJWS) {
            result = this.findAppClientFileForJWSLaunch();
            if (isFine) {
                _logger.fine(this.localStrings.getString("appclient.JWSAppClientFile", result.getAbsolutePath()));
            }
        } else if (clientJar == null) {
            File userDir = new File(System.getProperty("user.dir"));
            File appClientClass = new File(userDir, className);
            result = appClientClass.getParentFile();
            if (isFine) {
                _logger.fine(this.localStrings.getString("appclient.classFileAppClientFile", result.getAbsolutePath()));
            }
        } else {
            result = new File(clientJar);
            if (isFine) {
                _logger.fine(this.localStrings.getString("appclient.clientJarAppClientFile", result.getAbsolutePath()));
            }
            if (!result.exists()) {
                UserError ue = UserError.formatUserError(this.localStrings.getString("appclient.cannotFindJarFile"), result.getAbsolutePath());
                throw ue;
            }
        }
        return result;
    }

    private ClassLoader preparePreliminaryClassLoader(File jarOrDir) throws MalformedURLException {
        URLClassLoader result = null;
        URL[] urls = new URL[]{jarOrDir.toURI().toURL()};
        ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
        result = new URLClassLoader(urls, currentCL);
        return result;
    }

    private AppContainer createAppContainer(ApplicationClientDescriptor appDesc, boolean guiAuth) {
        AppContainer result = new AppContainer(appDesc, guiAuth);
        if (result == null) {
            _logger.log(Level.WARNING, "acc.no_client_desc", this.displayName == null ? this.mainClass : this.displayName);
            System.exit(1);
        }
        return result;
    }

    private static Cleanup prepareShutdownCleanup(AppContainer container, AppClientInfo appClientInfo) {
        Cleanup cleanup = new Cleanup();
        Runtime runtime = Runtime.getRuntime();
        runtime.addShutdownHook(cleanup);
        cleanup.setAppContainer(container);
        cleanup.setAppClientInfo(appClientInfo);
        return cleanup;
    }

    private static void prepareURLStreamHandling() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                URL.setURLStreamHandlerFactory(new HttpsURLStreamHandlerFactory());
                return null;
            }
        });
    }

    private Properties setTargetServerProperties(String clientXmlLocation) throws ConfigException {
        boolean isEndpointPropertySpecifiedByUser = false;
        String loadBalancingPolicy = null;
        Properties result = new Properties();
        StringBuilder completeEndpointList = new StringBuilder();
        try {
            if (clientXmlLocation == null || clientXmlLocation.equals("")) {
                clientXmlLocation = DEFAULT_CLIENT_CONTAINER_XML;
            }
            System.setProperty(SUNACC_XML_URL, clientXmlLocation);
            _logger.log(Level.INFO, "acc.using_xml_location", clientXmlLocation);
            ConfigContext ctx = ConfigFactory.createConfigContext(clientXmlLocation, true, false, false, ClientContainer.class, new ACCEntityResolver());
            ClientContainer cc = ClientBeansFactory.getClientBean(ctx);
            this.host = cc.getTargetServer(0).getAddress();
            this.port = cc.getTargetServer(0).getPort();
            TargetServer[] tServer = cc.getTargetServer();
            String targetServerEndpoints = null;
            for (int i = 0; i < tServer.length; ++i) {
                if (targetServerEndpoints == null) {
                    targetServerEndpoints = tServer[i].getAddress() + ":" + tServer[i].getPort();
                    continue;
                }
                targetServerEndpoints = targetServerEndpoints + "," + tServer[i].getAddress() + ":" + tServer[i].getPort();
                lb_enabled = true;
            }
            MainWithModuleSupport.setSSLData(cc);
            ClientCredential cCrd = cc.getClientCredential();
            if (cCrd != null) {
                String uname = null;
                String upass = null;
                if (System.getProperty(LOGIN_NAME) == null) {
                    _logger.config("using login name from client container xml...");
                    uname = cCrd.getUserName();
                }
                if (System.getProperty(LOGIN_PASSWORD) == null) {
                    _logger.config("using password from client container xml...");
                    upass = cCrd.getPassword();
                }
                if (uname != null || upass != null) {
                    UsernamePasswordStore.set(uname, upass);
                }
            }
            String endpoints_property = null;
            ElementProperty[] props = cc.getElementProperty();
            for (int i = 0; i < props.length; ++i) {
                if (props[i].getName().equals("ssl") && props[i].getValue().equals("required")) {
                    ORBManager.getCSIv2Props().put("com.sun.CSIV2.ssl.client.required", "true");
                }
                if (props[i].getName().equals("com.sun.appserv.iiop.loadbalancingpolicy")) {
                    loadBalancingPolicy = props[i].getValue();
                    lb_enabled = true;
                }
                if (!props[i].getName().equals("com.sun.appserv.iiop.endpoints")) continue;
                isEndpointPropertySpecifiedByUser = true;
                endpoints_property = props[i].getValue().trim();
                lb_enabled = true;
            }
            String jwsEndpointsProperty = System.getProperty(APPCLIENT_IIOP_FAILOVER_ENDPOINTS_PROPERTYNAME);
            if (jwsEndpointsProperty != null) {
                targetServerEndpoints = jwsEndpointsProperty;
                completeEndpointList.append(jwsEndpointsProperty);
                lb_enabled = true;
                _logger.fine("jwsEndpointsProperty = " + jwsEndpointsProperty);
            } else {
                if (isEndpointPropertySpecifiedByUser) {
                    _logger.warning("acc.targetserver.endpoints.warning");
                }
                _logger.fine("targetServerEndpoints = " + targetServerEndpoints + "endpoints_property = " + endpoints_property);
                if (lb_enabled) {
                    completeEndpointList.append(targetServerEndpoints.trim());
                    if (endpoints_property != null) {
                        completeEndpointList.append(",").append(endpoints_property);
                    }
                }
            }
            if (lb_enabled) {
                System.setProperty("com.sun.appserv.iiop.endpoints", completeEndpointList.toString());
                if (loadBalancingPolicy != null) {
                    System.setProperty("com.sun.appserv.iiop.loadbalancingpolicy", loadBalancingPolicy);
                }
                result = null;
            } else {
                result.setProperty(ORB_INITIAL_HOST_PROPERTYNAME, this.host);
                result.setProperty(ORB_INITIAL_PORT_PROPERTYNAME, this.port);
            }
            return result;
        }
        catch (ConfigException t) {
            _logger.log(Level.WARNING, "acc.acc_xml_file_error", new Object[]{clientXmlLocation, t.getMessage()});
            _logger.log(Level.FINE, "exception : " + t.toString(), t);
            throw t;
        }
    }

    private static void setSSLData(ClientContainer cc) {
        try {
            TargetServer tServer = cc.getTargetServer(0);
            Security security = tServer.getSecurity();
            if (security == null) {
                _logger.fine("No Security input set in ClientContainer.xml");
                return;
            }
            Ssl ssl = security.getSsl();
            if (ssl == null) {
                _logger.fine("No SSL input set in ClientContainer.xml");
                return;
            }
            SSLUtils.setAppclientSsl(ssl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void validateXMLFile(String xmlFullName) throws UserError {
        if (xmlFullName == null || xmlFullName.startsWith(DASH)) {
            this.usage();
        }
        try {
            File f = new File(xmlFullName);
            if (f != null && f.exists() && f.isFile() && f.canRead()) {
                return;
            }
            this.xmlMessage(xmlFullName);
        }
        catch (Exception ex) {
            this.xmlMessage(xmlFullName);
        }
    }

    private void shutDownSystemAdapters() {
        try {
            PoolManager poolmgr = Switch.getSwitch().getPoolManager();
            if (poolmgr != null) {
                Switch.getSwitch().getPoolManager().killFreeConnectionsInPools();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            ConnectorRegistry registry = ConnectorRegistry.getInstance();
            ActiveResourceAdapter activeRar = registry.getActiveResourceAdapter("jmsra");
            if (activeRar != null) {
                activeRar.destroy();
            }
        }
        catch (Exception e) {
            _logger.fine("Exception caught while shutting down system adapter:" + e.getMessage());
        }
    }

    private String getUsage() {
        return this.localStrings.getString("main.usage", "appclient [ -client <appjar> | <classfile> ] [-mainclass <appClass-name>|-name <display-name>] [-xml <xml>] [-textauth] [-user <username>] [-password <password>|-passwordfile <password-file>] [app-args]");
    }

    private void usage() {
        System.out.println(this.getUsage());
        System.exit(1);
    }

    private void xmlMessage(String xmlFullName) throws UserError {
        UserError ue = new UserError(this.localStrings.getString("main.cannot_read_clientContainer_xml", xmlFullName, "Client Container xml: " + xmlFullName + " not found or unable to read.\nYou may want to use the -xml option to locate your configuration xml."));
        ue.setUsage(this.getUsage());
        throw ue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadPasswordFromFile(String fileName) throws IOException {
        String string;
        block2: {
            BufferedInputStream inputStream = null;
            try {
                inputStream = new BufferedInputStream(new FileInputStream(fileName));
                Properties props = new Properties();
                props.load(inputStream);
                string = props.getProperty("PASSWORD");
                Object var6_5 = null;
                if (inputStream == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var6_6 = null;
                    if (inputStream == null) break block3;
                    ((InputStream)inputStream).close();
                }
                throw throwable;
            }
            ((InputStream)inputStream).close();
        }
        return string;
    }

    private String prepareJWSConfig() throws IOException, FileNotFoundException {
        return this.prepareJWSDefaultConfig();
    }

    private String prepareJWSDefaultConfig() throws IOException, FileNotFoundException {
        Object result = null;
        String sunACCTemplate = Util.loadResource(this.getClass(), SUN_ACC_DEFAULT_TEMPLATE);
        String wssClientConfigTemplate = Util.loadResource(this.getClass(), WSS_CLIENT_CONFIG_TEMPLATE);
        Properties tokenValues = new Properties(System.getProperties());
        String wssClientConfig = Util.replaceTokens(wssClientConfigTemplate, tokenValues);
        File wssClientConfigFile = Util.writeTextToTempFile(wssClientConfig, WSS_CLIENT_CONFIG_PREFIX, ".xml", this.retainTempFiles);
        _logger.fine("Temporary wss-client-config.xml file: " + wssClientConfigFile.getAbsolutePath() + lineSep);
        String quotedConfigFileSpec = wssClientConfigFile.getAbsolutePath().replaceAll("\\\\", "\\\\\\\\");
        tokenValues.setProperty(SUN_ACC_SECURITY_CONFIG_PROPERTY, quotedConfigFileSpec);
        String sunaccContent = Util.replaceTokens(sunACCTemplate, tokenValues);
        File sunaccFile = Util.writeTextToTempFile(sunaccContent, SUN_ACC_PREFIX, ".xml", this.retainTempFiles);
        _logger.fine("Temporary sun-acc.xml file: " + sunaccFile.getAbsolutePath());
        return sunaccFile.getAbsolutePath();
    }

    private void prepareJWSLoginConfig() {
        if (this.isJWS) {
            try {
                this.prepareJWSDefaultLoginConfig();
            }
            catch (Throwable thr) {
                throw new RuntimeException(this.localStrings.getString("appclient.errorPrepJWSLogginConfig"), thr);
            }
        }
    }

    private void prepareJWSDefaultLoginConfig() throws IOException, FileNotFoundException {
        String configContent = Util.loadResource(this.getClass(), LOGIN_CONF_TEMPLATE);
        File configFile = Util.writeTextToTempFile(configContent, LOGIN_CONF_FILE_PREFIX, LOGIN_CONF_FILE_SUFFIX, this.retainTempFiles);
        String configFilePath = configFile.getAbsolutePath();
        _logger.fine("Temporary appclientlogin.conf file: " + configFilePath);
        System.setProperty(LOGIN_CONF_PROPERTY_NAME, configFilePath);
    }

    private File findContainingJar(String target) throws IllegalArgumentException, URISyntaxException {
        File result = null;
        URL resourceURL = this.getClass().getResource(target);
        if (resourceURL != null) {
            URI uri = resourceURL.toURI();
            String scheme = uri.getScheme();
            String ssp = uri.getSchemeSpecificPart();
            if (scheme.equals("jar")) {
                int colon = ssp.indexOf(58);
                String subscheme = ssp.substring(0, colon);
                int excl = ssp.indexOf(33);
                String containingJarPath = ssp.substring(colon + 1, excl);
                result = new File(containingJarPath);
            } else if (scheme.equals("file")) {
                int resourceNamePosition = ssp.indexOf(target);
                String containingFilePath = ssp.substring(0, resourceNamePosition);
                result = new File(containingFilePath);
            } else {
                throw new IllegalArgumentException(resourceURL.toExternalForm());
            }
        }
        return result;
    }

    private File findAppClientFileForJWSLaunch() throws URISyntaxException {
        File containingJar = new File(System.getProperty("com.sun.aas.downloaded.appclient.jar"));
        _logger.fine("Location of appclient jar file: " + containingJar.getAbsolutePath());
        return containingJar;
    }

    private BufferedLogger prepareBufferedLogging() {
        BufferedLogger logger = new BufferedLogger();
        return logger;
    }

    static {
        lb_enabled = false;
    }

    private class BufferedHandler
    extends Handler {
        private Vector<LogRecord> buffer = new Vector();

        public BufferedHandler() {
            this.setLevel(Level.ALL);
            this.setFilter(null);
            this.setFormatter(new SimpleFormatter());
        }

        public synchronized void publish(LogRecord record) {
            if (this.buffer == null) {
                throw new IllegalStateException("Handler asked to publish log record after pushTo invoked");
            }
            this.buffer.add(record);
        }

        public synchronized void pushTo(Logger target) {
            if (this.buffer == null) {
                throw new IllegalStateException("Handler asked to push to target more than once");
            }
            for (LogRecord record : this.buffer) {
                target.log(record);
            }
            this.close();
        }

        public void close() throws SecurityException {
            this.buffer.clear();
            this.buffer = null;
        }

        public void flush() {
        }
    }

    private class BufferedLogger
    extends Logger {
        public BufferedLogger() {
            super(null, null);
            this.addHandler(new BufferedHandler());
        }

        public void pushTo(Logger target) {
            for (Handler handler : this.getHandlers()) {
                if (!(handler instanceof BufferedHandler)) continue;
                ((BufferedHandler)handler).pushTo(target);
            }
        }
    }

    private static class Cleanup
    extends Thread {
        private AppContainer appContainer = null;
        private AppClientInfo appClientInfo = null;
        private boolean cleanedUp = false;
        private InjectionManager injectionMgr = null;
        private ApplicationClientDescriptor appClient = null;
        private Class cls = null;
        private ScriptingSupport scriptingSupport = null;

        public void setAppContainer(AppContainer container) {
            this.appContainer = container;
        }

        public void setAppClientInfo(AppClientInfo info) {
            this.appClientInfo = info;
        }

        public void setInjectionManager(InjectionManager injMgr, Class cls, ApplicationClientDescriptor appDesc) {
            this.injectionMgr = injMgr;
            this.cls = cls;
            this.appClient = appDesc;
        }

        public void setScriptingSupport(ScriptingSupport scriptingSupport) {
            this.scriptingSupport = scriptingSupport;
        }

        public void run() {
            _logger.info("Clean-up starting");
            this.cleanUp();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanUp() {
            if (!this.cleanedUp) {
                try {
                    try {
                        if (this.scriptingSupport != null) {
                            this.scriptingSupport.close();
                            this.scriptingSupport = null;
                        }
                        if (this.appContainer != null) {
                            this.appContainer.postInvoke();
                        }
                        if (this.appClientInfo != null) {
                            this.appClientInfo.close();
                        }
                        if (this.injectionMgr != null) {
                            this.injectionMgr.invokeClassPreDestroy(this.cls, this.appClient);
                            this.injectionMgr = null;
                        }
                        if (this.appClient != null && this.appClient.getServiceReferenceDescriptors() != null) {
                            for (Object desc : this.appClient.getServiceReferenceDescriptors()) {
                                ClientPipeCloser.getInstance().cleanupClientPipe((ServiceReferenceDescriptor)desc);
                            }
                        }
                        Object var4_4 = null;
                        this.cleanedUp = true;
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        this.cleanedUp = true;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    this.cleanedUp = true;
                    throw throwable;
                }
            }
        }
    }
}

