/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.verifier.tests;

import com.sun.enterprise.admin.verifier.Result;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.logging.LogDomains;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class StaticTest {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");
    public static final String ADD = "ADD";
    public static final String DELETE = "DELETE";
    public static final String UPDATE = "UPDATE";
    public static final String SET = "SET";
    public static final String IAS_NAME = "com.sun.appserv:name=";
    public static final String XML_1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <xml>";
    public static final String XML_2 = "</xml>";

    public static boolean isPortValid(int i) {
        return i > 0 && i <= 65535;
    }

    public static boolean checkAddress(String address) {
        return !address.equalsIgnoreCase("ANY") && !address.equalsIgnoreCase("INADDR_ANY") && !address.equalsIgnoreCase("localhost");
    }

    public static boolean checkObjectName(String id) throws MalformedObjectNameException {
        String name = IAS_NAME + id;
        new ObjectName(name);
        return true;
    }

    public static boolean checkObjectName(String id, Result result) {
        try {
            return StaticTest.checkObjectName(id);
        }
        catch (MalformedObjectNameException ex) {
            _logger.log(Level.FINE, "serverxmlverifier.exception", ex);
            result.failed(ex.getMessage());
            return false;
        }
    }

    public static boolean checkXMLName(String name) throws SAXParseException, SAXException, IOException, ParserConfigurationException {
        String xml = XML_1 + name + XML_2;
        ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes());
        InputSource is = new InputSource(bais);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        db.parse(is);
        return true;
    }

    public static boolean checkXMLName(String name, Result result) throws SAXParseException {
        try {
            return StaticTest.checkXMLName(name);
        }
        catch (Exception s) {
            _logger.log(Level.FINE, "serverxmlverifier.exception", s);
            result.failed(s.getMessage());
            return false;
        }
    }

    public static Config getConfig(ConfigContext context) {
        Config mConfig = null;
        try {
            mConfig = ServerBeansFactory.getConfigBean(context);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mConfig;
    }
}

