/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.verifier.tests;

import com.sun.enterprise.admin.verifier.Result;
import com.sun.enterprise.admin.verifier.ServerCheck;
import com.sun.enterprise.admin.verifier.ServerXmlTest;
import com.sun.enterprise.admin.verifier.tests.StaticTest;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import javax.sql.XADataSource;

public class JdbcConnectionPoolTest
extends ServerXmlTest
implements ServerCheck {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");
    static int minPool = 0;
    static String connValReqd = null;
    static String connValMethod = null;

    public Result check(ConfigContext context) {
        Result result = super.getInitializedResult();
        return result;
    }

    public Result check(ConfigContextEvent ccce) {
        Result result = new Result();
        result.passed("Passed **");
        ConfigContext context = ccce.getConfigContext();
        Object value = ccce.getObject();
        String choice = ccce.getChoice();
        String beanName = ccce.getBeanName();
        if (beanName != null) {
            String name = ccce.getName();
            return this.testSave(name, (String)value);
        }
        JdbcConnectionPool pool = (JdbcConnectionPool)value;
        String poolName = pool.getName();
        if (!StaticTest.checkObjectName(poolName, result)) {
            result.failed("Connection Pool Name Invalid ");
            return result;
        }
        result.passed("Valid Object Name");
        String datasourceClassname = pool.getDatasourceClassname();
        if (choice != null && choice.equals("DELETE")) {
            try {
                Domain domain = (Domain)context.getRootConfigBean();
                Resources resource = domain.getResources();
                JdbcResource[] jdbcResource = resource.getJdbcResource();
                if (jdbcResource.length == 0) {
                    result.passed("Connect Pool not used by data source");
                }
                for (int i = 0; i < jdbcResource.length; ++i) {
                    if (jdbcResource[i].getPoolName().equals(poolName)) {
                        result.failed("Connection Pool Used by Existing data source, cannot delete pool");
                    }
                    result.passed("Connect Pool not used by data source");
                }
            }
            catch (Exception e) {}
        } else if (pool.isIsConnectionValidationRequired() && pool.getConnectionValidationMethod().equals("table")) {
            if (pool.getValidationTableName() == null || pool.getValidationTableName().equals("")) {
                result.failed("Required Table Name if Connection validation method is Table");
            } else {
                result.passed("Validation Table Name");
            }
        } else {
            result.passed("****** Passed Validation Table Name");
        }
        return result;
    }

    public Result testSave(String name, String value) {
        Result result = new Result();
        result.passed("Passed **");
        if (name.equals("steady-pool-size")) {
            try {
                minPool = Integer.parseInt(value);
                result.passed("Passed ");
            }
            catch (NumberFormatException e) {
                result.failed("Bad Number : Steady pool size");
            }
        }
        if (name.equals("max-pool-size")) {
            try {
                int maxPool = Integer.parseInt(value);
                if (maxPool < minPool) {
                    result.failed("Steady Pool size must be less than or equal to Maximum Pool size");
                } else {
                    result.passed("Passed ");
                }
            }
            catch (NumberFormatException e) {
                result.failed("Bad Number : Max pool size");
            }
        }
        if (name.equals("is-connection-validation-required")) {
            connValReqd = value;
        }
        if (name.equals("connection-validation-method")) {
            connValMethod = value;
        }
        if (name.equals("validation-table-name")) {
            if (connValReqd.equals("true")) {
                if (connValMethod.equals("table")) {
                    if (value == null || value.equals("")) {
                        result.failed("Required table name");
                    } else {
                        result.passed("Passed ***");
                    }
                } else {
                    result.passed("Passed ***");
                }
            } else {
                result.passed("Passed ***");
            }
        }
        if (name.equals("transaction-isolation-level") && value != null) {
            String isolation = value;
            if (isolation.equals("")) {
                result.failed("Transaction Isolation Level not specified");
            } else if (isolation.equals("read-uncommitted") || isolation.equals("read-committed") || isolation.equals("repeatable-read") || isolation.equals("serializable")) {
                result.passed("Valid Transaction Isolation Level");
            } else {
                result.failed("Invalid Transaction Isolation Level: " + isolation);
            }
        }
        if (name.equals("idle-timeout-in-seconds") && value != null) {
            try {
                Integer.parseInt(value);
                result.passed("Passed ***");
            }
            catch (NumberFormatException e) {
                result.failed("Idle Timeout : invalid number");
            }
        }
        return result;
    }

    public boolean isInValidDataSource(Result result, String datasourceClassname) {
        boolean failed = true;
        try {
            Class<?> c1 = Class.forName(datasourceClassname);
            Object obj = c1.newInstance();
            if (obj instanceof DataSource) {
                result.passed("Valid Data Source");
                failed = false;
            } else if (obj instanceof XADataSource) {
                result.passed("Valid XA DataSource");
                failed = false;
            } else {
                result.failed("Invalid  Data Source Class not implementing, javax.sql.DataSource or javax.sql.XADataSource");
            }
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "serverxmlverifier.error_instantiation", e.getMessage());
            result.failed("Invalid DataSource class");
        }
        return failed;
    }
}

