/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.mbean.config;

import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.admin.common.EntityStatus;
import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.common.constant.ConfigAttributeName;
import com.sun.enterprise.admin.common.exception.J2EEEjbJarModuleException;
import com.sun.enterprise.admin.common.exception.MBeanConfigException;
import com.sun.enterprise.admin.event.AdminEventCache;
import com.sun.enterprise.admin.event.AdminEventMulticaster;
import com.sun.enterprise.admin.event.AdminEventResult;
import com.sun.enterprise.admin.event.ModuleDeployEvent;
import com.sun.enterprise.admin.server.core.channel.AdminChannel;
import com.sun.enterprise.admin.server.core.channel.RMIClient;
import com.sun.enterprise.admin.server.core.mbean.config.ConfigMBeanBase;
import com.sun.enterprise.admin.server.core.mbean.config.ModulesXMLHelper;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class ManagedStandaloneJ2EEEjbJarModule
extends ConfigMBeanBase
implements ConfigAttributeName.StandaloneEjbJarModule {
    private static final String[][] MAPLIST = new String[][]{{"name", "@name"}, {"location", "@location"}, {"description", "@description"}};
    private static final String[] ATTRIBUTES = new String[]{"name, String,     R", "location, String,     RW", "description, String,     RW"};
    private static final String[] OPERATIONS = new String[]{"getStatus(),            INFO", "enable(),               ACTION", "disable(),              ACTION", "start(),                ACTION", "stop(),                 ACTION", "getState(),             INFO", "getEnterpriseBeans(),   INFO", "getSessionEJBs(),       INFO", "getEntityEJBs(),        INFO"};

    public ManagedStandaloneJ2EEEjbJarModule() throws MBeanConfigException {
        this.setDescriptions(MAPLIST, ATTRIBUTES, OPERATIONS);
    }

    public ManagedStandaloneJ2EEEjbJarModule(String instanceName, String moduleName) throws MBeanConfigException {
        this(instanceName, moduleName, null);
    }

    public ManagedStandaloneJ2EEEjbJarModule(String instanceName, String moduleName, AdminContext adminContext) throws MBeanConfigException {
        this();
        this.setAdminContext(adminContext);
        this.initialize("standalone-ejb-module", new String[]{instanceName, moduleName});
    }

    public EntityStatus getStatus() throws J2EEEjbJarModuleException {
        EntityStatus status = null;
        try {
            boolean isModuleEnabled = true;
            status = new EntityStatus();
            if (isModuleEnabled) {
                status.setEnabled();
            } else {
                status.setDisabled();
            }
        }
        catch (Exception e) {
            sLogger.throwing(this.getClass().getName(), "getStatus", e);
            throw new J2EEEjbJarModuleException(e.getMessage());
        }
        return status;
    }

    public void disable() throws J2EEEjbJarModuleException {
    }

    public void stop() throws J2EEEjbJarModuleException {
        try {
            String moduleName = (String)this.getAttribute("name");
            this.multicastAdminEvent(moduleName, "disable");
        }
        catch (Exception e) {
            sLogger.throwing(this.getClass().getName(), "stop", e);
            throw new J2EEEjbJarModuleException(e.getMessage());
        }
    }

    public Integer getState() throws J2EEEjbJarModuleException {
        try {
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            ServerContext serverContext = ApplicationServer.getServerContext();
            ObjectName objName = new ObjectName(serverContext.getDefaultDomainName() + ":" + "j2eeType=EJBModule," + "name=" + (String)this.getAttribute("name") + "," + "J2EEApplication=" + "null" + "," + "J2EEServer=" + serverContext.getInstanceName());
            Integer intObj = (Integer)mbs.getAttribute(objName, "state");
            return intObj;
        }
        catch (Exception e) {
            sLogger.throwing(this.getClass().getName(), "stop", e);
            throw new J2EEEjbJarModuleException(e.getMessage());
        }
    }

    public void enable() throws J2EEEjbJarModuleException {
    }

    public void start() throws J2EEEjbJarModuleException {
        try {
            String moduleName = (String)this.getAttribute("name");
            this.multicastAdminEvent(moduleName, "enable");
        }
        catch (Exception e) {
            sLogger.throwing(this.getClass().getName(), "start", e);
            throw new J2EEEjbJarModuleException(e.getMessage());
        }
    }

    public String[] getEnterpriseBeans() throws J2EEEjbJarModuleException {
        return this.getBeansByType(255);
    }

    public String[] getSessionEJBs() throws J2EEEjbJarModuleException {
        return this.getBeansByType(1);
    }

    public String[] getEntityEJBs() throws J2EEEjbJarModuleException {
        return this.getBeansByType(2);
    }

    private String[] getBeansByType(int ejbType) throws J2EEEjbJarModuleException {
        try {
            String location = (String)this.getAttribute("location");
            return ModulesXMLHelper.getEnterpriseBeansForEjbModule(location, null, ejbType);
        }
        catch (Exception e) {
            sLogger.throwing(this.getClass().getName(), "getBeansByType", e);
            throw new J2EEEjbJarModuleException(e.getMessage());
        }
    }

    private void multicastAdminEvent(String entityName, String actionCode) throws J2EEEjbJarModuleException {
        String instanceName = super.getServerInstanceName();
        InstanceEnvironment instEnv = new InstanceEnvironment(instanceName);
        try {
            instEnv.applyServerXmlChanges(false);
        }
        catch (Exception e) {
            sLogger.throwing(this.getClass().getName(), "getBeansByType", e);
            throw new J2EEEjbJarModuleException(e.getMessage());
        }
        ModuleDeployEvent event = new ModuleDeployEvent(instanceName, entityName, "ejb", actionCode);
        RMIClient serverInstancePinger = AdminChannel.getRMIClient(instanceName);
        if (serverInstancePinger.getInstanceStatusCode() != 0) {
            return;
        }
        AdminEventResult multicastResult = AdminEventMulticaster.multicastEvent(event);
        if (!"success".equals(multicastResult.getResultCode())) {
            AdminEventCache cache = AdminEventCache.getInstance(instanceName);
            cache.setRestartNeeded(true);
        }
    }
}

