/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.mbean.config;

import com.sun.enterprise.admin.common.exception.MBeanConfigException;
import com.sun.enterprise.admin.common.exception.PortInUseException;
import com.sun.enterprise.admin.common.exception.ServerInstanceException;
import com.sun.enterprise.admin.server.core.mbean.config.ConfigMBeanBase;
import com.sun.enterprise.admin.server.core.mbean.config.ManagedServerInstance;
import com.sun.enterprise.admin.util.HostAndPort;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.instance.InstanceEnvironment;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ManagedAdminServerInstance
extends ConfigMBeanBase {
    private static final String[][] MAPLIST = new String[0][];
    private static final String[] ATTRIBUTES = new String[0];
    private static final String[] OPERATIONS = new String[]{"applyConfigChanges(), ACTION", "useManualConfigChanges(), ACTION", "getHostAndPort(),  INFO", "isApplyNeeded(), INFO", "isRestartNeeded(), INFO"};
    private static final Logger _logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private ManagedServerInstance mDelegate;
    private boolean mRestartNeeded = false;

    public ManagedAdminServerInstance() throws MBeanConfigException {
        this.setDescriptions(MAPLIST, ATTRIBUTES, OPERATIONS);
        this.initialize("server-instance", new String[]{"admin-server"});
    }

    public boolean applyConfigChanges() throws ServerInstanceException {
        try {
            InstanceEnvironment ie = new InstanceEnvironment("admin-server");
            this.initDelegate();
            ConfigContext ctx = this.mDelegate.getConfigContext("admin-server");
            ctx.resetConfigChangeList();
            this.mRestartNeeded = true;
        }
        catch (ConfigException ce) {
            _logger.log(Level.INFO, "mbean.config.admin.apply_failed", ce.getLocalizedMessage());
            _logger.log(Level.FINEST, ce.getMessage(), ce);
            throw new ServerInstanceException(ce.getLocalizedMessage());
        }
        return this.mRestartNeeded;
    }

    public boolean canApplyConfigChanges() {
        boolean canApply = false;
        try {
            this.initDelegate();
            canApply = true;
        }
        catch (Exception ex) {
            _logger.log(Level.INFO, "mbean.config.admin.canapply_failed", ex.getLocalizedMessage());
            _logger.log(Level.FINEST, ex.getLocalizedMessage(), ex);
        }
        return canApply;
    }

    public boolean useManualConfigChanges() throws ServerInstanceException {
        try {
            this.initDelegate();
            InstanceEnvironment ie = new InstanceEnvironment("admin-server");
            this.mDelegate.reloadAfterChange(ie);
            this.mRestartNeeded = true;
        }
        catch (ConfigException ce) {
            _logger.log(Level.INFO, "mbean.config.admin.usemanual_failed", ce.getMessage());
            _logger.log(Level.FINEST, ce.getMessage(), ce);
            throw new ServerInstanceException(ce.getLocalizedMessage());
        }
        return this.mRestartNeeded;
    }

    public boolean isApplyNeeded(boolean check) throws ServerInstanceException {
        return this.isApplyNeeded();
    }

    public boolean isApplyNeeded() throws ServerInstanceException {
        boolean applyNeeded = false;
        try {
            this.initDelegate();
            ConfigContext ctx = this.mDelegate.getConfigContext("admin-server");
            applyNeeded = ctx.isChanged();
        }
        catch (ConfigException ce) {
            _logger.log(Level.INFO, "mbean.config.admin.applyneeded_failed", ce.getMessage());
            _logger.log(Level.FINEST, ce.getMessage(), ce);
            throw new ServerInstanceException(ce.getLocalizedMessage());
        }
        return applyNeeded;
    }

    public boolean isRestartNeeded() throws ServerInstanceException {
        return this.mRestartNeeded;
    }

    public HostAndPort getHostAndPort() throws ServerInstanceException {
        return this.getHttpListenerHostPort();
    }

    private synchronized void initDelegate() throws ServerInstanceException {
        if (this.mDelegate != null) {
            return;
        }
        try {
            HostAndPort hp = this.getHttpListenerHostPort();
            this.mDelegate = new ManagedServerInstance("admin-server", hp, false);
        }
        catch (ServerInstanceException sie) {
            throw sie;
        }
        catch (PortInUseException piue) {
        }
        catch (Exception e) {
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
    }

    private HostAndPort getHttpListenerHostPort() throws ServerInstanceException {
        HostAndPort hAndp = null;
        try {
            Config config = (Config)super.getConfigBeanByXPath("/domain/configs/config[@name='server-config']");
            HttpService https = config.getHttpService();
            HttpListener[] hlArray = https.getHttpListener();
            HttpListener ls = hlArray[0];
            for (int i = 0; i < hlArray.length; ++i) {
                if (!hlArray[i].isEnabled()) continue;
                ls = hlArray[i];
                break;
            }
            String port = ls.getPort();
            int intPort = Integer.parseInt(port);
            hAndp = new HostAndPort("localhost", intPort);
        }
        catch (Exception e) {
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
        return hAndp;
    }
}

