/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.jmx.tester;

import com.sun.enterprise.admin.server.core.jmx.MBeanIntrospector;
import com.sun.enterprise.admin.util.Debug;
import java.io.BufferedReader;
import java.io.FileReader;
import java.lang.constant.Constable;
import javax.management.NotCompliantMBeanException;

public class MBeanIntrospectorTester {
    public static void main(String[] args) throws Exception {
        String str;
        BufferedReader reader = new BufferedReader(new FileReader(args[0]));
        long begin = System.currentTimeMillis();
        while ((str = reader.readLine()) != null) {
            if (MBeanIntrospectorTester.isPrimitive(str = str.trim())) {
                try {
                    MBeanIntrospectorTester.checkPrimitive(str);
                    Debug.println("Test failed : " + str);
                }
                catch (NotCompliantMBeanException e) {}
                continue;
            }
            try {
                MBeanIntrospectorTester.checkNonPrimitive(str);
            }
            catch (NotCompliantMBeanException e) {
                Debug.println("Not Compliant : " + str);
            }
        }
        long end = System.currentTimeMillis();
        reader.close();
    }

    private static boolean isPrimitive(String str) {
        return str.equals("int") || str.equals("boolean") || str.equals("short") || str.equals("byte") || str.equals("char") || str.equals("float") || str.equals("long") || str.equals("double");
    }

    private static void checkPrimitive(String str) throws NotCompliantMBeanException {
        Class<Constable> c = null;
        if (str.equals("int")) {
            c = Integer.TYPE;
        } else if (str.equals("boolean")) {
            c = Boolean.TYPE;
        } else if (str.equals("short")) {
            c = Short.TYPE;
        } else if (str.equals("byte")) {
            c = Byte.TYPE;
        } else if (str.equals("char")) {
            c = Character.TYPE;
        } else if (str.equals("float")) {
            c = Float.TYPE;
        } else if (str.equals("long")) {
            c = Long.TYPE;
        } else if (str.equals("double")) {
            c = Double.TYPE;
        }
        new MBeanIntrospector(c);
    }

    private static void checkNonPrimitive(String str) throws ClassNotFoundException, NotCompliantMBeanException {
        Class<?> c = Class.forName(str);
        MBeanIntrospector intr = new MBeanIntrospector(c);
        String msg = " Type = ";
        msg = msg + (intr.isStandardMBean() ? "isStandard" : (intr.isDynamicMBean() ? "isDynamic" : "Don't know"));
        Debug.println(str + msg);
        Debug.println("Management interface = " + intr.getMBeanInterfaceClass().getName());
    }
}

