/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.jmx;

import com.sun.appserv.management.helper.AMXDebugHelper;
import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.admin.common.ObjectNameHelper;
import com.sun.enterprise.admin.common.ObjectNames;
import com.sun.enterprise.admin.common.exception.AFRuntimeException;
import com.sun.enterprise.admin.common.exception.AFRuntimeStoreException;
import com.sun.enterprise.admin.event.AdminEventCache;
import com.sun.enterprise.admin.meta.MBeanRegistry;
import com.sun.enterprise.admin.meta.MBeanRegistryFactory;
import com.sun.enterprise.admin.server.core.jmx.storage.MBeanManufacturer;
import com.sun.enterprise.admin.server.core.jmx.storage.PersistenceChecker;
import com.sun.enterprise.admin.util.proxy.ProxyFactory;
import com.sun.enterprise.interceptor.DynamicInterceptorHook;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ondemand.entry.ServerEntryHelper;
import com.sun.enterprise.util.i18n.StringManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;

public final class SunoneInterceptor
implements DynamicInterceptorHook {
    protected final AMXDebugHelper mDebug = new AMXDebugHelper("__SunoneInterceptor__");
    private static final String HOT_CONFIG_METHOD_NAME = "canApplyConfigChanges";
    private static final String FORCE_APPLY_METHOD_NAME = "overwriteConfigChanges";
    private static final String APPLY_METHOD_NAME = "applyConfigChanges";
    private static final String USE_MANUAL_METHOD_NAME = "useManualConfigChanges";
    private static final String GET_HOST_AND_PORT_METHOD_NAME = "getHostAndPort";
    private static final Logger sLogger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final StringManager localStrings = StringManager.getManager(SunoneInterceptor.class);
    private final AdminContext adminContext;
    private final MBeanServer delegateMBeanServer;
    private final MBeanServer proxyMBeanServer;
    private final MBeanServer outerMBeanServer;
    private static SunoneInterceptor _Instance = null;
    private static final String DottedMBeansIniterClassName = "com.sun.enterprise.admin.mbeans.DottedNameMBeansIniter";
    private static boolean _alreadyCalled = false;

    protected final void debug(Object ... args) {
        this.mDebug.println(args);
    }

    private SunoneInterceptor(AdminContext adminContextIn, MBeanServer outerMBeanServerIn, MBeanServer delegateMBeanServerIn) {
        this.mDebug.setEchoToStdOut(true);
        this.debug("SunoneInterceptor.SunoneInterceptor");
        this.adminContext = adminContextIn;
        this.delegateMBeanServer = delegateMBeanServerIn;
        this.outerMBeanServer = outerMBeanServerIn;
        this.proxyMBeanServer = (MBeanServer)ProxyFactory.createProxy(MBeanServer.class, this.delegateMBeanServer, this.adminContext.getMBeanServerInterceptor());
        this.logMBeanServerInfo();
        try {
            this.initialize();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized SunoneInterceptor createInstance(AdminContext adminContext, MBeanServer outerMBeanServer, MBeanServer delegateMBeanServer) {
        if (_Instance != null) {
            throw new IllegalStateException();
        }
        _Instance = new SunoneInterceptor(adminContext, outerMBeanServer, delegateMBeanServer);
        return _Instance;
    }

    public static synchronized SunoneInterceptor getInstance() {
        if (_Instance == null) {
            throw new IllegalStateException();
        }
        return _Instance;
    }

    private void initialize() throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectName controllerObjectName = ObjectNames.getControllerObjectName();
        ObjectName configObjectName = ObjectNames.getGenericConfiguratorObjectName();
        ObjectName[] objectNames = new ObjectName[]{controllerObjectName, configObjectName};
        String controllerClassName = "com.sun.enterprise.admin.server.core.mbean.config.ServerController";
        String configClassName = "com.sun.enterprise.admin.server.core.mbean.config.GenericConfigurator";
        String[] clNames = new String[]{"com.sun.enterprise.admin.server.core.mbean.config.ServerController", "com.sun.enterprise.admin.server.core.mbean.config.GenericConfigurator"};
        for (int i = 0; i < clNames.length; ++i) {
            this.createAndRegister(clNames[i], objectNames[i]);
        }
        this.registerDottedNameSupport();
    }

    private void registerDottedNameSupport() throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> initerClass = Class.forName(DottedMBeansIniterClassName);
        Class[] signature = new Class[]{MBeanServer.class};
        Constructor<?> constructor = initerClass.getConstructor(signature);
        constructor.newInstance(this.outerMBeanServer);
    }

    private ObjectInstance createAndRegister(String className, ObjectName objectName) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        Class<?> mbeanClass = Class.forName(className);
        Object mbeanImpl = mbeanClass.newInstance();
        ObjectInstance mbeanInstance = this.registerMBean(mbeanImpl, objectName);
        sLogger.log(Level.FINE, "core.system_mbean_init_ok", objectName.toString());
        return mbeanInstance;
    }

    private ObjectInstance registerMBean(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return this.outerMBeanServer.registerMBean(object, objectName);
    }

    private void generateEntryContext(Object obj) {
        ServerEntryHelper.generateMbeanEntryContext((ObjectName)obj);
    }

    public Object invoke(ObjectName objectName, String operationName, Object[] params, String[] signature) throws ReflectionException, InstanceNotFoundException, MBeanException {
        this.generateEntryContext(objectName);
        if (this.isInstanceMBean(objectName) && this.isConfigCheckRequired(operationName)) {
            this.checkHotConfigChanges(objectName);
        }
        if (FORCE_APPLY_METHOD_NAME.equals(operationName)) {
            String instanceName = ObjectNameHelper.getServerInstanceName(objectName);
            AdminEventCache cache = AdminEventCache.getInstance(instanceName);
            cache.setRestartNeeded(true);
        }
        this.registerWithPersistenceCheck(objectName);
        Object actualResult = this.proxyMBeanServer.invoke(objectName, operationName, params, signature);
        return actualResult;
    }

    public Object getAttribute(ObjectName objectName, String attributeName) throws InstanceNotFoundException, AttributeNotFoundException, MBeanException, ReflectionException {
        if (this.isInstanceMBean(objectName)) {
            this.checkHotConfigChanges(objectName);
        }
        this.registerWithPersistenceCheck(objectName);
        Object value = this.proxyMBeanServer.getAttribute(objectName, attributeName);
        return value;
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, MBeanException, ReflectionException, InvalidAttributeValueException {
        if (this.isInstanceMBean(objectName)) {
            this.checkHotConfigChanges(objectName);
        }
        this.registerWithPersistenceCheck(objectName);
        this.proxyMBeanServer.setAttribute(objectName, attribute);
    }

    public AttributeList getAttributes(ObjectName objectName, String[] attrNames) throws InstanceNotFoundException, ReflectionException {
        this.checkHotConfigChanges(objectName);
        this.registerWithPersistenceCheck(objectName);
        return this.proxyMBeanServer.getAttributes(objectName, attrNames);
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        if (this.isInstanceMBean(objectName)) {
            this.checkHotConfigChanges(objectName);
        }
        this.registerWithPersistenceCheck(objectName);
        return this.proxyMBeanServer.setAttributes(objectName, attributeList);
    }

    public MBeanInfo getMBeanInfo(ObjectName objName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        this.registerWithPersistenceCheck(objName);
        return this.proxyMBeanServer.getMBeanInfo(objName);
    }

    private void checkHotConfigChanges(ObjectName mbeanName) {
        try {
            String instanceName = ApplicationServer.getServerContext().getInstanceName();
            ObjectName instanceObjectName = ObjectNames.getServerInstanceObjectName(instanceName);
            Object canApply = this.invoke(instanceObjectName, HOT_CONFIG_METHOD_NAME, null, null);
            if (canApply.equals(Boolean.FALSE)) {
                String msg = localStrings.getString("admin.server.core.jmx.configuration_changed_apply_changes", instanceName);
                throw new AFRuntimeStoreException(msg);
            }
        }
        catch (AFRuntimeStoreException af) {
            throw af;
        }
        catch (Exception e) {
            String msg = localStrings.getString("admin.server.core.jmx.bad_server_configuration");
            sLogger.log(Level.INFO, msg, e);
            throw new AFRuntimeException(msg, e);
        }
    }

    private boolean isInstanceMBean(ObjectName mbeanName) {
        return ObjectNameHelper.getServerInstanceName(mbeanName) != null;
    }

    private boolean isConfigCheckRequired(String operationName) {
        if (GET_HOST_AND_PORT_METHOD_NAME.equals(operationName)) {
            return false;
        }
        if (FORCE_APPLY_METHOD_NAME.equals(operationName)) {
            return false;
        }
        if (USE_MANUAL_METHOD_NAME.equals(operationName)) {
            return false;
        }
        if (HOT_CONFIG_METHOD_NAME.equals(operationName)) {
            return false;
        }
        return !"getMBeanInfo".equals(operationName);
    }

    public ClassLoader getClassLoader(ObjectName objectName) throws InstanceNotFoundException {
        this.debug("SunoneInterceptor: getClassLoader: " + objectName);
        this.registerWithPersistenceCheck(objectName);
        return this.proxyMBeanServer.getClassLoader(objectName);
    }

    public ClassLoader getClassLoaderFor(ObjectName objectName) throws InstanceNotFoundException {
        this.debug("SunoneInterceptor: getClassLoaderFor: " + objectName);
        this.registerWithPersistenceCheck(objectName);
        return this.proxyMBeanServer.getClassLoaderFor(objectName);
    }

    private ClassLoaderRepository getClassLoaderRepository() {
        this.debug("SunoneInterceptor: getClassLoaderRepository()");
        return this.proxyMBeanServer.getClassLoaderRepository();
    }

    private void logMBeanServerInfo() {
        try {
            String name = "JMImplementation:type=MBeanServerDelegate";
            ObjectName oName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            sLogger.log(Level.FINE, "core.mbs_info");
            String attrName = "ImplementationName";
            String result = (String)this.proxyMBeanServer.getAttribute(oName, attrName);
            sLogger.log(Level.FINE, "core.mbs_implementation", result);
            attrName = "ImplementationVendor";
            result = (String)this.proxyMBeanServer.getAttribute(oName, attrName);
            sLogger.log(Level.FINE, "core.mbs_vendor", result);
            attrName = "ImplementationVersion";
            result = (String)this.proxyMBeanServer.getAttribute(oName, attrName);
            sLogger.log(Level.FINE, "core.jmx_impl_version", result);
            attrName = "MBeanServerId";
            result = (String)this.proxyMBeanServer.getAttribute(oName, attrName);
            sLogger.log(Level.FINE, "core.mbs_id", result);
            result = this.proxyMBeanServer.getClass().getName();
            sLogger.log(Level.FINE, "core_mbs_classname", result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized void manufactureAndRegisterMBean(ObjectName oName) throws Exception {
        if (this.outerMBeanServer.isRegistered(oName)) {
            this.debug("manufactureAndRegisterMBean: already registered: " + oName);
            return;
        }
        Object product = this.manufactureMBean(oName);
        if (product == null) {
            this.debug("manufactureAndRegisterMBean: can't manufacture: " + oName);
            String msg = localStrings.getString("admin.server.core.jmx.lazybean_not_found", oName.toString());
            throw new InstanceNotFoundException(msg);
        }
        this.debug("manufactureAndRegisterMBean: registering: " + oName);
        this.registerMBean(product, oName);
        this.debug("manufactureAndRegisterMBean: registered: " + oName);
        sLogger.log(Level.FINE, "core.create_and_register", oName);
    }

    private void registerWithPersistenceCheck(ObjectName oName) throws InstanceNotFoundException {
        if ("ias".equals(oName.getDomain())) {
            throw new RuntimeException("JMX domain 'ias' not suppported");
        }
        if (!this.outerMBeanServer.isRegistered(oName)) {
            this.debug("MBean NOT registered, will try to manufacture: " + oName);
            try {
                this.manufactureAndRegisterMBean(oName);
                this.debug("Manufactured: " + oName);
            }
            catch (InstanceNotFoundException infe) {
                this.debug("FAILED to manufacture: " + oName + " | " + infe);
                throw infe;
            }
            catch (RuntimeException re) {
                this.debug("FAILED to manufacture: " + oName + " | " + re);
                throw re;
            }
            catch (Exception e) {
                this.debug("FAILED to manufacture: " + oName + " | " + e);
                throw new RuntimeException(e);
            }
        }
    }

    private Object manufactureMBean(ObjectName oName) throws InstanceNotFoundException {
        PersistenceChecker checker = new PersistenceChecker();
        checker.setAdminContext(this.adminContext);
        Object storedObject = checker.findElement(oName);
        Object match = null;
        if (storedObject != null) {
            MBeanManufacturer producer = new MBeanManufacturer(oName, storedObject);
            producer.setAdminContext(this.adminContext);
            match = producer.createMBeanInstance();
        } else {
            sLogger.log(Level.FINEST, "core.not_in_config", oName);
        }
        return match;
    }

    private void shutdown() {
        MBeanServerFactory.releaseMBeanServer(this.proxyMBeanServer);
        sLogger.log(Level.FINE, "core.release_mbs");
    }

    private void logMBeanInfo(ObjectName oName) {
        if (!sLogger.isLoggable(Level.FINEST)) {
            return;
        }
        MBeanInfo info = null;
        try {
            info = this.proxyMBeanServer.getMBeanInfo(oName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        sLogger.log(Level.FINEST, "\nCLASSNAME: \t" + info.getClassName());
        sLogger.log(Level.FINEST, "\nDESCRIPTION: \t" + info.getDescription());
        sLogger.log(Level.FINEST, "\nATTRIBUTES");
        MBeanAttributeInfo[] attrInfo = info.getAttributes();
        if (attrInfo.length > 0) {
            for (int i = 0; i < attrInfo.length; ++i) {
                sLogger.log(Level.FINEST, " ** NAME: \t" + attrInfo[i].getName());
                sLogger.log(Level.FINEST, "    DESCR: \t" + attrInfo[i].getDescription());
                sLogger.log(Level.FINEST, "    TYPE: \t" + attrInfo[i].getType() + "\tREAD: " + attrInfo[i].isReadable() + "\tWRITE: " + attrInfo[i].isWritable());
            }
        } else {
            sLogger.log(Level.FINEST, " ** No attributes **");
        }
        sLogger.log(Level.FINEST, "\nCONSTRUCTORS");
        MBeanConstructorInfo[] constrInfo = info.getConstructors();
        for (int i = 0; i < constrInfo.length; ++i) {
            sLogger.log(Level.FINEST, " ** NAME: \t" + constrInfo[i].getName());
            sLogger.log(Level.FINEST, "    DESCR: \t" + constrInfo[i].getDescription());
            sLogger.log(Level.FINEST, "    PARAM: \t" + constrInfo[i].getSignature().length + " parameter(s)");
        }
        sLogger.log(Level.FINEST, "\nOPERATIONS");
        MBeanOperationInfo[] opInfo = info.getOperations();
        if (opInfo.length > 0) {
            for (int i = 0; i < opInfo.length; ++i) {
                sLogger.log(Level.FINEST, " ** NAME: \t" + opInfo[i].getName());
                sLogger.log(Level.FINEST, "    DESCR: \t" + opInfo[i].getDescription());
                sLogger.log(Level.FINEST, "    PARAM: \t" + opInfo[i].getSignature().length + " parameter(s)");
            }
        } else {
            sLogger.log(Level.FINEST, " ** No operations ** ");
        }
        sLogger.log(Level.FINEST, "\nNOTIFICATIONS");
        MBeanNotificationInfo[] notifInfo = info.getNotifications();
        if (notifInfo.length > 0) {
            for (int i = 0; i < notifInfo.length; ++i) {
                sLogger.log(Level.FINEST, " ** NAME: \t" + notifInfo[i].getName());
                sLogger.log(Level.FINEST, "    DESCR: \t" + notifInfo[i].getDescription());
            }
        } else {
            sLogger.log(Level.FINEST, " ** No notifications **");
        }
    }

    public synchronized void registerConfigMBeans() {
        if (!_alreadyCalled) {
            _alreadyCalled = true;
            try {
                MBeanRegistry mr = MBeanRegistryFactory.getAdminMBeanRegistry();
                mr.instantiateAndRegisterAllConfigMBeans(this.adminContext.getAdminConfigContext(), ApplicationServer.getServerContext().getDefaultDomainName());
            }
            catch (Throwable t) {
                sLogger.log(Level.WARNING, "Error in registering configMBeans", t);
            }
        }
    }
}

