/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core;

import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.admin.common.exception.DeploymentException;
import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.admin.event.AdminEventCache;
import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.AdminEventMulticaster;
import com.sun.enterprise.admin.event.AdminEventResult;
import com.sun.enterprise.admin.event.ApplicationDeployEvent;
import com.sun.enterprise.admin.event.EventBuilder;
import com.sun.enterprise.admin.event.EventContext;
import com.sun.enterprise.admin.event.EventStack;
import com.sun.enterprise.admin.event.ModuleDeployEvent;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeploymentNotificationHelper {
    public static final Logger sLogger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final int CONFIG_CHANGED = 7;
    private static StringManager localStrings = StringManager.getManager(DeploymentNotificationHelper.class);

    public static boolean multicastEvent(int eventType, String entityName, String moduleType, boolean cascade, boolean forceDeploy, int loadUnloadAction, String targetName) throws DeploymentException {
        AdminEvent event;
        block20: {
            event = null;
            EventBuilder builder = new EventBuilder();
            EventStack stack = EventContext.getEventStackFromThreadLocal();
            ConfigContext ctx = stack.getConfigContext();
            stack.setTarget(targetName);
            stack.setConfigChangeList(ctx.getConfigChangeList());
            try {
                if (eventType == 1) {
                    event = builder.createApplicationDeployEvent("deploy", entityName, false, forceDeploy, loadUnloadAction);
                    break block20;
                }
                if (eventType == 2) {
                    event = builder.createApplicationDeployEvent("undeploy", entityName, cascade, forceDeploy, loadUnloadAction);
                    break block20;
                }
                if (eventType == 3) {
                    event = builder.createApplicationDeployEvent("redeploy", entityName, false, forceDeploy, loadUnloadAction);
                    break block20;
                }
                if (eventType == 4) {
                    event = builder.createModuleDeployEvent("deploy", entityName, moduleType, cascade, forceDeploy);
                    break block20;
                }
                if (eventType == 5) {
                    event = builder.createModuleDeployEvent("undeploy", entityName, moduleType, cascade, forceDeploy);
                    break block20;
                }
                if (eventType == 6) {
                    event = builder.createModuleDeployEvent("redeploy", entityName, moduleType);
                    break block20;
                }
                if (eventType == 9) {
                    event = builder.createApplicationDeployEvent("enable", entityName, false, forceDeploy, loadUnloadAction);
                    break block20;
                }
                if (eventType == 10) {
                    event = builder.createApplicationDeployEvent("disable", entityName, false, forceDeploy, loadUnloadAction);
                    break block20;
                }
                if (eventType == 7) {
                    event = builder.createModuleDeployEvent("enable", entityName, moduleType, false, forceDeploy);
                    break block20;
                }
                if (eventType == 8) {
                    event = builder.createModuleDeployEvent("disable", entityName, moduleType, false, forceDeploy);
                    break block20;
                }
                if (eventType == 11) {
                    event = builder.createApplicationDeployEvent("reference-added", entityName, false, forceDeploy, loadUnloadAction);
                    break block20;
                }
                if (eventType == 12) {
                    event = builder.createApplicationDeployEvent("reference-removed", entityName, false, forceDeploy, loadUnloadAction);
                    break block20;
                }
                if (eventType == 7) {
                    event = builder.createConfigChangeEvent(targetName, null);
                    break block20;
                }
                String msg = localStrings.getString("admin.server.core.mbean.config.no_such_event", new Integer(eventType));
                throw new RuntimeException(msg);
            }
            catch (ConfigException ex) {
                DeploymentException de = new DeploymentException(ex.getMessage());
                de.initCause(ex);
                throw de;
            }
        }
        if (targetName != null) {
            event.setTargetDestination(targetName);
        }
        if (event instanceof ApplicationDeployEvent || event instanceof ModuleDeployEvent) {
            AdminEventCache.populateConfigChange(DeploymentNotificationHelper.getConfigContext(), event);
        }
        if (sLogger.isLoggable(Level.FINEST)) {
            sLogger.log(Level.FINEST, "mbean.event_sent", event.getEventInfo());
        } else {
            sLogger.log(Level.FINE, "mbean.send_event", ((AdminEvent)event).toString());
        }
        AdminEventResult multicastResult = AdminEventMulticaster.multicastEvent(event);
        sLogger.log(Level.FINE, "mbean.event_res", multicastResult.getResultCode());
        sLogger.log(Level.FINE, "mbean.event_reply", multicastResult.getAllMessagesAsString());
        boolean eventSuccess = true;
        AdminEventListenerException ale = null;
        ale = multicastResult.getFirstAdminEventListenerException();
        if (ale != null) {
            sLogger.log(Level.WARNING, "mbean.event_failed", ale.getMessage());
            DeploymentException de = new DeploymentException(ale.getMessage());
            de.initCause(ale);
            throw de;
        }
        return eventSuccess;
    }

    private static ConfigContext getConfigContext() {
        AdminContext adminContext = AdminService.getAdminService().getAdminContext();
        return adminContext.getAdminConfigContext();
    }
}

