/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core;

import com.sun.appserv.management.util.misc.RunnableBase;
import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.admin.common.ObjectNames;
import com.sun.enterprise.admin.meta.MBeanMetaException;
import com.sun.enterprise.admin.meta.MBeanRegistry;
import com.sun.enterprise.admin.meta.MBeanRegistryFactory;
import com.sun.enterprise.admin.server.core.jmx.InitException;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.FeatureAvailability;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ComSunAppservConfigMBeansIniter
extends RunnableBase<String> {
    private static final Logger sLogger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private final MBeanServer mServer;
    private final String mJMXDomainName;
    private final AdminContext mAdminContext;
    private static final String DottedMBeansIniterClassName = "com.sun.enterprise.admin.mbeans.DottedNameMBeansIniter";

    public ComSunAppservConfigMBeansIniter(String jmxDomainName, MBeanServer server, AdminContext adminContext) {
        super("ComSunAppservConfigMBeansIniter");
        this.mServer = server;
        this.mJMXDomainName = jmxDomainName;
        this.mAdminContext = adminContext;
        this.checkAlreadyLoaded();
    }

    private void checkAlreadyLoaded() {
        if (this.mServer.isRegistered(ObjectNames.getControllerObjectName())) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    protected void doRun() throws Exception {
        this.checkAlreadyLoaded();
        this.initialize();
    }

    protected void startLoading(boolean synchronous) {
        this.checkAlreadyLoaded();
        if (synchronous) {
            this.run();
        } else {
            new Thread(this).start();
        }
    }

    private void initialize() throws InitException {
        try {
            ObjectName controllerObjectName = ObjectNames.getControllerObjectName();
            ObjectName configObjectName = ObjectNames.getGenericConfiguratorObjectName();
            ObjectName[] objectNames = new ObjectName[]{controllerObjectName, configObjectName};
            String controllerClassName = "com.sun.enterprise.admin.server.core.mbean.config.ServerController";
            String configClassName = "com.sun.enterprise.admin.server.core.mbean.config.GenericConfigurator";
            String[] clNames = new String[]{"com.sun.enterprise.admin.server.core.mbean.config.ServerController", "com.sun.enterprise.admin.server.core.mbean.config.GenericConfigurator"};
            for (int i = 0; i < clNames.length; ++i) {
                this.createAndRegister(clNames[i], objectNames[i]);
            }
            this.registerDottedNameSupport();
            this.registerConfigMBeans();
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "Error in initialize", e);
            throw new InitException(e.getMessage(), e);
        }
    }

    private void registerDottedNameSupport() throws Exception {
        Class<?> initerClass = Class.forName(DottedMBeansIniterClassName);
        Class[] signature = new Class[]{MBeanServer.class};
        Constructor<?> constructor = initerClass.getConstructor(signature);
        constructor.newInstance(this.mServer);
    }

    private ObjectInstance createAndRegister(String className, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> mbeanClass = Class.forName(className);
        Object mbeanImpl = mbeanClass.newInstance();
        ObjectInstance mbeanInstance = this.registerMBean(mbeanImpl, objectName);
        return mbeanInstance;
    }

    public ObjectInstance registerMBean(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return this.mServer.registerMBean(object, objectName);
    }

    private void registerConfigMBeans() throws MBeanMetaException {
        long start = System.currentTimeMillis();
        MBeanRegistry mr = MBeanRegistryFactory.getAdminMBeanRegistry();
        ConfigContext configContext = this.mAdminContext.getAdminConfigContext();
        String jmxDomainName = ApplicationServer.getServerContext().getDefaultDomainName();
        mr.instantiateAndRegisterAllConfigMBeans(configContext, jmxDomainName);
        long elapsed = System.currentTimeMillis() - start;
        FeatureAvailability.getInstance().registerFeature("com.sun.appserv:category=config", this.mServer);
    }
}

