/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor;

import com.sun.enterprise.admin.monitor.BaseMonitorMBean;
import com.sun.enterprise.admin.monitor.GenericMonitorMBean;
import com.sun.enterprise.admin.monitor.IMonitorable;
import com.sun.enterprise.admin.monitor.MonitoredObjectType;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.ObjectName;

public class MonitoringHelper {
    private static StringManager localStrings = StringManager.getManager(MonitoringHelper.class);
    static Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    public static final String SYSTEM_ORB_NAME = "system";
    private static final HashMap userOrbNames = new HashMap();
    private static int orbNameUniquifier = 0;
    public static final String DEFAULT_USER_ORB_HINT = "user";
    private static final char COMMA = ',';
    private static final char SPACE = ' ';
    private static final char COLON = ':';
    private static final char EQUALS = '=';
    private static final String PURGE_MBEAN_FAILED = "monitor.purge_mbean_failed";
    private static final String PURGE_MBEAN_FAILED_TRACE = "monitor.purge_mbean_failed_trace";
    private static final String USER_ORB_MBEAN_NAME_USED = "monitor.user_orb_mbean_name_used";
    private static final String ORB_MBEAN_REGISTERED = "monitor.orb_mbean_registered";
    private static final String INVALID_USER_ORB_NAME_HINT = "monitor.invalid_user_orb_name_hint";

    public static ObjectName registerEJBMonitoringMBean(String appName, String moduleName, String ejbName, MonitoredObjectType type, BaseMonitorMBean mbean) throws InstanceAlreadyExistsException, MBeanRegistrationException {
        BaseMonitorMBean app = MonitoringHelper.getLevelOneMBeanForSure(MonitoredObjectType.APPLICATION, appName);
        BaseMonitorMBean module = MonitoringHelper.getMBeanForSure(app, MonitoredObjectType.EJBMODULE, moduleName);
        module.addChild(ejbName, type, mbean);
        return mbean.getObjectName();
    }

    public static ObjectName getEJBMonitoringMBeanName(String appName, String moduleName, String ejbName) throws InstanceNotFoundException {
        return MonitoringHelper.getEJBMonitoringMBean(appName, moduleName, ejbName).getObjectName();
    }

    public static void unregisterEJBMonitoringMBean(String appName, String moduleName, String ejbName) throws InstanceNotFoundException, MBeanRegistrationException {
        BaseMonitorMBean module = MonitoringHelper.getEJBModuleMBean(appName, moduleName);
        BaseMonitorMBean ejb = module.getFirstChildByName(ejbName);
        module.removeChild(ejb);
        MonitoringHelper.checkAndPurgeUnusedAppAndModule(appName, module);
    }

    public static ObjectName registerEJBMonitoringMBean(String standaloneModuleName, String ejbName, MonitoredObjectType type, BaseMonitorMBean mbean) throws InstanceAlreadyExistsException, MBeanRegistrationException {
        BaseMonitorMBean standaloneModule = MonitoringHelper.getLevelOneMBeanForSure(MonitoredObjectType.STANDALONE_EJBMODULE, standaloneModuleName);
        standaloneModule.addChild(ejbName, type, mbean);
        return mbean.getObjectName();
    }

    public static ObjectName getEJBMonitoringMBeanName(String standaloneModuleName, String ejbName) throws InstanceNotFoundException {
        return MonitoringHelper.getEJBMonitoringMBean(standaloneModuleName, ejbName).getObjectName();
    }

    public static void unregisterEJBMonitoringMBean(String standaloneModuleName, String ejbName) throws InstanceNotFoundException, MBeanRegistrationException {
        BaseMonitorMBean module = MonitoringHelper.getEJBModuleMBean(standaloneModuleName);
        BaseMonitorMBean ejb = module.getFirstChildByName(ejbName);
        module.removeChild(ejb);
        MonitoringHelper.checkAndPurgeUnusedLevelOneMBean(module);
    }

    public static void registerEJBMethodMonitoringMBean(ObjectName ejbMBeanName, String methodName, BaseMonitorMBean mbean) throws InstanceNotFoundException, InstanceAlreadyExistsException, MBeanRegistrationException {
        BaseMonitorMBean ejb = MonitoringHelper.getMonitorMBean(ejbMBeanName);
        ejb.addChild(methodName, MonitoredObjectType.BEAN_METHOD, mbean);
    }

    public static ObjectName registerMonitoringMBean(String name, BaseMonitorMBean mbean) throws InstanceNotFoundException, MBeanRegistrationException {
        return null;
    }

    public static void unregisterMonitoringMBean(String name) throws InstanceNotFoundException, MBeanRegistrationException {
    }

    public static void registerSystemORBMonitoringMBean(BaseMonitorMBean mbean) throws InstanceAlreadyExistsException, MBeanRegistrationException {
        MonitoringHelper.registerORBMonitoringMBean(SYSTEM_ORB_NAME, mbean);
    }

    public static void registerUserORBMonitoringMBean(String hint, BaseMonitorMBean mbean) throws InstanceAlreadyExistsException, MBeanRegistrationException {
        if (SYSTEM_ORB_NAME.equalsIgnoreCase(hint)) {
            String msg = localStrings.getString("admin.monitor.system_orb_name_used", hint);
            throw new IllegalArgumentException(msg);
        }
        MonitoringHelper.registerORBMonitoringMBean(MonitoringHelper.getUserOrbMBeanName(hint), mbean);
    }

    private static void registerORBMonitoringMBean(String name, BaseMonitorMBean mbean) throws InstanceAlreadyExistsException, MBeanRegistrationException {
        if (AdminService.getAdminService() == null) {
            String msg = localStrings.getString("admin.monitor.admin_service_not_inited");
            throw new IllegalStateException(msg);
        }
        BaseMonitorMBean iiop = MonitoringHelper.getLevelOneMBeanForSure(MonitoredObjectType.IIOP_SERVICE, MonitoredObjectType.IIOP_SERVICE.getTypeName());
        iiop.addChild(name, MonitoredObjectType.ORB, mbean);
        logger.log(Level.FINEST, ORB_MBEAN_REGISTERED, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getUserOrbMBeanName(String hint) {
        if (hint == null || hint.trim().equals("") || hint.equalsIgnoreCase(DEFAULT_USER_ORB_HINT) || hint.indexOf(44) != -1 || hint.indexOf(32) != -1 || hint.indexOf(58) != -1 || hint.indexOf(61) != -1) {
            logger.log(Level.FINEST, INVALID_USER_ORB_NAME_HINT, hint);
            hint = DEFAULT_USER_ORB_HINT + ++orbNameUniquifier;
        }
        HashMap hashMap = userOrbNames;
        synchronized (hashMap) {
            while (userOrbNames.containsKey(hint)) {
                logger.log(Level.FINEST, USER_ORB_MBEAN_NAME_USED, hint);
                hint = hint + ++orbNameUniquifier;
            }
            userOrbNames.put(hint, hint);
        }
        return hint;
    }

    public static ObjectName registerMonitorable(String name, IMonitorable monitorable) throws InstanceNotFoundException, MBeanRegistrationException {
        return null;
    }

    public static void unregisterMonitorable(String name) throws InstanceNotFoundException, MBeanRegistrationException {
    }

    public static BaseMonitorMBean getMonitorMBean(ObjectName name) throws InstanceNotFoundException {
        BaseMonitorMBean mbean = MonitoringHelper.getMonitorMBeanOrNull(name);
        if (mbean == null) {
            String msg = localStrings.getString("admin.monitor.mbean_with_name_not_found", name);
            throw new InstanceNotFoundException(msg);
        }
        return mbean;
    }

    private static BaseMonitorMBean getMonitorMBeanOrNull(ObjectName name) {
        BaseMonitorMBean mbean = (BaseMonitorMBean)BaseMonitorMBean.objectNameMap.get(name);
        return mbean;
    }

    private static BaseMonitorMBean getEJBMonitoringMBean(String appName, String moduleName, String ejbName) throws InstanceNotFoundException {
        ArrayList list;
        BaseMonitorMBean module;
        BaseMonitorMBean mbean = null;
        BaseMonitorMBean app = MonitoringHelper.getLevelOneMBean(MonitoredObjectType.APPLICATION, appName);
        if (app != null && (module = app.getChildOrNull(MonitoredObjectType.EJBMODULE, moduleName)) != null && !(list = module.getChildList(ejbName)).isEmpty()) {
            mbean = (BaseMonitorMBean)list.get(0);
        }
        if (mbean == null) {
            String msg = localStrings.getString("admin.monitor.no_mbean_for_appname_modulename_ejbname", appName, moduleName, ejbName);
            throw new InstanceNotFoundException(msg);
        }
        return mbean;
    }

    private static BaseMonitorMBean getEJBModuleMBean(String appName, String moduleName) {
        BaseMonitorMBean module = null;
        BaseMonitorMBean app = MonitoringHelper.getLevelOneMBean(MonitoredObjectType.APPLICATION, appName);
        if (app != null) {
            module = app.getChildOrNull(MonitoredObjectType.EJBMODULE, moduleName);
        }
        return module;
    }

    private static BaseMonitorMBean getEJBMonitoringMBean(String standaloneModuleName, String ejbName) throws InstanceNotFoundException {
        ArrayList list;
        BaseMonitorMBean mbean = null;
        BaseMonitorMBean module = MonitoringHelper.getLevelOneMBean(MonitoredObjectType.STANDALONE_EJBMODULE, standaloneModuleName);
        if (module != null && !(list = module.getChildList(ejbName)).isEmpty()) {
            mbean = (BaseMonitorMBean)list.get(0);
        }
        if (mbean == null) {
            String msg = localStrings.getString("admin.monitor.no_mbean_for_standalonemodulename_ejbname", standaloneModuleName, ejbName);
            throw new InstanceNotFoundException(msg);
        }
        return mbean;
    }

    private static BaseMonitorMBean getEJBModuleMBean(String standaloneModuleName) {
        return MonitoringHelper.getLevelOneMBean(MonitoredObjectType.STANDALONE_EJBMODULE, standaloneModuleName);
    }

    private static BaseMonitorMBean getLevelOneMBean(MonitoredObjectType type, String name) {
        GenericMonitorMBean root = GenericMonitorMBean.getRoot();
        return root.getChildOrNull(type, name);
    }

    private static BaseMonitorMBean getLevelOneMBeanForSure(MonitoredObjectType type, String name) {
        GenericMonitorMBean root = GenericMonitorMBean.getRoot();
        return MonitoringHelper.getMBeanForSure(root, type, name);
    }

    private static BaseMonitorMBean getMBeanForSure(BaseMonitorMBean parent, MonitoredObjectType type, String name) {
        BaseMonitorMBean mbean = parent.getChildOrNull(type, name);
        if (mbean == null) {
            mbean = new GenericMonitorMBean();
            try {
                parent.addChild(name, type, mbean);
            }
            catch (InstanceAlreadyExistsException iae) {
                mbean = parent.getChildOrNull(type, name);
                if (mbean == null) {
                    String msg = localStrings.getString("admin.monitor.unable_getting_mbean", type, name, parent.getObjectName());
                    throw new RuntimeException(msg);
                }
            }
            catch (MBeanRegistrationException mbr) {
                String msg = localStrings.getString("admin.monitor.rootcause_unable_to_register_mbean", type, name, mbr.getMessage());
                throw new RuntimeException(msg);
            }
        }
        return mbean;
    }

    public static ObjectName registerTxnMonitoringMBean(BaseMonitorMBean mbean) throws InstanceAlreadyExistsException, MBeanRegistrationException {
        GenericMonitorMBean.getRoot().addChild(MonitoredObjectType.TXNMGR.getTypeName(), MonitoredObjectType.TXNMGR, mbean);
        return mbean.getObjectName();
    }

    public static ObjectName registerJdbcPoolMonitoringMBean(String poolName, MonitoredObjectType type, BaseMonitorMBean mbean) throws InstanceAlreadyExistsException, MBeanRegistrationException {
        if (AdminService.getAdminService() != null) {
            BaseMonitorMBean resMBean = MonitoringHelper.getLevelOneMBeanForSure(MonitoredObjectType.RESOURCES, "resources");
            resMBean.addChild(poolName, type, mbean);
            return mbean.getObjectName();
        }
        return null;
    }

    public void unregisterJdbcPoolMonitoringMBean(MonitoredObjectType type, String poolName) throws InstanceNotFoundException, MBeanRegistrationException {
        BaseMonitorMBean resMBean = MonitoringHelper.getLevelOneMBean(MonitoredObjectType.RESOURCES, "resources");
        if (resMBean != null) {
            resMBean.removeChild(type, poolName);
        }
    }

    private static void checkAndPurgeUnusedAppAndModule(String appName, BaseMonitorMBean moduleMBean) {
        if (moduleMBean == null) {
            return;
        }
        BaseMonitorMBean appMBean = MonitoringHelper.getLevelOneMBean(MonitoredObjectType.APPLICATION, appName);
        boolean purged = MonitoringHelper.checkAndPurgeMBean(appMBean, moduleMBean);
        if (purged) {
            MonitoringHelper.checkAndPurgeUnusedLevelOneMBean(appMBean);
        }
    }

    private static void checkAndPurgeUnusedLevelOneMBean(BaseMonitorMBean levelOneMBean) {
        if (levelOneMBean == null) {
            return;
        }
        GenericMonitorMBean root = GenericMonitorMBean.getRoot();
        boolean purged = MonitoringHelper.checkAndPurgeMBean(root, levelOneMBean);
    }

    private static boolean checkAndPurgeMBean(BaseMonitorMBean parent, BaseMonitorMBean mbean) {
        ArrayList childList;
        boolean purged = false;
        if (mbean != null && parent != null && ((childList = mbean.getChildList()) == null || childList.size() == 0)) {
            try {
                parent.removeChild(mbean);
                purged = true;
            }
            catch (Throwable t) {
                logger.log(Level.FINE, PURGE_MBEAN_FAILED, mbean.getNodeType() + "/" + mbean.getNodeName());
                logger.log(Level.FINEST, PURGE_MBEAN_FAILED_TRACE, t);
            }
        }
        return purged;
    }
}

