/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor;

import com.sun.enterprise.admin.monitor.BaseMonitorMBean;
import com.sun.enterprise.admin.monitor.MonitorCommand;
import com.sun.enterprise.admin.monitor.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.MonitoringHelper;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class MonitorSetCommand
extends MonitorCommand {
    private String[] params;
    private static final String WILDCARD = "*";
    private String operationName;

    MonitorSetCommand(ObjectName mbeanName, MonitoredObjectType type, String operationName, String[] commandOperands) {
        this.objectName = mbeanName;
        if (type != null) {
            this.monitoredObjectType = type.getTypeName();
        }
        this.operationName = operationName;
        if (commandOperands.length > 0) {
            this.params = commandOperands;
        }
        if (WILDCARD.equals(operationName)) {
            throw new UnsupportedOperationException(BaseMonitorMBean.UNSUPPORTED_ERRMSG);
        }
    }

    Object runCommand() throws InstanceNotFoundException, ReflectionException, MBeanException {
        BaseMonitorMBean mbean = MonitoringHelper.getMonitorMBean(this.objectName);
        if (mbean == null) {
            throw new InstanceNotFoundException();
        }
        ArrayList mbeanList = null;
        if (this.monitoredObjectType != null) {
            mbeanList = mbean.getChildList(this.monitoredObjectType);
        } else {
            mbeanList = new ArrayList();
            mbeanList.add(mbean);
        }
        AttributeList result = new AttributeList();
        Object val = mbean.invoke(this.operationName, this.params, null);
        Attribute attr = new Attribute(this.operationName, val);
        result.add(attr);
        return result;
    }
}

