/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor;

import com.sun.enterprise.admin.common.MalformedNameException;
import com.sun.enterprise.admin.common.Name;
import com.sun.enterprise.admin.monitor.MonitorCommand;
import com.sun.enterprise.admin.monitor.MonitorGetCommand;
import com.sun.enterprise.admin.monitor.MonitorListCommand;
import com.sun.enterprise.admin.monitor.MonitorSetCommand;
import com.sun.enterprise.admin.monitor.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.ParsedDottedName;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class CommandMapper {
    private static HashMap instanceMap = new HashMap();
    private String instanceName;
    private static StringManager localStrings = StringManager.getManager(CommandMapper.class);
    public static final String CLI_COMMAND_GET = "GET";
    public static final String CLI_COMMAND_LIST = "LIST";
    public static final String CLI_COMMAND_SET = "SET";

    private CommandMapper() {
    }

    public MonitorCommand mapCliCommand(String command, String dottedName) throws MalformedNameException {
        MonitorCommand monitorCommand = null;
        if (CLI_COMMAND_GET.equalsIgnoreCase(command)) {
            monitorCommand = this.mapGetCommand(dottedName);
        } else if (CLI_COMMAND_LIST.equalsIgnoreCase(command)) {
            monitorCommand = this.mapListCommand(dottedName);
        } else {
            String msg = localStrings.getString("admin.monitor.unknown_cli_command", command);
            throw new IllegalArgumentException(msg);
        }
        return monitorCommand;
    }

    public MonitorGetCommand mapGetCommand(String dottedName) throws MalformedNameException {
        ParsedDottedName result = this.parseDottedName(dottedName, CLI_COMMAND_GET);
        MonitorGetCommand command = result.monitoredObjectType != null ? new MonitorGetCommand(result.objectName, result.monitoredObjectType, result.attributeName) : new MonitorGetCommand(result.objectName, result.attributeName);
        return command;
    }

    public MonitorListCommand mapListCommand(String dottedName) throws MalformedNameException {
        ParsedDottedName result = this.parseDottedName(dottedName, CLI_COMMAND_LIST);
        MonitorListCommand command = result.monitoredObjectType != null ? new MonitorListCommand(result.objectName, result.monitoredObjectType) : new MonitorListCommand(result.objectName);
        return command;
    }

    public MonitorSetCommand mapSetCommand(String dottedName, Object args) throws MalformedNameException {
        ParsedDottedName result = this.parseDottedName(dottedName, CLI_COMMAND_SET);
        MonitorSetCommand command = null;
        String argsStr = (String)args;
        StringTokenizer st = new StringTokenizer(argsStr, ",");
        String[] commandArgs = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            commandArgs[i] = st.nextToken();
            ++i;
        }
        command = new MonitorSetCommand(result.objectName, result.monitoredObjectType, result.operationName, commandArgs);
        return command;
    }

    public static synchronized CommandMapper getInstance(String instanceName) {
        CommandMapper cm = (CommandMapper)instanceMap.get(instanceName);
        if (cm == null) {
            cm = new CommandMapper();
            cm.instanceName = instanceName;
            instanceMap.put(instanceName, cm);
        }
        return cm;
    }

    private ParsedDottedName parseDottedName(String dottedString, String command) throws MalformedNameException {
        ArrayList<String> tokenList = new ArrayList<String>();
        Name dottedName = new Name(dottedString);
        int nTokens = dottedName.getNumParts();
        if (nTokens < 1) {
            String msg = localStrings.getString("admin.monitor.name_does_not_contain_any_tokens", dottedString);
            throw new MalformedNameException(msg);
        }
        for (int j = 0; j < nTokens; ++j) {
            tokenList.add(dottedName.getNamePart(j).toString());
        }
        return this.parseTokens(tokenList, command, dottedString);
    }

    private ParsedDottedName parseTokens(ArrayList tokenList, String command, String dottedName) throws MalformedNameException {
        Properties props = new Properties();
        props.put("type", "monitor");
        props.put("name", "root");
        props.put("mclass", "root");
        props.put("instance-name", this.instanceName);
        int count = tokenList.size();
        MonitoredObjectType type = null;
        int tokenCount = count;
        if (command.equals(CLI_COMMAND_GET) || command.equals(CLI_COMMAND_SET)) {
            tokenCount = count - 1;
        }
        boolean processType = true;
        for (int i = 1; i < tokenCount; ++i) {
            String token = (String)tokenList.get(i);
            if (processType) {
                type = MonitoredObjectType.getMonitoredObjectTypeOrNull(token);
                if (type == null) {
                    String msg = localStrings.getString("admin.monitor.invalid_entry", dottedName, token);
                    throw new MalformedNameException(msg);
                }
                String typeName = type.getTypeName();
                if (type.isSingleton()) {
                    this.swapNameType(props, typeName, typeName);
                    processType = true;
                    type = null;
                    continue;
                }
                processType = false;
                continue;
            }
            this.swapNameType(props, type.getTypeName(), token);
            processType = true;
            type = null;
        }
        ParsedDottedName result = new ParsedDottedName();
        try {
            result.objectName = new ObjectName("com.sun.appserv", props);
        }
        catch (MalformedObjectNameException ione) {
            throw new MalformedNameException(ione.getMessage());
        }
        if (type != null) {
            result.monitoredObjectType = type;
        }
        if (command.equals(CLI_COMMAND_GET)) {
            result.attributeName = (String)tokenList.get(count - 1);
        } else if (command.equals(CLI_COMMAND_SET)) {
            result.operationName = (String)tokenList.get(count - 1);
        }
        return result;
    }

    private void swapNameType(Properties props, String newType, String newName) {
        String oldType = props.getProperty("mclass");
        String oldName = props.getProperty("name");
        props.put("mclass", newType);
        props.put("name", newName);
        props.put(oldType, oldName);
    }
}

