/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans.custom;

import com.sun.enterprise.admin.mbeans.custom.loading.CustomMBeanRegistrationImpl;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.Mbean;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MBeanValidator {
    private final MBeanServer mbs = MBeanServerFactory.newMBeanServer();

    public ObjectName registerTestMBean(Map<String, String> params, Map<String, String> attributes) throws RuntimeException {
        try {
            CustomMBeanRegistrationImpl cmr = new CustomMBeanRegistrationImpl(this.mbs);
            Mbean m = MBeanValidator.toMbean(params, attributes, true);
            ObjectName ron = cmr.registerMBean(m);
            return ron;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void unregisterTestMBean(ObjectName ron) throws RuntimeException {
        try {
            if (this.mbs.isRegistered(ron)) {
                this.mbs.unregisterMBean(ron);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static final Mbean toMbean(Map<String, String> params, Map<String, String> attributes, boolean enabledNotUsed) {
        Mbean cmb = new Mbean();
        String name = params.get("name");
        String cName = params.get("impl-class-name");
        String on = params.get("object-name");
        String ot = params.get("object-type");
        String enabledString = params.get("enabled");
        boolean enabled = true;
        if (enabledString != null) {
            enabled = Boolean.valueOf(enabledString);
        }
        cmb.setName(name);
        cmb.setImplClassName(cName);
        cmb.setObjectName(on);
        cmb.setObjectType(ot);
        cmb.setEnabled(enabled);
        cmb.setElementProperty(MBeanValidator.map2Properties(attributes));
        return cmb;
    }

    public static ObjectName formDefaultObjectName(Map<String, String> params) throws MalformedObjectNameException {
        String domain = "user";
        HashMap<String, String> onProperties = new HashMap<String, String>();
        if (params.containsKey("impl-class-name")) {
            onProperties.put("impl-class-name", params.get("impl-class-name"));
        }
        if (params.containsKey("name")) {
            onProperties.put("name", params.get("name"));
        }
        ObjectName on = new ObjectName("user", new Hashtable<String, String>(onProperties));
        return on;
    }

    private static ElementProperty[] map2Properties(Map<String, String> attributes) {
        ElementProperty[] props = new ElementProperty[attributes.size()];
        int i = 0;
        for (String n : attributes.keySet()) {
            ElementProperty prop = new ElementProperty();
            prop.setName(n);
            prop.setValue(attributes.get(n));
            props[i] = prop;
            ++i;
        }
        return props;
    }
}

