/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.admin.config.BaseConfigMBean;
import com.sun.enterprise.admin.config.MBeanConfigException;
import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.admin.event.AdminEventMulticaster;
import com.sun.enterprise.admin.event.AdminEventResult;
import com.sun.enterprise.admin.event.tx.TransactionsRecoveryEvent;
import com.sun.enterprise.admin.mbeans.EJBTimerManagementMBean;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.logging.Level;

public class TransactionsRecoveryMBean
extends BaseConfigMBean {
    private static final StringManager _strMgr = StringManager.getManager(EJBTimerManagementMBean.class);

    public void recoverTransactions() throws MBeanConfigException {
        this.fine("TransactionsRecoverytMBean.recoveryTransactions for server");
        this.sendTransactionsRecoveryEvent(this.getServerName(), this.getServerName(), null);
    }

    private void sendTransactionsRecoveryEvent(String destinationServer, String serverToRecover, String transactionLogDir) throws MBeanConfigException {
        TransactionsRecoveryEvent event = new TransactionsRecoveryEvent(this.getServerName(), serverToRecover, transactionLogDir);
        event.setTargetDestination(destinationServer);
        AdminEventResult res = this.forwardEvent(event);
        if (!"success".equals(res.getResultCode())) {
            Throwable exc = null;
            exc = res.getFirstThrowable();
            if (exc != null) {
                throw new MBeanConfigException(_strMgr.getString("tx.exceptionInTargetServer", exc.getMessage()));
            }
            throw new MBeanConfigException(_strMgr.getString("tx.notSuccessInSendReturn", res.getResultCode()));
        }
    }

    private AdminEventResult forwardEvent(AdminEvent e) {
        AdminEventResult result = null;
        result = AdminEventMulticaster.multicastEvent(e);
        return result;
    }

    private void fine(String s) {
        _sLogger.log(Level.FINE, s);
    }

    private String getServerName() {
        return ApplicationServer.getServerContext().getInstanceName();
    }
}

