/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.admin.config.BaseConfigMBean;
import com.sun.enterprise.admin.config.ConfigMBeanHelper;
import com.sun.enterprise.admin.config.MBeanConfigException;
import com.sun.enterprise.admin.mbeanapi.IDomainMBean;
import com.sun.enterprise.admin.meta.MBeanRegistryEntry;
import com.sun.enterprise.admin.meta.MBeanRegistryFactory;
import com.sun.enterprise.admin.meta.naming.MBeanNamingDescriptor;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.pe.PEFileLayout;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigAPIHelper;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.JmsHost;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import com.sun.enterprise.config.serverbeans.PropertyResolver;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import javax.management.AttributeList;

public class DomainMBean
extends BaseConfigMBean
implements IDomainMBean {
    private static final StringManager localStrings = StringManager.getManager(DomainMBean.class);
    private static final String BUNDLED_DOMAINS_ROOT = "/var/appserver/domains";
    private static final String AUTOSTART_FILENAME = "autostart";

    public String resolveTokens(String value, String instanceName) throws ConfigException {
        return this.resolveTokens(value, instanceName, false);
    }

    public String resolveTokens(String value, String instanceName, boolean bResolvePathesAsWell) throws ConfigException {
        if (instanceName == null) {
            instanceName = MBeanRegistryFactory.getAdminContext().getServerName();
        }
        PropertyResolver resolver = new PropertyResolver(this.getConfigContext(), instanceName);
        return resolver.resolve(value, bResolvePathesAsWell);
    }

    public AttributeList getDefaultCustomProperties(String mbeanTypeName, AttributeList attributeList) {
        if (mbeanTypeName == null) {
            return null;
        }
        try {
            MBeanRegistryEntry entry = this.m_registry.findMBeanRegistryEntryByType(mbeanTypeName);
            MBeanNamingDescriptor descr = entry.getNamingDescriptor();
            String className = descr.getMBeanClassName();
            Class<?> cl = Class.forName(className);
            Method method = cl.getDeclaredMethod("getDefaultCustomProperties", Class.forName("javax.management.AttributeList"));
            return (AttributeList)method.invoke(null, attributeList);
        }
        catch (Exception e) {
            _sLogger.fine("getDefaultCustomProperties(): Exception for mbeanTypeName:" + mbeanTypeName);
            return null;
        }
    }

    public AttributeList getDefaultAttributeValues(String mbeanTypeName, String[] attrNames) {
        if (mbeanTypeName == null) {
            return null;
        }
        try {
            MBeanRegistryEntry entry = this.m_registry.findMBeanRegistryEntryByType(mbeanTypeName);
            if (attrNames == null && ((attrNames = entry.getAttributeNames()) == null || attrNames.length < 1)) {
                return null;
            }
            MBeanNamingDescriptor descr = entry.getNamingDescriptor();
            String className = descr.getMBeanClassName();
            Class<?> cl = Class.forName(className);
            Method method = null;
            try {
                method = cl.getDeclaredMethod("getDefaultAttributeValues", new String[0].getClass());
                return (AttributeList)method.invoke(null, new Object[]{attrNames});
            }
            catch (Exception e) {
                return ConfigMBeanHelper.getDefaultAttributeValues(descr, attrNames);
            }
        }
        catch (Exception e) {
            _sLogger.fine("getDefaultAttributeValues(): Exception for mbeanTypeName:" + mbeanTypeName);
            return null;
        }
    }

    public String getConfigDir() {
        InstanceEnvironment env = ApplicationServer.getServerContext().getInstanceEnvironment();
        return env.getConfigDirPath();
    }

    public boolean isAutoStartSupported() {
        return OS.isUnix() && this.getConfigDir().startsWith(BUNDLED_DOMAINS_ROOT);
    }

    public boolean isAutoStartEnabled() throws MBeanConfigException {
        this.checkAutoStartSupported();
        File autoStartFile = this.getAutoStartFile();
        return autoStartFile.exists();
    }

    public void setAutoStartEnabled(boolean state) throws MBeanConfigException {
        boolean success;
        this.checkAutoStartSupported();
        boolean bl = success = state ? this.enableAutoStart() : this.disableAutoStart();
        if (!success) {
            String msg = localStrings.getString("admin.mbeans.domain.set_autostart_failed");
            throw new MBeanConfigException(msg);
        }
    }

    public String getName() throws MBeanConfigException {
        String name = null;
        try {
            name = System.getProperty("domain.name");
        }
        catch (Exception e) {
            String msg = localStrings.getString("admin.mbeans.domain.get_name_failed") + " " + e.getLocalizedMessage();
            throw new MBeanConfigException(msg);
        }
        if (name == null) {
            String msg = localStrings.getString("admin.mbeans.domain.get_name_failed");
            throw new MBeanConfigException(msg);
        }
        return name;
    }

    private boolean enableAutoStart() {
        File autoStartFile = this.getAutoStartFile();
        boolean success = false;
        try {
            success = !autoStartFile.exists() ? autoStartFile.createNewFile() : true;
        }
        catch (IOException ioe) {
            _sLogger.log(Level.FINE, "mbean.autostart_ioexception", ioe);
            _sLogger.log(Level.WARNING, "mbean.autostart_enable_error", new Object[]{autoStartFile, ioe.getMessage()});
        }
        return success;
    }

    private boolean disableAutoStart() {
        File autoStartFile = this.getAutoStartFile();
        boolean success = true;
        if (autoStartFile.exists()) {
            success = autoStartFile.delete();
        }
        return success;
    }

    private void checkAutoStartSupported() throws MBeanConfigException {
        if (!this.isAutoStartSupported()) {
            String msg = localStrings.getString("admin.mbeans.domain.autostart_not_supported");
            throw new MBeanConfigException(msg);
        }
    }

    private File getAutoStartFile() {
        return new File(this.getConfigDir(), AUTOSTART_FILENAME);
    }

    public void addClusteringSupportUsingProfile(String profile) throws ConfigException {
        ConfigContext acc = MBeanRegistryFactory.getAdminContext().getAdminConfigContext();
        if (ServerHelper.isClusterAdminSupported(acc)) {
            String msg = localStrings.getString("domain.supports.cluster");
            throw new ConfigException(msg);
        }
        try {
            Config defaultConfig = this.getTemplateConfig(profile);
            DomainMBean.addConfig(acc, defaultConfig);
            DomainMBean.addClusterSupportElements(acc);
            DomainMBean.configurAdminServer(acc);
        }
        catch (Exception e) {
            throw new ConfigException(e);
        }
    }

    private Config getTemplateConfig(String profile) throws IllegalArgumentException, ConfigException {
        RepositoryConfig myRepos = new RepositoryConfig();
        PEFileLayout layout = new PEFileLayout(myRepos);
        File profileDomainXmlTemplate = layout.getPreExistingDomainXmlTemplateForProfile(profile);
        if (!profileDomainXmlTemplate.exists()) {
            String msg = localStrings.getString("template.domain.xml.not.found", profileDomainXmlTemplate.getAbsolutePath(), profile);
            throw new IllegalArgumentException(msg);
        }
        ConfigContext tcc = ConfigFactory.createConfigContext(profileDomainXmlTemplate.getAbsolutePath(), true);
        String tcn = "default-config";
        if (!DomainMBean.exists(ConfigAPIHelper.getConfigsInDomain(tcc), "default-config")) {
            String msg = localStrings.getString("template.config.not.found", "default-config", profileDomainXmlTemplate.getAbsolutePath());
            throw new IllegalArgumentException(msg);
        }
        Config tc = ConfigAPIHelper.getConfigByName(tcc, "default-config");
        return (Config)tc.clone();
    }

    private static boolean exists(Config[] configs, String configNamed) {
        boolean exists = false;
        for (Config c : configs) {
            if (!c.getName().equals(configNamed)) continue;
            exists = true;
            break;
        }
        return exists;
    }

    private static void addConfig(ConfigContext acc, Config dc) throws ConfigException {
        Configs configs = ConfigAPIHelper.getDomainConfigBean(acc).getConfigs();
        dc.setName("default-config");
        configs.addConfig(dc);
        DomainMBean.configureDefaultJmsHost(dc);
        DomainMBean.addClientHostNameProperty2SystemJmxConnector(dc);
    }

    private static void addClusterSupportElements(ConfigContext acc) throws ConfigException {
        Domain domain = ConfigAPIHelper.getDomainConfigBean(acc);
        domain.setClusters(domain.newClusters());
        domain.setNodeAgents(domain.newNodeAgents());
        domain.setLoadBalancers(domain.newLoadBalancers());
        domain.setLbConfigs(domain.newLbConfigs());
    }

    private static void configurAdminServer(ConfigContext acc) throws ConfigException {
        Config dasc = ServerHelper.getConfigForServer(acc, "server");
        JavaConfig jc = dasc.getJavaConfig();
        jc.addJvmOptions("-Djavax.management.builder.initial=com.sun.enterprise.ee.admin.AppServerMBeanServerBuilder");
        jc.addJvmOptions("-Dcom.sun.appserv.pluggable.features=com.sun.enterprise.ee.server.pluggable.EEPluggableFeatureImpl");
        DomainMBean.addClientHostNameProperty2SystemJmxConnector(dasc);
    }

    private static void configureDefaultJmsHost(Config tc) {
        JmsService js = tc.getJmsService();
        String jmshn = js.getDefaultJmsHost();
        JmsHost jmsh = js.getJmsHostByName(jmshn);
        jmsh.setAdminUserName("admin");
        jmsh.setAdminPassword("admin");
        jmsh.setHost(System.getProperty("com.sun.aas.hostName"));
    }

    private static void addClientHostNameProperty2SystemJmxConnector(Config someConfig) throws ConfigException {
        AdminService as = someConfig.getAdminService();
        JmxConnector jc = as.getJmxConnectorByName("system");
        String hostValue = System.getProperty("com.sun.aas.hostName");
        String hostName = "client-hostname";
        ElementProperty ep = jc.getElementPropertyByName("client-hostname");
        if (ep == null) {
            ep = new ElementProperty();
            ep.setName("client-hostname");
            ep.setValue(hostValue);
            jc.addElementProperty(ep);
        } else {
            ep.setValue(hostValue);
        }
    }
}

