/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.event;

import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.util.i18n.StringManager;

public class BaseDeployEvent
extends AdminEvent
implements Cloneable {
    public static final String APPLICATION = "application";
    public static final String MODULE = "module";
    public static final String RESOURCE = "resource";
    public static final String DEPLOY = "deploy";
    public static final String UNDEPLOY = "undeploy";
    public static final String REDEPLOY = "redeploy";
    public static final String ENABLE = "enable";
    public static final String DISABLE = "disable";
    public static final String ADD_REFERENCE = "reference-added";
    public static final String REMOVE_REFERENCE = "reference-removed";
    public static final int APPLICATION_DEPLOYED = 1;
    public static final int APPLICATION_UNDEPLOYED = 2;
    public static final int APPLICATION_REDEPLOYED = 3;
    public static final int MODULE_DEPLOYED = 4;
    public static final int MODULE_UNDEPLOYED = 5;
    public static final int MODULE_REDEPLOYED = 6;
    public static final int MODULE_ENABLE = 7;
    public static final int MODULE_DISABLE = 8;
    public static final int APPLICATION_ENABLE = 9;
    public static final int APPLICATION_DISABLE = 10;
    public static final int APPLICATION_REFERENCED = 11;
    public static final int APPLICATION_UNREFERENCED = 12;
    static final String eventType = BaseDeployEvent.class.getName();
    protected String j2eeComponentType;
    protected String j2eeComponentName;
    protected String actionName;
    protected boolean cascade = false;
    private static StringManager localStrings = StringManager.getManager(BaseDeployEvent.class);

    public BaseDeployEvent(String instance, String componentType, String componentName, String action) {
        this(eventType, instance, componentType, componentName, action);
    }

    public BaseDeployEvent(String type, String instance, String componentType, String componentName, String action) {
        this(type, instance, componentType, componentName, action, false);
    }

    public BaseDeployEvent(String type, String instance, String componentType, String componentName, String action, boolean cascade) {
        super(type, instance);
        this.j2eeComponentType = componentType;
        this.j2eeComponentName = componentName;
        this.setAction(action);
        this.setCascade(cascade);
    }

    public BaseDeployEvent(String type, Object source, long seqNumber, long time) {
        super(type, source, seqNumber, time);
    }

    public String getJ2EEComponentType() {
        return this.j2eeComponentType;
    }

    public String getJ2EEComponentName() {
        return this.j2eeComponentName;
    }

    public String getAction() {
        return this.actionName;
    }

    protected void setAction(String action) {
        boolean valid = false;
        if (DEPLOY.equals(action) || UNDEPLOY.equals(action) || REDEPLOY.equals(action) || ENABLE.equals(action) || DISABLE.equals(action) || ADD_REFERENCE.equals(action) || REMOVE_REFERENCE.equals(action)) {
            valid = true;
        }
        if (!valid) {
            String msg = localStrings.getString("admin.event.invalid_action", action);
            throw new IllegalArgumentException(msg);
        }
        this.actionName = action;
    }

    public boolean getCascade() {
        return this.cascade;
    }

    public void setCascade(boolean cascade) {
        this.cascade = cascade;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

