/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.event;

import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.util.i18n.StringManager;

public class AuditModuleEvent
extends AdminEvent {
    public static final int ACTION_CREATE = 1;
    public static final int ACTION_DELETE = 2;
    public static final int ACTION_UPDATE = 3;
    static final String eventType = AuditModuleEvent.class.getName();
    private int actionType;
    private String moduleName;
    private static StringManager localStrings = StringManager.getManager(AuditModuleEvent.class);

    public AuditModuleEvent(String instance, String module, int action) {
        this(eventType, instance, module, action);
    }

    public AuditModuleEvent(String type, String instance, String module, int action) {
        super(type, instance);
        this.moduleName = module;
        this.setAction(action);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public int getActionType() {
        return this.actionType;
    }

    private void setAction(int action) {
        boolean valid = false;
        if (action == 1 || action == 2 || action == 3) {
            valid = true;
        }
        if (!valid) {
            String msg = localStrings.getString("admin.event.invalid_action", "" + action);
            throw new IllegalArgumentException(msg);
        }
        this.actionType = action;
    }
}

