/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.dottedname;

import com.sun.enterprise.admin.dottedname.DottedName;
import com.sun.enterprise.admin.dottedname.DottedNameServerInfo;
import com.sun.enterprise.admin.util.ArrayConversion;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DottedNameAliasSupport {
    public static final String DOMAIN_SCOPE = "domain";
    public static final String DOMAIN_SCOPE_DOT = "domain.";
    public static final Set DOMAIN_PARTS = ArrayConversion.toSet(new String[]{"applications", "resources"});
    private static final Set NON_ALIASED_PARTS_SET = ArrayConversion.toSet(new String[]{"application-ref", "resource-ref", "config-ref", "node-agent-ref", "server-ref", "property", "name"});
    static Logger sLogger = null;

    public static boolean scopeIsDomain(String scope) {
        return scope.equals(DOMAIN_SCOPE) || scope.startsWith(DOMAIN_SCOPE_DOT);
    }

    public static boolean isAliasedDomain(DottedName dn) {
        boolean isAliased = false;
        List parts = dn.getParts();
        if (parts.size() >= 1) {
            isAliased = DOMAIN_PARTS.contains(parts.get(0));
        }
        return isAliased;
    }

    protected static boolean isNonAliasedServer(DottedName dn) {
        boolean isNonAliased = false;
        List parts = dn.getParts();
        if (parts.size() >= 1) {
            isNonAliased = NON_ALIASED_PARTS_SET.contains(parts.get(0));
        }
        return isNonAliased;
    }

    public static String resolveScope(DottedNameServerInfo serverInfo, DottedName dn) throws DottedNameServerInfo.UnavailableException {
        boolean scopeIsServerName;
        String scopeNameIn;
        String actualScopeName = scopeNameIn = dn.getScope();
        if (!DottedNameAliasSupport.scopeIsDomain(scopeNameIn) && (scopeIsServerName = serverInfo.getServerNames().contains(actualScopeName))) {
            if (DottedNameAliasSupport.isAliasedDomain(dn)) {
                actualScopeName = DOMAIN_SCOPE;
            } else if (!DottedNameAliasSupport.isNonAliasedServer(dn)) {
                actualScopeName = serverInfo.getConfigNameForServer(scopeNameIn);
            }
        }
        return actualScopeName;
    }

    static void dm(Object o) {
        if (sLogger == null) {
            sLogger = Logger.getLogger("DottedNameGetSetMBeanImplLogger");
            sLogger.setLevel(Level.INFO);
        }
        sLogger.info(o.toString());
    }
}

