/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.config;

import com.sun.enterprise.admin.config.MBeanConfigException;
import com.sun.enterprise.admin.config.ManagedConfigBean;
import com.sun.enterprise.admin.meta.DottedNameHelper;
import com.sun.enterprise.admin.meta.MBeanMetaConstants;
import com.sun.enterprise.admin.meta.MBeanRegistry;
import com.sun.enterprise.admin.meta.MBeanRegistryEntry;
import com.sun.enterprise.admin.meta.MBeanRegistryFactory;
import com.sun.enterprise.admin.meta.naming.MBeanNamingDescriptor;
import com.sun.enterprise.admin.meta.naming.MBeanNamingInfo;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigBeansFactory;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEventListener;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigFactory;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.modelmbean.ModelMBeanInfo;

public class OfflineConfigMgr
implements MBeanMetaConstants {
    MBeanRegistry _registry;
    ConfigContext _ctx;
    ArrayList _allDottedNames;

    public OfflineConfigMgr(String domainFileName) throws Exception {
        this._ctx = ConfigFactory.createConfigContext(domainFileName);
        this._registry = MBeanRegistryFactory.getOfflineAdminMBeanRegistry();
        try {
            Class<?> cl = Class.forName("com.sun.enterprise.config.serverbeans.validation.DomainMgr");
            Constructor<?> ctr = cl.getConstructor(ConfigContext.class, Boolean.TYPE, MBeanRegistry.class);
            this._ctx.addConfigContextEventListener((ConfigContextEventListener)ctr.newInstance(this._ctx, false, this._registry));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MBeanConfigException("error registering validator");
        }
    }

    public AttributeList getAttributes(String dottedName) throws MBeanConfigException {
        String[] splitted = DottedNameHelper.splitAttributeNameFromDottedName(dottedName);
        ManagedConfigBean mb = this.getManagedConfigBean(splitted[0]);
        AttributeList attrs = mb.getAttributes(new String[]{splitted[1]});
        return DottedNameHelper.addDottedPrefix(attrs, splitted[0]);
    }

    public AttributeList setAttributes(AttributeList attrsIn) {
        AttributeList attrsOut = new AttributeList();
        for (int i = 0; i < attrsIn.size(); ++i) {
            Attribute attr = (Attribute)attrsIn.get(i);
            try {
                AttributeList attrs = this.setAttribute(attr.getName(), attr.getValue());
                if (attrs.size() <= 0) continue;
                attrsOut.addAll(attrs);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return attrsOut;
    }

    public AttributeList setAttribute(String dottedName, Object value) throws MBeanConfigException, ConfigException {
        String[] splitted = DottedNameHelper.splitAttributeNameFromDottedName(dottedName);
        ManagedConfigBean mb = this.getManagedConfigBean(splitted[0]);
        AttributeList attrsIn = new AttributeList();
        attrsIn.add(new Attribute(splitted[1], value));
        AttributeList attrsOut = mb.setAttributes(attrsIn);
        this._ctx.flush();
        return DottedNameHelper.addDottedPrefix(attrsOut, splitted[0]);
    }

    public AttributeList addSubvaluesToArrayAttribute(String dottedName, String[] addValues) throws MBeanConfigException, ConfigException {
        String[] splitted = DottedNameHelper.splitAttributeNameFromDottedName(dottedName);
        ManagedConfigBean mb = this.getManagedConfigBean(splitted[0]);
        MBeanAttributeInfo attrInfo = mb.getAttributeInfo(splitted[1]);
        if (attrInfo == null || !attrInfo.getType().startsWith("[")) {
            throw new MBeanConfigException("add subelement: attribute type is not array");
        }
        AttributeList list = this.getAttributes(dottedName);
        ArrayList values = new ArrayList();
        if (list.size() != 0) {
            DottedNameHelper.addArrayToList(values, (Object[])((Attribute)list.get(0)).getValue());
        }
        DottedNameHelper.addArrayToList(values, addValues);
        return this.setAttribute(dottedName, values.toArray(new String[0]));
    }

    public AttributeList removeSubvaluesFromArrayAttribute(String dottedName, String[] removeValues) throws MBeanConfigException, ConfigException {
        String[] splitted = DottedNameHelper.splitAttributeNameFromDottedName(dottedName);
        ManagedConfigBean mb = this.getManagedConfigBean(splitted[0]);
        MBeanAttributeInfo attrInfo = mb.getAttributeInfo(splitted[1]);
        if (attrInfo == null || !attrInfo.getType().startsWith("[")) {
            throw new MBeanConfigException("add subelement: attribute type is not array");
        }
        AttributeList list = this.getAttributes(dottedName);
        ArrayList values = new ArrayList();
        if (list.size() != 0) {
            DottedNameHelper.addArrayToList(values, (Object[])((Attribute)list.get(0)).getValue());
            block0: for (int i = 0; i < removeValues.length; ++i) {
                for (int j = 0; j < values.size(); ++j) {
                    if (!removeValues[i].equals(values.get(j))) continue;
                    values.remove(j);
                    continue block0;
                }
            }
        }
        return this.setAttribute(dottedName, values.toArray(new String[0]));
    }

    private ManagedConfigBean getManagedConfigBean(String dottedName) throws MBeanConfigException {
        int elementTargetType;
        String resolvedName;
        int cmdTargetType = DottedNameHelper.getDottedNameTargetType(this._ctx, dottedName);
        MBeanRegistryEntry entry = this.findRegistryEntry(dottedName, cmdTargetType);
        ManagedConfigBean mbc = null;
        if (entry != null && (resolvedName = DottedNameHelper.resolveDottedNameToTarget(this._ctx, dottedName, cmdTargetType, elementTargetType = this.getRegistryEntryTargetType(entry))) != null) {
            try {
                MBeanNamingInfo namingInfo = new MBeanNamingInfo(entry.getNamingDescriptor(), resolvedName);
                String xpath = namingInfo.getXPath();
                ConfigBean configBean = ConfigBeansFactory.getConfigBeanByXPath(this._ctx, xpath);
                if (configBean != null) {
                    ModelMBeanInfo mbi = entry.createMBeanInfo(namingInfo, "offline");
                    mbc = new ManagedConfigBean((MBeanInfo)((Object)mbi), configBean, this._registry);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (mbc == null) {
            throw new MBeanConfigException("config element is not found");
        }
        return mbc;
    }

    private MBeanRegistryEntry findRegistryEntry(String dottedName, int nameTarget) {
        MBeanRegistryEntry[] entries = this._registry.findMBeanRegistryEntriesByDottedName(dottedName);
        if (entries == null || entries.length == 0) {
            return null;
        }
        if (entries.length == 1) {
            return entries[0];
        }
        for (int i = 0; i < entries.length; ++i) {
            int entryTarget = this.getRegistryEntryTargetType(entries[i]);
            if (nameTarget == entryTarget) {
                return entries[i];
            }
            if (!(nameTarget != 2 && nameTarget != 3 || entryTarget != 4 && entryTarget != 6 && entryTarget != 7)) {
                return entries[i];
            }
            if (nameTarget != 1 || entryTarget == 4 || entryTarget == 2 || entryTarget == 3) continue;
            return entries[i];
        }
        return null;
    }

    private int getRegistryEntryTargetType(MBeanRegistryEntry entry) {
        MBeanNamingDescriptor descr = entry.getNamingDescriptor();
        return DottedNameHelper.getTargetTypeForXPath(descr.getXPathPattern());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDottedNames() throws Exception {
        OfflineConfigMgr offlineConfigMgr = this;
        synchronized (offlineConfigMgr) {
            this._allDottedNames = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getListDottedNames(String mask) throws Exception {
        OfflineConfigMgr offlineConfigMgr = this;
        synchronized (offlineConfigMgr) {
            if (this._allDottedNames == null) {
                this._allDottedNames = new ArrayList();
                DottedNameHelper.collectConfigMBeansDottedNames(this._registry, this._ctx.getRootConfigBean(), this._allDottedNames);
            }
        }
        ArrayList list = DottedNameHelper.filterStringValues(this._allDottedNames, mask);
        return DottedNameHelper.sortDottedNames(this._ctx, list);
    }
}

