/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.EJBUtils;
import com.sun.ejb.Invocation;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.ContainerFactoryImpl;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.EJBTimerServiceWrapper;
import com.sun.ejb.containers.StatefulSessionContainer;
import com.sun.ejb.spi.container.StatefulEJBContext;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import java.rmi.Remote;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.SessionContext;
import javax.ejb.TimerService;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.transaction.UserTransaction;
import javax.xml.rpc.handler.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SessionContextImpl
extends EJBContextImpl
implements SessionContext,
StatefulEJBContext {
    private Object instanceKey;
    private boolean completedTxStatus;
    private boolean afterCompletionDelayed = false;
    private boolean committing = false;
    private boolean inAfterCompletion = false;
    private boolean isStateless = false;
    private boolean isStateful = false;
    private boolean existsInSessionStore = false;
    private transient int refCount = 0;
    private boolean txCheckpointDelayed;
    private String ejbName;
    private long lastPersistedAt;
    private long version;
    private transient Map<EntityManagerFactory, EntityManager> extendedEntityManagerMap;
    private transient Set<EntityManagerFactory> emfsRegisteredWithTx;
    private Collection<StatefulSessionContainer.EEMRefInfo> eemRefInfos = new HashSet<StatefulSessionContainer.EEMRefInfo>();

    SessionContextImpl(Object ejb, BaseContainer container) {
        super(ejb, container);
        EjbSessionDescriptor sessionDesc = (EjbSessionDescriptor)this.getContainer().getEjbDescriptor();
        this.isStateless = sessionDesc.isStateless();
        this.isStateful = sessionDesc.isStateful();
        this.ejbName = sessionDesc.getName();
    }

    public String toString() {
        return this.ejbName + "; id: " + this.instanceKey;
    }

    public Map<EntityManagerFactory, EntityManager> getExtendedEntityManagerMap() {
        if (this.extendedEntityManagerMap == null) {
            this.extendedEntityManagerMap = new HashMap<EntityManagerFactory, EntityManager>();
        }
        return this.extendedEntityManagerMap;
    }

    Collection<StatefulSessionContainer.EEMRefInfo> getAllEEMRefInfos() {
        return this.eemRefInfos;
    }

    void setEEMRefInfos(Collection<StatefulSessionContainer.EEMRefInfo> val) {
        if (val != null) {
            this.eemRefInfos = val;
        }
    }

    public void addExtendedEntityManagerMapping(EntityManagerFactory emf, StatefulSessionContainer.EEMRefInfo refInfo) {
        this.getExtendedEntityManagerMap().put(emf, refInfo.getEntityManager());
    }

    public EntityManager getExtendedEntityManager(EntityManagerFactory emf) {
        return this.getExtendedEntityManagerMap().get(emf);
    }

    public Collection<EntityManager> getExtendedEntityManagers() {
        return this.getExtendedEntityManagerMap().values();
    }

    private Set<EntityManagerFactory> getEmfsRegisteredWithTx() {
        if (this.emfsRegisteredWithTx == null) {
            this.emfsRegisteredWithTx = new HashSet<EntityManagerFactory>();
        }
        return this.emfsRegisteredWithTx;
    }

    public void setEmfRegisteredWithTx(EntityManagerFactory emf, boolean flag) {
        if (flag) {
            this.getEmfsRegisteredWithTx().add(emf);
        } else {
            this.getEmfsRegisteredWithTx().remove(emf);
        }
    }

    public boolean isEmfRegisteredWithTx(EntityManagerFactory emf) {
        return this.getEmfsRegisteredWithTx().contains(emf);
    }

    public TimerService getTimerService() throws IllegalStateException {
        if (this.isStateful) {
            throw new IllegalStateException("EJBTimer Service is not accessible to Stateful Session ejbs");
        }
        if (this.instanceKey == null) {
            throw new IllegalStateException("Operation not allowed");
        }
        ContainerFactoryImpl cf = (ContainerFactoryImpl)Switch.getSwitch().getContainerFactory();
        EJBTimerService timerService = cf.getEJBTimerService();
        if (timerService == null) {
            throw new EJBException("EJB Timer service not available");
        }
        return new EJBTimerServiceWrapper(timerService, this);
    }

    @Override
    public UserTransaction getUserTransaction() throws IllegalStateException {
        if (this.state == -999 && this.instanceKey == null) {
            throw new IllegalStateException("Operation not allowed");
        }
        return ((BaseContainer)this.getContainer()).getUserTransaction();
    }

    public MessageContext getMessageContext() {
        if (this.isStateless) {
            Switch theSwitch = Switch.getSwitch();
            InvocationManager invManager = theSwitch.getInvocationManager();
            try {
                ComponentInvocation inv = invManager.getCurrentInvocation();
                if (inv != null && this.isWebServiceInvocation(inv)) {
                    return ((Invocation)inv).messageContext;
                }
                throw new IllegalStateException("Attempt to access MessageContext outside of a web service invocation");
            }
            catch (Exception e) {
                IllegalStateException ise = new IllegalStateException();
                ise.initCause(e);
                throw ise;
            }
        }
        throw new IllegalStateException("Attempt to access MessageContext from stateful session ejb");
    }

    public <T> T getBusinessObject(Class<T> businessInterface) throws IllegalStateException {
        if (this.instanceKey == null) {
            throw new IllegalStateException("Operation not allowed");
        }
        Object businessObject = null;
        EjbDescriptor ejbDesc = this.container.getEjbDescriptor();
        if (businessInterface != null) {
            String intfName = businessInterface.getName();
            if (this.ejbLocalBusinessObjectImpl != null && ejbDesc.getLocalBusinessClassNames().contains(intfName)) {
                businessObject = this.ejbLocalBusinessObjectImpl.getClientObject(intfName);
            } else if (this.ejbRemoteBusinessObjectImpl != null && ejbDesc.getRemoteBusinessClassNames().contains(intfName)) {
                String generatedIntf = EJBUtils.getGeneratedRemoteIntfName(intfName);
                Remote stub = this.ejbRemoteBusinessObjectImpl.getStub(generatedIntf);
                try {
                    businessObject = EJBUtils.createRemoteBusinessObject(this.container.getClassLoader(), intfName, stub);
                }
                catch (Exception e) {
                    IllegalStateException ise = new IllegalStateException("Error creating remote business object for " + intfName);
                    ise.initCause(e);
                    throw ise;
                }
            }
        }
        if (businessObject == null) {
            throw new IllegalStateException("Invalid business interface : " + businessInterface + " for ejb " + ejbDesc.getName());
        }
        return (T)businessObject;
    }

    public Class getInvokedBusinessInterface() throws IllegalStateException {
        Switch theSwitch = Switch.getSwitch();
        InvocationManager invManager = theSwitch.getInvocationManager();
        Class businessInterface = null;
        try {
            ComponentInvocation inv = invManager.getCurrentInvocation();
            if (inv != null && inv instanceof Invocation) {
                Invocation invocation = (Invocation)inv;
                if (invocation.isBusinessInterface) {
                    businessInterface = invocation.clientInterface;
                }
            }
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException();
            ise.initCause(e);
            throw ise;
        }
        if (businessInterface == null) {
            throw new IllegalStateException("Attempt to call getInvokedBusinessInterface outside the scope of a business method");
        }
        return businessInterface;
    }

    @Override
    protected void checkAccessToCallerSecurity() throws IllegalStateException {
        if (this.isStateless ? this.state == -999 || this.inEjbRemove : this.state == -999) {
            throw new IllegalStateException("Operation not allowed");
        }
    }

    @Override
    public void checkTimerServiceMethodAccess() throws IllegalStateException {
        ComponentInvocation compInv = this.getCurrentComponentInvocation();
        if (this.isStateful && (this.inStatefulSessionEjbCreate(compInv) || this.inActivatePassivate(compInv) || this.inAfterCompletion)) {
            throw new IllegalStateException("EJB Timer methods for stateful session beans cannot be  called in this context");
        }
        if (this.state == -999 || this.inEjbRemove) {
            throw new IllegalStateException("EJB Timer method calls cannot be called in this context");
        }
    }

    public Object getInstanceKey() {
        return this.instanceKey;
    }

    public void setInstanceKey(Object instanceKey) {
        this.instanceKey = instanceKey;
    }

    boolean getCompletedTxStatus() {
        return this.completedTxStatus;
    }

    void setCompletedTxStatus(boolean s) {
        this.completedTxStatus = s;
    }

    boolean isAfterCompletionDelayed() {
        return this.afterCompletionDelayed;
    }

    void setAfterCompletionDelayed(boolean s) {
        this.afterCompletionDelayed = s;
    }

    boolean isTxCompleting() {
        return this.committing;
    }

    void setTxCompleting(boolean s) {
        this.committing = s;
    }

    void setInAfterCompletion(boolean flag) {
        this.inAfterCompletion = flag;
    }

    private ComponentInvocation getCurrentComponentInvocation() {
        BaseContainer container = (BaseContainer)this.getContainer();
        return container.invocationManager.getCurrentInvocation();
    }

    private boolean isWebServiceInvocation(ComponentInvocation inv) {
        return inv instanceof Invocation && ((Invocation)inv).isWebService;
    }

    private boolean inStatefulSessionEjbCreate(ComponentInvocation inv) {
        boolean inEjbCreate = false;
        if (inv instanceof Invocation) {
            Class clientIntf = ((Invocation)inv).clientInterface;
            inEjbCreate = ((Invocation)inv).isHome && (EJBHome.class.isAssignableFrom(clientIntf) || EJBLocalHome.class.isAssignableFrom(clientIntf));
        }
        return inEjbCreate;
    }

    void setTxCheckpointDelayed(boolean val) {
        this.txCheckpointDelayed = val;
    }

    boolean isTxCheckpointDelayed() {
        return this.txCheckpointDelayed;
    }

    long getLastPersistedAt() {
        return this.lastPersistedAt;
    }

    void setLastPersistedAt(long val) {
        this.lastPersistedAt = val;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public long incrementAndGetVersion() {
        return ++this.version;
    }

    @Override
    public void setVersion(long newVersion) {
        this.version = newVersion;
    }

    @Override
    public long getLastAccessTime() {
        return this.getLastTimeUsed();
    }

    @Override
    public boolean canBePassivated() {
        return this.state == 2;
    }

    public boolean hasExtendedPC() {
        return this.getExtendedEntityManagerMap().size() != 0;
    }

    @Override
    public SessionContext getSessionContext() {
        return this;
    }

    @Override
    public boolean existsInStore() {
        return this.existsInSessionStore;
    }

    @Override
    public void setExistsInStore(boolean val) {
        this.existsInSessionStore = val;
    }

    public final void incrementRefCount() {
        ++this.refCount;
    }

    public final void decrementRefCount() {
        --this.refCount;
    }

    public final int getRefCount() {
        return this.refCount;
    }
}

