/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.task;

import java.io.File;
import java.io.FileWriter;
import org.apache.ddlutils.io.DatabaseIO;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.task.Command;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class SplitSchemaFileByTable
implements Command {
    private String _destination;

    public void setDestination(String destination) {
        this._destination = destination;
    }

    public String getDestination() {
        return this._destination;
    }

    public void execute(Task task, Database model) throws BuildException {
        Table[] tables = model.getTables();
        int i = 0;
        while (i < tables.length) {
            String outputFile = String.valueOf(tables[i].getName()) + ".xml";
            if (this._destination != null) {
                outputFile = !this._destination.endsWith(File.separator) ? String.valueOf(this._destination) + File.separator + outputFile : String.valueOf(this._destination) + outputFile;
            }
            try {
                FileWriter outputWriter = new FileWriter(outputFile);
                DatabaseIO dbIO = new DatabaseIO();
                Database m = new Database();
                m.setIdMethod(model.getIdMethod());
                m.setName(model.getName());
                m.setVersion(model.getVersion());
                m.addTable(tables[i]);
                dbIO.write(m, outputWriter);
                outputWriter.close();
                task.log("Written schema to " + outputFile, 2);
            }
            catch (Exception ex) {
                throw new BuildException("Failed to write to output file " + outputFile, (Throwable)ex);
            }
            ++i;
        }
    }

    public boolean isRequiringModel() {
        return true;
    }
}

