/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.task;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.task.Command;
import org.apache.ddlutils.task.DatabaseCommand;
import org.apache.ddlutils.task.PlatformConfiguration;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public abstract class DatabaseTaskBase
extends Task {
    private PlatformConfiguration _platformConf = new PlatformConfiguration();
    private ArrayList _commands = new ArrayList();

    public String getDatabaseType() {
        return this._platformConf.getDatabaseType();
    }

    public void setDatabaseType(String type) {
        if (type != null && type.length() > 0) {
            this._platformConf.setDatabaseType(type);
        }
    }

    public BasicDataSource getDataSource() {
        return this._platformConf.getDataSource();
    }

    public void addConfiguredDatabase(BasicDataSource dataSource) {
        this._platformConf.setDataSource(dataSource);
    }

    public void setCatalogPattern(String catalogPattern) {
        if (catalogPattern != null && catalogPattern.length() > 0) {
            this._platformConf.setCatalogPattern(catalogPattern);
        }
    }

    public void setSchemaPattern(String schemaPattern) {
        if (schemaPattern != null && schemaPattern.length() > 0) {
            this._platformConf.setSchemaPattern(schemaPattern);
        }
    }

    public boolean isUseDelimitedSqlIdentifiers() {
        return this._platformConf.isUseDelimitedSqlIdentifiers();
    }

    public void setUseDelimitedSqlIdentifiers(boolean useDelimitedSqlIdentifiers) {
        this._platformConf.setUseDelimitedSqlIdentifiers(useDelimitedSqlIdentifiers);
    }

    public boolean isSortForeignKeys() {
        return this._platformConf.isSortForeignKeys();
    }

    public void setSortForeignKeys(boolean sortForeignKeys) {
        this._platformConf.setSortForeignKeys(sortForeignKeys);
    }

    public boolean isShutdownDatabase() {
        return this._platformConf.isShutdownDatabase();
    }

    public void setShutdownDatabase(boolean shutdownDatabase) {
        this._platformConf.setShutdownDatabase(shutdownDatabase);
    }

    protected void addCommand(Command command) {
        this._commands.add(command);
    }

    protected boolean hasCommands() {
        return !this._commands.isEmpty();
    }

    protected Iterator getCommands() {
        return this._commands.iterator();
    }

    protected PlatformConfiguration getPlatformConfiguration() {
        return this._platformConf;
    }

    protected Platform getPlatform() {
        return this._platformConf.getPlatform();
    }

    protected abstract Database readModel();

    protected void executeCommands(Database model) throws BuildException {
        Iterator it = this.getCommands();
        while (it.hasNext()) {
            Command cmd = (Command)it.next();
            if (cmd.isRequiringModel() && model == null) {
                throw new BuildException("No database model specified");
            }
            if (cmd instanceof DatabaseCommand) {
                ((DatabaseCommand)cmd).setPlatformConfiguration(this._platformConf);
            }
            cmd.execute(this, model);
        }
    }

    public void execute() throws BuildException {
        if (!this.hasCommands()) {
            this.log("No sub tasks specified, so there is nothing to do.", 2);
            return;
        }
        ClassLoader sysClassLoader = Thread.currentThread().getContextClassLoader();
        AntClassLoader newClassLoader = new AntClassLoader(((Object)((Object)this)).getClass().getClassLoader(), true);
        Thread.currentThread().setContextClassLoader((ClassLoader)newClassLoader);
        try {
            this.executeCommands(this.readModel());
        }
        finally {
            if (this.getDataSource() != null && this.isShutdownDatabase()) {
                this.getPlatform().shutdownDatabase();
            }
            Thread.currentThread().setContextClassLoader(sysClassLoader);
        }
    }
}

