/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.io;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import org.apache.commons.beanutils.DynaBean;
import org.apache.ddlutils.dynabean.SqlDynaBean;
import org.apache.ddlutils.io.ConverterConfiguration;
import org.apache.ddlutils.io.DataSink;
import org.apache.ddlutils.io.DataSinkException;
import org.apache.ddlutils.io.DataWriter;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;

public class DataToFileSink
implements DataSink {
    private Database _model;
    private ConverterConfiguration _converterConf;
    private String _destination;
    private String _tableName;
    private ArrayList<SqlDynaBean> _tables;

    public DataToFileSink(Database model, ConverterConfiguration converterConf, String destination) {
        this._model = model;
        this._converterConf = converterConf;
        this._destination = destination;
    }

    public void addBean(DynaBean bean) throws DataSinkException {
        SqlDynaBean sqlBean = (SqlDynaBean)bean;
        Table table = this._model.getDynaClassFor(bean).getTable();
        if (this._tables == null || this._tableName == null) {
            this._tables = new ArrayList();
            this._tableName = table.getName();
            this._tables.add(sqlBean);
        } else if (table.getName().equalsIgnoreCase(this._tableName)) {
            this._tables.add(sqlBean);
        } else {
            this.writeDataToFile();
            this._tables = new ArrayList();
            this._tableName = table.getName();
            this._tables.add(sqlBean);
        }
    }

    private void writeDataToFile() throws DataSinkException {
        String fileName = String.valueOf(this._tableName) + ".xml";
        if (this._destination != null) {
            fileName = this._destination.endsWith(File.separator) ? String.valueOf(this._destination) + fileName : String.valueOf(this._destination) + File.separator + fileName;
        }
        try {
            DataWriter writer = new DataWriter(new FileOutputStream(fileName), null);
            writer.setConvertedConfiguration(this._converterConf);
            writer.writeDocumentStart();
            int size = this._tables.size();
            int idx = 0;
            while (idx < size) {
                SqlDynaBean bean = this._tables.get(idx);
                writer.write(bean);
                ++idx;
            }
            writer.writeDocumentEnd();
        }
        catch (Exception ex) {
            throw new DataSinkException(ex);
        }
    }

    public void end() throws DataSinkException {
        if (this._tables != null && this._tables.size() > 0) {
            this.writeDataToFile();
        }
    }

    public void start() throws DataSinkException {
        this._tables = null;
        this._tableName = null;
    }
}

