/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VComboBox;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLocator;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VNumber;
import org.compiere.grid.ed.VPAttribute;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.GridField;
import org.compiere.model.GridFieldVO;
import org.compiere.model.Lookup;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MColumn;
import org.compiere.model.MLocatorLookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MPAttributeLookup;
import org.compiere.model.MProduct;
import org.compiere.model.MStorage;
import org.compiere.model.MTab;
import org.compiere.model.MWindow;
import org.compiere.plaf.CompiereColor;
import org.compiere.process.ProcessInfo;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.swing.CTextPane;
import org.compiere.util.ASyncProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;
import org.eevolution.model.MPPOrder;
import org.eevolution.model.MPPOrderBOMLine;

public class VOrderReceiptIssue
extends CPanel
implements FormPanel,
ActionListener,
VetoableChangeListener,
ChangeListener,
ListSelectionListener,
TableModelListener,
ASyncProcess {
    private static final long serialVersionUID = 1L;
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private StatusBar statusBar = new StatusBar();
    private static CLogger log = CLogger.getCLogger(VOrderReceiptIssue.class);
    private CPanel mainPanel = new CPanel();
    private CPanel Generate = new CPanel();
    private CPanel PanelBottom = new CPanel();
    private CPanel PanelCenter = new CPanel();
    private CPanel northPanel = new CPanel();
    private CButton Process = new CButton();
    private CPanel ReceiptIssueOrder = new CPanel();
    private JTabbedPane TabsReceiptsIssue = new JTabbedPane();
    private VPAttribute attribute = null;
    private CLabel attributeLabel = new CLabel();
    private VNumber orderedQtyField = new VNumber("QtyOrdered", false, false, false, 29, "QtyOrdered");
    private CLabel orderedQtyLabel = new CLabel();
    private VNumber deliveredQtyField = new VNumber("QtyDelivered", false, false, false, 29, "QtyDelivered");
    private CLabel deliveredQtyLabel = new CLabel();
    private VNumber openQtyField = new VNumber("QtyOpen", false, false, false, 29, "QtyOpen");
    private CLabel openQtyLabel = new CLabel();
    private VNumber toDeliverQty = new VNumber("QtyToDeliver", true, false, true, 29, "QtyToDeliver");
    private CLabel toDeliverQtyLabel = new CLabel();
    private JScrollPane issueScrollPane = new JScrollPane();
    private MiniTable issue = new MiniTable();
    private VDate movementDateField = new VDate("MovementDate", true, false, true, 15, "MovementDate");
    private CLabel movementDateLabel = new CLabel();
    private VLookup orderField = null;
    private CLabel orderLabel = new CLabel();
    private VNumber rejectQty = new VNumber("Qtyreject", false, false, true, 29, "QtyReject");
    private CLabel rejectQtyLabel = new CLabel();
    private VLookup resourceField = null;
    private CLabel resourceLabel = new CLabel();
    private VLookup warehouseField = null;
    private CLabel warehouseLabel = new CLabel();
    private VNumber scrapQtyField = new VNumber("Qtyscrap", false, false, true, 29, "Qtyscrap");
    private CLabel scrapQtyLabel = new CLabel();
    private CLabel backflushGroupLabel = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"BackflushGroup"));
    private CTextField backflushGroup = new CTextField(10);
    private CLabel productLabel = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"M_Product_ID"));
    private VLookup productField = null;
    private CLabel uomLabel = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"C_UOM_ID"));
    private VLookup uomField = null;
    private CLabel uomorderLabel = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"Altert UOM"));
    private VLookup uomorderField = null;
    private CLabel locatorLabel = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"M_Locator_ID"));
    private VLocator locatorField = null;
    private CLabel labelcombo = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"DeliveryRule"));
    private VComboBox pickcombo = new VComboBox();
    private CLabel QtyBatchsLabel = new CLabel();
    private VNumber qtyBatchsField = new VNumber("QtyBatchs", false, false, false, 29, "QtyBatchs");
    private CLabel QtyBatchSizeLabel = new CLabel();
    private VNumber qtyBatchSizeField = new VNumber("QtyBatchSize", false, false, false, 29, "QtyBatchSize");
    private CTextPane info = new CTextPane();
    private MPPOrder m_PP_order = null;

    public void init(int WindowNo, FormFrame frame) {
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        log.info("VOrderReceipIssue.init - WinNo=" + this.m_WindowNo);
        try {
            this.fillPicks();
            this.jbInit();
            this.dynInit();
            this.pickcombo.addActionListener((ActionListener)this);
            frame.getContentPane().add((Component)this.mainPanel, "Center");
            frame.getContentPane().add((Component)this.statusBar, "South");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "VOrderReceipIssue.init", (Throwable)e);
        }
    }

    private void fillPicks() throws Exception {
        Properties ctx = Env.getCtx();
        Language language = Language.getLoginLanguage();
        MLookup orderL = MLookupFactory.get((Properties)ctx, (int)this.m_WindowNo, (int)MColumn.getColumn_ID((String)"PP_Order", (String)"PP_Order_ID"), (int)30, (Language)language, (String)"PP_Order_ID", (int)0, (boolean)false, (String)"PP_Order.DocStatus = 'CO'");
        this.orderField = new VLookup("PP_Order_ID", false, false, true, (Lookup)orderL);
        this.orderField.setBackground(AdempierePLAF.getInfoBackground());
        this.orderField.addVetoableChangeListener((VetoableChangeListener)this);
        MLookup resourceL = MLookupFactory.get((Properties)ctx, (int)this.m_WindowNo, (int)0, (int)MColumn.getColumn_ID((String)"PP_Order", (String)"S_Resource_ID"), (int)19);
        this.resourceField = new VLookup("S_Resource_ID", false, false, false, (Lookup)resourceL);
        MLookup warehouseL = MLookupFactory.get((Properties)ctx, (int)this.m_WindowNo, (int)0, (int)MColumn.getColumn_ID((String)"PP_Order", (String)"M_Warehouse_ID"), (int)19);
        this.warehouseField = new VLookup("M_Warehouse_ID", false, false, false, (Lookup)warehouseL);
        MLookup productL = MLookupFactory.get((Properties)ctx, (int)this.m_WindowNo, (int)0, (int)MColumn.getColumn_ID((String)"PP_Order", (String)"M_Product_ID"), (int)19);
        this.productField = new VLookup("M_Product_ID", false, false, false, (Lookup)productL);
        MLookup uomL = MLookupFactory.get((Properties)ctx, (int)this.m_WindowNo, (int)0, (int)MColumn.getColumn_ID((String)"PP_Order", (String)"C_UOM_ID"), (int)19);
        this.uomField = new VLookup("C_UOM_ID", false, false, false, (Lookup)uomL);
        MLookup uomorderL = MLookupFactory.get((Properties)ctx, (int)this.m_WindowNo, (int)0, (int)MColumn.getColumn_ID((String)"PP_Order", (String)"C_UOM_ID"), (int)19);
        this.uomorderField = new VLookup("C_UOM_ID", false, false, false, (Lookup)uomorderL);
        MLocatorLookup locatorL = new MLocatorLookup(ctx, this.m_WindowNo);
        this.locatorField = new VLocator("M_Locator_ID", true, false, true, locatorL, this.m_WindowNo);
        MPAttributeLookup attributeL = new MPAttributeLookup(ctx, this.m_WindowNo);
        this.attribute = new VPAttribute(false, false, true, this.m_WindowNo, attributeL);
        this.attribute.setValue((Object)0);
        int m_Window = MWindow.getWindow_ID((String)"Manufacturing Order");
        GridFieldVO vo = GridFieldVO.createStdField((Properties)ctx, (int)this.m_WindowNo, (int)0, (int)m_Window, (int)MTab.getTab_ID((int)m_Window, (String)"Order"), (boolean)false, (boolean)false, (boolean)false);
        vo.AD_Column_ID = MColumn.getColumn_ID((String)"PP_Order", (String)"M_AttributeSetInstance_ID");
        GridField field = new GridField(vo);
        this.attribute.setField(field);
        this.scrapQtyField.setValue((Object)Env.ZERO);
        this.rejectQty.setValue((Object)Env.ZERO);
        this.pickcombo.addItem((Object)new KeyNamePair(1, Msg.translate((Properties)Env.getCtx(), (String)"IsBackflush")));
        this.pickcombo.addItem((Object)new KeyNamePair(2, Msg.translate((Properties)Env.getCtx(), (String)"OnlyIssue")));
        this.pickcombo.addItem((Object)new KeyNamePair(3, Msg.translate((Properties)Env.getCtx(), (String)"OnlyReceipt")));
        this.pickcombo.addActionListener((ActionListener)this);
        this.Process.addActionListener((ActionListener)this);
        this.toDeliverQty.addActionListener((ActionListener)this);
        this.scrapQtyField.addActionListener((ActionListener)this);
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout((LayoutManager)new BorderLayout());
        this.ReceiptIssueOrder.setLayout((LayoutManager)new BorderLayout());
        this.PanelCenter.setLayout((LayoutManager)new BorderLayout());
        this.issueScrollPane.setBorder(new TitledBorder(""));
        this.issueScrollPane.setViewportView((Component)this.issue);
        this.PanelCenter.add((Component)this.issueScrollPane, (Object)"Center");
        this.ReceiptIssueOrder.add((Component)this.PanelCenter, (Object)"Center");
        this.Process.setText(Msg.translate((Properties)Env.getCtx(), (String)"OK"));
        this.PanelBottom.add((Component)this.Process);
        this.ReceiptIssueOrder.add((Component)this.PanelBottom, (Object)"South");
        this.northPanel.setLayout((LayoutManager)new GridBagLayout());
        this.orderLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"PP_Order_ID"));
        this.northPanel.add((Component)this.orderLabel, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.orderField, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.resourceLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"S_Resource_ID"));
        this.northPanel.add((Component)this.resourceLabel, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.resourceField, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.warehouseLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"M_Warehouse_ID"));
        this.northPanel.add((Component)this.warehouseLabel, (Object)new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.warehouseField, (Object)new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.warehouseLabel, (Object)new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.productLabel, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.productField, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.uomLabel, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.uomField, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.uomorderLabel, (Object)new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.uomorderField, (Object)new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.orderedQtyLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"QtyOrdered"));
        this.northPanel.add((Component)this.orderedQtyLabel, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.orderedQtyField, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.deliveredQtyLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"QtyDelivered"));
        this.northPanel.add((Component)this.deliveredQtyLabel, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.deliveredQtyField, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.openQtyLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"QtyOpen"));
        this.northPanel.add((Component)this.openQtyLabel, (Object)new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.openQtyField, (Object)new GridBagConstraints(5, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.QtyBatchsLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"QtyBatchs"));
        this.northPanel.add((Component)this.QtyBatchsLabel, (Object)new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.qtyBatchsField, (Object)new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.QtyBatchSizeLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"QtyBatchSize"));
        this.northPanel.add((Component)this.QtyBatchSizeLabel, (Object)new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.qtyBatchSizeField, (Object)new GridBagConstraints(5, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.labelcombo, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.pickcombo, (Object)new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.toDeliverQtyLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"QtyToDeliver"));
        this.northPanel.add((Component)this.toDeliverQtyLabel, (Object)new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.toDeliverQty, (Object)new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.scrapQtyLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"QtyScrap"));
        this.northPanel.add((Component)this.scrapQtyLabel, (Object)new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.scrapQtyField, (Object)new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.rejectQtyLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"QtyReject"));
        this.northPanel.add((Component)this.rejectQtyLabel, (Object)new GridBagConstraints(4, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.rejectQty, (Object)new GridBagConstraints(5, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.movementDateLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"MovementDate"));
        this.northPanel.add((Component)this.movementDateLabel, (Object)new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.movementDateField, (Object)new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.locatorLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"M_Locator_ID"));
        this.northPanel.add((Component)this.locatorLabel, (Object)new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.locatorField, (Object)new GridBagConstraints(3, 7, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.attributeLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"M_AttributeSetInstance_ID"));
        this.northPanel.add((Component)this.attributeLabel, (Object)new GridBagConstraints(4, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.attribute, (Object)new GridBagConstraints(5, 7, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.backflushGroupLabel, (Object)new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.backflushGroup, (Object)new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.ReceiptIssueOrder.add((Component)this.northPanel, (Object)"North");
        this.TabsReceiptsIssue.add((Component)this.ReceiptIssueOrder, Msg.translate((Properties)Env.getCtx(), (String)"IsShipConfirm"));
        this.TabsReceiptsIssue.add((Component)this.Generate, Msg.translate((Properties)Env.getCtx(), (String)"Generate"));
        this.Generate.setLayout((LayoutManager)new BorderLayout());
        this.Generate.add((Component)this.info, (Object)"Center");
        this.Generate.setEnabled(false);
        this.info.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        this.info.setEditable(false);
        this.TabsReceiptsIssue.addChangeListener(this);
        this.add(this.TabsReceiptsIssue, "Center");
        this.mainPanel.add((Component)this.TabsReceiptsIssue, (Object)"Center");
        this.add((Component)this.mainPanel, "North");
    }

    private void dynInit() {
        this.disableToDeliver();
        this.issue.addColumn("PP_Order_BOMLine_ID");
        this.issue.addColumn("IsCritical");
        this.issue.addColumn("Value");
        this.issue.addColumn("M_Product_ID");
        this.issue.addColumn("C_UOM_ID");
        this.issue.addColumn("M_AttributeSetInstance_ID");
        this.issue.addColumn("QtyRequiered");
        this.issue.addColumn("QtyDelivered");
        this.issue.addColumn("QtyToDeliver");
        this.issue.addColumn("QtyScrap");
        this.issue.addColumn("QtyOnHand");
        this.issue.addColumn("QtyReserved");
        this.issue.addColumn("QtyAvailable");
        this.issue.addColumn("M_Locator_ID");
        this.issue.addColumn("M_Warehouse_ID");
        this.issue.addColumn("QtyBOM");
        this.issue.addColumn("IsQtyPercentage");
        this.issue.addColumn("QtyBatch");
        this.issue.setMultiSelection(true);
        this.issue.setRowSelectionAllowed(true);
        this.issue.setColumnClass(0, IDColumn.class, false, " ");
        this.issue.setColumnClass(1, Boolean.class, true, Msg.translate((Properties)Env.getCtx(), (String)"IsCritical"));
        this.issue.setColumnClass(2, String.class, true, Msg.translate((Properties)Env.getCtx(), (String)"Value"));
        this.issue.setColumnClass(3, KeyNamePair.class, true, Msg.translate((Properties)Env.getCtx(), (String)"M_Product_ID"));
        this.issue.setColumnClass(4, KeyNamePair.class, true, Msg.translate((Properties)Env.getCtx(), (String)"C_UOM_ID"));
        this.issue.setColumnClass(5, String.class, true, Msg.translate((Properties)Env.getCtx(), (String)"M_AttributeSetInstance_ID"));
        this.issue.setColumnClass(6, BigDecimal.class, true, Msg.translate((Properties)Env.getCtx(), (String)"QtyRequired"));
        this.issue.setColumnClass(7, BigDecimal.class, true, Msg.translate((Properties)Env.getCtx(), (String)"QtyDelivered"));
        this.issue.setColumnClass(8, BigDecimal.class, false, Msg.translate((Properties)Env.getCtx(), (String)"QtyToDeliver"));
        this.issue.setColumnClass(9, BigDecimal.class, false, Msg.translate((Properties)Env.getCtx(), (String)"QtyScrap"));
        this.issue.setColumnClass(10, BigDecimal.class, true, Msg.translate((Properties)Env.getCtx(), (String)"QtyOnHand"));
        this.issue.setColumnClass(11, BigDecimal.class, true, Msg.translate((Properties)Env.getCtx(), (String)"QtyReserved"));
        this.issue.setColumnClass(12, BigDecimal.class, true, Msg.translate((Properties)Env.getCtx(), (String)"QtyAvailable"));
        this.issue.setColumnClass(13, String.class, true, Msg.translate((Properties)Env.getCtx(), (String)"M_Locator_ID"));
        this.issue.setColumnClass(14, KeyNamePair.class, true, Msg.translate((Properties)Env.getCtx(), (String)"M_Warehouse_ID"));
        this.issue.setColumnClass(15, BigDecimal.class, true, Msg.translate((Properties)Env.getCtx(), (String)"QtyBom"));
        this.issue.setColumnClass(16, Boolean.class, true, Msg.translate((Properties)Env.getCtx(), (String)"IsQtyPercentage"));
        this.issue.setColumnClass(17, BigDecimal.class, true, Msg.translate((Properties)Env.getCtx(), (String)"QtyBatch"));
        this.issue.autoSize();
        this.issue.getModel().addTableModelListener(this);
        CompiereColor.setBackground((JComponent)((Object)this));
        this.issue.setCellSelectionEnabled(true);
        this.issue.getSelectionModel().addListSelectionListener(this);
        this.issue.setRowCount(0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.fine("Event:" + e.getSource());
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
            return;
        }
        if (e.getSource().equals(this.Process)) {
            if (this.getMovementDate() == null) {
                JOptionPane.showMessageDialog(null, Msg.getMsg((Properties)Env.getCtx(), (String)"NoDate"), "Info", 1);
                return;
            }
            if ((this.isOnlyReceipt() || this.isBackflush()) && this.getM_Locator_ID() <= 0) {
                JOptionPane.showMessageDialog(null, Msg.getMsg((Properties)Env.getCtx(), (String)"NoLocator"), "Info", 1);
                return;
            }
            this.TabsReceiptsIssue.setSelectedIndex(1);
            this.generateSummaryTable();
            if (ADialog.ask((int)this.m_WindowNo, (Container)((Object)this), (String)"Update")) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (this.cmd_process()) {
                    this.dispose();
                    return;
                }
                this.setCursor(Cursor.getDefaultCursor());
            }
            this.TabsReceiptsIssue.setSelectedIndex(0);
        }
        if ((e.getSource().equals(this.toDeliverQty) || e.getSource().equals(this.scrapQtyField)) && this.getPP_Order_ID() > 0 && this.isBackflush()) {
            this.executeQuery();
        }
        if (e.getSource().equals(this.pickcombo)) {
            if (this.isOnlyReceipt()) {
                this.enableToDeliver();
                this.locatorLabel.setVisible(true);
                this.locatorField.setVisible(true);
                this.attribute.setVisible(true);
                this.attributeLabel.setVisible(true);
                this.issue.setVisible(false);
            } else if (this.isOnlyIssue()) {
                this.disableToDeliver();
                this.locatorLabel.setVisible(false);
                this.locatorField.setVisible(false);
                this.attribute.setVisible(false);
                this.attributeLabel.setVisible(false);
                this.issue.setVisible(true);
                this.executeQuery();
            } else if (this.isBackflush()) {
                this.enableToDeliver();
                this.locatorLabel.setVisible(true);
                this.locatorField.setVisible(true);
                this.attribute.setVisible(true);
                this.attributeLabel.setVisible(true);
                this.issue.setVisible(true);
                this.executeQuery();
            }
            this.setToDeliverQty(this.getOpenQty());
        }
    }

    public void enableToDeliver() {
        this.setToDeliver(true);
    }

    public void disableToDeliver() {
        this.setToDeliver(false);
    }

    private void setToDeliver(Boolean state) {
        this.toDeliverQty.getComponent(0).setEnabled(state);
        this.toDeliverQty.getComponent(1).setEnabled(state);
        this.scrapQtyLabel.setVisible(state.booleanValue());
        this.scrapQtyField.setVisible(state.booleanValue());
        this.rejectQtyLabel.setVisible(state.booleanValue());
        this.rejectQty.setVisible(state.booleanValue());
    }

    private void executeQuery() {
        this.issue.removeAll();
        String sql = "SELECT obl.PP_Order_BOMLine_ID,obl.IsCritical,p.Value,obl.M_Product_ID,p.Name,p.C_UOM_ID,u.Name,obl.QtyRequiered,obl.QtyReserved,bomQtyAvailable(obl.M_Product_ID,obl.M_Warehouse_ID,0 ) AS QtyAvailable,bomQtyOnHand(obl.M_Product_ID,obl.M_Warehouse_ID,0) AS QtyOnHand,p.M_Locator_ID,obl.M_Warehouse_ID,w.Name,obl.QtyBom,obl.isQtyPercentage,obl.QtyBatch,obl.ComponentType,obl.QtyRequiered - QtyDelivered AS QtyOpen,obl.QtyDelivered FROM PP_Order_BOMLine obl INNER JOIN M_Product p ON (obl.M_Product_ID = p.M_Product_ID)  INNER JOIN C_UOM u ON (p.C_UOM_ID = u.C_UOM_ID)  INNER JOIN M_Warehouse w ON (w.M_Warehouse_ID = obl.M_Warehouse_ID)  WHERE obl.PP_Order_ID = ? ORDER BY obl.Line";
        int row = 0;
        this.issue.setRowCount(row);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)"SELECT obl.PP_Order_BOMLine_ID,obl.IsCritical,p.Value,obl.M_Product_ID,p.Name,p.C_UOM_ID,u.Name,obl.QtyRequiered,obl.QtyReserved,bomQtyAvailable(obl.M_Product_ID,obl.M_Warehouse_ID,0 ) AS QtyAvailable,bomQtyOnHand(obl.M_Product_ID,obl.M_Warehouse_ID,0) AS QtyOnHand,p.M_Locator_ID,obl.M_Warehouse_ID,w.Name,obl.QtyBom,obl.isQtyPercentage,obl.QtyBatch,obl.ComponentType,obl.QtyRequiered - QtyDelivered AS QtyOpen,obl.QtyDelivered FROM PP_Order_BOMLine obl INNER JOIN M_Product p ON (obl.M_Product_ID = p.M_Product_ID)  INNER JOIN C_UOM u ON (p.C_UOM_ID = u.C_UOM_ID)  INNER JOIN M_Warehouse w ON (w.M_Warehouse_ID = obl.M_Warehouse_ID)  WHERE obl.PP_Order_ID = ? ORDER BY obl.Line", null);
                pstmt.setInt(1, this.getPP_Order_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    this.issue.setRowCount(row + 1);
                    IDColumn id = new IDColumn(rs.getInt(1));
                    BigDecimal qtyBom = rs.getBigDecimal(15);
                    Boolean isQtyPercentage = rs.getString(16).equals("Y");
                    Boolean isCritical = rs.getString(2).equals("Y");
                    BigDecimal qtyBatch = rs.getBigDecimal(17);
                    BigDecimal qtyRequired = rs.getBigDecimal(8);
                    BigDecimal qtyOnHand = rs.getBigDecimal(11);
                    BigDecimal qtyOpen = rs.getBigDecimal(19);
                    BigDecimal qtyDelivered = rs.getBigDecimal(20);
                    String componentType = rs.getString(18);
                    BigDecimal toDeliverQty = this.getToDeliverQty();
                    BigDecimal openQty = this.getOpenQty();
                    BigDecimal scrapQty = this.getScrapQty();
                    BigDecimal componentToDeliverQty = Env.ZERO;
                    BigDecimal componentScrapQty = Env.ZERO;
                    BigDecimal componentQtyReq = Env.ZERO;
                    BigDecimal componentQtyToDel = Env.ZERO;
                    id.setSelected(this.isOnlyReceipt());
                    this.issue.setValueAt((Object)id, row, 0);
                    this.issue.setValueAt((Object)isCritical, row, 1);
                    this.issue.setValueAt((Object)rs.getString(3), row, 2);
                    this.issue.setValueAt((Object)new KeyNamePair(rs.getInt(4), rs.getString(5)), row, 3);
                    this.issue.setValueAt((Object)new KeyNamePair(rs.getInt(6), rs.getString(7)), row, 4);
                    this.issue.setValueAt((Object)qtyRequired, row, 6);
                    this.issue.setValueAt((Object)qtyDelivered, row, 7);
                    this.issue.setValueAt((Object)qtyOnHand, row, 10);
                    this.issue.setValueAt((Object)rs.getBigDecimal(9), row, 11);
                    this.issue.setValueAt((Object)rs.getBigDecimal(10), row, 12);
                    this.issue.setValueAt((Object)new KeyNamePair(rs.getInt(13), rs.getString(14)), row, 14);
                    this.issue.setValueAt((Object)qtyBom, row, 15);
                    this.issue.setValueAt((Object)isQtyPercentage, row, 16);
                    this.issue.setValueAt((Object)qtyBatch, row, 17);
                    if (componentType.equals("CO") || componentType.equals("PK")) {
                        id.setSelected(qtyOnHand.signum() > 0 && qtyRequired.signum() > 0);
                        if (isQtyPercentage.booleanValue()) {
                            BigDecimal qtyBatchPerc = qtyBatch.divide(Env.ONEHUNDRED, 8, RoundingMode.HALF_UP);
                            if (this.isBackflush()) {
                                if (qtyRequired.signum() == 0 || qtyOpen.signum() == 0) {
                                    componentToDeliverQty = Env.ZERO;
                                } else {
                                    componentToDeliverQty = toDeliverQty.multiply(qtyBatchPerc);
                                    if (qtyRequired.subtract(qtyDelivered).signum() < 0 | componentToDeliverQty.signum() == 0) {
                                        componentToDeliverQty = qtyRequired.subtract(qtyDelivered);
                                    }
                                }
                                if (componentToDeliverQty.signum() != 0) {
                                    componentQtyToDel = componentToDeliverQty.setScale(4, 4);
                                    this.issue.setValueAt((Object)componentToDeliverQty, row, 8);
                                }
                            } else {
                                componentToDeliverQty = qtyOpen;
                                if (componentToDeliverQty.signum() != 0) {
                                    componentQtyReq = openQty.multiply(qtyBatchPerc);
                                    componentQtyToDel = componentToDeliverQty.setScale(4, 4);
                                    this.issue.setValueAt((Object)componentToDeliverQty.setScale(8, 4), row, 8);
                                    this.issue.setValueAt((Object)openQty.multiply(qtyBatchPerc), row, 6);
                                }
                            }
                            if (scrapQty.signum() != 0 && (componentScrapQty = scrapQty.multiply(qtyBatchPerc)).signum() != 0) {
                                this.issue.setValueAt((Object)componentScrapQty, row, 9);
                            }
                        } else {
                            if (this.isBackflush()) {
                                componentToDeliverQty = toDeliverQty.multiply(qtyBom);
                                if (componentToDeliverQty.signum() != 0) {
                                    componentQtyReq = toDeliverQty.multiply(qtyBom);
                                    componentQtyToDel = componentToDeliverQty;
                                    this.issue.setValueAt((Object)componentQtyReq, row, 6);
                                    this.issue.setValueAt((Object)componentToDeliverQty, row, 8);
                                }
                            } else {
                                componentToDeliverQty = qtyOpen;
                                if (componentToDeliverQty.signum() != 0) {
                                    componentQtyReq = openQty.multiply(qtyBom);
                                    componentQtyToDel = componentToDeliverQty;
                                    this.issue.setValueAt((Object)componentQtyReq, row, 6);
                                    this.issue.setValueAt((Object)componentToDeliverQty, row, 8);
                                }
                            }
                            if (scrapQty.signum() != 0 && (componentScrapQty = scrapQty.multiply(qtyBom)).signum() != 0) {
                                this.issue.setValueAt((Object)componentScrapQty, row, 9);
                            }
                        }
                    } else if (componentType.equals("TL")) {
                        componentToDeliverQty = qtyBom;
                        if (componentToDeliverQty.signum() != 0) {
                            componentQtyReq = qtyBom;
                            componentQtyToDel = componentToDeliverQty;
                            this.issue.setValueAt((Object)qtyBom, row, 6);
                            this.issue.setValueAt((Object)componentToDeliverQty, row, 8);
                        }
                    } else {
                        this.issue.setValueAt((Object)Env.ZERO, row, 6);
                        this.issue.setValueAt((Object)Env.ZERO, row, 8);
                    }
                    ++row;
                    if (!this.isOnlyIssue() && !this.isBackflush()) continue;
                    int warehouse_id = rs.getInt(13);
                    int product_id = rs.getInt(4);
                    row += this.lotes(row, id, warehouse_id, product_id, componentQtyReq, componentQtyToDel);
                }
            }
            catch (SQLException e) {
                throw new DBException((Exception)e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        this.issue.autoSize();
    }

    private int lotes(int row, IDColumn id, int Warehouse_ID, int M_Product_ID, BigDecimal qtyRequired, BigDecimal qtyToDelivery) {
        int linesNo = 0;
        BigDecimal qtyRequiredActual = qtyRequired;
        String sql = "SELECT s.M_Product_ID , s.QtyOnHand, s.M_AttributeSetInstance_ID, p.Name, masi.Description, l.Value, w.Value, w.M_warehouse_ID,p.Value  FROM M_Storage s  INNER JOIN M_Product p ON (s.M_Product_ID = p.M_Product_ID)  INNER JOIN C_UOM u ON (u.C_UOM_ID = p.C_UOM_ID)  INNER JOIN M_AttributeSetInstance masi ON (masi.M_AttributeSetInstance_ID = s.M_AttributeSetInstance_ID)  INNER JOIN M_Warehouse w ON (w.M_Warehouse_ID = ?)  INNER JOIN M_Locator l ON(l.M_Warehouse_ID=w.M_Warehouse_ID and s.M_Locator_ID=l.M_Locator_ID)  WHERE s.M_Product_ID = ? and s.QtyOnHand > 0  and s.M_AttributeSetInstance_ID <> 0  ORDER BY s.Created ";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)"SELECT s.M_Product_ID , s.QtyOnHand, s.M_AttributeSetInstance_ID, p.Name, masi.Description, l.Value, w.Value, w.M_warehouse_ID,p.Value  FROM M_Storage s  INNER JOIN M_Product p ON (s.M_Product_ID = p.M_Product_ID)  INNER JOIN C_UOM u ON (u.C_UOM_ID = p.C_UOM_ID)  INNER JOIN M_AttributeSetInstance masi ON (masi.M_AttributeSetInstance_ID = s.M_AttributeSetInstance_ID)  INNER JOIN M_Warehouse w ON (w.M_Warehouse_ID = ?)  INNER JOIN M_Locator l ON(l.M_Warehouse_ID=w.M_Warehouse_ID and s.M_Locator_ID=l.M_Locator_ID)  WHERE s.M_Product_ID = ? and s.QtyOnHand > 0  and s.M_AttributeSetInstance_ID <> 0  ORDER BY s.Created ", null);
                pstmt.setInt(1, Warehouse_ID);
                pstmt.setInt(2, M_Product_ID);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    this.issue.setRowCount(row + 1);
                    BigDecimal qtyOnHand = rs.getBigDecimal(2);
                    IDColumn id1 = new IDColumn(rs.getInt(3));
                    id1.setSelected(false);
                    this.issue.setRowSelectionAllowed(true);
                    this.issue.setValueAt((Object)id1, row, 0);
                    KeyNamePair productkey = new KeyNamePair(rs.getInt(1), rs.getString(4));
                    this.issue.setValueAt((Object)productkey, row, 3);
                    this.issue.setValueAt((Object)qtyOnHand, row, 10);
                    this.issue.setValueAt((Object)rs.getString(5), row, 5);
                    this.issue.setValueAt((Object)rs.getString(6), row, 13);
                    KeyNamePair m_warehousekey = new KeyNamePair(rs.getInt(8), rs.getString(7));
                    this.issue.setValueAt((Object)m_warehousekey, row, 14);
                    if (qtyRequiredActual.compareTo(qtyOnHand) < 0) {
                        this.issue.setValueAt((Object)(qtyRequiredActual.signum() > 0 ? qtyRequiredActual : Env.ZERO), row, 6);
                    } else {
                        this.issue.setValueAt((Object)qtyOnHand, row, 6);
                    }
                    qtyRequiredActual = qtyRequiredActual.subtract(qtyOnHand);
                    ++linesNo;
                    ++row;
                }
            }
            catch (SQLException e) {
                throw new DBException((Exception)e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return linesNo;
    }

    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        String name = e.getPropertyName();
        Object value = e.getNewValue();
        log.fine("VOrderReceip.vetoableChange - " + name + "=" + value);
        if (value == null) {
            return;
        }
        if (name.equals("PP_Order_ID")) {
            this.orderField.setValue(value);
            MPPOrder pp_order = this.getPP_Order();
            if (pp_order != null) {
                this.setS_Resource_ID(pp_order.getS_Resource_ID());
                this.setM_Warehouse_ID(pp_order.getM_Warehouse_ID());
                this.setDeliveredQty(pp_order.getQtyDelivered());
                this.setOrderedQty(pp_order.getQtyOrdered());
                this.setQtyBatchs(pp_order.getQtyBatchs());
                this.setQtyBatchSize(pp_order.getQtyBatchSize());
                this.setOpenQty(pp_order.getQtyOrdered().subtract(pp_order.getQtyDelivered()));
                this.setToDeliverQty(this.getOpenQty());
                this.setM_Product_ID(pp_order.getM_Product_ID());
                MProduct m_product = MProduct.get((Properties)Env.getCtx(), (int)pp_order.getM_Product_ID());
                this.setC_UOM_ID(m_product.getC_UOM_ID());
                this.setOrder_UOM_ID(pp_order.getC_UOM_ID());
                this.setM_AttributeSetInstance_ID(pp_order.getMPPOrderBOM().getM_AttributeSetInstance_ID());
                this.pickcombo.setSelectedIndex(0);
            }
        }
    }

    private boolean cmd_process() {
        if ((this.isOnlyReceipt() || this.isBackflush()) && this.getM_Locator_ID() <= 0) {
            JOptionPane.showMessageDialog(null, Msg.getMsg((Properties)Env.getCtx(), (String)"NoLocator"), "Info", 1);
        }
        if (this.getPP_Order() == null || this.getMovementDate() == null) {
            return false;
        }
        final boolean isCloseDocument = ADialog.ask((int)this.m_WindowNo, (Container)((Object)this), (String)Msg.parseTranslation((Properties)Env.getCtx(), (String)("@IsCloseDocument@ : " + this.getPP_Order().getDocumentNo())));
        try {
            try {
                Trx.run((TrxRunnable)new TrxRunnable(){

                    public void run(String trxName) {
                        MPPOrder order = new MPPOrder(Env.getCtx(), VOrderReceiptIssue.this.getPP_Order_ID(), trxName);
                        if (VOrderReceiptIssue.this.isBackflush() || VOrderReceiptIssue.this.isOnlyIssue()) {
                            VOrderReceiptIssue.this.createIssue(order);
                        }
                        if (VOrderReceiptIssue.this.isOnlyReceipt() || VOrderReceiptIssue.this.isBackflush()) {
                            MPPOrder.createReceipt(order, VOrderReceiptIssue.this.getMovementDate(), VOrderReceiptIssue.this.getDeliveredQty(), VOrderReceiptIssue.this.getToDeliverQty(), VOrderReceiptIssue.this.getScrapQty(), VOrderReceiptIssue.this.getRejectQty(), VOrderReceiptIssue.this.getM_Locator_ID(), VOrderReceiptIssue.this.getM_AttributeSetInstance_ID());
                            if (isCloseDocument) {
                                order.setDateFinish(VOrderReceiptIssue.this.getMovementDate());
                                order.closeIt();
                                order.saveEx();
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                ADialog.error((int)this.m_WindowNo, (Container)((Object)this), (String)"Error", (String)e.getLocalizedMessage());
                this.m_PP_order = null;
                return false;
            }
        }
        finally {
            this.m_PP_order = null;
        }
        return true;
    }

    private void createIssue(MPPOrder order) {
        Timestamp movementDate;
        Timestamp minGuaranteeDate = movementDate = this.getMovementDate();
        boolean isCompleteQtyDeliver = false;
        ArrayList[][] m_issue = new ArrayList[this.issue.getRowCount()][1];
        int row = 0;
        int i = 0;
        while (i < this.issue.getRowCount()) {
            ArrayList<Object> data = new ArrayList<Object>();
            IDColumn id = (IDColumn)this.issue.getValueAt(i, 0);
            KeyNamePair key = new KeyNamePair(id.getRecord_ID().intValue(), id.isSelected() ? "Y" : "N");
            data.add(key);
            data.add(this.issue.getValueAt(i, 1));
            data.add(this.issue.getValueAt(i, 2));
            data.add(this.issue.getValueAt(i, 3));
            data.add(this.getValueBigDecimal(i, 8));
            data.add(this.getValueBigDecimal(i, 9));
            m_issue[row][0] = data;
            ++row;
            ++i;
        }
        isCompleteQtyDeliver = MPPOrder.isQtyAvailable(order, m_issue, minGuaranteeDate);
        if (!isCompleteQtyDeliver) {
            ADialog.error((int)this.m_WindowNo, (Container)((Object)this), (String)"NoQtyAvailable");
            throw new AdempiereException("@NoQtyAvailable@");
        }
        i = 0;
        while (i < m_issue.length) {
            KeyNamePair key = (KeyNamePair)m_issue[i][0].get(0);
            boolean isSelected = key.getName().equals("Y");
            if (key != null && isSelected) {
                Boolean isCritical = (Boolean)m_issue[i][0].get(1);
                String value = (String)m_issue[i][0].get(2);
                KeyNamePair productkey = (KeyNamePair)m_issue[i][0].get(3);
                int M_Product_ID = productkey.getKey();
                MPPOrderBOMLine orderbomLine = null;
                int PP_Order_BOMLine_ID = 0;
                int M_AttributeSetInstance_ID = 0;
                BigDecimal qtyToDeliver = (BigDecimal)m_issue[i][0].get(4);
                BigDecimal qtyScrapComponent = (BigDecimal)m_issue[i][0].get(5);
                MProduct product = MProduct.get((Properties)order.getCtx(), (int)M_Product_ID);
                if (product != null && product.get_ID() != 0 && product.isStocked()) {
                    if (value == null && isSelected) {
                        M_AttributeSetInstance_ID = key.getKey();
                        orderbomLine = MPPOrderBOMLine.forM_Product_ID(Env.getCtx(), order.get_ID(), M_Product_ID, order.get_TrxName());
                        if (orderbomLine != null) {
                            PP_Order_BOMLine_ID = orderbomLine.get_ID();
                        }
                    } else if (value != null && isSelected && (PP_Order_BOMLine_ID = Integer.valueOf(key.getKey()).intValue()) > 0) {
                        orderbomLine = new MPPOrderBOMLine(order.getCtx(), PP_Order_BOMLine_ID, order.get_TrxName());
                        M_AttributeSetInstance_ID = orderbomLine.getM_AttributeSetInstance_ID();
                    }
                    MStorage[] storages = MPPOrder.getStorages(Env.getCtx(), M_Product_ID, order.getM_Warehouse_ID(), M_AttributeSetInstance_ID, minGuaranteeDate, order.get_TrxName());
                    MPPOrder.createIssue(order, PP_Order_BOMLine_ID, movementDate, qtyToDeliver, qtyScrapComponent, Env.ZERO, storages, false);
                }
            }
            ++i;
        }
    }

    private void generateSummaryTable() {
        String[][] table;
        StringBuffer iText = new StringBuffer();
        iText.append("<b>");
        iText.append(Msg.translate((Properties)Env.getCtx(), (String)"IsShipConfirm"));
        iText.append("</b>");
        iText.append("<br />");
        if (this.isOnlyReceipt() || this.isBackflush()) {
            table = new String[][]{{Msg.translate((Properties)Env.getCtx(), (String)"Name"), Msg.translate((Properties)Env.getCtx(), (String)"C_UOM_ID"), Msg.translate((Properties)Env.getCtx(), (String)"M_AttributeSetInstance_ID"), Msg.translate((Properties)Env.getCtx(), (String)"QtyToDeliver"), Msg.translate((Properties)Env.getCtx(), (String)"QtyDelivered"), Msg.translate((Properties)Env.getCtx(), (String)"QtyScrap")}, {this.productField.getDisplay(), this.uomField.getDisplay(), this.attribute.getDisplay(), this.toDeliverQty.getDisplay(), this.deliveredQtyField.getDisplay(), this.scrapQtyField.getDisplay()}};
            iText.append(this.createHTMLTable(table));
        }
        if (this.isBackflush() || this.isOnlyIssue()) {
            iText.append("<br /><br />");
            table = new ArrayList();
            table.add(new String[]{Msg.translate((Properties)Env.getCtx(), (String)"Value"), Msg.translate((Properties)Env.getCtx(), (String)"Name"), Msg.translate((Properties)Env.getCtx(), (String)"C_UOM_ID"), Msg.translate((Properties)Env.getCtx(), (String)"M_AttributeSetInstance_ID"), Msg.translate((Properties)Env.getCtx(), (String)"QtyToDeliver"), Msg.translate((Properties)Env.getCtx(), (String)"QtyDelivered"), Msg.translate((Properties)Env.getCtx(), (String)"QtyScrap")});
            int i = 0;
            while (i < this.issue.getRowCount()) {
                IDColumn id = (IDColumn)this.issue.getValueAt(i, 0);
                if (id != null && id.isSelected()) {
                    KeyNamePair m_productkey = (KeyNamePair)this.issue.getValueAt(i, 3);
                    int m_M_Product_ID = m_productkey.getKey();
                    KeyNamePair m_uomkey = (KeyNamePair)this.issue.getValueAt(i, 4);
                    if (this.issue.getValueAt(i, 5) == null) {
                        Timestamp m_movementDate;
                        Timestamp minGuaranteeDate = m_movementDate = this.getMovementDate();
                        MStorage[] storages = MPPOrder.getStorages(Env.getCtx(), m_M_Product_ID, this.getPP_Order().getM_Warehouse_ID(), 0, minGuaranteeDate, null);
                        BigDecimal todelivery = this.getValueBigDecimal(i, 8);
                        BigDecimal scrap = this.getValueBigDecimal(i, 9);
                        BigDecimal toIssue = todelivery.add(scrap);
                        MStorage[] mStorageArray = storages;
                        int n = storages.length;
                        int n2 = 0;
                        while (n2 < n) {
                            MStorage storage = mStorageArray[n2];
                            if (storage.getQtyOnHand().signum() != 0) {
                                BigDecimal issueact = toIssue;
                                if (issueact.compareTo(storage.getQtyOnHand()) > 0) {
                                    issueact = storage.getQtyOnHand();
                                }
                                toIssue = toIssue.subtract(issueact);
                                String desc = new MAttributeSetInstance(Env.getCtx(), storage.getM_AttributeSetInstance_ID(), null).getDescription();
                                String[] row = new String[]{"", "", "", "", "0.00", "0.00", "0.00"};
                                row[0] = this.issue.getValueAt(i, 2) != null ? this.issue.getValueAt(i, 2).toString() : "";
                                row[1] = m_productkey.toString();
                                row[2] = m_uomkey != null ? m_uomkey.toString() : "";
                                row[3] = desc != null ? desc : "";
                                row[4] = issueact.setScale(2, 4).toString();
                                row[5] = this.getValueBigDecimal(i, 7).setScale(2, 4).toString();
                                row[6] = this.getValueBigDecimal(i, 9).toString();
                                table.add(row);
                                if (toIssue.signum() <= 0) break;
                            }
                            ++n2;
                        }
                    } else {
                        String[] row = new String[]{"", "", "", "", "0.00", "0.00", "0.00"};
                        row[0] = this.issue.getValueAt(i, 2) != null ? this.issue.getValueAt(i, 2).toString() : "";
                        row[1] = m_productkey.toString();
                        row[2] = m_uomkey != null ? m_uomkey.toString() : "";
                        row[3] = this.issue.getValueAt(i, 5) != null ? this.issue.getValueAt(i, 5).toString() : "";
                        row[4] = this.getValueBigDecimal(i, 8).toString();
                        row[5] = this.getValueBigDecimal(i, 7).toString();
                        row[6] = this.getValueBigDecimal(i, 9).toString();
                        table.add(row);
                    }
                }
                ++i;
            }
            String[][] tableArray = (String[][])table.toArray((T[])new String[table.size()][]);
            iText.append(this.createHTMLTable(tableArray));
        }
        this.info.setText(iText.toString());
    }

    private boolean isOnlyReceipt() {
        return this.pickcombo.getDisplay().equals("OnlyReceipt");
    }

    private boolean isOnlyIssue() {
        return this.pickcombo.getDisplay().equals("OnlyIssue");
    }

    protected boolean isBackflush() {
        return this.pickcombo.getDisplay().equals("IsBackflush");
    }

    protected Timestamp getMovementDate() {
        return (Timestamp)this.movementDateField.getValue();
    }

    protected BigDecimal getOrderedQty() {
        BigDecimal bd = (BigDecimal)this.orderedQtyField.getValue();
        return bd != null ? bd : Env.ZERO;
    }

    protected void setOrderedQty(BigDecimal qty) {
        this.orderedQtyField.setValue((Object)qty);
    }

    protected BigDecimal getDeliveredQty() {
        BigDecimal bd = (BigDecimal)this.deliveredQtyField.getValue();
        return bd != null ? bd : Env.ZERO;
    }

    protected void setDeliveredQty(BigDecimal qty) {
        this.deliveredQtyField.setValue((Object)qty);
    }

    protected BigDecimal getToDeliverQty() {
        BigDecimal bd = (BigDecimal)this.toDeliverQty.getValue();
        return bd != null ? bd : Env.ZERO;
    }

    protected void setToDeliverQty(BigDecimal qty) {
        this.toDeliverQty.setValue((Object)qty);
    }

    protected BigDecimal getScrapQty() {
        BigDecimal bd = (BigDecimal)this.scrapQtyField.getValue();
        return bd != null ? bd : Env.ZERO;
    }

    protected BigDecimal getRejectQty() {
        BigDecimal bd = (BigDecimal)this.rejectQty.getValue();
        return bd != null ? bd : Env.ZERO;
    }

    protected BigDecimal getOpenQty() {
        BigDecimal bd = (BigDecimal)this.openQtyField.getValue();
        return bd != null ? bd : Env.ZERO;
    }

    protected void setOpenQty(BigDecimal qty) {
        this.openQtyField.setValue((Object)qty);
    }

    protected BigDecimal getQtyBatchs() {
        BigDecimal bd = (BigDecimal)this.qtyBatchsField.getValue();
        return bd != null ? bd : Env.ZERO;
    }

    protected void setQtyBatchs(BigDecimal qty) {
        this.qtyBatchsField.setValue((Object)qty);
    }

    protected BigDecimal getQtyBatchSize() {
        BigDecimal bd = (BigDecimal)this.qtyBatchSizeField.getValue();
        return bd != null ? bd : Env.ZERO;
    }

    protected void setQtyBatchSize(BigDecimal qty) {
        this.qtyBatchSizeField.setValue((Object)qty);
    }

    protected int getM_AttributeSetInstance_ID() {
        Integer ii = (Integer)this.attribute.getValue();
        return ii != null ? ii : 0;
    }

    protected void setM_AttributeSetInstance_ID(int M_AttributeSetInstance_ID) {
        this.attribute.setValue((Object)M_AttributeSetInstance_ID);
    }

    protected int getM_Locator_ID() {
        Integer ii = (Integer)this.locatorField.getValue();
        return ii != null ? ii : 0;
    }

    protected void setM_Locator_ID(int M_Locator_ID) {
        this.locatorField.setValue((Object)M_Locator_ID);
    }

    protected int getPP_Order_ID() {
        Integer ii = (Integer)this.orderField.getValue();
        return ii != null ? ii : 0;
    }

    protected MPPOrder getPP_Order() {
        int id = this.getPP_Order_ID();
        if (id <= 0) {
            this.m_PP_order = null;
            return null;
        }
        if (this.m_PP_order == null || this.m_PP_order.get_ID() != id) {
            this.m_PP_order = new MPPOrder(Env.getCtx(), id, null);
        }
        return this.m_PP_order;
    }

    protected int getS_Resource_ID() {
        Integer ii = (Integer)this.resourceField.getValue();
        return ii != null ? ii : 0;
    }

    protected void setS_Resource_ID(int S_Resource_ID) {
        this.resourceField.setValue((Object)S_Resource_ID);
    }

    protected int getM_Warehouse_ID() {
        Integer ii = (Integer)this.warehouseField.getValue();
        return ii != null ? ii : 0;
    }

    protected void setM_Warehouse_ID(int M_Warehouse_ID) {
        this.warehouseField.setValue((Object)M_Warehouse_ID);
    }

    protected int getM_Product_ID() {
        Integer ii = (Integer)this.productField.getValue();
        return ii != null ? ii : 0;
    }

    protected void setM_Product_ID(int M_Product_ID) {
        this.productField.setValue((Object)M_Product_ID);
        Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)"M_Product_ID", (int)M_Product_ID);
    }

    protected int getC_UOM_ID() {
        Integer ii = (Integer)this.uomField.getValue();
        return ii != null ? ii : 0;
    }

    protected void setC_UOM_ID(int C_UOM_ID) {
        this.uomField.setValue((Object)C_UOM_ID);
    }

    protected int getOrder_UOM_ID() {
        Integer ii = (Integer)this.uomorderField.getValue();
        return ii != null ? ii : 0;
    }

    protected void setOrder_UOM_ID(int C_UOM_ID) {
        this.uomorderField.setValue((Object)C_UOM_ID);
    }

    private String createHTMLTable(String[][] table) {
        StringBuffer html = new StringBuffer("<table width=\"100%\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">");
        int i = 0;
        while (i < table.length) {
            if (table[i] != null) {
                html.append("<tr>");
                int j = 0;
                while (j < table[i].length) {
                    html.append("<td>");
                    if (table[i][j] != null) {
                        html.append(table[i][j]);
                    }
                    html.append("</td>");
                    ++j;
                }
                html.append("</tr>");
            }
            ++i;
        }
        html.append("</table>");
        return html.toString();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }

    public void executeASync(ProcessInfo processInfo) {
    }

    public boolean isUILocked() {
        return true;
    }

    public void lockUI(ProcessInfo processInfo) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    @Override
    public void tableChanged(TableModelEvent e) {
    }

    public void unlockUI(ProcessInfo processInfo) {
    }

    private BigDecimal getValueBigDecimal(int row, int col) {
        BigDecimal bd = (BigDecimal)this.issue.getValueAt(row, col);
        return bd == null ? Env.ZERO : bd;
    }
}

