/*
 * Decompiled with CFR 0.152.
 */
package com.tamak.core.utils;

import com.tamak.core.bean.MessageBean;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.compiere.Adempiere;
import org.compiere.util.CLogMgt;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrlMsgImporter {
    private static String USER_MAINTAINED_MSG = "User maintained";
    private static String INFORMATION_MSG = "Information";
    public static String FR_LANGUAGE = "fr_FR";

    public ArrayList<MessageBean> getMessageList(File file) throws Exception {
        FileReader fileReader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String strLine = null;
        ArrayList<MessageBean> messageList = new ArrayList<MessageBean>();
        strLine = bufferedReader.readLine();
        while ((strLine = bufferedReader.readLine()) != null) {
            StringTokenizer tokenizer = new StringTokenizer(strLine, ";");
            String searchKey = tokenizer.nextToken().replaceAll("\"", "");
            String msgText = tokenizer.nextToken().replaceAll("\"", "");
            String msgTip = tokenizer.nextToken().replaceAll("\"", "");
            if (!tokenizer.hasMoreTokens()) continue;
            String msgTextTrl = tokenizer.nextToken().replaceAll("\"", "");
            String msgTipTrl = null;
            if (tokenizer.hasMoreTokens()) {
                msgTipTrl = tokenizer.nextToken().replaceAll("\"", "");
            }
            MessageBean msgBean = new MessageBean();
            msgBean.setSearchKey(searchKey);
            msgBean.setEntityType(USER_MAINTAINED_MSG);
            msgBean.setMsgType(INFORMATION_MSG);
            msgBean.setMsgText(msgText);
            msgBean.setMsgTip(msgTip);
            msgBean.setMsgTextTrl(msgTextTrl);
            msgBean.setMsgTipTrl(msgTipTrl);
            messageList.add(msgBean);
        }
        bufferedReader.close();
        fileReader.close();
        return messageList;
    }

    private String getEntityType(String entityType) {
        if (entityType == null) {
            throw new IllegalArgumentException("Entity Type cannot be null");
        }
        if (entityType.compareTo(USER_MAINTAINED_MSG) == 0) {
            return "U";
        }
        throw new IllegalArgumentException("Unknown entity type: " + entityType);
    }

    private String getMessageType(String messageType) {
        if (messageType == null) {
            throw new IllegalArgumentException("Message Type cannot be null");
        }
        if (messageType.compareTo(INFORMATION_MSG) == 0) {
            return "I";
        }
        throw new IllegalArgumentException("Unknown message type: " + messageType);
    }

    public boolean isTrlPresent(int msgId, String language, String trxName) {
        boolean present = false;
        Statement pstmt = null;
        try {
            try {
                String sql = "select AD_Message_ID from AD_Message_Trl where AD_Message_ID=" + msgId + " and AD_Language='" + language + "'";
                pstmt = DB.prepareStatement((String)sql, (String)trxName);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    present = true;
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException ex) {
                throw new RuntimeException("Could not execute query to check translation");
            }
        }
        finally {
            try {
                pstmt.close();
            }
            catch (Exception exception) {}
        }
        return present;
    }

    public int getMessageId(Properties ctx, String key, String trxName) {
        String sqlStmt = "Select AD_Message_ID from AD_Message where Value='" + key + "'";
        CPreparedStatement pstmt = null;
        int msgId = 0;
        try {
            try {
                pstmt = DB.prepareStatement((String)sqlStmt, (String)trxName);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    msgId = rs.getInt(1);
                }
                rs.close();
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not retrieve messageId for Message with value: " + key);
            }
        }
        finally {
            try {
                pstmt.close();
            }
            catch (Exception exception) {}
        }
        return msgId;
    }

    public void importMessagesTrl(Properties ctx, ArrayList<MessageBean> msgList, String language, String trxName) {
        for (MessageBean msgBean : msgList) {
            String msgTip;
            int msgId = this.getMessageId(ctx, msgBean.getSearchKey(), trxName);
            boolean trlPresent = false;
            if (msgId != 0) {
                trlPresent = this.isTrlPresent(msgId, language, trxName);
            }
            StringBuffer sqlStmt = new StringBuffer();
            String string = msgTip = msgBean.getMsgTipTrl() == null ? "" : msgBean.getMsgTipTrl().replaceAll("'", "''");
            if (trlPresent) {
                sqlStmt.append("Update AD_Message_Trl set MsgText='" + msgBean.getMsgTextTrl().replaceAll("'", "''") + "'");
                sqlStmt.append(", MsgTip='" + msgTip + "'");
                sqlStmt.append(" where AD_Message_ID=" + msgId);
                sqlStmt.append(" and AD_Language='" + language + "'");
            } else {
                sqlStmt.append("Insert into AD_Message_Trl (AD_Message_ID, AD_Language, AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy, MsgText, MsgTip, IsTranslated) Values");
                sqlStmt.append("(" + msgId + ", ");
                sqlStmt.append("'" + language + "', ");
                sqlStmt.append("0, 0, 'Y', SysDate, 0, SysDate, 0, '" + msgBean.getMsgTextTrl().replaceAll("'", "''") + "', '" + msgTip + "', 'Y')");
            }
            int succ = DB.executeUpdate((String)sqlStmt.toString(), (String)trxName);
            if (succ != -1) continue;
            throw new RuntimeException("Could not set Translation with sql: " + sqlStmt.toString());
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args.length > 1) {
            throw new Exception("Should provide only one argument, that is the path of the file to import");
        }
        File adMsgFileTrl = new File(args[0]);
        if (!adMsgFileTrl.exists()) {
            throw new Exception("File does not exist:" + args[0]);
        }
        Properties ctx = Env.getCtx();
        CLogMgt.initialize((boolean)true);
        Adempiere.startup((boolean)true);
        ctx.setProperty("#AD_Client_ID", "0");
        ctx.setProperty("#AD_Org_ID", "0");
        ctx.setProperty("#AD_User_ID", "100");
        try {
            TrlMsgImporter trlMsgImporter = new TrlMsgImporter();
            ArrayList<MessageBean> msgList = trlMsgImporter.getMessageList(adMsgFileTrl);
            trlMsgImporter.importMessagesTrl(ctx, msgList, FR_LANGUAGE, null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

